<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for VerificaPagamentosDisponiveisMBResponse StructType
 * @subpackage Structs
 */
class VerificaPagamentosDisponiveisMBResponse extends AbstractStructBase
{
    /**
     * The VerificaPagamentosDisponiveisMBResult
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $VerificaPagamentosDisponiveisMBResult;
    /**
     * The numeroPagamentos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroPagamentos;
    /**
     * The numeroPagamentosNaoIntegrados
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $numeroPagamentosNaoIntegrados;
    /**
     * The listaPagamentosEntontrados
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfref_detail
     */
    public $listaPagamentosEntontrados;
    /**
     * The mensagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $mensagem;
    /**
     * The sucesso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $sucesso;
    /**
     * Constructor method for VerificaPagamentosDisponiveisMBResponse
     * @uses VerificaPagamentosDisponiveisMBResponse::setVerificaPagamentosDisponiveisMBResult()
     * @uses VerificaPagamentosDisponiveisMBResponse::setNumeroPagamentos()
     * @uses VerificaPagamentosDisponiveisMBResponse::setNumeroPagamentosNaoIntegrados()
     * @uses VerificaPagamentosDisponiveisMBResponse::setListaPagamentosEntontrados()
     * @uses VerificaPagamentosDisponiveisMBResponse::setMensagem()
     * @uses VerificaPagamentosDisponiveisMBResponse::setSucesso()
     * @param bool $verificaPagamentosDisponiveisMBResult
     * @param int $numeroPagamentos
     * @param int $numeroPagamentosNaoIntegrados
     * @param \ArrayType\ArrayOfref_detail $listaPagamentosEntontrados
     * @param string $mensagem
     * @param bool $sucesso
     */
    public function __construct($verificaPagamentosDisponiveisMBResult = null, $numeroPagamentos = null, $numeroPagamentosNaoIntegrados = null, \ArrayType\ArrayOfref_detail $listaPagamentosEntontrados = null, $mensagem = null, $sucesso = null)
    {
        $this
            ->setVerificaPagamentosDisponiveisMBResult($verificaPagamentosDisponiveisMBResult)
            ->setNumeroPagamentos($numeroPagamentos)
            ->setNumeroPagamentosNaoIntegrados($numeroPagamentosNaoIntegrados)
            ->setListaPagamentosEntontrados($listaPagamentosEntontrados)
            ->setMensagem($mensagem)
            ->setSucesso($sucesso);
    }
    /**
     * Get VerificaPagamentosDisponiveisMBResult value
     * @return bool|null
     */
    public function getVerificaPagamentosDisponiveisMBResult()
    {
        return $this->VerificaPagamentosDisponiveisMBResult;
    }
    /**
     * Set VerificaPagamentosDisponiveisMBResult value
     * @param bool $verificaPagamentosDisponiveisMBResult
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public function setVerificaPagamentosDisponiveisMBResult($verificaPagamentosDisponiveisMBResult = null)
    {
        // validation for constraint: boolean
        if (!is_null($verificaPagamentosDisponiveisMBResult) && !is_bool($verificaPagamentosDisponiveisMBResult)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($verificaPagamentosDisponiveisMBResult)), __LINE__);
        }
        $this->VerificaPagamentosDisponiveisMBResult = $verificaPagamentosDisponiveisMBResult;
        return $this;
    }
    /**
     * Get numeroPagamentos value
     * @return int|null
     */
    public function getNumeroPagamentos()
    {
        return $this->numeroPagamentos;
    }
    /**
     * Set numeroPagamentos value
     * @param int $numeroPagamentos
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public function setNumeroPagamentos($numeroPagamentos = null)
    {
        // validation for constraint: int
        if (!is_null($numeroPagamentos) && !is_numeric($numeroPagamentos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroPagamentos)), __LINE__);
        }
        $this->numeroPagamentos = $numeroPagamentos;
        return $this;
    }
    /**
     * Get numeroPagamentosNaoIntegrados value
     * @return int|null
     */
    public function getNumeroPagamentosNaoIntegrados()
    {
        return $this->numeroPagamentosNaoIntegrados;
    }
    /**
     * Set numeroPagamentosNaoIntegrados value
     * @param int $numeroPagamentosNaoIntegrados
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public function setNumeroPagamentosNaoIntegrados($numeroPagamentosNaoIntegrados = null)
    {
        // validation for constraint: int
        if (!is_null($numeroPagamentosNaoIntegrados) && !is_numeric($numeroPagamentosNaoIntegrados)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroPagamentosNaoIntegrados)), __LINE__);
        }
        $this->numeroPagamentosNaoIntegrados = $numeroPagamentosNaoIntegrados;
        return $this;
    }
    /**
     * Get listaPagamentosEntontrados value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfref_detail|null
     */
    public function getListaPagamentosEntontrados()
    {
        return isset($this->listaPagamentosEntontrados) ? $this->listaPagamentosEntontrados : null;
    }
    /**
     * Set listaPagamentosEntontrados value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfref_detail $listaPagamentosEntontrados
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public function setListaPagamentosEntontrados(\ArrayType\ArrayOfref_detail $listaPagamentosEntontrados = null)
    {
        if (is_null($listaPagamentosEntontrados) || (is_array($listaPagamentosEntontrados) && empty($listaPagamentosEntontrados))) {
            unset($this->listaPagamentosEntontrados);
        } else {
            $this->listaPagamentosEntontrados = $listaPagamentosEntontrados;
        }
        return $this;
    }
    /**
     * Get mensagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMensagem()
    {
        return isset($this->mensagem) ? $this->mensagem : null;
    }
    /**
     * Set mensagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $mensagem
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public function setMensagem($mensagem = null)
    {
        // validation for constraint: string
        if (!is_null($mensagem) && !is_string($mensagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($mensagem)), __LINE__);
        }
        if (is_null($mensagem) || (is_array($mensagem) && empty($mensagem))) {
            unset($this->mensagem);
        } else {
            $this->mensagem = $mensagem;
        }
        return $this;
    }
    /**
     * Get sucesso value
     * @return bool|null
     */
    public function getSucesso()
    {
        return $this->sucesso;
    }
    /**
     * Set sucesso value
     * @param bool $sucesso
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public function setSucesso($sucesso = null)
    {
        // validation for constraint: boolean
        if (!is_null($sucesso) && !is_bool($sucesso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sucesso)), __LINE__);
        }
        $this->sucesso = $sucesso;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\VerificaPagamentosDisponiveisMBResponse
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
