<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for SeriesContratosERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:SeriesContratosERP
 * @subpackage Structs
 */
class SeriesContratosERP extends AbstractStructBase
{
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Numerador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Numerador;
    /**
     * The Ordem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordem;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Serie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serie;
    /**
     * The SerieInactiva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SerieInactiva;
    /**
     * The SeriePorDefeito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $SeriePorDefeito;
    /**
     * The TipoDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDoc;
    /**
     * Constructor method for SeriesContratosERP
     * @uses SeriesContratosERP::setDescricao()
     * @uses SeriesContratosERP::setNumerador()
     * @uses SeriesContratosERP::setOrdem()
     * @uses SeriesContratosERP::setProtegida()
     * @uses SeriesContratosERP::setSerie()
     * @uses SeriesContratosERP::setSerieInactiva()
     * @uses SeriesContratosERP::setSeriePorDefeito()
     * @uses SeriesContratosERP::setTipoDoc()
     * @param string $descricao
     * @param int $numerador
     * @param int $ordem
     * @param bool $protegida
     * @param string $serie
     * @param bool $serieInactiva
     * @param bool $seriePorDefeito
     * @param string $tipoDoc
     */
    public function __construct($descricao = null, $numerador = null, $ordem = null, $protegida = null, $serie = null, $serieInactiva = null, $seriePorDefeito = null, $tipoDoc = null)
    {
        $this
            ->setDescricao($descricao)
            ->setNumerador($numerador)
            ->setOrdem($ordem)
            ->setProtegida($protegida)
            ->setSerie($serie)
            ->setSerieInactiva($serieInactiva)
            ->setSeriePorDefeito($seriePorDefeito)
            ->setTipoDoc($tipoDoc);
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\SeriesContratosERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Numerador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumerador()
    {
        return isset($this->Numerador) ? $this->Numerador : null;
    }
    /**
     * Set Numerador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numerador
     * @return \StructType\SeriesContratosERP
     */
    public function setNumerador($numerador = null)
    {
        // validation for constraint: int
        if (!is_null($numerador) && !is_numeric($numerador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numerador)), __LINE__);
        }
        if (is_null($numerador) || (is_array($numerador) && empty($numerador))) {
            unset($this->Numerador);
        } else {
            $this->Numerador = $numerador;
        }
        return $this;
    }
    /**
     * Get Ordem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdem()
    {
        return isset($this->Ordem) ? $this->Ordem : null;
    }
    /**
     * Set Ordem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordem
     * @return \StructType\SeriesContratosERP
     */
    public function setOrdem($ordem = null)
    {
        // validation for constraint: int
        if (!is_null($ordem) && !is_numeric($ordem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordem)), __LINE__);
        }
        if (is_null($ordem) || (is_array($ordem) && empty($ordem))) {
            unset($this->Ordem);
        } else {
            $this->Ordem = $ordem;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\SeriesContratosERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Serie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerie()
    {
        return isset($this->Serie) ? $this->Serie : null;
    }
    /**
     * Set Serie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serie
     * @return \StructType\SeriesContratosERP
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serie)), __LINE__);
        }
        if (is_null($serie) || (is_array($serie) && empty($serie))) {
            unset($this->Serie);
        } else {
            $this->Serie = $serie;
        }
        return $this;
    }
    /**
     * Get SerieInactiva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSerieInactiva()
    {
        return isset($this->SerieInactiva) ? $this->SerieInactiva : null;
    }
    /**
     * Set SerieInactiva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $serieInactiva
     * @return \StructType\SeriesContratosERP
     */
    public function setSerieInactiva($serieInactiva = null)
    {
        // validation for constraint: boolean
        if (!is_null($serieInactiva) && !is_bool($serieInactiva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($serieInactiva)), __LINE__);
        }
        if (is_null($serieInactiva) || (is_array($serieInactiva) && empty($serieInactiva))) {
            unset($this->SerieInactiva);
        } else {
            $this->SerieInactiva = $serieInactiva;
        }
        return $this;
    }
    /**
     * Get SeriePorDefeito value
     * @return bool|null
     */
    public function getSeriePorDefeito()
    {
        return $this->SeriePorDefeito;
    }
    /**
     * Set SeriePorDefeito value
     * @param bool $seriePorDefeito
     * @return \StructType\SeriesContratosERP
     */
    public function setSeriePorDefeito($seriePorDefeito = null)
    {
        // validation for constraint: boolean
        if (!is_null($seriePorDefeito) && !is_bool($seriePorDefeito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($seriePorDefeito)), __LINE__);
        }
        $this->SeriePorDefeito = $seriePorDefeito;
        return $this;
    }
    /**
     * Get TipoDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDoc()
    {
        return isset($this->TipoDoc) ? $this->TipoDoc : null;
    }
    /**
     * Set TipoDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDoc
     * @return \StructType\SeriesContratosERP
     */
    public function setTipoDoc($tipoDoc = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDoc) && !is_string($tipoDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDoc)), __LINE__);
        }
        if (is_null($tipoDoc) || (is_array($tipoDoc) && empty($tipoDoc))) {
            unset($this->TipoDoc);
        } else {
            $this->TipoDoc = $tipoDoc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\SeriesContratosERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
