<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MotivosEstornoERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MotivosEstornoERP
 * @subpackage Structs
 */
class MotivosEstornoERP extends AbstractStructBase
{
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Motivo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Motivo;
    /**
     * The MovimentaStock
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $MovimentaStock;
    /**
     * The NovoDocumento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $NovoDocumento;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for MotivosEstornoERP
     * @uses MotivosEstornoERP::setDescricao()
     * @uses MotivosEstornoERP::setMotivo()
     * @uses MotivosEstornoERP::setMovimentaStock()
     * @uses MotivosEstornoERP::setNovoDocumento()
     * @uses MotivosEstornoERP::setProtegida()
     * @uses MotivosEstornoERP::setVersaoUltAct()
     * @param string $descricao
     * @param string $motivo
     * @param bool $movimentaStock
     * @param bool $novoDocumento
     * @param bool $protegida
     * @param string $versaoUltAct
     */
    public function __construct($descricao = null, $motivo = null, $movimentaStock = null, $novoDocumento = null, $protegida = null, $versaoUltAct = null)
    {
        $this
            ->setDescricao($descricao)
            ->setMotivo($motivo)
            ->setMovimentaStock($movimentaStock)
            ->setNovoDocumento($novoDocumento)
            ->setProtegida($protegida)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\MotivosEstornoERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Motivo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivo()
    {
        return isset($this->Motivo) ? $this->Motivo : null;
    }
    /**
     * Set Motivo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivo
     * @return \StructType\MotivosEstornoERP
     */
    public function setMotivo($motivo = null)
    {
        // validation for constraint: string
        if (!is_null($motivo) && !is_string($motivo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivo)), __LINE__);
        }
        if (is_null($motivo) || (is_array($motivo) && empty($motivo))) {
            unset($this->Motivo);
        } else {
            $this->Motivo = $motivo;
        }
        return $this;
    }
    /**
     * Get MovimentaStock value
     * @return bool|null
     */
    public function getMovimentaStock()
    {
        return $this->MovimentaStock;
    }
    /**
     * Set MovimentaStock value
     * @param bool $movimentaStock
     * @return \StructType\MotivosEstornoERP
     */
    public function setMovimentaStock($movimentaStock = null)
    {
        // validation for constraint: boolean
        if (!is_null($movimentaStock) && !is_bool($movimentaStock)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($movimentaStock)), __LINE__);
        }
        $this->MovimentaStock = $movimentaStock;
        return $this;
    }
    /**
     * Get NovoDocumento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getNovoDocumento()
    {
        return isset($this->NovoDocumento) ? $this->NovoDocumento : null;
    }
    /**
     * Set NovoDocumento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $novoDocumento
     * @return \StructType\MotivosEstornoERP
     */
    public function setNovoDocumento($novoDocumento = null)
    {
        // validation for constraint: boolean
        if (!is_null($novoDocumento) && !is_bool($novoDocumento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($novoDocumento)), __LINE__);
        }
        if (is_null($novoDocumento) || (is_array($novoDocumento) && empty($novoDocumento))) {
            unset($this->NovoDocumento);
        } else {
            $this->NovoDocumento = $novoDocumento;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\MotivosEstornoERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\MotivosEstornoERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MotivosEstornoERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
