<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasDocStatusERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasDocStatusERP
 * @subpackage Structs
 */
class LinhasDocStatusERP extends AbstractStructBase
{
    /**
     * The EstadoTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoTrans;
    /**
     * The Estrategia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estrategia;
    /**
     * The Fechado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Fechado;
    /**
     * The IdLinhasDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhasDoc;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QuantCopiada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantCopiada;
    /**
     * The QuantReserv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantReserv;
    /**
     * The QuantTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantTrans;
    /**
     * The Quantidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantidade;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * The eGAR_APADocCodeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $eGAR_APADocCodeID;
    /**
     * Constructor method for LinhasDocStatusERP
     * @uses LinhasDocStatusERP::setEstadoTrans()
     * @uses LinhasDocStatusERP::setEstrategia()
     * @uses LinhasDocStatusERP::setFechado()
     * @uses LinhasDocStatusERP::setIdLinhasDoc()
     * @uses LinhasDocStatusERP::setProtegida()
     * @uses LinhasDocStatusERP::setQuantCopiada()
     * @uses LinhasDocStatusERP::setQuantReserv()
     * @uses LinhasDocStatusERP::setQuantTrans()
     * @uses LinhasDocStatusERP::setQuantidade()
     * @uses LinhasDocStatusERP::setVersaoUltAct()
     * @uses LinhasDocStatusERP::setEGAR_APADocCodeID()
     * @param string $estadoTrans
     * @param string $estrategia
     * @param bool $fechado
     * @param string $idLinhasDoc
     * @param bool $protegida
     * @param float $quantCopiada
     * @param float $quantReserv
     * @param float $quantTrans
     * @param float $quantidade
     * @param string $versaoUltAct
     * @param string $eGAR_APADocCodeID
     */
    public function __construct($estadoTrans = null, $estrategia = null, $fechado = null, $idLinhasDoc = null, $protegida = null, $quantCopiada = null, $quantReserv = null, $quantTrans = null, $quantidade = null, $versaoUltAct = null, $eGAR_APADocCodeID = null)
    {
        $this
            ->setEstadoTrans($estadoTrans)
            ->setEstrategia($estrategia)
            ->setFechado($fechado)
            ->setIdLinhasDoc($idLinhasDoc)
            ->setProtegida($protegida)
            ->setQuantCopiada($quantCopiada)
            ->setQuantReserv($quantReserv)
            ->setQuantTrans($quantTrans)
            ->setQuantidade($quantidade)
            ->setVersaoUltAct($versaoUltAct)
            ->setEGAR_APADocCodeID($eGAR_APADocCodeID);
    }
    /**
     * Get EstadoTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoTrans()
    {
        return isset($this->EstadoTrans) ? $this->EstadoTrans : null;
    }
    /**
     * Set EstadoTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoTrans
     * @return \StructType\LinhasDocStatusERP
     */
    public function setEstadoTrans($estadoTrans = null)
    {
        // validation for constraint: string
        if (!is_null($estadoTrans) && !is_string($estadoTrans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoTrans)), __LINE__);
        }
        if (is_null($estadoTrans) || (is_array($estadoTrans) && empty($estadoTrans))) {
            unset($this->EstadoTrans);
        } else {
            $this->EstadoTrans = $estadoTrans;
        }
        return $this;
    }
    /**
     * Get Estrategia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstrategia()
    {
        return isset($this->Estrategia) ? $this->Estrategia : null;
    }
    /**
     * Set Estrategia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estrategia
     * @return \StructType\LinhasDocStatusERP
     */
    public function setEstrategia($estrategia = null)
    {
        // validation for constraint: string
        if (!is_null($estrategia) && !is_string($estrategia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estrategia)), __LINE__);
        }
        if (is_null($estrategia) || (is_array($estrategia) && empty($estrategia))) {
            unset($this->Estrategia);
        } else {
            $this->Estrategia = $estrategia;
        }
        return $this;
    }
    /**
     * Get Fechado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFechado()
    {
        return isset($this->Fechado) ? $this->Fechado : null;
    }
    /**
     * Set Fechado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fechado
     * @return \StructType\LinhasDocStatusERP
     */
    public function setFechado($fechado = null)
    {
        // validation for constraint: boolean
        if (!is_null($fechado) && !is_bool($fechado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fechado)), __LINE__);
        }
        if (is_null($fechado) || (is_array($fechado) && empty($fechado))) {
            unset($this->Fechado);
        } else {
            $this->Fechado = $fechado;
        }
        return $this;
    }
    /**
     * Get IdLinhasDoc value
     * @return string|null
     */
    public function getIdLinhasDoc()
    {
        return $this->IdLinhasDoc;
    }
    /**
     * Set IdLinhasDoc value
     * @param string $idLinhasDoc
     * @return \StructType\LinhasDocStatusERP
     */
    public function setIdLinhasDoc($idLinhasDoc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhasDoc) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhasDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhasDoc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhasDoc) && !is_string($idLinhasDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhasDoc)), __LINE__);
        }
        $this->IdLinhasDoc = $idLinhasDoc;
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasDocStatusERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QuantCopiada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantCopiada()
    {
        return isset($this->QuantCopiada) ? $this->QuantCopiada : null;
    }
    /**
     * Set QuantCopiada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantCopiada
     * @return \StructType\LinhasDocStatusERP
     */
    public function setQuantCopiada($quantCopiada = null)
    {
        if (is_null($quantCopiada) || (is_array($quantCopiada) && empty($quantCopiada))) {
            unset($this->QuantCopiada);
        } else {
            $this->QuantCopiada = $quantCopiada;
        }
        return $this;
    }
    /**
     * Get QuantReserv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantReserv()
    {
        return isset($this->QuantReserv) ? $this->QuantReserv : null;
    }
    /**
     * Set QuantReserv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantReserv
     * @return \StructType\LinhasDocStatusERP
     */
    public function setQuantReserv($quantReserv = null)
    {
        if (is_null($quantReserv) || (is_array($quantReserv) && empty($quantReserv))) {
            unset($this->QuantReserv);
        } else {
            $this->QuantReserv = $quantReserv;
        }
        return $this;
    }
    /**
     * Get QuantTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantTrans()
    {
        return isset($this->QuantTrans) ? $this->QuantTrans : null;
    }
    /**
     * Set QuantTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantTrans
     * @return \StructType\LinhasDocStatusERP
     */
    public function setQuantTrans($quantTrans = null)
    {
        if (is_null($quantTrans) || (is_array($quantTrans) && empty($quantTrans))) {
            unset($this->QuantTrans);
        } else {
            $this->QuantTrans = $quantTrans;
        }
        return $this;
    }
    /**
     * Get Quantidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantidade()
    {
        return isset($this->Quantidade) ? $this->Quantidade : null;
    }
    /**
     * Set Quantidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantidade
     * @return \StructType\LinhasDocStatusERP
     */
    public function setQuantidade($quantidade = null)
    {
        if (is_null($quantidade) || (is_array($quantidade) && empty($quantidade))) {
            unset($this->Quantidade);
        } else {
            $this->Quantidade = $quantidade;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasDocStatusERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Get eGAR_APADocCodeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEGAR_APADocCodeID()
    {
        return isset($this->eGAR_APADocCodeID) ? $this->eGAR_APADocCodeID : null;
    }
    /**
     * Set eGAR_APADocCodeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $eGAR_APADocCodeID
     * @return \StructType\LinhasDocStatusERP
     */
    public function setEGAR_APADocCodeID($eGAR_APADocCodeID = null)
    {
        // validation for constraint: string
        if (!is_null($eGAR_APADocCodeID) && !is_string($eGAR_APADocCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($eGAR_APADocCodeID)), __LINE__);
        }
        if (is_null($eGAR_APADocCodeID) || (is_array($eGAR_APADocCodeID) && empty($eGAR_APADocCodeID))) {
            unset($this->eGAR_APADocCodeID);
        } else {
            $this->eGAR_APADocCodeID = $eGAR_APADocCodeID;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasDocStatusERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
