<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasComprasTransERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasComprasTransERP
 * @subpackage Structs
 */
class LinhasComprasTransERP extends AbstractStructBase
{
    /**
     * The IdLinhasCompras
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhasCompras;
    /**
     * The IdLinhasComprasOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhasComprasOrigem;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QuantTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantTrans;
    /**
     * The VPT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VPT;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for LinhasComprasTransERP
     * @uses LinhasComprasTransERP::setIdLinhasCompras()
     * @uses LinhasComprasTransERP::setIdLinhasComprasOrigem()
     * @uses LinhasComprasTransERP::setProtegida()
     * @uses LinhasComprasTransERP::setQuantTrans()
     * @uses LinhasComprasTransERP::setVPT()
     * @uses LinhasComprasTransERP::setVersaoUltAct()
     * @param string $idLinhasCompras
     * @param string $idLinhasComprasOrigem
     * @param bool $protegida
     * @param float $quantTrans
     * @param float $vPT
     * @param string $versaoUltAct
     */
    public function __construct($idLinhasCompras = null, $idLinhasComprasOrigem = null, $protegida = null, $quantTrans = null, $vPT = null, $versaoUltAct = null)
    {
        $this
            ->setIdLinhasCompras($idLinhasCompras)
            ->setIdLinhasComprasOrigem($idLinhasComprasOrigem)
            ->setProtegida($protegida)
            ->setQuantTrans($quantTrans)
            ->setVPT($vPT)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get IdLinhasCompras value
     * @return string|null
     */
    public function getIdLinhasCompras()
    {
        return $this->IdLinhasCompras;
    }
    /**
     * Set IdLinhasCompras value
     * @param string $idLinhasCompras
     * @return \StructType\LinhasComprasTransERP
     */
    public function setIdLinhasCompras($idLinhasCompras = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhasCompras) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhasCompras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhasCompras, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhasCompras) && !is_string($idLinhasCompras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhasCompras)), __LINE__);
        }
        $this->IdLinhasCompras = $idLinhasCompras;
        return $this;
    }
    /**
     * Get IdLinhasComprasOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhasComprasOrigem()
    {
        return isset($this->IdLinhasComprasOrigem) ? $this->IdLinhasComprasOrigem : null;
    }
    /**
     * Set IdLinhasComprasOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhasComprasOrigem
     * @return \StructType\LinhasComprasTransERP
     */
    public function setIdLinhasComprasOrigem($idLinhasComprasOrigem = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhasComprasOrigem) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhasComprasOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhasComprasOrigem, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhasComprasOrigem) && !is_string($idLinhasComprasOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhasComprasOrigem)), __LINE__);
        }
        if (is_null($idLinhasComprasOrigem) || (is_array($idLinhasComprasOrigem) && empty($idLinhasComprasOrigem))) {
            unset($this->IdLinhasComprasOrigem);
        } else {
            $this->IdLinhasComprasOrigem = $idLinhasComprasOrigem;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasComprasTransERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QuantTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantTrans()
    {
        return isset($this->QuantTrans) ? $this->QuantTrans : null;
    }
    /**
     * Set QuantTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantTrans
     * @return \StructType\LinhasComprasTransERP
     */
    public function setQuantTrans($quantTrans = null)
    {
        if (is_null($quantTrans) || (is_array($quantTrans) && empty($quantTrans))) {
            unset($this->QuantTrans);
        } else {
            $this->QuantTrans = $quantTrans;
        }
        return $this;
    }
    /**
     * Get VPT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVPT()
    {
        return isset($this->VPT) ? $this->VPT : null;
    }
    /**
     * Set VPT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $vPT
     * @return \StructType\LinhasComprasTransERP
     */
    public function setVPT($vPT = null)
    {
        if (is_null($vPT) || (is_array($vPT) && empty($vPT))) {
            unset($this->VPT);
        } else {
            $this->VPT = $vPT;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasComprasTransERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasComprasTransERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
