<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExisteArtigoUnidade StructType
 * @subpackage Structs
 */
class ExisteArtigoUnidade extends AbstractStructBase
{
    /**
     * The artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artigo;
    /**
     * The unidadeOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unidadeOrigem;
    /**
     * The unidadeDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unidadeDestino;
    /**
     * Constructor method for ExisteArtigoUnidade
     * @uses ExisteArtigoUnidade::setArtigo()
     * @uses ExisteArtigoUnidade::setUnidadeOrigem()
     * @uses ExisteArtigoUnidade::setUnidadeDestino()
     * @param string $artigo
     * @param string $unidadeOrigem
     * @param string $unidadeDestino
     */
    public function __construct($artigo = null, $unidadeOrigem = null, $unidadeDestino = null)
    {
        $this
            ->setArtigo($artigo)
            ->setUnidadeOrigem($unidadeOrigem)
            ->setUnidadeDestino($unidadeDestino);
    }
    /**
     * Get artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->artigo) ? $this->artigo : null;
    }
    /**
     * Set artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\ExisteArtigoUnidade
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->artigo);
        } else {
            $this->artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get unidadeOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeOrigem()
    {
        return isset($this->unidadeOrigem) ? $this->unidadeOrigem : null;
    }
    /**
     * Set unidadeOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeOrigem
     * @return \StructType\ExisteArtigoUnidade
     */
    public function setUnidadeOrigem($unidadeOrigem = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeOrigem) && !is_string($unidadeOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeOrigem)), __LINE__);
        }
        if (is_null($unidadeOrigem) || (is_array($unidadeOrigem) && empty($unidadeOrigem))) {
            unset($this->unidadeOrigem);
        } else {
            $this->unidadeOrigem = $unidadeOrigem;
        }
        return $this;
    }
    /**
     * Get unidadeDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeDestino()
    {
        return isset($this->unidadeDestino) ? $this->unidadeDestino : null;
    }
    /**
     * Set unidadeDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeDestino
     * @return \StructType\ExisteArtigoUnidade
     */
    public function setUnidadeDestino($unidadeDestino = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeDestino) && !is_string($unidadeDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeDestino)), __LINE__);
        }
        if (is_null($unidadeDestino) || (is_array($unidadeDestino) && empty($unidadeDestino))) {
            unset($this->unidadeDestino);
        } else {
            $this->unidadeDestino = $unidadeDestino;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExisteArtigoUnidade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
