<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtigoUnidadesERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArtigoUnidadesERP
 * @subpackage Structs
 */
class ArtigoUnidadesERP extends AbstractStructBase
{
    /**
     * The Artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Artigo;
    /**
     * The FactorConversao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FactorConversao;
    /**
     * The Formula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Formula;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The UnidadeDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnidadeDestino;
    /**
     * The UnidadeOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnidadeOrigem;
    /**
     * The UtilizaFormula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $UtilizaFormula;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ArtigoUnidadesERP
     * @uses ArtigoUnidadesERP::setArtigo()
     * @uses ArtigoUnidadesERP::setFactorConversao()
     * @uses ArtigoUnidadesERP::setFormula()
     * @uses ArtigoUnidadesERP::setID()
     * @uses ArtigoUnidadesERP::setProtegida()
     * @uses ArtigoUnidadesERP::setUnidadeDestino()
     * @uses ArtigoUnidadesERP::setUnidadeOrigem()
     * @uses ArtigoUnidadesERP::setUtilizaFormula()
     * @uses ArtigoUnidadesERP::setVersaoUltAct()
     * @param string $artigo
     * @param float $factorConversao
     * @param string $formula
     * @param string $iD
     * @param bool $protegida
     * @param string $unidadeDestino
     * @param string $unidadeOrigem
     * @param bool $utilizaFormula
     * @param string $versaoUltAct
     */
    public function __construct($artigo = null, $factorConversao = null, $formula = null, $iD = null, $protegida = null, $unidadeDestino = null, $unidadeOrigem = null, $utilizaFormula = null, $versaoUltAct = null)
    {
        $this
            ->setArtigo($artigo)
            ->setFactorConversao($factorConversao)
            ->setFormula($formula)
            ->setID($iD)
            ->setProtegida($protegida)
            ->setUnidadeDestino($unidadeDestino)
            ->setUnidadeOrigem($unidadeOrigem)
            ->setUtilizaFormula($utilizaFormula)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->Artigo) ? $this->Artigo : null;
    }
    /**
     * Set Artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->Artigo);
        } else {
            $this->Artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get FactorConversao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFactorConversao()
    {
        return isset($this->FactorConversao) ? $this->FactorConversao : null;
    }
    /**
     * Set FactorConversao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $factorConversao
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setFactorConversao($factorConversao = null)
    {
        if (is_null($factorConversao) || (is_array($factorConversao) && empty($factorConversao))) {
            unset($this->FactorConversao);
        } else {
            $this->FactorConversao = $factorConversao;
        }
        return $this;
    }
    /**
     * Get Formula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormula()
    {
        return isset($this->Formula) ? $this->Formula : null;
    }
    /**
     * Set Formula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formula
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setFormula($formula = null)
    {
        // validation for constraint: string
        if (!is_null($formula) && !is_string($formula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formula)), __LINE__);
        }
        if (is_null($formula) || (is_array($formula) && empty($formula))) {
            unset($this->Formula);
        } else {
            $this->Formula = $formula;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setID($iD = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iD, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get UnidadeDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeDestino()
    {
        return isset($this->UnidadeDestino) ? $this->UnidadeDestino : null;
    }
    /**
     * Set UnidadeDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeDestino
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setUnidadeDestino($unidadeDestino = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeDestino) && !is_string($unidadeDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeDestino)), __LINE__);
        }
        if (is_null($unidadeDestino) || (is_array($unidadeDestino) && empty($unidadeDestino))) {
            unset($this->UnidadeDestino);
        } else {
            $this->UnidadeDestino = $unidadeDestino;
        }
        return $this;
    }
    /**
     * Get UnidadeOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeOrigem()
    {
        return isset($this->UnidadeOrigem) ? $this->UnidadeOrigem : null;
    }
    /**
     * Set UnidadeOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeOrigem
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setUnidadeOrigem($unidadeOrigem = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeOrigem) && !is_string($unidadeOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeOrigem)), __LINE__);
        }
        if (is_null($unidadeOrigem) || (is_array($unidadeOrigem) && empty($unidadeOrigem))) {
            unset($this->UnidadeOrigem);
        } else {
            $this->UnidadeOrigem = $unidadeOrigem;
        }
        return $this;
    }
    /**
     * Get UtilizaFormula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getUtilizaFormula()
    {
        return isset($this->UtilizaFormula) ? $this->UtilizaFormula : null;
    }
    /**
     * Set UtilizaFormula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $utilizaFormula
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setUtilizaFormula($utilizaFormula = null)
    {
        // validation for constraint: boolean
        if (!is_null($utilizaFormula) && !is_bool($utilizaFormula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($utilizaFormula)), __LINE__);
        }
        if (is_null($utilizaFormula) || (is_array($utilizaFormula) && empty($utilizaFormula))) {
            unset($this->UtilizaFormula);
        } else {
            $this->UtilizaFormula = $utilizaFormula;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ArtigoUnidadesERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArtigoUnidadesERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
