<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArtigoIdiomaERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArtigoIdiomaERP
 * @subpackage Structs
 */
class ArtigoIdiomaERP extends AbstractStructBase
{
    /**
     * The Artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Artigo;
    /**
     * The Caracteristicas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Caracteristicas;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The DescricaoAbrev
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescricaoAbrev;
    /**
     * The DescricaoComercial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescricaoComercial;
    /**
     * The Idioma
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Idioma;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ArtigoIdiomaERP
     * @uses ArtigoIdiomaERP::setArtigo()
     * @uses ArtigoIdiomaERP::setCaracteristicas()
     * @uses ArtigoIdiomaERP::setDescricao()
     * @uses ArtigoIdiomaERP::setDescricaoAbrev()
     * @uses ArtigoIdiomaERP::setDescricaoComercial()
     * @uses ArtigoIdiomaERP::setIdioma()
     * @uses ArtigoIdiomaERP::setProtegida()
     * @uses ArtigoIdiomaERP::setVersaoUltAct()
     * @param string $artigo
     * @param string $caracteristicas
     * @param string $descricao
     * @param string $descricaoAbrev
     * @param string $descricaoComercial
     * @param string $idioma
     * @param bool $protegida
     * @param string $versaoUltAct
     */
    public function __construct($artigo = null, $caracteristicas = null, $descricao = null, $descricaoAbrev = null, $descricaoComercial = null, $idioma = null, $protegida = null, $versaoUltAct = null)
    {
        $this
            ->setArtigo($artigo)
            ->setCaracteristicas($caracteristicas)
            ->setDescricao($descricao)
            ->setDescricaoAbrev($descricaoAbrev)
            ->setDescricaoComercial($descricaoComercial)
            ->setIdioma($idioma)
            ->setProtegida($protegida)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->Artigo) ? $this->Artigo : null;
    }
    /**
     * Set Artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->Artigo);
        } else {
            $this->Artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get Caracteristicas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCaracteristicas()
    {
        return isset($this->Caracteristicas) ? $this->Caracteristicas : null;
    }
    /**
     * Set Caracteristicas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $caracteristicas
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setCaracteristicas($caracteristicas = null)
    {
        // validation for constraint: string
        if (!is_null($caracteristicas) && !is_string($caracteristicas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($caracteristicas)), __LINE__);
        }
        if (is_null($caracteristicas) || (is_array($caracteristicas) && empty($caracteristicas))) {
            unset($this->Caracteristicas);
        } else {
            $this->Caracteristicas = $caracteristicas;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get DescricaoAbrev value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricaoAbrev()
    {
        return isset($this->DescricaoAbrev) ? $this->DescricaoAbrev : null;
    }
    /**
     * Set DescricaoAbrev value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricaoAbrev
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setDescricaoAbrev($descricaoAbrev = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoAbrev) && !is_string($descricaoAbrev)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoAbrev)), __LINE__);
        }
        if (is_null($descricaoAbrev) || (is_array($descricaoAbrev) && empty($descricaoAbrev))) {
            unset($this->DescricaoAbrev);
        } else {
            $this->DescricaoAbrev = $descricaoAbrev;
        }
        return $this;
    }
    /**
     * Get DescricaoComercial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricaoComercial()
    {
        return isset($this->DescricaoComercial) ? $this->DescricaoComercial : null;
    }
    /**
     * Set DescricaoComercial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricaoComercial
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setDescricaoComercial($descricaoComercial = null)
    {
        // validation for constraint: string
        if (!is_null($descricaoComercial) && !is_string($descricaoComercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricaoComercial)), __LINE__);
        }
        if (is_null($descricaoComercial) || (is_array($descricaoComercial) && empty($descricaoComercial))) {
            unset($this->DescricaoComercial);
        } else {
            $this->DescricaoComercial = $descricaoComercial;
        }
        return $this;
    }
    /**
     * Get Idioma value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdioma()
    {
        return isset($this->Idioma) ? $this->Idioma : null;
    }
    /**
     * Set Idioma value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idioma
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setIdioma($idioma = null)
    {
        // validation for constraint: string
        if (!is_null($idioma) && !is_string($idioma)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idioma)), __LINE__);
        }
        if (is_null($idioma) || (is_array($idioma) && empty($idioma))) {
            unset($this->Idioma);
        } else {
            $this->Idioma = $idioma;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ArtigoIdiomaERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArtigoIdiomaERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
