<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ArmazemLocalizacaoERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArmazemLocalizacaoERP
 * @subpackage Structs
 */
class ArmazemLocalizacaoERP extends AbstractStructBase
{
    /**
     * The Activa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Activa;
    /**
     * The Armazem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Armazem;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdPai
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdPai;
    /**
     * The Localizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localizacao;
    /**
     * The Manual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Manual;
    /**
     * The NomeNivel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeNivel;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ArmazemLocalizacaoERP
     * @uses ArmazemLocalizacaoERP::setActiva()
     * @uses ArmazemLocalizacaoERP::setArmazem()
     * @uses ArmazemLocalizacaoERP::setDescricao()
     * @uses ArmazemLocalizacaoERP::setId()
     * @uses ArmazemLocalizacaoERP::setIdPai()
     * @uses ArmazemLocalizacaoERP::setLocalizacao()
     * @uses ArmazemLocalizacaoERP::setManual()
     * @uses ArmazemLocalizacaoERP::setNomeNivel()
     * @uses ArmazemLocalizacaoERP::setProtegida()
     * @uses ArmazemLocalizacaoERP::setVersaoUltAct()
     * @param bool $activa
     * @param string $armazem
     * @param string $descricao
     * @param string $id
     * @param string $idPai
     * @param string $localizacao
     * @param bool $manual
     * @param string $nomeNivel
     * @param bool $protegida
     * @param string $versaoUltAct
     */
    public function __construct($activa = null, $armazem = null, $descricao = null, $id = null, $idPai = null, $localizacao = null, $manual = null, $nomeNivel = null, $protegida = null, $versaoUltAct = null)
    {
        $this
            ->setActiva($activa)
            ->setArmazem($armazem)
            ->setDescricao($descricao)
            ->setId($id)
            ->setIdPai($idPai)
            ->setLocalizacao($localizacao)
            ->setManual($manual)
            ->setNomeNivel($nomeNivel)
            ->setProtegida($protegida)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Activa value
     * @return bool|null
     */
    public function getActiva()
    {
        return $this->Activa;
    }
    /**
     * Set Activa value
     * @param bool $activa
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setActiva($activa = null)
    {
        // validation for constraint: boolean
        if (!is_null($activa) && !is_bool($activa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($activa)), __LINE__);
        }
        $this->Activa = $activa;
        return $this;
    }
    /**
     * Get Armazem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArmazem()
    {
        return isset($this->Armazem) ? $this->Armazem : null;
    }
    /**
     * Set Armazem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $armazem
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setArmazem($armazem = null)
    {
        // validation for constraint: string
        if (!is_null($armazem) && !is_string($armazem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($armazem)), __LINE__);
        }
        if (is_null($armazem) || (is_array($armazem) && empty($armazem))) {
            unset($this->Armazem);
        } else {
            $this->Armazem = $armazem;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdPai value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdPai()
    {
        return isset($this->IdPai) ? $this->IdPai : null;
    }
    /**
     * Set IdPai value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idPai
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setIdPai($idPai = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idPai) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idPai)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idPai, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idPai) && !is_string($idPai)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idPai)), __LINE__);
        }
        if (is_null($idPai) || (is_array($idPai) && empty($idPai))) {
            unset($this->IdPai);
        } else {
            $this->IdPai = $idPai;
        }
        return $this;
    }
    /**
     * Get Localizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizacao()
    {
        return isset($this->Localizacao) ? $this->Localizacao : null;
    }
    /**
     * Set Localizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizacao
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setLocalizacao($localizacao = null)
    {
        // validation for constraint: string
        if (!is_null($localizacao) && !is_string($localizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizacao)), __LINE__);
        }
        if (is_null($localizacao) || (is_array($localizacao) && empty($localizacao))) {
            unset($this->Localizacao);
        } else {
            $this->Localizacao = $localizacao;
        }
        return $this;
    }
    /**
     * Get Manual value
     * @return bool|null
     */
    public function getManual()
    {
        return $this->Manual;
    }
    /**
     * Set Manual value
     * @param bool $manual
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setManual($manual = null)
    {
        // validation for constraint: boolean
        if (!is_null($manual) && !is_bool($manual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($manual)), __LINE__);
        }
        $this->Manual = $manual;
        return $this;
    }
    /**
     * Get NomeNivel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeNivel()
    {
        return isset($this->NomeNivel) ? $this->NomeNivel : null;
    }
    /**
     * Set NomeNivel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeNivel
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setNomeNivel($nomeNivel = null)
    {
        // validation for constraint: string
        if (!is_null($nomeNivel) && !is_string($nomeNivel)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeNivel)), __LINE__);
        }
        if (is_null($nomeNivel) || (is_array($nomeNivel) && empty($nomeNivel))) {
            unset($this->NomeNivel);
        } else {
            $this->NomeNivel = $nomeNivel;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ArmazemLocalizacaoERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
