<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AbrePlataforma StructType
 * @subpackage Structs
 */
class AbrePlataforma extends AbstractStructBase
{
    /**
     * The tipoPlataforma
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $tipoPlataforma;
    /**
     * The empresa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $empresa;
    /**
     * The utilizador
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $utilizador;
    /**
     * The password
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $password;
    /**
     * The instancia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $instancia;
    /**
     * Constructor method for AbrePlataforma
     * @uses AbrePlataforma::setTipoPlataforma()
     * @uses AbrePlataforma::setEmpresa()
     * @uses AbrePlataforma::setUtilizador()
     * @uses AbrePlataforma::setPassword()
     * @uses AbrePlataforma::setInstancia()
     * @param string $tipoPlataforma
     * @param string $empresa
     * @param string $utilizador
     * @param string $password
     * @param string $instancia
     */
    public function __construct($tipoPlataforma = null, $empresa = null, $utilizador = null, $password = null, $instancia = null)
    {
        $this
            ->setTipoPlataforma($tipoPlataforma)
            ->setEmpresa($empresa)
            ->setUtilizador($utilizador)
            ->setPassword($password)
            ->setInstancia($instancia);
    }
    /**
     * Get tipoPlataforma value
     * @return string|null
     */
    public function getTipoPlataforma()
    {
        return $this->tipoPlataforma;
    }
    /**
     * Set tipoPlataforma value
     * @uses \EnumType\EnumTipoPlataformaERP::valueIsValid()
     * @uses \EnumType\EnumTipoPlataformaERP::getValidValues()
     * @throws \InvalidArgumentException
     * @param string $tipoPlataforma
     * @return \StructType\AbrePlataforma
     */
    public function setTipoPlataforma($tipoPlataforma = null)
    {
        // validation for constraint: enumeration
        if (!\EnumType\EnumTipoPlataformaERP::valueIsValid($tipoPlataforma)) {
            throw new \InvalidArgumentException(sprintf('Value "%s" is invalid, please use one of: %s', $tipoPlataforma, implode(', ', \EnumType\EnumTipoPlataformaERP::getValidValues())), __LINE__);
        }
        $this->tipoPlataforma = $tipoPlataforma;
        return $this;
    }
    /**
     * Get empresa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEmpresa()
    {
        return isset($this->empresa) ? $this->empresa : null;
    }
    /**
     * Set empresa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $empresa
     * @return \StructType\AbrePlataforma
     */
    public function setEmpresa($empresa = null)
    {
        // validation for constraint: string
        if (!is_null($empresa) && !is_string($empresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($empresa)), __LINE__);
        }
        if (is_null($empresa) || (is_array($empresa) && empty($empresa))) {
            unset($this->empresa);
        } else {
            $this->empresa = $empresa;
        }
        return $this;
    }
    /**
     * Get utilizador value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUtilizador()
    {
        return isset($this->utilizador) ? $this->utilizador : null;
    }
    /**
     * Set utilizador value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $utilizador
     * @return \StructType\AbrePlataforma
     */
    public function setUtilizador($utilizador = null)
    {
        // validation for constraint: string
        if (!is_null($utilizador) && !is_string($utilizador)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($utilizador)), __LINE__);
        }
        if (is_null($utilizador) || (is_array($utilizador) && empty($utilizador))) {
            unset($this->utilizador);
        } else {
            $this->utilizador = $utilizador;
        }
        return $this;
    }
    /**
     * Get password value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPassword()
    {
        return isset($this->password) ? $this->password : null;
    }
    /**
     * Set password value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $password
     * @return \StructType\AbrePlataforma
     */
    public function setPassword($password = null)
    {
        // validation for constraint: string
        if (!is_null($password) && !is_string($password)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($password)), __LINE__);
        }
        if (is_null($password) || (is_array($password) && empty($password))) {
            unset($this->password);
        } else {
            $this->password = $password;
        }
        return $this;
    }
    /**
     * Get instancia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getInstancia()
    {
        return isset($this->instancia) ? $this->instancia : null;
    }
    /**
     * Set instancia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $instancia
     * @return \StructType\AbrePlataforma
     */
    public function setInstancia($instancia = null)
    {
        // validation for constraint: string
        if (!is_null($instancia) && !is_string($instancia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($instancia)), __LINE__);
        }
        if (is_null($instancia) || (is_array($instancia) && empty($instancia))) {
            unset($this->instancia);
        } else {
            $this->instancia = $instancia;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AbrePlataforma
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
