<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Lista ServiceType
 * @subpackage Services
 */
class Lista extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ListaContasBancariasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaContasBancariasJSON $parameters
     * @return \StructType\ListaContasBancariasJSONResponse|bool
     */
    public function ListaContasBancariasJSON(\StructType\ListaContasBancariasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaContasBancariasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDistritosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDistritosJSON $parameters
     * @return \StructType\ListaDistritosJSONResponse|bool
     */
    public function ListaDistritosJSON(\StructType\ListaDistritosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDistritosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaTiposDocumentoContasCorrentesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoContasCorrentesJSON $parameters
     * @return \StructType\ListaTiposDocumentoContasCorrentesJSONResponse|bool
     */
    public function ListaTiposDocumentoContasCorrentesJSON(\StructType\ListaTiposDocumentoContasCorrentesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoContasCorrentesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoCompraJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoCompraJSON $parameters
     * @return \StructType\ListaTiposDocumentoCompraJSONResponse|bool
     */
    public function ListaTiposDocumentoCompraJSON(\StructType\ListaTiposDocumentoCompraJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoCompraJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoInternosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoInternosJSON $parameters
     * @return \StructType\ListaTiposDocumentoInternosJSONResponse|bool
     */
    public function ListaTiposDocumentoInternosJSON(\StructType\ListaTiposDocumentoInternosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoInternosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoStockJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoStockJSON $parameters
     * @return \StructType\ListaTiposDocumentoStockJSONResponse|bool
     */
    public function ListaTiposDocumentoStockJSON(\StructType\ListaTiposDocumentoStockJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoStockJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoVendaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoVendaJSON $parameters
     * @return \StructType\ListaTiposDocumentoVendaJSONResponse|bool
     */
    public function ListaTiposDocumentoVendaJSON(\StructType\ListaTiposDocumentoVendaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoVendaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFamiliasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFamiliasJSON $parameters
     * @return \StructType\ListaFamiliasJSONResponse|bool
     */
    public function ListaFamiliasJSON(\StructType\ListaFamiliasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFamiliasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFornecedoresJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFornecedoresJSON $parameters
     * @return \StructType\ListaFornecedoresJSONResponse|bool
     */
    public function ListaFornecedoresJSON(\StructType\ListaFornecedoresJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFornecedoresJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFreguesiasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFreguesiasJSON $parameters
     * @return \StructType\ListaFreguesiasJSONResponse|bool
     */
    public function ListaFreguesiasJSON(\StructType\ListaFreguesiasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFreguesiasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFuncionariosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFuncionariosJSON $parameters
     * @return \StructType\ListaFuncionariosJSONResponse|bool
     */
    public function ListaFuncionariosJSON(\StructType\ListaFuncionariosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFuncionariosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaIvasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaIvasJSON $parameters
     * @return \StructType\ListaIvasJSONResponse|bool
     */
    public function ListaIvasJSON(\StructType\ListaIvasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaIvasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocJSON $parameters
     * @return \StructType\ListaLinhasDocJSONResponse|bool
     */
    public function ListaLinhasDocJSON(\StructType\ListaLinhasDocJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocStatusJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocStatusJSON $parameters
     * @return \StructType\ListaLinhasDocStatusJSONResponse|bool
     */
    public function ListaLinhasDocStatusJSON(\StructType\ListaLinhasDocStatusJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocStatusJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocTransJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocTransJSON $parameters
     * @return \StructType\ListaLinhasDocTransJSONResponse|bool
     */
    public function ListaLinhasDocTransJSON(\StructType\ListaLinhasDocTransJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocTransJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasInternosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasInternosJSON $parameters
     * @return \StructType\ListaLinhasInternosJSONResponse|bool
     */
    public function ListaLinhasInternosJSON(\StructType\ListaLinhasInternosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasInternosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasInternosStatusJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasInternosStatusJSON $parameters
     * @return \StructType\ListaLinhasInternosStatusJSONResponse|bool
     */
    public function ListaLinhasInternosStatusJSON(\StructType\ListaLinhasInternosStatusJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasInternosStatusJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasLiqJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasLiqJSON $parameters
     * @return \StructType\ListaLinhasLiqJSONResponse|bool
     */
    public function ListaLinhasLiqJSON(\StructType\ListaLinhasLiqJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasLiqJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMarcasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMarcasJSON $parameters
     * @return \StructType\ListaMarcasJSONResponse|bool
     */
    public function ListaMarcasJSON(\StructType\ListaMarcasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMarcasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaModelosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaModelosJSON $parameters
     * @return \StructType\ListaModelosJSONResponse|bool
     */
    public function ListaModelosJSON(\StructType\ListaModelosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaModelosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMoedasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoedasJSON $parameters
     * @return \StructType\ListaMoedasJSONResponse|bool
     */
    public function ListaMoedasJSON(\StructType\ListaMoedasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoedasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaMoradasAlternativasClienteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoradasAlternativasClienteJSON $parameters
     * @return \StructType\ListaMoradasAlternativasClienteJSONResponse|bool
     */
    public function ListaMoradasAlternativasClienteJSON(\StructType\ListaMoradasAlternativasClienteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoradasAlternativasClienteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaMoradasAlternativasFornecedorJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoradasAlternativasFornecedorJSON $parameters
     * @return \StructType\ListaMoradasAlternativasFornecedorJSONResponse|bool
     */
    public function ListaMoradasAlternativasFornecedorJSON(\StructType\ListaMoradasAlternativasFornecedorJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoradasAlternativasFornecedorJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMotivosEstornoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMotivosEstornoJSON $parameters
     * @return \StructType\ListaMotivosEstornoJSONResponse|bool
     */
    public function ListaMotivosEstornoJSON(\StructType\ListaMotivosEstornoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMotivosEstornoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMotivosIsencaoIVAJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMotivosIsencaoIVAJSON $parameters
     * @return \StructType\ListaMotivosIsencaoIVAJSONResponse|bool
     */
    public function ListaMotivosIsencaoIVAJSON(\StructType\ListaMotivosIsencaoIVAJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMotivosIsencaoIVAJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaOrigensContactoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaOrigensContactoJSON $parameters
     * @return \StructType\ListaOrigensContactoJSONResponse|bool
     */
    public function ListaOrigensContactoJSON(\StructType\ListaOrigensContactoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaOrigensContactoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaOutrosTerceirosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaOutrosTerceirosJSON $parameters
     * @return \StructType\ListaOutrosTerceirosJSONResponse|bool
     */
    public function ListaOutrosTerceirosJSON(\StructType\ListaOutrosTerceirosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaOutrosTerceirosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesJSON $parameters
     * @return \StructType\ListaPendentesJSONResponse|bool
     */
    public function ListaPendentesJSON(\StructType\ListaPendentesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesEntidadeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesEntidadeJSON $parameters
     * @return \StructType\ListaPendentesEntidadeJSONResponse|bool
     */
    public function ListaPendentesEntidadeJSON(\StructType\ListaPendentesEntidadeJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesEntidadeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesEstabelecimentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesEstabelecimentoJSON $parameters
     * @return \StructType\ListaPendentesEstabelecimentoJSONResponse|bool
     */
    public function ListaPendentesEstabelecimentoJSON(\StructType\ListaPendentesEstabelecimentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesEstabelecimentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoContaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaJSON $parameters
     * @return \StructType\ListaExtratoContaJSONResponse|bool
     */
    public function ListaExtratoContaJSON(\StructType\ListaExtratoContaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaExtratoContaEstabelecimentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaEstabelecimentoJSON $parameters
     * @return \StructType\ListaExtratoContaEstabelecimentoJSONResponse|bool
     */
    public function ListaExtratoContaEstabelecimentoJSON(\StructType\ListaExtratoContaEstabelecimentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaEstabelecimentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoContaEntidadeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaEntidadeJSON $parameters
     * @return \StructType\ListaExtratoContaEntidadeJSONResponse|bool
     */
    public function ListaExtratoContaEntidadeJSON(\StructType\ListaExtratoContaEntidadeJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaEntidadeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosIvaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosIvaJSON $parameters
     * @return \StructType\ListaResumosIvaJSONResponse|bool
     */
    public function ListaResumosIvaJSON(\StructType\ListaResumosIvaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosIvaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosRetencaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosRetencaoJSON $parameters
     * @return \StructType\ListaResumosRetencaoJSONResponse|bool
     */
    public function ListaResumosRetencaoJSON(\StructType\ListaResumosRetencaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosRetencaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosRetencaoLiqJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosRetencaoLiqJSON $parameters
     * @return \StructType\ListaResumosRetencaoLiqJSONResponse|bool
     */
    public function ListaResumosRetencaoLiqJSON(\StructType\ListaResumosRetencaoLiqJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosRetencaoLiqJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesCCTJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesCCTJSON $parameters
     * @return \StructType\ListaSeriesCCTJSONResponse|bool
     */
    public function ListaSeriesCCTJSON(\StructType\ListaSeriesCCTJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesCCTJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesContratosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesContratosJSON $parameters
     * @return \StructType\ListaSeriesContratosJSONResponse|bool
     */
    public function ListaSeriesContratosJSON(\StructType\ListaSeriesContratosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesContratosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesStockJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesStockJSON $parameters
     * @return \StructType\ListaSeriesStockJSONResponse|bool
     */
    public function ListaSeriesStockJSON(\StructType\ListaSeriesStockJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesStockJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesVendasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesVendasJSON $parameters
     * @return \StructType\ListaSeriesVendasJSONResponse|bool
     */
    public function ListaSeriesVendasJSON(\StructType\ListaSeriesVendasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesVendasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesComprasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesComprasJSON $parameters
     * @return \StructType\ListaSeriesComprasJSONResponse|bool
     */
    public function ListaSeriesComprasJSON(\StructType\ListaSeriesComprasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesComprasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposTerceiroJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposTerceiroJSON $parameters
     * @return \StructType\ListaTiposTerceiroJSONResponse|bool
     */
    public function ListaTiposTerceiroJSON(\StructType\ListaTiposTerceiroJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposTerceiroJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposParceiroJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposParceiroJSON $parameters
     * @return \StructType\ListaTiposParceiroJSONResponse|bool
     */
    public function ListaTiposParceiroJSON(\StructType\ListaTiposParceiroJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposParceiroJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaUnidadesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaUnidadesJSON $parameters
     * @return \StructType\ListaUnidadesJSONResponse|bool
     */
    public function ListaUnidadesJSON(\StructType\ListaUnidadesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaUnidadesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosMoedaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosMoedaXML $parameters
     * @return \StructType\ListaArtigosMoedaXMLResponse|bool
     */
    public function ListaArtigosMoedaXML(\StructType\ListaArtigosMoedaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosMoedaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosUnidadeXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosUnidadeXML $parameters
     * @return \StructType\ListaArtigosUnidadeXMLResponse|bool
     */
    public function ListaArtigosUnidadeXML(\StructType\ListaArtigosUnidadeXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosUnidadeXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosCompraXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosCompraXML $parameters
     * @return \StructType\ListaDocumentosCompraXMLResponse|bool
     */
    public function ListaDocumentosCompraXML(\StructType\ListaDocumentosCompraXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosCompraXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstadosDocumentosCompraXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstadosDocumentosCompraXML $parameters
     * @return \StructType\ListaEstadosDocumentosCompraXMLResponse|bool
     */
    public function ListaEstadosDocumentosCompraXML(\StructType\ListaEstadosDocumentosCompraXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstadosDocumentosCompraXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosVendaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosVendaXML $parameters
     * @return \StructType\ListaDocumentosVendaXMLResponse|bool
     */
    public function ListaDocumentosVendaXML(\StructType\ListaDocumentosVendaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosVendaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEncomendasVendaPendentesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEncomendasVendaPendentesXML $parameters
     * @return \StructType\ListaEncomendasVendaPendentesXMLResponse|bool
     */
    public function ListaEncomendasVendaPendentesXML(\StructType\ListaEncomendasVendaPendentesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEncomendasVendaPendentesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstadosDocumentosVendaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstadosDocumentosVendaXML $parameters
     * @return \StructType\ListaEstadosDocumentosVendaXMLResponse|bool
     */
    public function ListaEstadosDocumentosVendaXML(\StructType\ListaEstadosDocumentosVendaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstadosDocumentosVendaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosInternosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosInternosXML $parameters
     * @return \StructType\ListaDocumentosInternosXMLResponse|bool
     */
    public function ListaDocumentosInternosXML(\StructType\ListaDocumentosInternosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosInternosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosLiquidacaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosLiquidacaoXML $parameters
     * @return \StructType\ListaDocumentosLiquidacaoXMLResponse|bool
     */
    public function ListaDocumentosLiquidacaoXML(\StructType\ListaDocumentosLiquidacaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosLiquidacaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaClientesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaClientesXML $parameters
     * @return \StructType\ListaClientesXMLResponse|bool
     */
    public function ListaClientesXML(\StructType\ListaClientesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaClientesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaConcelhosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaConcelhosXML $parameters
     * @return \StructType\ListaConcelhosXMLResponse|bool
     */
    public function ListaConcelhosXML(\StructType\ListaConcelhosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaConcelhosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaContasBancariasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaContasBancariasXML $parameters
     * @return \StructType\ListaContasBancariasXMLResponse|bool
     */
    public function ListaContasBancariasXML(\StructType\ListaContasBancariasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaContasBancariasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDistritosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDistritosXML $parameters
     * @return \StructType\ListaDistritosXMLResponse|bool
     */
    public function ListaDistritosXML(\StructType\ListaDistritosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDistritosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaTiposDocumentoContasCorrentesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoContasCorrentesXML $parameters
     * @return \StructType\ListaTiposDocumentoContasCorrentesXMLResponse|bool
     */
    public function ListaTiposDocumentoContasCorrentesXML(\StructType\ListaTiposDocumentoContasCorrentesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoContasCorrentesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoCompraXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoCompraXML $parameters
     * @return \StructType\ListaTiposDocumentoCompraXMLResponse|bool
     */
    public function ListaTiposDocumentoCompraXML(\StructType\ListaTiposDocumentoCompraXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoCompraXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoInternosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoInternosXML $parameters
     * @return \StructType\ListaTiposDocumentoInternosXMLResponse|bool
     */
    public function ListaTiposDocumentoInternosXML(\StructType\ListaTiposDocumentoInternosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoInternosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoStockXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoStockXML $parameters
     * @return \StructType\ListaTiposDocumentoStockXMLResponse|bool
     */
    public function ListaTiposDocumentoStockXML(\StructType\ListaTiposDocumentoStockXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoStockXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoVendaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoVendaXML $parameters
     * @return \StructType\ListaTiposDocumentoVendaXMLResponse|bool
     */
    public function ListaTiposDocumentoVendaXML(\StructType\ListaTiposDocumentoVendaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoVendaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFamiliasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFamiliasXML $parameters
     * @return \StructType\ListaFamiliasXMLResponse|bool
     */
    public function ListaFamiliasXML(\StructType\ListaFamiliasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFamiliasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFornecedoresXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFornecedoresXML $parameters
     * @return \StructType\ListaFornecedoresXMLResponse|bool
     */
    public function ListaFornecedoresXML(\StructType\ListaFornecedoresXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFornecedoresXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFreguesiasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFreguesiasXML $parameters
     * @return \StructType\ListaFreguesiasXMLResponse|bool
     */
    public function ListaFreguesiasXML(\StructType\ListaFreguesiasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFreguesiasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFuncionariosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFuncionariosXML $parameters
     * @return \StructType\ListaFuncionariosXMLResponse|bool
     */
    public function ListaFuncionariosXML(\StructType\ListaFuncionariosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFuncionariosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaIvasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaIvasXML $parameters
     * @return \StructType\ListaIvasXMLResponse|bool
     */
    public function ListaIvasXML(\StructType\ListaIvasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaIvasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocXML $parameters
     * @return \StructType\ListaLinhasDocXMLResponse|bool
     */
    public function ListaLinhasDocXML(\StructType\ListaLinhasDocXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocStatusXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocStatusXML $parameters
     * @return \StructType\ListaLinhasDocStatusXMLResponse|bool
     */
    public function ListaLinhasDocStatusXML(\StructType\ListaLinhasDocStatusXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocStatusXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocTransXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocTransXML $parameters
     * @return \StructType\ListaLinhasDocTransXMLResponse|bool
     */
    public function ListaLinhasDocTransXML(\StructType\ListaLinhasDocTransXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocTransXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasInternosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasInternosXML $parameters
     * @return \StructType\ListaLinhasInternosXMLResponse|bool
     */
    public function ListaLinhasInternosXML(\StructType\ListaLinhasInternosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasInternosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasInternosStatusXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasInternosStatusXML $parameters
     * @return \StructType\ListaLinhasInternosStatusXMLResponse|bool
     */
    public function ListaLinhasInternosStatusXML(\StructType\ListaLinhasInternosStatusXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasInternosStatusXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasLiqXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasLiqXML $parameters
     * @return \StructType\ListaLinhasLiqXMLResponse|bool
     */
    public function ListaLinhasLiqXML(\StructType\ListaLinhasLiqXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasLiqXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMarcasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMarcasXML $parameters
     * @return \StructType\ListaMarcasXMLResponse|bool
     */
    public function ListaMarcasXML(\StructType\ListaMarcasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMarcasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaModelosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaModelosXML $parameters
     * @return \StructType\ListaModelosXMLResponse|bool
     */
    public function ListaModelosXML(\StructType\ListaModelosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaModelosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMoedasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoedasXML $parameters
     * @return \StructType\ListaMoedasXMLResponse|bool
     */
    public function ListaMoedasXML(\StructType\ListaMoedasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoedasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMoradasAlternativasClienteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoradasAlternativasClienteXML $parameters
     * @return \StructType\ListaMoradasAlternativasClienteXMLResponse|bool
     */
    public function ListaMoradasAlternativasClienteXML(\StructType\ListaMoradasAlternativasClienteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoradasAlternativasClienteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaMoradasAlternativasFornecedorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoradasAlternativasFornecedorXML $parameters
     * @return \StructType\ListaMoradasAlternativasFornecedorXMLResponse|bool
     */
    public function ListaMoradasAlternativasFornecedorXML(\StructType\ListaMoradasAlternativasFornecedorXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoradasAlternativasFornecedorXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMotivosEstornoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMotivosEstornoXML $parameters
     * @return \StructType\ListaMotivosEstornoXMLResponse|bool
     */
    public function ListaMotivosEstornoXML(\StructType\ListaMotivosEstornoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMotivosEstornoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMotivosIsencaoIVAXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMotivosIsencaoIVAXML $parameters
     * @return \StructType\ListaMotivosIsencaoIVAXMLResponse|bool
     */
    public function ListaMotivosIsencaoIVAXML(\StructType\ListaMotivosIsencaoIVAXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMotivosIsencaoIVAXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaOrigensContactoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaOrigensContactoXML $parameters
     * @return \StructType\ListaOrigensContactoXMLResponse|bool
     */
    public function ListaOrigensContactoXML(\StructType\ListaOrigensContactoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaOrigensContactoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaOutrosTerceirosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaOutrosTerceirosXML $parameters
     * @return \StructType\ListaOutrosTerceirosXMLResponse|bool
     */
    public function ListaOutrosTerceirosXML(\StructType\ListaOutrosTerceirosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaOutrosTerceirosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesXML $parameters
     * @return \StructType\ListaPendentesXMLResponse|bool
     */
    public function ListaPendentesXML(\StructType\ListaPendentesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesEntidadeXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesEntidadeXML $parameters
     * @return \StructType\ListaPendentesEntidadeXMLResponse|bool
     */
    public function ListaPendentesEntidadeXML(\StructType\ListaPendentesEntidadeXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesEntidadeXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesEstabelecimentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesEstabelecimentoXML $parameters
     * @return \StructType\ListaPendentesEstabelecimentoXMLResponse|bool
     */
    public function ListaPendentesEstabelecimentoXML(\StructType\ListaPendentesEstabelecimentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesEstabelecimentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoContaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaXML $parameters
     * @return \StructType\ListaExtratoContaXMLResponse|bool
     */
    public function ListaExtratoContaXML(\StructType\ListaExtratoContaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoContaEntidadeXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaEntidadeXML $parameters
     * @return \StructType\ListaExtratoContaEntidadeXMLResponse|bool
     */
    public function ListaExtratoContaEntidadeXML(\StructType\ListaExtratoContaEntidadeXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaEntidadeXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * ListaExtratoContaEstabelecimentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaEstabelecimentoXML $parameters
     * @return \StructType\ListaExtratoContaEstabelecimentoXMLResponse|bool
     */
    public function ListaExtratoContaEstabelecimentoXML(\StructType\ListaExtratoContaEstabelecimentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaEstabelecimentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosIvaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosIvaXML $parameters
     * @return \StructType\ListaResumosIvaXMLResponse|bool
     */
    public function ListaResumosIvaXML(\StructType\ListaResumosIvaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosIvaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosRetencaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosRetencaoXML $parameters
     * @return \StructType\ListaResumosRetencaoXMLResponse|bool
     */
    public function ListaResumosRetencaoXML(\StructType\ListaResumosRetencaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosRetencaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosRetencaoLiqXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosRetencaoLiqXML $parameters
     * @return \StructType\ListaResumosRetencaoLiqXMLResponse|bool
     */
    public function ListaResumosRetencaoLiqXML(\StructType\ListaResumosRetencaoLiqXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosRetencaoLiqXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesCCTXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesCCTXML $parameters
     * @return \StructType\ListaSeriesCCTXMLResponse|bool
     */
    public function ListaSeriesCCTXML(\StructType\ListaSeriesCCTXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesCCTXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesContratosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesContratosXML $parameters
     * @return \StructType\ListaSeriesContratosXMLResponse|bool
     */
    public function ListaSeriesContratosXML(\StructType\ListaSeriesContratosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesContratosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesStockXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesStockXML $parameters
     * @return \StructType\ListaSeriesStockXMLResponse|bool
     */
    public function ListaSeriesStockXML(\StructType\ListaSeriesStockXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesStockXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesVendasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesVendasXML $parameters
     * @return \StructType\ListaSeriesVendasXMLResponse|bool
     */
    public function ListaSeriesVendasXML(\StructType\ListaSeriesVendasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesVendasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesComprasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesComprasXML $parameters
     * @return \StructType\ListaSeriesComprasXMLResponse|bool
     */
    public function ListaSeriesComprasXML(\StructType\ListaSeriesComprasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesComprasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposTerceiroXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposTerceiroXML $parameters
     * @return \StructType\ListaTiposTerceiroXMLResponse|bool
     */
    public function ListaTiposTerceiroXML(\StructType\ListaTiposTerceiroXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposTerceiroXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposParceiroXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposParceiroXML $parameters
     * @return \StructType\ListaTiposParceiroXMLResponse|bool
     */
    public function ListaTiposParceiroXML(\StructType\ListaTiposParceiroXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposParceiroXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaUnidadesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaUnidadesXML $parameters
     * @return \StructType\ListaUnidadesXMLResponse|bool
     */
    public function ListaUnidadesXML(\StructType\ListaUnidadesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaUnidadesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaConfiguracoesEasyPayJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaConfiguracoesEasyPayJSON $parameters
     * @return \StructType\ListaConfiguracoesEasyPayJSONResponse|bool
     */
    public function ListaConfiguracoesEasyPayJSON(\StructType\ListaConfiguracoesEasyPayJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaConfiguracoesEasyPayJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosArmazemJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosArmazemJSON $parameters
     * @return \StructType\ListaArtigosArmazemJSONResponse|bool
     */
    public function ListaArtigosArmazemJSON(\StructType\ListaArtigosArmazemJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosArmazemJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaVendedoresJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaVendedoresJSON $parameters
     * @return \StructType\ListaVendedoresJSONResponse|bool
     */
    public function ListaVendedoresJSON(\StructType\ListaVendedoresJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaVendedoresJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaModosExpedicaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaModosExpedicaoJSON $parameters
     * @return \StructType\ListaModosExpedicaoJSONResponse|bool
     */
    public function ListaModosExpedicaoJSON(\StructType\ListaModosExpedicaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaModosExpedicaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosJSON $parameters
     * @return \StructType\ListaArtigosJSONResponse|bool
     */
    public function ListaArtigosJSON(\StructType\ListaArtigosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTipoDocIdentificacaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTipoDocIdentificacaoJSON $parameters
     * @return \StructType\ListaTipoDocIdentificacaoJSONResponse|bool
     */
    public function ListaTipoDocIdentificacaoJSON(\StructType\ListaTipoDocIdentificacaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTipoDocIdentificacaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEmpresasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEmpresasJSON $parameters
     * @return \StructType\ListaEmpresasJSONResponse|bool
     */
    public function ListaEmpresasJSON(\StructType\ListaEmpresasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEmpresasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPaisesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPaisesJSON $parameters
     * @return \StructType\ListaPaisesJSONResponse|bool
     */
    public function ListaPaisesJSON(\StructType\ListaPaisesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPaisesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaParceirosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaParceirosJSON $parameters
     * @return \StructType\ListaParceirosJSONResponse|bool
     */
    public function ListaParceirosJSON(\StructType\ListaParceirosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaParceirosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposContactoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposContactoJSON $parameters
     * @return \StructType\ListaTiposContactoJSONResponse|bool
     */
    public function ListaTiposContactoJSON(\StructType\ListaTiposContactoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposContactoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstabelecimentosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstabelecimentosJSON $parameters
     * @return \StructType\ListaEstabelecimentosJSONResponse|bool
     */
    public function ListaEstabelecimentosJSON(\StructType\ListaEstabelecimentosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstabelecimentosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaContactosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaContactosJSON $parameters
     * @return \StructType\ListaContactosJSONResponse|bool
     */
    public function ListaContactosJSON(\StructType\ListaContactosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaContactosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArmazensJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArmazensJSON $parameters
     * @return \StructType\ListaArmazensJSONResponse|bool
     */
    public function ListaArmazensJSON(\StructType\ListaArmazensJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArmazensJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArmazemLocalizacoesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArmazemLocalizacoesJSON $parameters
     * @return \StructType\ListaArmazemLocalizacoesJSONResponse|bool
     */
    public function ListaArmazemLocalizacoesJSON(\StructType\ListaArmazemLocalizacoesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArmazemLocalizacoesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMetodosPagamentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMetodosPagamentoJSON $parameters
     * @return \StructType\ListaMetodosPagamentoJSONResponse|bool
     */
    public function ListaMetodosPagamentoJSON(\StructType\ListaMetodosPagamentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMetodosPagamentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaCondicoesPagamentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaCondicoesPagamentoJSON $parameters
     * @return \StructType\ListaCondicoesPagamentoJSONResponse|bool
     */
    public function ListaCondicoesPagamentoJSON(\StructType\ListaCondicoesPagamentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaCondicoesPagamentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosFornecedorJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosFornecedorJSON $parameters
     * @return \StructType\ListaArtigosFornecedorJSONResponse|bool
     */
    public function ListaArtigosFornecedorJSON(\StructType\ListaArtigosFornecedorJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosFornecedorJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosIdiomaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosIdiomaJSON $parameters
     * @return \StructType\ListaArtigosIdiomaJSONResponse|bool
     */
    public function ListaArtigosIdiomaJSON(\StructType\ListaArtigosIdiomaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosIdiomaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosLoteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosLoteJSON $parameters
     * @return \StructType\ListaArtigosLoteJSONResponse|bool
     */
    public function ListaArtigosLoteJSON(\StructType\ListaArtigosLoteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosLoteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosMoedaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosMoedaJSON $parameters
     * @return \StructType\ListaArtigosMoedaJSONResponse|bool
     */
    public function ListaArtigosMoedaJSON(\StructType\ListaArtigosMoedaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosMoedaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosUnidadeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosUnidadeJSON $parameters
     * @return \StructType\ListaArtigosUnidadeJSONResponse|bool
     */
    public function ListaArtigosUnidadeJSON(\StructType\ListaArtigosUnidadeJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosUnidadeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosCompraJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosCompraJSON $parameters
     * @return \StructType\ListaDocumentosCompraJSONResponse|bool
     */
    public function ListaDocumentosCompraJSON(\StructType\ListaDocumentosCompraJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosCompraJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstadosDocumentosCompraJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstadosDocumentosCompraJSON $parameters
     * @return \StructType\ListaEstadosDocumentosCompraJSONResponse|bool
     */
    public function ListaEstadosDocumentosCompraJSON(\StructType\ListaEstadosDocumentosCompraJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstadosDocumentosCompraJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosVendaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosVendaJSON $parameters
     * @return \StructType\ListaDocumentosVendaJSONResponse|bool
     */
    public function ListaDocumentosVendaJSON(\StructType\ListaDocumentosVendaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosVendaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEncomendasVendaPendentesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEncomendasVendaPendentesJSON $parameters
     * @return \StructType\ListaEncomendasVendaPendentesJSONResponse|bool
     */
    public function ListaEncomendasVendaPendentesJSON(\StructType\ListaEncomendasVendaPendentesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEncomendasVendaPendentesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstadosDocumentosVendaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstadosDocumentosVendaJSON $parameters
     * @return \StructType\ListaEstadosDocumentosVendaJSONResponse|bool
     */
    public function ListaEstadosDocumentosVendaJSON(\StructType\ListaEstadosDocumentosVendaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstadosDocumentosVendaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosInternosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosInternosJSON $parameters
     * @return \StructType\ListaDocumentosInternosJSONResponse|bool
     */
    public function ListaDocumentosInternosJSON(\StructType\ListaDocumentosInternosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosInternosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosLiquidacaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosLiquidacaoJSON $parameters
     * @return \StructType\ListaDocumentosLiquidacaoJSONResponse|bool
     */
    public function ListaDocumentosLiquidacaoJSON(\StructType\ListaDocumentosLiquidacaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosLiquidacaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaClientesJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaClientesJSON $parameters
     * @return \StructType\ListaClientesJSONResponse|bool
     */
    public function ListaClientesJSON(\StructType\ListaClientesJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaClientesJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaConcelhosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaConcelhosJSON $parameters
     * @return \StructType\ListaConcelhosJSONResponse|bool
     */
    public function ListaConcelhosJSON(\StructType\ListaConcelhosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaConcelhosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstabelecimentos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstabelecimentos $parameters
     * @return \StructType\ListaEstabelecimentosResponse|bool
     */
    public function ListaEstabelecimentos(\StructType\ListaEstabelecimentos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstabelecimentos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaContactos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaContactos $parameters
     * @return \StructType\ListaContactosResponse|bool
     */
    public function ListaContactos(\StructType\ListaContactos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaContactos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArmazens
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArmazens $parameters
     * @return \StructType\ListaArmazensResponse|bool
     */
    public function ListaArmazens(\StructType\ListaArmazens $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArmazens($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArmazemLocalizacoes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArmazemLocalizacoes $parameters
     * @return \StructType\ListaArmazemLocalizacoesResponse|bool
     */
    public function ListaArmazemLocalizacoes(\StructType\ListaArmazemLocalizacoes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArmazemLocalizacoes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMetodosPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMetodosPagamento $parameters
     * @return \StructType\ListaMetodosPagamentoResponse|bool
     */
    public function ListaMetodosPagamento(\StructType\ListaMetodosPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMetodosPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaCondicoesPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaCondicoesPagamento $parameters
     * @return \StructType\ListaCondicoesPagamentoResponse|bool
     */
    public function ListaCondicoesPagamento(\StructType\ListaCondicoesPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaCondicoesPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigos $parameters
     * @return \StructType\ListaArtigosResponse|bool
     */
    public function ListaArtigos(\StructType\ListaArtigos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTipoDocIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTipoDocIdentificacao $parameters
     * @return \StructType\ListaTipoDocIdentificacaoResponse|bool
     */
    public function ListaTipoDocIdentificacao(\StructType\ListaTipoDocIdentificacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTipoDocIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosFornecedor $parameters
     * @return \StructType\ListaArtigosFornecedorResponse|bool
     */
    public function ListaArtigosFornecedor(\StructType\ListaArtigosFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosIdioma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosIdioma $parameters
     * @return \StructType\ListaArtigosIdiomaResponse|bool
     */
    public function ListaArtigosIdioma(\StructType\ListaArtigosIdioma $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosIdioma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosLote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosLote $parameters
     * @return \StructType\ListaArtigosLoteResponse|bool
     */
    public function ListaArtigosLote(\StructType\ListaArtigosLote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosLote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosMoeda $parameters
     * @return \StructType\ListaArtigosMoedaResponse|bool
     */
    public function ListaArtigosMoeda(\StructType\ListaArtigosMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosUnidade $parameters
     * @return \StructType\ListaArtigosUnidadeResponse|bool
     */
    public function ListaArtigosUnidade(\StructType\ListaArtigosUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosCompra $parameters
     * @return \StructType\ListaDocumentosCompraResponse|bool
     */
    public function ListaDocumentosCompra(\StructType\ListaDocumentosCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstadosDocumentosCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstadosDocumentosCompra $parameters
     * @return \StructType\ListaEstadosDocumentosCompraResponse|bool
     */
    public function ListaEstadosDocumentosCompra(\StructType\ListaEstadosDocumentosCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstadosDocumentosCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosVenda $parameters
     * @return \StructType\ListaDocumentosVendaResponse|bool
     */
    public function ListaDocumentosVenda(\StructType\ListaDocumentosVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEncomendasVendaPendentes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEncomendasVendaPendentes $parameters
     * @return \StructType\ListaEncomendasVendaPendentesResponse|bool
     */
    public function ListaEncomendasVendaPendentes(\StructType\ListaEncomendasVendaPendentes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEncomendasVendaPendentes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstadosDocumentosVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstadosDocumentosVenda $parameters
     * @return \StructType\ListaEstadosDocumentosVendaResponse|bool
     */
    public function ListaEstadosDocumentosVenda(\StructType\ListaEstadosDocumentosVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstadosDocumentosVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosInternos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosInternos $parameters
     * @return \StructType\ListaDocumentosInternosResponse|bool
     */
    public function ListaDocumentosInternos(\StructType\ListaDocumentosInternos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosInternos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDocumentosLiquidacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDocumentosLiquidacao $parameters
     * @return \StructType\ListaDocumentosLiquidacaoResponse|bool
     */
    public function ListaDocumentosLiquidacao(\StructType\ListaDocumentosLiquidacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDocumentosLiquidacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaClientes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaClientes $parameters
     * @return \StructType\ListaClientesResponse|bool
     */
    public function ListaClientes(\StructType\ListaClientes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaClientes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaConcelhos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaConcelhos $parameters
     * @return \StructType\ListaConcelhosResponse|bool
     */
    public function ListaConcelhos(\StructType\ListaConcelhos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaConcelhos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaContasBancarias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaContasBancarias $parameters
     * @return \StructType\ListaContasBancariasResponse|bool
     */
    public function ListaContasBancarias(\StructType\ListaContasBancarias $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaContasBancarias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaDistritos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaDistritos $parameters
     * @return \StructType\ListaDistritosResponse|bool
     */
    public function ListaDistritos(\StructType\ListaDistritos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaDistritos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoContasCorrentes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoContasCorrentes $parameters
     * @return \StructType\ListaTiposDocumentoContasCorrentesResponse|bool
     */
    public function ListaTiposDocumentoContasCorrentes(\StructType\ListaTiposDocumentoContasCorrentes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoContasCorrentes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoCompra $parameters
     * @return \StructType\ListaTiposDocumentoCompraResponse|bool
     */
    public function ListaTiposDocumentoCompra(\StructType\ListaTiposDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoInternos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoInternos $parameters
     * @return \StructType\ListaTiposDocumentoInternosResponse|bool
     */
    public function ListaTiposDocumentoInternos(\StructType\ListaTiposDocumentoInternos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoInternos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoStock $parameters
     * @return \StructType\ListaTiposDocumentoStockResponse|bool
     */
    public function ListaTiposDocumentoStock(\StructType\ListaTiposDocumentoStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposDocumentoVenda $parameters
     * @return \StructType\ListaTiposDocumentoVendaResponse|bool
     */
    public function ListaTiposDocumentoVenda(\StructType\ListaTiposDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFamilias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFamilias $parameters
     * @return \StructType\ListaFamiliasResponse|bool
     */
    public function ListaFamilias(\StructType\ListaFamilias $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFamilias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFornecedores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFornecedores $parameters
     * @return \StructType\ListaFornecedoresResponse|bool
     */
    public function ListaFornecedores(\StructType\ListaFornecedores $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFornecedores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFreguesias
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFreguesias $parameters
     * @return \StructType\ListaFreguesiasResponse|bool
     */
    public function ListaFreguesias(\StructType\ListaFreguesias $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFreguesias($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaFuncionarios
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaFuncionarios $parameters
     * @return \StructType\ListaFuncionariosResponse|bool
     */
    public function ListaFuncionarios(\StructType\ListaFuncionarios $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaFuncionarios($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaIvas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaIvas $parameters
     * @return \StructType\ListaIvasResponse|bool
     */
    public function ListaIvas(\StructType\ListaIvas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaIvas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDoc $parameters
     * @return \StructType\ListaLinhasDocResponse|bool
     */
    public function ListaLinhasDoc(\StructType\ListaLinhasDoc $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocStatus $parameters
     * @return \StructType\ListaLinhasDocStatusResponse|bool
     */
    public function ListaLinhasDocStatus(\StructType\ListaLinhasDocStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasDocTrans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasDocTrans $parameters
     * @return \StructType\ListaLinhasDocTransResponse|bool
     */
    public function ListaLinhasDocTrans(\StructType\ListaLinhasDocTrans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasDocTrans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasInternos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasInternos $parameters
     * @return \StructType\ListaLinhasInternosResponse|bool
     */
    public function ListaLinhasInternos(\StructType\ListaLinhasInternos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasInternos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasInternosStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasInternosStatus $parameters
     * @return \StructType\ListaLinhasInternosStatusResponse|bool
     */
    public function ListaLinhasInternosStatus(\StructType\ListaLinhasInternosStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasInternosStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaLinhasLiq
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaLinhasLiq $parameters
     * @return \StructType\ListaLinhasLiqResponse|bool
     */
    public function ListaLinhasLiq(\StructType\ListaLinhasLiq $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaLinhasLiq($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMarcas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMarcas $parameters
     * @return \StructType\ListaMarcasResponse|bool
     */
    public function ListaMarcas(\StructType\ListaMarcas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMarcas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaModelos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaModelos $parameters
     * @return \StructType\ListaModelosResponse|bool
     */
    public function ListaModelos(\StructType\ListaModelos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaModelos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMoedas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoedas $parameters
     * @return \StructType\ListaMoedasResponse|bool
     */
    public function ListaMoedas(\StructType\ListaMoedas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoedas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMoradasAlternativasCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoradasAlternativasCliente $parameters
     * @return \StructType\ListaMoradasAlternativasClienteResponse|bool
     */
    public function ListaMoradasAlternativasCliente(\StructType\ListaMoradasAlternativasCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoradasAlternativasCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMoradasAlternativasFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMoradasAlternativasFornecedor $parameters
     * @return \StructType\ListaMoradasAlternativasFornecedorResponse|bool
     */
    public function ListaMoradasAlternativasFornecedor(\StructType\ListaMoradasAlternativasFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMoradasAlternativasFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMotivosEstorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMotivosEstorno $parameters
     * @return \StructType\ListaMotivosEstornoResponse|bool
     */
    public function ListaMotivosEstorno(\StructType\ListaMotivosEstorno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMotivosEstorno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMotivosIsencaoIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMotivosIsencaoIVA $parameters
     * @return \StructType\ListaMotivosIsencaoIVAResponse|bool
     */
    public function ListaMotivosIsencaoIVA(\StructType\ListaMotivosIsencaoIVA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMotivosIsencaoIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaOrigensContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaOrigensContacto $parameters
     * @return \StructType\ListaOrigensContactoResponse|bool
     */
    public function ListaOrigensContacto(\StructType\ListaOrigensContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaOrigensContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaOutrosTerceiros
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaOutrosTerceiros $parameters
     * @return \StructType\ListaOutrosTerceirosResponse|bool
     */
    public function ListaOutrosTerceiros(\StructType\ListaOutrosTerceiros $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaOutrosTerceiros($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentes
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentes $parameters
     * @return \StructType\ListaPendentesResponse|bool
     */
    public function ListaPendentes(\StructType\ListaPendentes $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentes($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesEntidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesEntidade $parameters
     * @return \StructType\ListaPendentesEntidadeResponse|bool
     */
    public function ListaPendentesEntidade(\StructType\ListaPendentesEntidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesEntidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPendentesEstabelecimento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPendentesEstabelecimento $parameters
     * @return \StructType\ListaPendentesEstabelecimentoResponse|bool
     */
    public function ListaPendentesEstabelecimento(\StructType\ListaPendentesEstabelecimento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPendentesEstabelecimento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoConta
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoConta $parameters
     * @return \StructType\ListaExtratoContaResponse|bool
     */
    public function ListaExtratoConta(\StructType\ListaExtratoConta $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoConta($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoContaEntidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaEntidade $parameters
     * @return \StructType\ListaExtratoContaEntidadeResponse|bool
     */
    public function ListaExtratoContaEntidade(\StructType\ListaExtratoContaEntidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaEntidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaExtratoContaEstabelecimento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaExtratoContaEstabelecimento $parameters
     * @return \StructType\ListaExtratoContaEstabelecimentoResponse|bool
     */
    public function ListaExtratoContaEstabelecimento(\StructType\ListaExtratoContaEstabelecimento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaExtratoContaEstabelecimento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosIva $parameters
     * @return \StructType\ListaResumosIvaResponse|bool
     */
    public function ListaResumosIva(\StructType\ListaResumosIva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosRetencao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosRetencao $parameters
     * @return \StructType\ListaResumosRetencaoResponse|bool
     */
    public function ListaResumosRetencao(\StructType\ListaResumosRetencao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosRetencao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaResumosRetencaoLiq
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaResumosRetencaoLiq $parameters
     * @return \StructType\ListaResumosRetencaoLiqResponse|bool
     */
    public function ListaResumosRetencaoLiq(\StructType\ListaResumosRetencaoLiq $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaResumosRetencaoLiq($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesCCT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesCCT $parameters
     * @return \StructType\ListaSeriesCCTResponse|bool
     */
    public function ListaSeriesCCT(\StructType\ListaSeriesCCT $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesCCT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesContratos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesContratos $parameters
     * @return \StructType\ListaSeriesContratosResponse|bool
     */
    public function ListaSeriesContratos(\StructType\ListaSeriesContratos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesContratos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesStock $parameters
     * @return \StructType\ListaSeriesStockResponse|bool
     */
    public function ListaSeriesStock(\StructType\ListaSeriesStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesVendas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesVendas $parameters
     * @return \StructType\ListaSeriesVendasResponse|bool
     */
    public function ListaSeriesVendas(\StructType\ListaSeriesVendas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesVendas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaSeriesCompras
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaSeriesCompras $parameters
     * @return \StructType\ListaSeriesComprasResponse|bool
     */
    public function ListaSeriesCompras(\StructType\ListaSeriesCompras $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaSeriesCompras($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposTerceiro $parameters
     * @return \StructType\ListaTiposTerceiroResponse|bool
     */
    public function ListaTiposTerceiro(\StructType\ListaTiposTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposParceiro $parameters
     * @return \StructType\ListaTiposParceiroResponse|bool
     */
    public function ListaTiposParceiro(\StructType\ListaTiposParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaUnidades
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaUnidades $parameters
     * @return \StructType\ListaUnidadesResponse|bool
     */
    public function ListaUnidades(\StructType\ListaUnidades $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaUnidades($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosArmazemXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosArmazemXML $parameters
     * @return \StructType\ListaArtigosArmazemXMLResponse|bool
     */
    public function ListaArtigosArmazemXML(\StructType\ListaArtigosArmazemXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosArmazemXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaVendedoresXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaVendedoresXML $parameters
     * @return \StructType\ListaVendedoresXMLResponse|bool
     */
    public function ListaVendedoresXML(\StructType\ListaVendedoresXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaVendedoresXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaModosExpedicaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaModosExpedicaoXML $parameters
     * @return \StructType\ListaModosExpedicaoXMLResponse|bool
     */
    public function ListaModosExpedicaoXML(\StructType\ListaModosExpedicaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaModosExpedicaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosXML $parameters
     * @return \StructType\ListaArtigosXMLResponse|bool
     */
    public function ListaArtigosXML(\StructType\ListaArtigosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEmpresasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEmpresasXML $parameters
     * @return \StructType\ListaEmpresasXMLResponse|bool
     */
    public function ListaEmpresasXML(\StructType\ListaEmpresasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEmpresasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTipoDocIdentificacaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTipoDocIdentificacaoXML $parameters
     * @return \StructType\ListaTipoDocIdentificacaoXMLResponse|bool
     */
    public function ListaTipoDocIdentificacaoXML(\StructType\ListaTipoDocIdentificacaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTipoDocIdentificacaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPaisesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPaisesXML $parameters
     * @return \StructType\ListaPaisesXMLResponse|bool
     */
    public function ListaPaisesXML(\StructType\ListaPaisesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPaisesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaParceirosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaParceirosXML $parameters
     * @return \StructType\ListaParceirosXMLResponse|bool
     */
    public function ListaParceirosXML(\StructType\ListaParceirosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaParceirosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEstabelecimentosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEstabelecimentosXML $parameters
     * @return \StructType\ListaEstabelecimentosXMLResponse|bool
     */
    public function ListaEstabelecimentosXML(\StructType\ListaEstabelecimentosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEstabelecimentosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposContactoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposContactoXML $parameters
     * @return \StructType\ListaTiposContactoXMLResponse|bool
     */
    public function ListaTiposContactoXML(\StructType\ListaTiposContactoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposContactoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaContactosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaContactosXML $parameters
     * @return \StructType\ListaContactosXMLResponse|bool
     */
    public function ListaContactosXML(\StructType\ListaContactosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaContactosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArmazensXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArmazensXML $parameters
     * @return \StructType\ListaArmazensXMLResponse|bool
     */
    public function ListaArmazensXML(\StructType\ListaArmazensXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArmazensXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArmazemLocalizacoesXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArmazemLocalizacoesXML $parameters
     * @return \StructType\ListaArmazemLocalizacoesXMLResponse|bool
     */
    public function ListaArmazemLocalizacoesXML(\StructType\ListaArmazemLocalizacoesXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArmazemLocalizacoesXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaMetodosPagamentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaMetodosPagamentoXML $parameters
     * @return \StructType\ListaMetodosPagamentoXMLResponse|bool
     */
    public function ListaMetodosPagamentoXML(\StructType\ListaMetodosPagamentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaMetodosPagamentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaCondicoesPagamentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaCondicoesPagamentoXML $parameters
     * @return \StructType\ListaCondicoesPagamentoXMLResponse|bool
     */
    public function ListaCondicoesPagamentoXML(\StructType\ListaCondicoesPagamentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaCondicoesPagamentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosFornecedorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosFornecedorXML $parameters
     * @return \StructType\ListaArtigosFornecedorXMLResponse|bool
     */
    public function ListaArtigosFornecedorXML(\StructType\ListaArtigosFornecedorXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosFornecedorXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosIdiomaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosIdiomaXML $parameters
     * @return \StructType\ListaArtigosIdiomaXMLResponse|bool
     */
    public function ListaArtigosIdiomaXML(\StructType\ListaArtigosIdiomaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosIdiomaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosLoteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosLoteXML $parameters
     * @return \StructType\ListaArtigosLoteXMLResponse|bool
     */
    public function ListaArtigosLoteXML(\StructType\ListaArtigosLoteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosLoteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaConfiguracoesEasyPay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaConfiguracoesEasyPay $parameters
     * @return \StructType\ListaConfiguracoesEasyPayResponse|bool
     */
    public function ListaConfiguracoesEasyPay(\StructType\ListaConfiguracoesEasyPay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaConfiguracoesEasyPay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaArtigosArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaArtigosArmazem $parameters
     * @return \StructType\ListaArtigosArmazemResponse|bool
     */
    public function ListaArtigosArmazem(\StructType\ListaArtigosArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaArtigosArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaVendedores
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaVendedores $parameters
     * @return \StructType\ListaVendedoresResponse|bool
     */
    public function ListaVendedores(\StructType\ListaVendedores $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaVendedores($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaModosExpedicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaModosExpedicao $parameters
     * @return \StructType\ListaModosExpedicaoResponse|bool
     */
    public function ListaModosExpedicao(\StructType\ListaModosExpedicao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaModosExpedicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaEmpresas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaEmpresas $parameters
     * @return \StructType\ListaEmpresasResponse|bool
     */
    public function ListaEmpresas(\StructType\ListaEmpresas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaEmpresas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaPaises
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaPaises $parameters
     * @return \StructType\ListaPaisesResponse|bool
     */
    public function ListaPaises(\StructType\ListaPaises $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaPaises($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaParceiros
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaParceiros $parameters
     * @return \StructType\ListaParceirosResponse|bool
     */
    public function ListaParceiros(\StructType\ListaParceiros $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaParceiros($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ListaTiposContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ListaTiposContacto $parameters
     * @return \StructType\ListaTiposContactoResponse|bool
     */
    public function ListaTiposContacto(\StructType\ListaTiposContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ListaTiposContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ListaArmazemLocalizacoesJSONResponse|\StructType\ListaArmazemLocalizacoesResponse|\StructType\ListaArmazemLocalizacoesXMLResponse|\StructType\ListaArmazensJSONResponse|\StructType\ListaArmazensResponse|\StructType\ListaArmazensXMLResponse|\StructType\ListaArtigosArmazemJSONResponse|\StructType\ListaArtigosArmazemResponse|\StructType\ListaArtigosArmazemXMLResponse|\StructType\ListaArtigosFornecedorJSONResponse|\StructType\ListaArtigosFornecedorResponse|\StructType\ListaArtigosFornecedorXMLResponse|\StructType\ListaArtigosIdiomaJSONResponse|\StructType\ListaArtigosIdiomaResponse|\StructType\ListaArtigosIdiomaXMLResponse|\StructType\ListaArtigosJSONResponse|\StructType\ListaArtigosLoteJSONResponse|\StructType\ListaArtigosLoteResponse|\StructType\ListaArtigosLoteXMLResponse|\StructType\ListaArtigosMoedaJSONResponse|\StructType\ListaArtigosMoedaResponse|\StructType\ListaArtigosMoedaXMLResponse|\StructType\ListaArtigosResponse|\StructType\ListaArtigosUnidadeJSONResponse|\StructType\ListaArtigosUnidadeResponse|\StructType\ListaArtigosUnidadeXMLResponse|\StructType\ListaArtigosXMLResponse|\StructType\ListaClientesJSONResponse|\StructType\ListaClientesResponse|\StructType\ListaClientesXMLResponse|\StructType\ListaConcelhosJSONResponse|\StructType\ListaConcelhosResponse|\StructType\ListaConcelhosXMLResponse|\StructType\ListaCondicoesPagamentoJSONResponse|\StructType\ListaCondicoesPagamentoResponse|\StructType\ListaCondicoesPagamentoXMLResponse|\StructType\ListaConfiguracoesEasyPayJSONResponse|\StructType\ListaConfiguracoesEasyPayResponse|\StructType\ListaContactosJSONResponse|\StructType\ListaContactosResponse|\StructType\ListaContactosXMLResponse|\StructType\ListaContasBancariasJSONResponse|\StructType\ListaContasBancariasResponse|\StructType\ListaContasBancariasXMLResponse|\StructType\ListaDistritosJSONResponse|\StructType\ListaDistritosResponse|\StructType\ListaDistritosXMLResponse|\StructType\ListaDocumentosCompraJSONResponse|\StructType\ListaDocumentosCompraResponse|\StructType\ListaDocumentosCompraXMLResponse|\StructType\ListaDocumentosInternosJSONResponse|\StructType\ListaDocumentosInternosResponse|\StructType\ListaDocumentosInternosXMLResponse|\StructType\ListaDocumentosLiquidacaoJSONResponse|\StructType\ListaDocumentosLiquidacaoResponse|\StructType\ListaDocumentosLiquidacaoXMLResponse|\StructType\ListaDocumentosVendaJSONResponse|\StructType\ListaDocumentosVendaResponse|\StructType\ListaDocumentosVendaXMLResponse|\StructType\ListaEmpresasJSONResponse|\StructType\ListaEmpresasResponse|\StructType\ListaEmpresasXMLResponse|\StructType\ListaEncomendasVendaPendentesJSONResponse|\StructType\ListaEncomendasVendaPendentesResponse|\StructType\ListaEncomendasVendaPendentesXMLResponse|\StructType\ListaEstabelecimentosJSONResponse|\StructType\ListaEstabelecimentosResponse|\StructType\ListaEstabelecimentosXMLResponse|\StructType\ListaEstadosDocumentosCompraJSONResponse|\StructType\ListaEstadosDocumentosCompraResponse|\StructType\ListaEstadosDocumentosCompraXMLResponse|\StructType\ListaEstadosDocumentosVendaJSONResponse|\StructType\ListaEstadosDocumentosVendaResponse|\StructType\ListaEstadosDocumentosVendaXMLResponse|\StructType\ListaExtratoContaEntidadeJSONResponse|\StructType\ListaExtratoContaEntidadeResponse|\StructType\ListaExtratoContaEntidadeXMLResponse|\StructType\ListaExtratoContaEstabelecimentoJSONResponse|\StructType\ListaExtratoContaEstabelecimentoResponse|\StructType\ListaExtratoContaEstabelecimentoXMLResponse|\StructType\ListaExtratoContaJSONResponse|\StructType\ListaExtratoContaResponse|\StructType\ListaExtratoContaXMLResponse|\StructType\ListaFamiliasJSONResponse|\StructType\ListaFamiliasResponse|\StructType\ListaFamiliasXMLResponse|\StructType\ListaFornecedoresJSONResponse|\StructType\ListaFornecedoresResponse|\StructType\ListaFornecedoresXMLResponse|\StructType\ListaFreguesiasJSONResponse|\StructType\ListaFreguesiasResponse|\StructType\ListaFreguesiasXMLResponse|\StructType\ListaFuncionariosJSONResponse|\StructType\ListaFuncionariosResponse|\StructType\ListaFuncionariosXMLResponse|\StructType\ListaIvasJSONResponse|\StructType\ListaIvasResponse|\StructType\ListaIvasXMLResponse|\StructType\ListaLinhasDocJSONResponse|\StructType\ListaLinhasDocResponse|\StructType\ListaLinhasDocStatusJSONResponse|\StructType\ListaLinhasDocStatusResponse|\StructType\ListaLinhasDocStatusXMLResponse|\StructType\ListaLinhasDocTransJSONResponse|\StructType\ListaLinhasDocTransResponse|\StructType\ListaLinhasDocTransXMLResponse|\StructType\ListaLinhasDocXMLResponse|\StructType\ListaLinhasInternosJSONResponse|\StructType\ListaLinhasInternosResponse|\StructType\ListaLinhasInternosStatusJSONResponse|\StructType\ListaLinhasInternosStatusResponse|\StructType\ListaLinhasInternosStatusXMLResponse|\StructType\ListaLinhasInternosXMLResponse|\StructType\ListaLinhasLiqJSONResponse|\StructType\ListaLinhasLiqResponse|\StructType\ListaLinhasLiqXMLResponse|\StructType\ListaMarcasJSONResponse|\StructType\ListaMarcasResponse|\StructType\ListaMarcasXMLResponse|\StructType\ListaMetodosPagamentoJSONResponse|\StructType\ListaMetodosPagamentoResponse|\StructType\ListaMetodosPagamentoXMLResponse|\StructType\ListaModelosJSONResponse|\StructType\ListaModelosResponse|\StructType\ListaModelosXMLResponse|\StructType\ListaModosExpedicaoJSONResponse|\StructType\ListaModosExpedicaoResponse|\StructType\ListaModosExpedicaoXMLResponse|\StructType\ListaMoedasJSONResponse|\StructType\ListaMoedasResponse|\StructType\ListaMoedasXMLResponse|\StructType\ListaMoradasAlternativasClienteJSONResponse|\StructType\ListaMoradasAlternativasClienteResponse|\StructType\ListaMoradasAlternativasClienteXMLResponse|\StructType\ListaMoradasAlternativasFornecedorJSONResponse|\StructType\ListaMoradasAlternativasFornecedorResponse|\StructType\ListaMoradasAlternativasFornecedorXMLResponse|\StructType\ListaMotivosEstornoJSONResponse|\StructType\ListaMotivosEstornoResponse|\StructType\ListaMotivosEstornoXMLResponse|\StructType\ListaMotivosIsencaoIVAJSONResponse|\StructType\ListaMotivosIsencaoIVAResponse|\StructType\ListaMotivosIsencaoIVAXMLResponse|\StructType\ListaOrigensContactoJSONResponse|\StructType\ListaOrigensContactoResponse|\StructType\ListaOrigensContactoXMLResponse|\StructType\ListaOutrosTerceirosJSONResponse|\StructType\ListaOutrosTerceirosResponse|\StructType\ListaOutrosTerceirosXMLResponse|\StructType\ListaPaisesJSONResponse|\StructType\ListaPaisesResponse|\StructType\ListaPaisesXMLResponse|\StructType\ListaParceirosJSONResponse|\StructType\ListaParceirosResponse|\StructType\ListaParceirosXMLResponse|\StructType\ListaPendentesEntidadeJSONResponse|\StructType\ListaPendentesEntidadeResponse|\StructType\ListaPendentesEntidadeXMLResponse|\StructType\ListaPendentesEstabelecimentoJSONResponse|\StructType\ListaPendentesEstabelecimentoResponse|\StructType\ListaPendentesEstabelecimentoXMLResponse|\StructType\ListaPendentesJSONResponse|\StructType\ListaPendentesResponse|\StructType\ListaPendentesXMLResponse|\StructType\ListaResumosIvaJSONResponse|\StructType\ListaResumosIvaResponse|\StructType\ListaResumosIvaXMLResponse|\StructType\ListaResumosRetencaoJSONResponse|\StructType\ListaResumosRetencaoLiqJSONResponse|\StructType\ListaResumosRetencaoLiqResponse|\StructType\ListaResumosRetencaoLiqXMLResponse|\StructType\ListaResumosRetencaoResponse|\StructType\ListaResumosRetencaoXMLResponse|\StructType\ListaSeriesCCTJSONResponse|\StructType\ListaSeriesCCTResponse|\StructType\ListaSeriesCCTXMLResponse|\StructType\ListaSeriesComprasJSONResponse|\StructType\ListaSeriesComprasResponse|\StructType\ListaSeriesComprasXMLResponse|\StructType\ListaSeriesContratosJSONResponse|\StructType\ListaSeriesContratosResponse|\StructType\ListaSeriesContratosXMLResponse|\StructType\ListaSeriesStockJSONResponse|\StructType\ListaSeriesStockResponse|\StructType\ListaSeriesStockXMLResponse|\StructType\ListaSeriesVendasJSONResponse|\StructType\ListaSeriesVendasResponse|\StructType\ListaSeriesVendasXMLResponse|\StructType\ListaTipoDocIdentificacaoJSONResponse|\StructType\ListaTipoDocIdentificacaoResponse|\StructType\ListaTipoDocIdentificacaoXMLResponse|\StructType\ListaTiposContactoJSONResponse|\StructType\ListaTiposContactoResponse|\StructType\ListaTiposContactoXMLResponse|\StructType\ListaTiposDocumentoCompraJSONResponse|\StructType\ListaTiposDocumentoCompraResponse|\StructType\ListaTiposDocumentoCompraXMLResponse|\StructType\ListaTiposDocumentoContasCorrentesJSONResponse|\StructType\ListaTiposDocumentoContasCorrentesResponse|\StructType\ListaTiposDocumentoContasCorrentesXMLResponse|\StructType\ListaTiposDocumentoInternosJSONResponse|\StructType\ListaTiposDocumentoInternosResponse|\StructType\ListaTiposDocumentoInternosXMLResponse|\StructType\ListaTiposDocumentoStockJSONResponse|\StructType\ListaTiposDocumentoStockResponse|\StructType\ListaTiposDocumentoStockXMLResponse|\StructType\ListaTiposDocumentoVendaJSONResponse|\StructType\ListaTiposDocumentoVendaResponse|\StructType\ListaTiposDocumentoVendaXMLResponse|\StructType\ListaTiposParceiroJSONResponse|\StructType\ListaTiposParceiroResponse|\StructType\ListaTiposParceiroXMLResponse|\StructType\ListaTiposTerceiroJSONResponse|\StructType\ListaTiposTerceiroResponse|\StructType\ListaTiposTerceiroXMLResponse|\StructType\ListaUnidadesJSONResponse|\StructType\ListaUnidadesResponse|\StructType\ListaUnidadesXMLResponse|\StructType\ListaVendedoresJSONResponse|\StructType\ListaVendedoresResponse|\StructType\ListaVendedoresXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
