<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Existe ServiceType
 * @subpackage Services
 */
class Existe extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ExisteConfiguracaoEasyPay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteConfiguracaoEasyPay $parameters
     * @return \StructType\ExisteConfiguracaoEasyPayResponse|bool
     */
    public function ExisteConfiguracaoEasyPay(\StructType\ExisteConfiguracaoEasyPay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteConfiguracaoEasyPay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigoArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigoArmazem $parameters
     * @return \StructType\ExisteArtigoArmazemResponse|bool
     */
    public function ExisteArtigoArmazem(\StructType\ExisteArtigoArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigoArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteVendedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteVendedor $parameters
     * @return \StructType\ExisteVendedorResponse|bool
     */
    public function ExisteVendedor(\StructType\ExisteVendedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteVendedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteModoExpedicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteModoExpedicao $parameters
     * @return \StructType\ExisteModoExpedicaoResponse|bool
     */
    public function ExisteModoExpedicao(\StructType\ExisteModoExpedicao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteModoExpedicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteEmpresa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteEmpresa $parameters
     * @return \StructType\ExisteEmpresaResponse|bool
     */
    public function ExisteEmpresa(\StructType\ExisteEmpresa $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteEmpresa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExistePais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExistePais $parameters
     * @return \StructType\ExistePaisResponse|bool
     */
    public function ExistePais(\StructType\ExistePais $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExistePais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoDocIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoDocIdentificacao $parameters
     * @return \StructType\ExisteTipoDocIdentificacaoResponse|bool
     */
    public function ExisteTipoDocIdentificacao(\StructType\ExisteTipoDocIdentificacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoDocIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoContacto $parameters
     * @return \StructType\ExisteTipoContactoResponse|bool
     */
    public function ExisteTipoContacto(\StructType\ExisteTipoContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoParceiro $parameters
     * @return \StructType\ExisteTipoParceiroResponse|bool
     */
    public function ExisteTipoParceiro(\StructType\ExisteTipoParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteEstabelecimento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteEstabelecimento $parameters
     * @return \StructType\ExisteEstabelecimentoResponse|bool
     */
    public function ExisteEstabelecimento(\StructType\ExisteEstabelecimento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteEstabelecimento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteContacto $parameters
     * @return \StructType\ExisteContactoResponse|bool
     */
    public function ExisteContacto(\StructType\ExisteContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArmazem $parameters
     * @return \StructType\ExisteArmazemResponse|bool
     */
    public function ExisteArmazem(\StructType\ExisteArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteParceiro $parameters
     * @return \StructType\ExisteParceiroResponse|bool
     */
    public function ExisteParceiro(\StructType\ExisteParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArmazemLocalizacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArmazemLocalizacao $parameters
     * @return \StructType\ExisteArmazemLocalizacaoResponse|bool
     */
    public function ExisteArmazemLocalizacao(\StructType\ExisteArmazemLocalizacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArmazemLocalizacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMetodoPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMetodoPagamento $parameters
     * @return \StructType\ExisteMetodoPagamentoResponse|bool
     */
    public function ExisteMetodoPagamento(\StructType\ExisteMetodoPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMetodoPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteCondicaoPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteCondicaoPagamento $parameters
     * @return \StructType\ExisteCondicaoPagamentoResponse|bool
     */
    public function ExisteCondicaoPagamento(\StructType\ExisteCondicaoPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteCondicaoPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigo $parameters
     * @return \StructType\ExisteArtigoResponse|bool
     */
    public function ExisteArtigo(\StructType\ExisteArtigo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigoFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigoFornecedor $parameters
     * @return \StructType\ExisteArtigoFornecedorResponse|bool
     */
    public function ExisteArtigoFornecedor(\StructType\ExisteArtigoFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigoFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigoIdioma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigoIdioma $parameters
     * @return \StructType\ExisteArtigoIdiomaResponse|bool
     */
    public function ExisteArtigoIdioma(\StructType\ExisteArtigoIdioma $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigoIdioma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigoLote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigoLote $parameters
     * @return \StructType\ExisteArtigoLoteResponse|bool
     */
    public function ExisteArtigoLote(\StructType\ExisteArtigoLote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigoLote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigoMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigoMoeda $parameters
     * @return \StructType\ExisteArtigoMoedaResponse|bool
     */
    public function ExisteArtigoMoeda(\StructType\ExisteArtigoMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigoMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteArtigoUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteArtigoUnidade $parameters
     * @return \StructType\ExisteArtigoUnidadeResponse|bool
     */
    public function ExisteArtigoUnidade(\StructType\ExisteArtigoUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteArtigoUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoCompraId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoCompraId $parameters
     * @return \StructType\ExisteDocumentoCompraIdResponse|bool
     */
    public function ExisteDocumentoCompraId(\StructType\ExisteDocumentoCompraId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoCompraId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoCompra $parameters
     * @return \StructType\ExisteDocumentoCompraResponse|bool
     */
    public function ExisteDocumentoCompra(\StructType\ExisteDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteEstadoDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteEstadoDocumentoCompra $parameters
     * @return \StructType\ExisteEstadoDocumentoCompraResponse|bool
     */
    public function ExisteEstadoDocumentoCompra(\StructType\ExisteEstadoDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteEstadoDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoVendaId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoVendaId $parameters
     * @return \StructType\ExisteDocumentoVendaIdResponse|bool
     */
    public function ExisteDocumentoVendaId(\StructType\ExisteDocumentoVendaId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoVendaId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoVenda $parameters
     * @return \StructType\ExisteDocumentoVendaResponse|bool
     */
    public function ExisteDocumentoVenda(\StructType\ExisteDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteEstadoDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteEstadoDocumentoVenda $parameters
     * @return \StructType\ExisteEstadoDocumentoVendaResponse|bool
     */
    public function ExisteEstadoDocumentoVenda(\StructType\ExisteEstadoDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteEstadoDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoInternoId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoInternoId $parameters
     * @return \StructType\ExisteDocumentoInternoIdResponse|bool
     */
    public function ExisteDocumentoInternoId(\StructType\ExisteDocumentoInternoId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoInternoId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoInterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoInterno $parameters
     * @return \StructType\ExisteDocumentoInternoResponse|bool
     */
    public function ExisteDocumentoInterno(\StructType\ExisteDocumentoInterno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoInterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoLiquidacaoId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoLiquidacaoId $parameters
     * @return \StructType\ExisteDocumentoLiquidacaoIdResponse|bool
     */
    public function ExisteDocumentoLiquidacaoId(\StructType\ExisteDocumentoLiquidacaoId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoLiquidacaoId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDocumentoLiquidacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDocumentoLiquidacao $parameters
     * @return \StructType\ExisteDocumentoLiquidacaoResponse|bool
     */
    public function ExisteDocumentoLiquidacao(\StructType\ExisteDocumentoLiquidacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDocumentoLiquidacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteCliente $parameters
     * @return \StructType\ExisteClienteResponse|bool
     */
    public function ExisteCliente(\StructType\ExisteCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteConcelho
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteConcelho $parameters
     * @return \StructType\ExisteConcelhoResponse|bool
     */
    public function ExisteConcelho(\StructType\ExisteConcelho $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteConcelho($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteContaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteContaBancaria $parameters
     * @return \StructType\ExisteContaBancariaResponse|bool
     */
    public function ExisteContaBancaria(\StructType\ExisteContaBancaria $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteContaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteDistrito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteDistrito $parameters
     * @return \StructType\ExisteDistritoResponse|bool
     */
    public function ExisteDistrito(\StructType\ExisteDistrito $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteDistrito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoDocumentoContaCorrente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoDocumentoContaCorrente $parameters
     * @return \StructType\ExisteTipoDocumentoContaCorrenteResponse|bool
     */
    public function ExisteTipoDocumentoContaCorrente(\StructType\ExisteTipoDocumentoContaCorrente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoDocumentoContaCorrente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoDocumentoCompra $parameters
     * @return \StructType\ExisteTipoDocumentoCompraResponse|bool
     */
    public function ExisteTipoDocumentoCompra(\StructType\ExisteTipoDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoDocumentoInterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoDocumentoInterno $parameters
     * @return \StructType\ExisteTipoDocumentoInternoResponse|bool
     */
    public function ExisteTipoDocumentoInterno(\StructType\ExisteTipoDocumentoInterno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoDocumentoInterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoDocumentStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoDocumentStock $parameters
     * @return \StructType\ExisteTipoDocumentStockResponse|bool
     */
    public function ExisteTipoDocumentStock(\StructType\ExisteTipoDocumentStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoDocumentStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoDocumentoVenda $parameters
     * @return \StructType\ExisteTipoDocumentoVendaResponse|bool
     */
    public function ExisteTipoDocumentoVenda(\StructType\ExisteTipoDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteFamilia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteFamilia $parameters
     * @return \StructType\ExisteFamiliaResponse|bool
     */
    public function ExisteFamilia(\StructType\ExisteFamilia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteFamilia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteFornecedor $parameters
     * @return \StructType\ExisteFornecedorResponse|bool
     */
    public function ExisteFornecedor(\StructType\ExisteFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteFreguesia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteFreguesia $parameters
     * @return \StructType\ExisteFreguesiaResponse|bool
     */
    public function ExisteFreguesia(\StructType\ExisteFreguesia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteFreguesia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteFuncionario
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteFuncionario $parameters
     * @return \StructType\ExisteFuncionarioResponse|bool
     */
    public function ExisteFuncionario(\StructType\ExisteFuncionario $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteFuncionario($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteIva $parameters
     * @return \StructType\ExisteIvaResponse|bool
     */
    public function ExisteIva(\StructType\ExisteIva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteLinhaDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteLinhaDoc $parameters
     * @return \StructType\ExisteLinhaDocResponse|bool
     */
    public function ExisteLinhaDoc(\StructType\ExisteLinhaDoc $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteLinhaDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteLinhaDocStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteLinhaDocStatus $parameters
     * @return \StructType\ExisteLinhaDocStatusResponse|bool
     */
    public function ExisteLinhaDocStatus(\StructType\ExisteLinhaDocStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteLinhaDocStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteLinhaDocTrans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteLinhaDocTrans $parameters
     * @return \StructType\ExisteLinhaDocTransResponse|bool
     */
    public function ExisteLinhaDocTrans(\StructType\ExisteLinhaDocTrans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteLinhaDocTrans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteLinhaInternos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteLinhaInternos $parameters
     * @return \StructType\ExisteLinhaInternosResponse|bool
     */
    public function ExisteLinhaInternos(\StructType\ExisteLinhaInternos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteLinhaInternos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteLinhaInternosStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteLinhaInternosStatus $parameters
     * @return \StructType\ExisteLinhaInternosStatusResponse|bool
     */
    public function ExisteLinhaInternosStatus(\StructType\ExisteLinhaInternosStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteLinhaInternosStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteLinhaLiq
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteLinhaLiq $parameters
     * @return \StructType\ExisteLinhaLiqResponse|bool
     */
    public function ExisteLinhaLiq(\StructType\ExisteLinhaLiq $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteLinhaLiq($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMarca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMarca $parameters
     * @return \StructType\ExisteMarcaResponse|bool
     */
    public function ExisteMarca(\StructType\ExisteMarca $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMarca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteModelo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteModelo $parameters
     * @return \StructType\ExisteModeloResponse|bool
     */
    public function ExisteModelo(\StructType\ExisteModelo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteModelo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMoeda $parameters
     * @return \StructType\ExisteMoedaResponse|bool
     */
    public function ExisteMoeda(\StructType\ExisteMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMoradaAlternativaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMoradaAlternativaCliente $parameters
     * @return \StructType\ExisteMoradaAlternativaClienteResponse|bool
     */
    public function ExisteMoradaAlternativaCliente(\StructType\ExisteMoradaAlternativaCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMoradaAlternativaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMoradaAlternativaFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMoradaAlternativaFornecedor $parameters
     * @return \StructType\ExisteMoradaAlternativaFornecedorResponse|bool
     */
    public function ExisteMoradaAlternativaFornecedor(\StructType\ExisteMoradaAlternativaFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMoradaAlternativaFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMotivoEstorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMotivoEstorno $parameters
     * @return \StructType\ExisteMotivoEstornoResponse|bool
     */
    public function ExisteMotivoEstorno(\StructType\ExisteMotivoEstorno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMotivoEstorno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteMotivoIsencaoIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteMotivoIsencaoIVA $parameters
     * @return \StructType\ExisteMotivoIsencaoIVAResponse|bool
     */
    public function ExisteMotivoIsencaoIVA(\StructType\ExisteMotivoIsencaoIVA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteMotivoIsencaoIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteOrigemContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteOrigemContacto $parameters
     * @return \StructType\ExisteOrigemContactoResponse|bool
     */
    public function ExisteOrigemContacto(\StructType\ExisteOrigemContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteOrigemContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteOutroTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteOutroTerceiro $parameters
     * @return \StructType\ExisteOutroTerceiroResponse|bool
     */
    public function ExisteOutroTerceiro(\StructType\ExisteOutroTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteOutroTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExistePendenteId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExistePendenteId $parameters
     * @return \StructType\ExistePendenteIdResponse|bool
     */
    public function ExistePendenteId(\StructType\ExistePendenteId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExistePendenteId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExistePendente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExistePendente $parameters
     * @return \StructType\ExistePendenteResponse|bool
     */
    public function ExistePendente(\StructType\ExistePendente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExistePendente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteResumoIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteResumoIva $parameters
     * @return \StructType\ExisteResumoIvaResponse|bool
     */
    public function ExisteResumoIva(\StructType\ExisteResumoIva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteResumoIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteResumoRetencao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteResumoRetencao $parameters
     * @return \StructType\ExisteResumoRetencaoResponse|bool
     */
    public function ExisteResumoRetencao(\StructType\ExisteResumoRetencao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteResumoRetencao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteResumoRetencaoLiq
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteResumoRetencaoLiq $parameters
     * @return \StructType\ExisteResumoRetencaoLiqResponse|bool
     */
    public function ExisteResumoRetencaoLiq(\StructType\ExisteResumoRetencaoLiq $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteResumoRetencaoLiq($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteSerieCCT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteSerieCCT $parameters
     * @return \StructType\ExisteSerieCCTResponse|bool
     */
    public function ExisteSerieCCT(\StructType\ExisteSerieCCT $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteSerieCCT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteSerieContrato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteSerieContrato $parameters
     * @return \StructType\ExisteSerieContratoResponse|bool
     */
    public function ExisteSerieContrato(\StructType\ExisteSerieContrato $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteSerieContrato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteSerieStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteSerieStock $parameters
     * @return \StructType\ExisteSerieStockResponse|bool
     */
    public function ExisteSerieStock(\StructType\ExisteSerieStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteSerieStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteSerieVendas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteSerieVendas $parameters
     * @return \StructType\ExisteSerieVendasResponse|bool
     */
    public function ExisteSerieVendas(\StructType\ExisteSerieVendas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteSerieVendas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteTipoTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteTipoTerceiro $parameters
     * @return \StructType\ExisteTipoTerceiroResponse|bool
     */
    public function ExisteTipoTerceiro(\StructType\ExisteTipoTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteTipoTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ExisteUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ExisteUnidade $parameters
     * @return \StructType\ExisteUnidadeResponse|bool
     */
    public function ExisteUnidade(\StructType\ExisteUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ExisteUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ExisteArmazemLocalizacaoResponse|\StructType\ExisteArmazemResponse|\StructType\ExisteArtigoArmazemResponse|\StructType\ExisteArtigoFornecedorResponse|\StructType\ExisteArtigoIdiomaResponse|\StructType\ExisteArtigoLoteResponse|\StructType\ExisteArtigoMoedaResponse|\StructType\ExisteArtigoResponse|\StructType\ExisteArtigoUnidadeResponse|\StructType\ExisteClienteResponse|\StructType\ExisteConcelhoResponse|\StructType\ExisteCondicaoPagamentoResponse|\StructType\ExisteConfiguracaoEasyPayResponse|\StructType\ExisteContaBancariaResponse|\StructType\ExisteContactoResponse|\StructType\ExisteDistritoResponse|\StructType\ExisteDocumentoCompraIdResponse|\StructType\ExisteDocumentoCompraResponse|\StructType\ExisteDocumentoInternoIdResponse|\StructType\ExisteDocumentoInternoResponse|\StructType\ExisteDocumentoLiquidacaoIdResponse|\StructType\ExisteDocumentoLiquidacaoResponse|\StructType\ExisteDocumentoVendaIdResponse|\StructType\ExisteDocumentoVendaResponse|\StructType\ExisteEmpresaResponse|\StructType\ExisteEstabelecimentoResponse|\StructType\ExisteEstadoDocumentoCompraResponse|\StructType\ExisteEstadoDocumentoVendaResponse|\StructType\ExisteFamiliaResponse|\StructType\ExisteFornecedorResponse|\StructType\ExisteFreguesiaResponse|\StructType\ExisteFuncionarioResponse|\StructType\ExisteIvaResponse|\StructType\ExisteLinhaDocResponse|\StructType\ExisteLinhaDocStatusResponse|\StructType\ExisteLinhaDocTransResponse|\StructType\ExisteLinhaInternosResponse|\StructType\ExisteLinhaInternosStatusResponse|\StructType\ExisteLinhaLiqResponse|\StructType\ExisteMarcaResponse|\StructType\ExisteMetodoPagamentoResponse|\StructType\ExisteModeloResponse|\StructType\ExisteModoExpedicaoResponse|\StructType\ExisteMoedaResponse|\StructType\ExisteMoradaAlternativaClienteResponse|\StructType\ExisteMoradaAlternativaFornecedorResponse|\StructType\ExisteMotivoEstornoResponse|\StructType\ExisteMotivoIsencaoIVAResponse|\StructType\ExisteOrigemContactoResponse|\StructType\ExisteOutroTerceiroResponse|\StructType\ExistePaisResponse|\StructType\ExisteParceiroResponse|\StructType\ExistePendenteIdResponse|\StructType\ExistePendenteResponse|\StructType\ExisteResumoIvaResponse|\StructType\ExisteResumoRetencaoLiqResponse|\StructType\ExisteResumoRetencaoResponse|\StructType\ExisteSerieCCTResponse|\StructType\ExisteSerieContratoResponse|\StructType\ExisteSerieStockResponse|\StructType\ExisteSerieVendasResponse|\StructType\ExisteTipoContactoResponse|\StructType\ExisteTipoDocIdentificacaoResponse|\StructType\ExisteTipoDocumentoCompraResponse|\StructType\ExisteTipoDocumentoContaCorrenteResponse|\StructType\ExisteTipoDocumentoInternoResponse|\StructType\ExisteTipoDocumentoVendaResponse|\StructType\ExisteTipoDocumentStockResponse|\StructType\ExisteTipoParceiroResponse|\StructType\ExisteTipoTerceiroResponse|\StructType\ExisteUnidadeResponse|\StructType\ExisteVendedorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
