<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Anular ServiceType
 * @subpackage Services
 */
class Anular extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AnularDocumentoDeVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnularDocumentoDeVenda $parameters
     * @return \StructType\AnularDocumentoDeVendaResponse|bool
     */
    public function AnularDocumentoDeVenda(\StructType\AnularDocumentoDeVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AnularDocumentoDeVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AnularDocumentoDeVendaSimples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnularDocumentoDeVendaSimples $parameters
     * @return \StructType\AnularDocumentoDeVendaSimplesResponse|bool
     */
    public function AnularDocumentoDeVendaSimples(\StructType\AnularDocumentoDeVendaSimples $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AnularDocumentoDeVendaSimples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AnularDocumentoDeCompraSimples
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnularDocumentoDeCompraSimples $parameters
     * @return \StructType\AnularDocumentoDeCompraSimplesResponse|bool
     */
    public function AnularDocumentoDeCompraSimples(\StructType\AnularDocumentoDeCompraSimples $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AnularDocumentoDeCompraSimples($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AnularDocumentoDeCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AnularDocumentoDeCompra $parameters
     * @return \StructType\AnularDocumentoDeCompraResponse|bool
     */
    public function AnularDocumentoDeCompra(\StructType\AnularDocumentoDeCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AnularDocumentoDeCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AnularDocumentoDeCompraResponse|\StructType\AnularDocumentoDeCompraSimplesResponse|\StructType\AnularDocumentoDeVendaResponse|\StructType\AnularDocumentoDeVendaSimplesResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
