<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfPaisERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfPaisERP
 * @subpackage Arrays
 */
class ArrayOfPaisERP extends AbstractStructArrayBase
{
    /**
     * The PaisERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\PaisERP[]
     */
    public $PaisERP;
    /**
     * Constructor method for ArrayOfPaisERP
     * @uses ArrayOfPaisERP::setPaisERP()
     * @param \StructType\PaisERP[] $paisERP
     */
    public function __construct(array $paisERP = array())
    {
        $this
            ->setPaisERP($paisERP);
    }
    /**
     * Get PaisERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\PaisERP[]|null
     */
    public function getPaisERP()
    {
        return isset($this->PaisERP) ? $this->PaisERP : null;
    }
    /**
     * Set PaisERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\PaisERP[] $paisERP
     * @return \ArrayType\ArrayOfPaisERP
     */
    public function setPaisERP(array $paisERP = array())
    {
        foreach ($paisERP as $arrayOfPaisERPPaisERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfPaisERPPaisERPItem instanceof \StructType\PaisERP) {
                throw new \InvalidArgumentException(sprintf('The PaisERP property can only contain items of \StructType\PaisERP, "%s" given', is_object($arrayOfPaisERPPaisERPItem) ? get_class($arrayOfPaisERPPaisERPItem) : gettype($arrayOfPaisERPPaisERPItem)), __LINE__);
            }
        }
        if (is_null($paisERP) || (is_array($paisERP) && empty($paisERP))) {
            unset($this->PaisERP);
        } else {
            $this->PaisERP = $paisERP;
        }
        return $this;
    }
    /**
     * Add item to PaisERP value
     * @throws \InvalidArgumentException
     * @param \StructType\PaisERP $item
     * @return \ArrayType\ArrayOfPaisERP
     */
    public function addToPaisERP(\StructType\PaisERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\PaisERP) {
            throw new \InvalidArgumentException(sprintf('The PaisERP property can only contain items of \StructType\PaisERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->PaisERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\PaisERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\PaisERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\PaisERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\PaisERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\PaisERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string PaisERP
     */
    public function getAttributeName()
    {
        return 'PaisERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfPaisERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
