<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLinhasDocERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLinhasDocERP
 * @subpackage Arrays
 */
class ArrayOfLinhasDocERP extends AbstractStructArrayBase
{
    /**
     * The LinhasDocERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LinhasDocERP[]
     */
    public $LinhasDocERP;
    /**
     * Constructor method for ArrayOfLinhasDocERP
     * @uses ArrayOfLinhasDocERP::setLinhasDocERP()
     * @param \StructType\LinhasDocERP[] $linhasDocERP
     */
    public function __construct(array $linhasDocERP = array())
    {
        $this
            ->setLinhasDocERP($linhasDocERP);
    }
    /**
     * Get LinhasDocERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LinhasDocERP[]|null
     */
    public function getLinhasDocERP()
    {
        return isset($this->LinhasDocERP) ? $this->LinhasDocERP : null;
    }
    /**
     * Set LinhasDocERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LinhasDocERP[] $linhasDocERP
     * @return \ArrayType\ArrayOfLinhasDocERP
     */
    public function setLinhasDocERP(array $linhasDocERP = array())
    {
        foreach ($linhasDocERP as $arrayOfLinhasDocERPLinhasDocERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfLinhasDocERPLinhasDocERPItem instanceof \StructType\LinhasDocERP) {
                throw new \InvalidArgumentException(sprintf('The LinhasDocERP property can only contain items of \StructType\LinhasDocERP, "%s" given', is_object($arrayOfLinhasDocERPLinhasDocERPItem) ? get_class($arrayOfLinhasDocERPLinhasDocERPItem) : gettype($arrayOfLinhasDocERPLinhasDocERPItem)), __LINE__);
            }
        }
        if (is_null($linhasDocERP) || (is_array($linhasDocERP) && empty($linhasDocERP))) {
            unset($this->LinhasDocERP);
        } else {
            $this->LinhasDocERP = $linhasDocERP;
        }
        return $this;
    }
    /**
     * Add item to LinhasDocERP value
     * @throws \InvalidArgumentException
     * @param \StructType\LinhasDocERP $item
     * @return \ArrayType\ArrayOfLinhasDocERP
     */
    public function addToLinhasDocERP(\StructType\LinhasDocERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinhasDocERP) {
            throw new \InvalidArgumentException(sprintf('The LinhasDocERP property can only contain items of \StructType\LinhasDocERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinhasDocERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LinhasDocERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LinhasDocERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LinhasDocERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LinhasDocERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LinhasDocERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LinhasDocERP
     */
    public function getAttributeName()
    {
        return 'LinhasDocERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLinhasDocERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
