<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfFornecedoresERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfFornecedoresERP
 * @subpackage Arrays
 */
class ArrayOfFornecedoresERP extends AbstractStructArrayBase
{
    /**
     * The FornecedoresERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\FornecedoresERP[]
     */
    public $FornecedoresERP;
    /**
     * Constructor method for ArrayOfFornecedoresERP
     * @uses ArrayOfFornecedoresERP::setFornecedoresERP()
     * @param \StructType\FornecedoresERP[] $fornecedoresERP
     */
    public function __construct(array $fornecedoresERP = array())
    {
        $this
            ->setFornecedoresERP($fornecedoresERP);
    }
    /**
     * Get FornecedoresERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\FornecedoresERP[]|null
     */
    public function getFornecedoresERP()
    {
        return isset($this->FornecedoresERP) ? $this->FornecedoresERP : null;
    }
    /**
     * Set FornecedoresERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\FornecedoresERP[] $fornecedoresERP
     * @return \ArrayType\ArrayOfFornecedoresERP
     */
    public function setFornecedoresERP(array $fornecedoresERP = array())
    {
        foreach ($fornecedoresERP as $arrayOfFornecedoresERPFornecedoresERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfFornecedoresERPFornecedoresERPItem instanceof \StructType\FornecedoresERP) {
                throw new \InvalidArgumentException(sprintf('The FornecedoresERP property can only contain items of \StructType\FornecedoresERP, "%s" given', is_object($arrayOfFornecedoresERPFornecedoresERPItem) ? get_class($arrayOfFornecedoresERPFornecedoresERPItem) : gettype($arrayOfFornecedoresERPFornecedoresERPItem)), __LINE__);
            }
        }
        if (is_null($fornecedoresERP) || (is_array($fornecedoresERP) && empty($fornecedoresERP))) {
            unset($this->FornecedoresERP);
        } else {
            $this->FornecedoresERP = $fornecedoresERP;
        }
        return $this;
    }
    /**
     * Add item to FornecedoresERP value
     * @throws \InvalidArgumentException
     * @param \StructType\FornecedoresERP $item
     * @return \ArrayType\ArrayOfFornecedoresERP
     */
    public function addToFornecedoresERP(\StructType\FornecedoresERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\FornecedoresERP) {
            throw new \InvalidArgumentException(sprintf('The FornecedoresERP property can only contain items of \StructType\FornecedoresERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->FornecedoresERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\FornecedoresERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\FornecedoresERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\FornecedoresERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\FornecedoresERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\FornecedoresERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string FornecedoresERP
     */
    public function getAttributeName()
    {
        return 'FornecedoresERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfFornecedoresERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
