<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfArmazemERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfArmazemERP
 * @subpackage Arrays
 */
class ArrayOfArmazemERP extends AbstractStructArrayBase
{
    /**
     * The ArmazemERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ArmazemERP[]
     */
    public $ArmazemERP;
    /**
     * Constructor method for ArrayOfArmazemERP
     * @uses ArrayOfArmazemERP::setArmazemERP()
     * @param \StructType\ArmazemERP[] $armazemERP
     */
    public function __construct(array $armazemERP = array())
    {
        $this
            ->setArmazemERP($armazemERP);
    }
    /**
     * Get ArmazemERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ArmazemERP[]|null
     */
    public function getArmazemERP()
    {
        return isset($this->ArmazemERP) ? $this->ArmazemERP : null;
    }
    /**
     * Set ArmazemERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ArmazemERP[] $armazemERP
     * @return \ArrayType\ArrayOfArmazemERP
     */
    public function setArmazemERP(array $armazemERP = array())
    {
        foreach ($armazemERP as $arrayOfArmazemERPArmazemERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfArmazemERPArmazemERPItem instanceof \StructType\ArmazemERP) {
                throw new \InvalidArgumentException(sprintf('The ArmazemERP property can only contain items of \StructType\ArmazemERP, "%s" given', is_object($arrayOfArmazemERPArmazemERPItem) ? get_class($arrayOfArmazemERPArmazemERPItem) : gettype($arrayOfArmazemERPArmazemERPItem)), __LINE__);
            }
        }
        if (is_null($armazemERP) || (is_array($armazemERP) && empty($armazemERP))) {
            unset($this->ArmazemERP);
        } else {
            $this->ArmazemERP = $armazemERP;
        }
        return $this;
    }
    /**
     * Add item to ArmazemERP value
     * @throws \InvalidArgumentException
     * @param \StructType\ArmazemERP $item
     * @return \ArrayType\ArrayOfArmazemERP
     */
    public function addToArmazemERP(\StructType\ArmazemERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ArmazemERP) {
            throw new \InvalidArgumentException(sprintf('The ArmazemERP property can only contain items of \StructType\ArmazemERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ArmazemERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ArmazemERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ArmazemERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ArmazemERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ArmazemERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ArmazemERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ArmazemERP
     */
    public function getAttributeName()
    {
        return 'ArmazemERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfArmazemERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
