<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ResumoIvaERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ResumoIvaERP
 * @subpackage Structs
 */
class ResumoIvaERP extends AbstractStructBase
{
    /**
     * The AcertoIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $AcertoIVA;
    /**
     * The CodIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIva;
    /**
     * The Filial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filial;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ID;
    /**
     * The IDOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDOrig;
    /**
     * The IVAIndeferido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IVAIndeferido;
    /**
     * The Incidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Incidencia;
    /**
     * The IncidenciaADI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IncidenciaADI;
    /**
     * The IvaNaoDedutivel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IvaNaoDedutivel;
    /**
     * The Modulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Modulo;
    /**
     * The NumDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumDoc;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Serie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serie;
    /**
     * The TaxaIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxaIva;
    /**
     * The TaxaRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TaxaRecargo;
    /**
     * The TipoDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDoc;
    /**
     * The Valor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Valor;
    /**
     * The ValorADI
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorADI;
    /**
     * The ValorRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRecargo;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ResumoIvaERP
     * @uses ResumoIvaERP::setAcertoIVA()
     * @uses ResumoIvaERP::setCodIva()
     * @uses ResumoIvaERP::setFilial()
     * @uses ResumoIvaERP::setID()
     * @uses ResumoIvaERP::setIDOrig()
     * @uses ResumoIvaERP::setIVAIndeferido()
     * @uses ResumoIvaERP::setIncidencia()
     * @uses ResumoIvaERP::setIncidenciaADI()
     * @uses ResumoIvaERP::setIvaNaoDedutivel()
     * @uses ResumoIvaERP::setModulo()
     * @uses ResumoIvaERP::setNumDoc()
     * @uses ResumoIvaERP::setProtegida()
     * @uses ResumoIvaERP::setSerie()
     * @uses ResumoIvaERP::setTaxaIva()
     * @uses ResumoIvaERP::setTaxaRecargo()
     * @uses ResumoIvaERP::setTipoDoc()
     * @uses ResumoIvaERP::setValor()
     * @uses ResumoIvaERP::setValorADI()
     * @uses ResumoIvaERP::setValorRecargo()
     * @uses ResumoIvaERP::setVersaoUltAct()
     * @param float $acertoIVA
     * @param string $codIva
     * @param string $filial
     * @param string $iD
     * @param string $iDOrig
     * @param bool $iVAIndeferido
     * @param float $incidencia
     * @param float $incidenciaADI
     * @param float $ivaNaoDedutivel
     * @param string $modulo
     * @param int $numDoc
     * @param bool $protegida
     * @param string $serie
     * @param float $taxaIva
     * @param float $taxaRecargo
     * @param string $tipoDoc
     * @param float $valor
     * @param float $valorADI
     * @param float $valorRecargo
     * @param string $versaoUltAct
     */
    public function __construct($acertoIVA = null, $codIva = null, $filial = null, $iD = null, $iDOrig = null, $iVAIndeferido = null, $incidencia = null, $incidenciaADI = null, $ivaNaoDedutivel = null, $modulo = null, $numDoc = null, $protegida = null, $serie = null, $taxaIva = null, $taxaRecargo = null, $tipoDoc = null, $valor = null, $valorADI = null, $valorRecargo = null, $versaoUltAct = null)
    {
        $this
            ->setAcertoIVA($acertoIVA)
            ->setCodIva($codIva)
            ->setFilial($filial)
            ->setID($iD)
            ->setIDOrig($iDOrig)
            ->setIVAIndeferido($iVAIndeferido)
            ->setIncidencia($incidencia)
            ->setIncidenciaADI($incidenciaADI)
            ->setIvaNaoDedutivel($ivaNaoDedutivel)
            ->setModulo($modulo)
            ->setNumDoc($numDoc)
            ->setProtegida($protegida)
            ->setSerie($serie)
            ->setTaxaIva($taxaIva)
            ->setTaxaRecargo($taxaRecargo)
            ->setTipoDoc($tipoDoc)
            ->setValor($valor)
            ->setValorADI($valorADI)
            ->setValorRecargo($valorRecargo)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get AcertoIVA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getAcertoIVA()
    {
        return isset($this->AcertoIVA) ? $this->AcertoIVA : null;
    }
    /**
     * Set AcertoIVA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $acertoIVA
     * @return \StructType\ResumoIvaERP
     */
    public function setAcertoIVA($acertoIVA = null)
    {
        if (is_null($acertoIVA) || (is_array($acertoIVA) && empty($acertoIVA))) {
            unset($this->AcertoIVA);
        } else {
            $this->AcertoIVA = $acertoIVA;
        }
        return $this;
    }
    /**
     * Get CodIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIva()
    {
        return isset($this->CodIva) ? $this->CodIva : null;
    }
    /**
     * Set CodIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIva
     * @return \StructType\ResumoIvaERP
     */
    public function setCodIva($codIva = null)
    {
        // validation for constraint: string
        if (!is_null($codIva) && !is_string($codIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIva)), __LINE__);
        }
        if (is_null($codIva) || (is_array($codIva) && empty($codIva))) {
            unset($this->CodIva);
        } else {
            $this->CodIva = $codIva;
        }
        return $this;
    }
    /**
     * Get Filial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilial()
    {
        return isset($this->Filial) ? $this->Filial : null;
    }
    /**
     * Set Filial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filial
     * @return \StructType\ResumoIvaERP
     */
    public function setFilial($filial = null)
    {
        // validation for constraint: string
        if (!is_null($filial) && !is_string($filial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filial)), __LINE__);
        }
        if (is_null($filial) || (is_array($filial) && empty($filial))) {
            unset($this->Filial);
        } else {
            $this->Filial = $filial;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return string|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param string $iD
     * @return \StructType\ResumoIvaERP
     */
    public function setID($iD = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iD) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iD, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iD) && !is_string($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IDOrig value
     * @return string|null
     */
    public function getIDOrig()
    {
        return $this->IDOrig;
    }
    /**
     * Set IDOrig value
     * @param string $iDOrig
     * @return \StructType\ResumoIvaERP
     */
    public function setIDOrig($iDOrig = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDOrig) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDOrig, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDOrig) && !is_string($iDOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDOrig)), __LINE__);
        }
        $this->IDOrig = $iDOrig;
        return $this;
    }
    /**
     * Get IVAIndeferido value
     * @return bool|null
     */
    public function getIVAIndeferido()
    {
        return $this->IVAIndeferido;
    }
    /**
     * Set IVAIndeferido value
     * @param bool $iVAIndeferido
     * @return \StructType\ResumoIvaERP
     */
    public function setIVAIndeferido($iVAIndeferido = null)
    {
        // validation for constraint: boolean
        if (!is_null($iVAIndeferido) && !is_bool($iVAIndeferido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($iVAIndeferido)), __LINE__);
        }
        $this->IVAIndeferido = $iVAIndeferido;
        return $this;
    }
    /**
     * Get Incidencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIncidencia()
    {
        return isset($this->Incidencia) ? $this->Incidencia : null;
    }
    /**
     * Set Incidencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $incidencia
     * @return \StructType\ResumoIvaERP
     */
    public function setIncidencia($incidencia = null)
    {
        if (is_null($incidencia) || (is_array($incidencia) && empty($incidencia))) {
            unset($this->Incidencia);
        } else {
            $this->Incidencia = $incidencia;
        }
        return $this;
    }
    /**
     * Get IncidenciaADI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIncidenciaADI()
    {
        return isset($this->IncidenciaADI) ? $this->IncidenciaADI : null;
    }
    /**
     * Set IncidenciaADI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $incidenciaADI
     * @return \StructType\ResumoIvaERP
     */
    public function setIncidenciaADI($incidenciaADI = null)
    {
        if (is_null($incidenciaADI) || (is_array($incidenciaADI) && empty($incidenciaADI))) {
            unset($this->IncidenciaADI);
        } else {
            $this->IncidenciaADI = $incidenciaADI;
        }
        return $this;
    }
    /**
     * Get IvaNaoDedutivel value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIvaNaoDedutivel()
    {
        return isset($this->IvaNaoDedutivel) ? $this->IvaNaoDedutivel : null;
    }
    /**
     * Set IvaNaoDedutivel value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $ivaNaoDedutivel
     * @return \StructType\ResumoIvaERP
     */
    public function setIvaNaoDedutivel($ivaNaoDedutivel = null)
    {
        if (is_null($ivaNaoDedutivel) || (is_array($ivaNaoDedutivel) && empty($ivaNaoDedutivel))) {
            unset($this->IvaNaoDedutivel);
        } else {
            $this->IvaNaoDedutivel = $ivaNaoDedutivel;
        }
        return $this;
    }
    /**
     * Get Modulo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModulo()
    {
        return isset($this->Modulo) ? $this->Modulo : null;
    }
    /**
     * Set Modulo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modulo
     * @return \StructType\ResumoIvaERP
     */
    public function setModulo($modulo = null)
    {
        // validation for constraint: string
        if (!is_null($modulo) && !is_string($modulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modulo)), __LINE__);
        }
        if (is_null($modulo) || (is_array($modulo) && empty($modulo))) {
            unset($this->Modulo);
        } else {
            $this->Modulo = $modulo;
        }
        return $this;
    }
    /**
     * Get NumDoc value
     * @return int|null
     */
    public function getNumDoc()
    {
        return $this->NumDoc;
    }
    /**
     * Set NumDoc value
     * @param int $numDoc
     * @return \StructType\ResumoIvaERP
     */
    public function setNumDoc($numDoc = null)
    {
        // validation for constraint: int
        if (!is_null($numDoc) && !is_numeric($numDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDoc)), __LINE__);
        }
        $this->NumDoc = $numDoc;
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ResumoIvaERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Serie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerie()
    {
        return isset($this->Serie) ? $this->Serie : null;
    }
    /**
     * Set Serie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serie
     * @return \StructType\ResumoIvaERP
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serie)), __LINE__);
        }
        if (is_null($serie) || (is_array($serie) && empty($serie))) {
            unset($this->Serie);
        } else {
            $this->Serie = $serie;
        }
        return $this;
    }
    /**
     * Get TaxaIva value
     * @return float|null
     */
    public function getTaxaIva()
    {
        return $this->TaxaIva;
    }
    /**
     * Set TaxaIva value
     * @param float $taxaIva
     * @return \StructType\ResumoIvaERP
     */
    public function setTaxaIva($taxaIva = null)
    {
        $this->TaxaIva = $taxaIva;
        return $this;
    }
    /**
     * Get TaxaRecargo value
     * @return float|null
     */
    public function getTaxaRecargo()
    {
        return $this->TaxaRecargo;
    }
    /**
     * Set TaxaRecargo value
     * @param float $taxaRecargo
     * @return \StructType\ResumoIvaERP
     */
    public function setTaxaRecargo($taxaRecargo = null)
    {
        $this->TaxaRecargo = $taxaRecargo;
        return $this;
    }
    /**
     * Get TipoDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDoc()
    {
        return isset($this->TipoDoc) ? $this->TipoDoc : null;
    }
    /**
     * Set TipoDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDoc
     * @return \StructType\ResumoIvaERP
     */
    public function setTipoDoc($tipoDoc = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDoc) && !is_string($tipoDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDoc)), __LINE__);
        }
        if (is_null($tipoDoc) || (is_array($tipoDoc) && empty($tipoDoc))) {
            unset($this->TipoDoc);
        } else {
            $this->TipoDoc = $tipoDoc;
        }
        return $this;
    }
    /**
     * Get Valor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValor()
    {
        return isset($this->Valor) ? $this->Valor : null;
    }
    /**
     * Set Valor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valor
     * @return \StructType\ResumoIvaERP
     */
    public function setValor($valor = null)
    {
        if (is_null($valor) || (is_array($valor) && empty($valor))) {
            unset($this->Valor);
        } else {
            $this->Valor = $valor;
        }
        return $this;
    }
    /**
     * Get ValorADI value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorADI()
    {
        return isset($this->ValorADI) ? $this->ValorADI : null;
    }
    /**
     * Set ValorADI value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorADI
     * @return \StructType\ResumoIvaERP
     */
    public function setValorADI($valorADI = null)
    {
        if (is_null($valorADI) || (is_array($valorADI) && empty($valorADI))) {
            unset($this->ValorADI);
        } else {
            $this->ValorADI = $valorADI;
        }
        return $this;
    }
    /**
     * Get ValorRecargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRecargo()
    {
        return isset($this->ValorRecargo) ? $this->ValorRecargo : null;
    }
    /**
     * Set ValorRecargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRecargo
     * @return \StructType\ResumoIvaERP
     */
    public function setValorRecargo($valorRecargo = null)
    {
        if (is_null($valorRecargo) || (is_array($valorRecargo) && empty($valorRecargo))) {
            unset($this->ValorRecargo);
        } else {
            $this->ValorRecargo = $valorRecargo;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ResumoIvaERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ResumoIvaERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
