<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ReferenciaMB StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ReferenciaMB
 * @subpackage Structs
 */
class ReferenciaMB extends AbstractStructBase
{
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The Referencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Referencia;
    /**
     * Constructor method for ReferenciaMB
     * @uses ReferenciaMB::setEntidade()
     * @uses ReferenciaMB::setReferencia()
     * @param string $entidade
     * @param string $referencia
     */
    public function __construct($entidade = null, $referencia = null)
    {
        $this
            ->setEntidade($entidade)
            ->setReferencia($referencia);
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\ReferenciaMB
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get Referencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferencia()
    {
        return isset($this->Referencia) ? $this->Referencia : null;
    }
    /**
     * Set Referencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referencia
     * @return \StructType\ReferenciaMB
     */
    public function setReferencia($referencia = null)
    {
        // validation for constraint: string
        if (!is_null($referencia) && !is_string($referencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referencia)), __LINE__);
        }
        if (is_null($referencia) || (is_array($referencia) && empty($referencia))) {
            unset($this->Referencia);
        } else {
            $this->Referencia = $referencia;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ReferenciaMB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
