<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MoedasERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MoedasERP
 * @subpackage Structs
 */
class MoedasERP extends AbstractStructBase
{
    /**
     * The Compra
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Compra;
    /**
     * The DataCambio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataCambio;
    /**
     * The DataUltimaActualizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataUltimaActualizacao;
    /**
     * The DecArredonda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DecArredonda;
    /**
     * The DecArredondaIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DecArredondaIva;
    /**
     * The DecPrecUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DecPrecUnit;
    /**
     * The DescParteDecimal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescParteDecimal;
    /**
     * The DescParteInteira
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescParteInteira;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The IDIso
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IDIso;
    /**
     * The ISO4217
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ISO4217;
    /**
     * The Moeda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Moeda;
    /**
     * The PertenceUEM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PertenceUEM;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Simbolo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Simbolo;
    /**
     * The Venda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Venda;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for MoedasERP
     * @uses MoedasERP::setCompra()
     * @uses MoedasERP::setDataCambio()
     * @uses MoedasERP::setDataUltimaActualizacao()
     * @uses MoedasERP::setDecArredonda()
     * @uses MoedasERP::setDecArredondaIva()
     * @uses MoedasERP::setDecPrecUnit()
     * @uses MoedasERP::setDescParteDecimal()
     * @uses MoedasERP::setDescParteInteira()
     * @uses MoedasERP::setDescricao()
     * @uses MoedasERP::setIDIso()
     * @uses MoedasERP::setISO4217()
     * @uses MoedasERP::setMoeda()
     * @uses MoedasERP::setPertenceUEM()
     * @uses MoedasERP::setProtegida()
     * @uses MoedasERP::setSimbolo()
     * @uses MoedasERP::setVenda()
     * @uses MoedasERP::setVersaoUltAct()
     * @param float $compra
     * @param string $dataCambio
     * @param string $dataUltimaActualizacao
     * @param int $decArredonda
     * @param int $decArredondaIva
     * @param int $decPrecUnit
     * @param string $descParteDecimal
     * @param string $descParteInteira
     * @param string $descricao
     * @param string $iDIso
     * @param string $iSO4217
     * @param string $moeda
     * @param bool $pertenceUEM
     * @param bool $protegida
     * @param string $simbolo
     * @param float $venda
     * @param string $versaoUltAct
     */
    public function __construct($compra = null, $dataCambio = null, $dataUltimaActualizacao = null, $decArredonda = null, $decArredondaIva = null, $decPrecUnit = null, $descParteDecimal = null, $descParteInteira = null, $descricao = null, $iDIso = null, $iSO4217 = null, $moeda = null, $pertenceUEM = null, $protegida = null, $simbolo = null, $venda = null, $versaoUltAct = null)
    {
        $this
            ->setCompra($compra)
            ->setDataCambio($dataCambio)
            ->setDataUltimaActualizacao($dataUltimaActualizacao)
            ->setDecArredonda($decArredonda)
            ->setDecArredondaIva($decArredondaIva)
            ->setDecPrecUnit($decPrecUnit)
            ->setDescParteDecimal($descParteDecimal)
            ->setDescParteInteira($descParteInteira)
            ->setDescricao($descricao)
            ->setIDIso($iDIso)
            ->setISO4217($iSO4217)
            ->setMoeda($moeda)
            ->setPertenceUEM($pertenceUEM)
            ->setProtegida($protegida)
            ->setSimbolo($simbolo)
            ->setVenda($venda)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Compra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCompra()
    {
        return isset($this->Compra) ? $this->Compra : null;
    }
    /**
     * Set Compra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $compra
     * @return \StructType\MoedasERP
     */
    public function setCompra($compra = null)
    {
        if (is_null($compra) || (is_array($compra) && empty($compra))) {
            unset($this->Compra);
        } else {
            $this->Compra = $compra;
        }
        return $this;
    }
    /**
     * Get DataCambio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataCambio()
    {
        return isset($this->DataCambio) ? $this->DataCambio : null;
    }
    /**
     * Set DataCambio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataCambio
     * @return \StructType\MoedasERP
     */
    public function setDataCambio($dataCambio = null)
    {
        // validation for constraint: string
        if (!is_null($dataCambio) && !is_string($dataCambio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataCambio)), __LINE__);
        }
        if (is_null($dataCambio) || (is_array($dataCambio) && empty($dataCambio))) {
            unset($this->DataCambio);
        } else {
            $this->DataCambio = $dataCambio;
        }
        return $this;
    }
    /**
     * Get DataUltimaActualizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataUltimaActualizacao()
    {
        return isset($this->DataUltimaActualizacao) ? $this->DataUltimaActualizacao : null;
    }
    /**
     * Set DataUltimaActualizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataUltimaActualizacao
     * @return \StructType\MoedasERP
     */
    public function setDataUltimaActualizacao($dataUltimaActualizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataUltimaActualizacao) && !is_string($dataUltimaActualizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataUltimaActualizacao)), __LINE__);
        }
        if (is_null($dataUltimaActualizacao) || (is_array($dataUltimaActualizacao) && empty($dataUltimaActualizacao))) {
            unset($this->DataUltimaActualizacao);
        } else {
            $this->DataUltimaActualizacao = $dataUltimaActualizacao;
        }
        return $this;
    }
    /**
     * Get DecArredonda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDecArredonda()
    {
        return isset($this->DecArredonda) ? $this->DecArredonda : null;
    }
    /**
     * Set DecArredonda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $decArredonda
     * @return \StructType\MoedasERP
     */
    public function setDecArredonda($decArredonda = null)
    {
        // validation for constraint: int
        if (!is_null($decArredonda) && !is_numeric($decArredonda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decArredonda)), __LINE__);
        }
        if (is_null($decArredonda) || (is_array($decArredonda) && empty($decArredonda))) {
            unset($this->DecArredonda);
        } else {
            $this->DecArredonda = $decArredonda;
        }
        return $this;
    }
    /**
     * Get DecArredondaIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDecArredondaIva()
    {
        return isset($this->DecArredondaIva) ? $this->DecArredondaIva : null;
    }
    /**
     * Set DecArredondaIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $decArredondaIva
     * @return \StructType\MoedasERP
     */
    public function setDecArredondaIva($decArredondaIva = null)
    {
        // validation for constraint: int
        if (!is_null($decArredondaIva) && !is_numeric($decArredondaIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decArredondaIva)), __LINE__);
        }
        if (is_null($decArredondaIva) || (is_array($decArredondaIva) && empty($decArredondaIva))) {
            unset($this->DecArredondaIva);
        } else {
            $this->DecArredondaIva = $decArredondaIva;
        }
        return $this;
    }
    /**
     * Get DecPrecUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDecPrecUnit()
    {
        return isset($this->DecPrecUnit) ? $this->DecPrecUnit : null;
    }
    /**
     * Set DecPrecUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $decPrecUnit
     * @return \StructType\MoedasERP
     */
    public function setDecPrecUnit($decPrecUnit = null)
    {
        // validation for constraint: int
        if (!is_null($decPrecUnit) && !is_numeric($decPrecUnit)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($decPrecUnit)), __LINE__);
        }
        if (is_null($decPrecUnit) || (is_array($decPrecUnit) && empty($decPrecUnit))) {
            unset($this->DecPrecUnit);
        } else {
            $this->DecPrecUnit = $decPrecUnit;
        }
        return $this;
    }
    /**
     * Get DescParteDecimal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescParteDecimal()
    {
        return isset($this->DescParteDecimal) ? $this->DescParteDecimal : null;
    }
    /**
     * Set DescParteDecimal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descParteDecimal
     * @return \StructType\MoedasERP
     */
    public function setDescParteDecimal($descParteDecimal = null)
    {
        // validation for constraint: string
        if (!is_null($descParteDecimal) && !is_string($descParteDecimal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descParteDecimal)), __LINE__);
        }
        if (is_null($descParteDecimal) || (is_array($descParteDecimal) && empty($descParteDecimal))) {
            unset($this->DescParteDecimal);
        } else {
            $this->DescParteDecimal = $descParteDecimal;
        }
        return $this;
    }
    /**
     * Get DescParteInteira value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescParteInteira()
    {
        return isset($this->DescParteInteira) ? $this->DescParteInteira : null;
    }
    /**
     * Set DescParteInteira value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descParteInteira
     * @return \StructType\MoedasERP
     */
    public function setDescParteInteira($descParteInteira = null)
    {
        // validation for constraint: string
        if (!is_null($descParteInteira) && !is_string($descParteInteira)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descParteInteira)), __LINE__);
        }
        if (is_null($descParteInteira) || (is_array($descParteInteira) && empty($descParteInteira))) {
            unset($this->DescParteInteira);
        } else {
            $this->DescParteInteira = $descParteInteira;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\MoedasERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get IDIso value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDIso()
    {
        return isset($this->IDIso) ? $this->IDIso : null;
    }
    /**
     * Set IDIso value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDIso
     * @return \StructType\MoedasERP
     */
    public function setIDIso($iDIso = null)
    {
        // validation for constraint: string
        if (!is_null($iDIso) && !is_string($iDIso)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDIso)), __LINE__);
        }
        if (is_null($iDIso) || (is_array($iDIso) && empty($iDIso))) {
            unset($this->IDIso);
        } else {
            $this->IDIso = $iDIso;
        }
        return $this;
    }
    /**
     * Get ISO4217 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getISO4217()
    {
        return isset($this->ISO4217) ? $this->ISO4217 : null;
    }
    /**
     * Set ISO4217 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iSO4217
     * @return \StructType\MoedasERP
     */
    public function setISO4217($iSO4217 = null)
    {
        // validation for constraint: string
        if (!is_null($iSO4217) && !is_string($iSO4217)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iSO4217)), __LINE__);
        }
        if (is_null($iSO4217) || (is_array($iSO4217) && empty($iSO4217))) {
            unset($this->ISO4217);
        } else {
            $this->ISO4217 = $iSO4217;
        }
        return $this;
    }
    /**
     * Get Moeda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoeda()
    {
        return isset($this->Moeda) ? $this->Moeda : null;
    }
    /**
     * Set Moeda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moeda
     * @return \StructType\MoedasERP
     */
    public function setMoeda($moeda = null)
    {
        // validation for constraint: string
        if (!is_null($moeda) && !is_string($moeda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moeda)), __LINE__);
        }
        if (is_null($moeda) || (is_array($moeda) && empty($moeda))) {
            unset($this->Moeda);
        } else {
            $this->Moeda = $moeda;
        }
        return $this;
    }
    /**
     * Get PertenceUEM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPertenceUEM()
    {
        return isset($this->PertenceUEM) ? $this->PertenceUEM : null;
    }
    /**
     * Set PertenceUEM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $pertenceUEM
     * @return \StructType\MoedasERP
     */
    public function setPertenceUEM($pertenceUEM = null)
    {
        // validation for constraint: boolean
        if (!is_null($pertenceUEM) && !is_bool($pertenceUEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($pertenceUEM)), __LINE__);
        }
        if (is_null($pertenceUEM) || (is_array($pertenceUEM) && empty($pertenceUEM))) {
            unset($this->PertenceUEM);
        } else {
            $this->PertenceUEM = $pertenceUEM;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\MoedasERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Simbolo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSimbolo()
    {
        return isset($this->Simbolo) ? $this->Simbolo : null;
    }
    /**
     * Set Simbolo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $simbolo
     * @return \StructType\MoedasERP
     */
    public function setSimbolo($simbolo = null)
    {
        // validation for constraint: string
        if (!is_null($simbolo) && !is_string($simbolo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($simbolo)), __LINE__);
        }
        if (is_null($simbolo) || (is_array($simbolo) && empty($simbolo))) {
            unset($this->Simbolo);
        } else {
            $this->Simbolo = $simbolo;
        }
        return $this;
    }
    /**
     * Get Venda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVenda()
    {
        return isset($this->Venda) ? $this->Venda : null;
    }
    /**
     * Set Venda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $venda
     * @return \StructType\MoedasERP
     */
    public function setVenda($venda = null)
    {
        if (is_null($venda) || (is_array($venda) && empty($venda))) {
            unset($this->Venda);
        } else {
            $this->Venda = $venda;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\MoedasERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MoedasERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
