<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ModelosERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ModelosERP
 * @subpackage Structs
 */
class ModelosERP extends AbstractStructBase
{
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Marca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Marca;
    /**
     * The Modelo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Modelo;
    /**
     * The Ordem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ordem;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The UnidadeCaracterizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UnidadeCaracterizacao;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ModelosERP
     * @uses ModelosERP::setDescricao()
     * @uses ModelosERP::setMarca()
     * @uses ModelosERP::setModelo()
     * @uses ModelosERP::setOrdem()
     * @uses ModelosERP::setProtegida()
     * @uses ModelosERP::setUnidadeCaracterizacao()
     * @uses ModelosERP::setVersaoUltAct()
     * @param string $descricao
     * @param string $marca
     * @param string $modelo
     * @param int $ordem
     * @param bool $protegida
     * @param string $unidadeCaracterizacao
     * @param string $versaoUltAct
     */
    public function __construct($descricao = null, $marca = null, $modelo = null, $ordem = null, $protegida = null, $unidadeCaracterizacao = null, $versaoUltAct = null)
    {
        $this
            ->setDescricao($descricao)
            ->setMarca($marca)
            ->setModelo($modelo)
            ->setOrdem($ordem)
            ->setProtegida($protegida)
            ->setUnidadeCaracterizacao($unidadeCaracterizacao)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\ModelosERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Marca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarca()
    {
        return isset($this->Marca) ? $this->Marca : null;
    }
    /**
     * Set Marca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marca
     * @return \StructType\ModelosERP
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marca)), __LINE__);
        }
        if (is_null($marca) || (is_array($marca) && empty($marca))) {
            unset($this->Marca);
        } else {
            $this->Marca = $marca;
        }
        return $this;
    }
    /**
     * Get Modelo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModelo()
    {
        return isset($this->Modelo) ? $this->Modelo : null;
    }
    /**
     * Set Modelo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modelo
     * @return \StructType\ModelosERP
     */
    public function setModelo($modelo = null)
    {
        // validation for constraint: string
        if (!is_null($modelo) && !is_string($modelo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelo)), __LINE__);
        }
        if (is_null($modelo) || (is_array($modelo) && empty($modelo))) {
            unset($this->Modelo);
        } else {
            $this->Modelo = $modelo;
        }
        return $this;
    }
    /**
     * Get Ordem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getOrdem()
    {
        return isset($this->Ordem) ? $this->Ordem : null;
    }
    /**
     * Set Ordem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ordem
     * @return \StructType\ModelosERP
     */
    public function setOrdem($ordem = null)
    {
        // validation for constraint: int
        if (!is_null($ordem) && !is_numeric($ordem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordem)), __LINE__);
        }
        if (is_null($ordem) || (is_array($ordem) && empty($ordem))) {
            unset($this->Ordem);
        } else {
            $this->Ordem = $ordem;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ModelosERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get UnidadeCaracterizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeCaracterizacao()
    {
        return isset($this->UnidadeCaracterizacao) ? $this->UnidadeCaracterizacao : null;
    }
    /**
     * Set UnidadeCaracterizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeCaracterizacao
     * @return \StructType\ModelosERP
     */
    public function setUnidadeCaracterizacao($unidadeCaracterizacao = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeCaracterizacao) && !is_string($unidadeCaracterizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeCaracterizacao)), __LINE__);
        }
        if (is_null($unidadeCaracterizacao) || (is_array($unidadeCaracterizacao) && empty($unidadeCaracterizacao))) {
            unset($this->UnidadeCaracterizacao);
        } else {
            $this->UnidadeCaracterizacao = $unidadeCaracterizacao;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ModelosERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ModelosERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
