<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasDocTransERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasDocTransERP
 * @subpackage Structs
 */
class LinhasDocTransERP extends AbstractStructBase
{
    /**
     * The IdLinhasDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhasDoc;
    /**
     * The IdLinhasDocOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhasDocOrigem;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QuantTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QuantTrans;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for LinhasDocTransERP
     * @uses LinhasDocTransERP::setIdLinhasDoc()
     * @uses LinhasDocTransERP::setIdLinhasDocOrigem()
     * @uses LinhasDocTransERP::setProtegida()
     * @uses LinhasDocTransERP::setQuantTrans()
     * @uses LinhasDocTransERP::setVersaoUltAct()
     * @param string $idLinhasDoc
     * @param string $idLinhasDocOrigem
     * @param bool $protegida
     * @param float $quantTrans
     * @param string $versaoUltAct
     */
    public function __construct($idLinhasDoc = null, $idLinhasDocOrigem = null, $protegida = null, $quantTrans = null, $versaoUltAct = null)
    {
        $this
            ->setIdLinhasDoc($idLinhasDoc)
            ->setIdLinhasDocOrigem($idLinhasDocOrigem)
            ->setProtegida($protegida)
            ->setQuantTrans($quantTrans)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get IdLinhasDoc value
     * @return string|null
     */
    public function getIdLinhasDoc()
    {
        return $this->IdLinhasDoc;
    }
    /**
     * Set IdLinhasDoc value
     * @param string $idLinhasDoc
     * @return \StructType\LinhasDocTransERP
     */
    public function setIdLinhasDoc($idLinhasDoc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhasDoc) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhasDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhasDoc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhasDoc) && !is_string($idLinhasDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhasDoc)), __LINE__);
        }
        $this->IdLinhasDoc = $idLinhasDoc;
        return $this;
    }
    /**
     * Get IdLinhasDocOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhasDocOrigem()
    {
        return isset($this->IdLinhasDocOrigem) ? $this->IdLinhasDocOrigem : null;
    }
    /**
     * Set IdLinhasDocOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhasDocOrigem
     * @return \StructType\LinhasDocTransERP
     */
    public function setIdLinhasDocOrigem($idLinhasDocOrigem = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhasDocOrigem) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhasDocOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhasDocOrigem, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhasDocOrigem) && !is_string($idLinhasDocOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhasDocOrigem)), __LINE__);
        }
        if (is_null($idLinhasDocOrigem) || (is_array($idLinhasDocOrigem) && empty($idLinhasDocOrigem))) {
            unset($this->IdLinhasDocOrigem);
        } else {
            $this->IdLinhasDocOrigem = $idLinhasDocOrigem;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasDocTransERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QuantTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantTrans()
    {
        return isset($this->QuantTrans) ? $this->QuantTrans : null;
    }
    /**
     * Set QuantTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantTrans
     * @return \StructType\LinhasDocTransERP
     */
    public function setQuantTrans($quantTrans = null)
    {
        if (is_null($quantTrans) || (is_array($quantTrans) && empty($quantTrans))) {
            unset($this->QuantTrans);
        } else {
            $this->QuantTrans = $quantTrans;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasDocTransERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasDocTransERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
