<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditaConcelhoJSON StructType
 * @subpackage Structs
 */
class EditaConcelhoJSON extends AbstractStructBase
{
    /**
     * The distrito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $distrito;
    /**
     * The concelho
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $concelho;
    /**
     * The forceRefresh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $forceRefresh;
    /**
     * Constructor method for EditaConcelhoJSON
     * @uses EditaConcelhoJSON::setDistrito()
     * @uses EditaConcelhoJSON::setConcelho()
     * @uses EditaConcelhoJSON::setForceRefresh()
     * @param string $distrito
     * @param string $concelho
     * @param bool $forceRefresh
     */
    public function __construct($distrito = null, $concelho = null, $forceRefresh = null)
    {
        $this
            ->setDistrito($distrito)
            ->setConcelho($concelho)
            ->setForceRefresh($forceRefresh);
    }
    /**
     * Get distrito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistrito()
    {
        return isset($this->distrito) ? $this->distrito : null;
    }
    /**
     * Set distrito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distrito
     * @return \StructType\EditaConcelhoJSON
     */
    public function setDistrito($distrito = null)
    {
        // validation for constraint: string
        if (!is_null($distrito) && !is_string($distrito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distrito)), __LINE__);
        }
        if (is_null($distrito) || (is_array($distrito) && empty($distrito))) {
            unset($this->distrito);
        } else {
            $this->distrito = $distrito;
        }
        return $this;
    }
    /**
     * Get concelho value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConcelho()
    {
        return isset($this->concelho) ? $this->concelho : null;
    }
    /**
     * Set concelho value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $concelho
     * @return \StructType\EditaConcelhoJSON
     */
    public function setConcelho($concelho = null)
    {
        // validation for constraint: string
        if (!is_null($concelho) && !is_string($concelho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($concelho)), __LINE__);
        }
        if (is_null($concelho) || (is_array($concelho) && empty($concelho))) {
            unset($this->concelho);
        } else {
            $this->concelho = $concelho;
        }
        return $this;
    }
    /**
     * Get forceRefresh value
     * @return bool|null
     */
    public function getForceRefresh()
    {
        return $this->forceRefresh;
    }
    /**
     * Set forceRefresh value
     * @param bool $forceRefresh
     * @return \StructType\EditaConcelhoJSON
     */
    public function setForceRefresh($forceRefresh = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceRefresh) && !is_bool($forceRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceRefresh)), __LINE__);
        }
        $this->forceRefresh = $forceRefresh;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditaConcelhoJSON
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
