<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditaArtigoUnidade StructType
 * @subpackage Structs
 */
class EditaArtigoUnidade extends AbstractStructBase
{
    /**
     * The artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artigo;
    /**
     * The unidadeOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unidadeOrigem;
    /**
     * The unidadeDestino
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unidadeDestino;
    /**
     * The forceRefresh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $forceRefresh;
    /**
     * Constructor method for EditaArtigoUnidade
     * @uses EditaArtigoUnidade::setArtigo()
     * @uses EditaArtigoUnidade::setUnidadeOrigem()
     * @uses EditaArtigoUnidade::setUnidadeDestino()
     * @uses EditaArtigoUnidade::setForceRefresh()
     * @param string $artigo
     * @param string $unidadeOrigem
     * @param string $unidadeDestino
     * @param bool $forceRefresh
     */
    public function __construct($artigo = null, $unidadeOrigem = null, $unidadeDestino = null, $forceRefresh = null)
    {
        $this
            ->setArtigo($artigo)
            ->setUnidadeOrigem($unidadeOrigem)
            ->setUnidadeDestino($unidadeDestino)
            ->setForceRefresh($forceRefresh);
    }
    /**
     * Get artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->artigo) ? $this->artigo : null;
    }
    /**
     * Set artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\EditaArtigoUnidade
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->artigo);
        } else {
            $this->artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get unidadeOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeOrigem()
    {
        return isset($this->unidadeOrigem) ? $this->unidadeOrigem : null;
    }
    /**
     * Set unidadeOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeOrigem
     * @return \StructType\EditaArtigoUnidade
     */
    public function setUnidadeOrigem($unidadeOrigem = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeOrigem) && !is_string($unidadeOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeOrigem)), __LINE__);
        }
        if (is_null($unidadeOrigem) || (is_array($unidadeOrigem) && empty($unidadeOrigem))) {
            unset($this->unidadeOrigem);
        } else {
            $this->unidadeOrigem = $unidadeOrigem;
        }
        return $this;
    }
    /**
     * Get unidadeDestino value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidadeDestino()
    {
        return isset($this->unidadeDestino) ? $this->unidadeDestino : null;
    }
    /**
     * Set unidadeDestino value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidadeDestino
     * @return \StructType\EditaArtigoUnidade
     */
    public function setUnidadeDestino($unidadeDestino = null)
    {
        // validation for constraint: string
        if (!is_null($unidadeDestino) && !is_string($unidadeDestino)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidadeDestino)), __LINE__);
        }
        if (is_null($unidadeDestino) || (is_array($unidadeDestino) && empty($unidadeDestino))) {
            unset($this->unidadeDestino);
        } else {
            $this->unidadeDestino = $unidadeDestino;
        }
        return $this;
    }
    /**
     * Get forceRefresh value
     * @return bool|null
     */
    public function getForceRefresh()
    {
        return $this->forceRefresh;
    }
    /**
     * Set forceRefresh value
     * @param bool $forceRefresh
     * @return \StructType\EditaArtigoUnidade
     */
    public function setForceRefresh($forceRefresh = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceRefresh) && !is_bool($forceRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceRefresh)), __LINE__);
        }
        $this->forceRefresh = $forceRefresh;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditaArtigoUnidade
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
