<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for DevolveDocumentosPagosMB StructType
 * @subpackage Structs
 */
class DevolveDocumentosPagosMB extends AbstractStructBase
{
    /**
     * The codParceiro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $codParceiro;
    /**
     * The dataInicio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataInicio;
    /**
     * The dataFim
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dataFim;
    /**
     * The idSessaoFicheiros
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $idSessaoFicheiros;
    /**
     * Constructor method for DevolveDocumentosPagosMB
     * @uses DevolveDocumentosPagosMB::setCodParceiro()
     * @uses DevolveDocumentosPagosMB::setDataInicio()
     * @uses DevolveDocumentosPagosMB::setDataFim()
     * @uses DevolveDocumentosPagosMB::setIdSessaoFicheiros()
     * @param string $codParceiro
     * @param string $dataInicio
     * @param string $dataFim
     * @param string $idSessaoFicheiros
     */
    public function __construct($codParceiro = null, $dataInicio = null, $dataFim = null, $idSessaoFicheiros = null)
    {
        $this
            ->setCodParceiro($codParceiro)
            ->setDataInicio($dataInicio)
            ->setDataFim($dataFim)
            ->setIdSessaoFicheiros($idSessaoFicheiros);
    }
    /**
     * Get codParceiro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodParceiro()
    {
        return isset($this->codParceiro) ? $this->codParceiro : null;
    }
    /**
     * Set codParceiro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codParceiro
     * @return \StructType\DevolveDocumentosPagosMB
     */
    public function setCodParceiro($codParceiro = null)
    {
        // validation for constraint: string
        if (!is_null($codParceiro) && !is_string($codParceiro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codParceiro)), __LINE__);
        }
        if (is_null($codParceiro) || (is_array($codParceiro) && empty($codParceiro))) {
            unset($this->codParceiro);
        } else {
            $this->codParceiro = $codParceiro;
        }
        return $this;
    }
    /**
     * Get dataInicio value
     * @return string|null
     */
    public function getDataInicio()
    {
        return $this->dataInicio;
    }
    /**
     * Set dataInicio value
     * @param string $dataInicio
     * @return \StructType\DevolveDocumentosPagosMB
     */
    public function setDataInicio($dataInicio = null)
    {
        // validation for constraint: string
        if (!is_null($dataInicio) && !is_string($dataInicio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataInicio)), __LINE__);
        }
        $this->dataInicio = $dataInicio;
        return $this;
    }
    /**
     * Get dataFim value
     * @return string|null
     */
    public function getDataFim()
    {
        return $this->dataFim;
    }
    /**
     * Set dataFim value
     * @param string $dataFim
     * @return \StructType\DevolveDocumentosPagosMB
     */
    public function setDataFim($dataFim = null)
    {
        // validation for constraint: string
        if (!is_null($dataFim) && !is_string($dataFim)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataFim)), __LINE__);
        }
        $this->dataFim = $dataFim;
        return $this;
    }
    /**
     * Get idSessaoFicheiros value
     * @return string|null
     */
    public function getIdSessaoFicheiros()
    {
        return $this->idSessaoFicheiros;
    }
    /**
     * Set idSessaoFicheiros value
     * @param string $idSessaoFicheiros
     * @return \StructType\DevolveDocumentosPagosMB
     */
    public function setIdSessaoFicheiros($idSessaoFicheiros = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idSessaoFicheiros) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idSessaoFicheiros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idSessaoFicheiros, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idSessaoFicheiros) && !is_string($idSessaoFicheiros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idSessaoFicheiros)), __LINE__);
        }
        $this->idSessaoFicheiros = $idSessaoFicheiros;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\DevolveDocumentosPagosMB
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
