<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConcelhosERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ConcelhosERP
 * @subpackage Structs
 */
class ConcelhosERP extends AbstractStructBase
{
    /**
     * The Concelho
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Concelho;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Distrito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Distrito;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * Constructor method for ConcelhosERP
     * @uses ConcelhosERP::setConcelho()
     * @uses ConcelhosERP::setDescricao()
     * @uses ConcelhosERP::setDistrito()
     * @uses ConcelhosERP::setProtegida()
     * @param string $concelho
     * @param string $descricao
     * @param string $distrito
     * @param bool $protegida
     */
    public function __construct($concelho = null, $descricao = null, $distrito = null, $protegida = null)
    {
        $this
            ->setConcelho($concelho)
            ->setDescricao($descricao)
            ->setDistrito($distrito)
            ->setProtegida($protegida);
    }
    /**
     * Get Concelho value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConcelho()
    {
        return isset($this->Concelho) ? $this->Concelho : null;
    }
    /**
     * Set Concelho value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $concelho
     * @return \StructType\ConcelhosERP
     */
    public function setConcelho($concelho = null)
    {
        // validation for constraint: string
        if (!is_null($concelho) && !is_string($concelho)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($concelho)), __LINE__);
        }
        if (is_null($concelho) || (is_array($concelho) && empty($concelho))) {
            unset($this->Concelho);
        } else {
            $this->Concelho = $concelho;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\ConcelhosERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Distrito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDistrito()
    {
        return isset($this->Distrito) ? $this->Distrito : null;
    }
    /**
     * Set Distrito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $distrito
     * @return \StructType\ConcelhosERP
     */
    public function setDistrito($distrito = null)
    {
        // validation for constraint: string
        if (!is_null($distrito) && !is_string($distrito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($distrito)), __LINE__);
        }
        if (is_null($distrito) || (is_array($distrito) && empty($distrito))) {
            unset($this->Distrito);
        } else {
            $this->Distrito = $distrito;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ConcelhosERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConcelhosERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
