<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for AnularDocumentoDeVendaSimples StructType
 * @subpackage Structs
 */
class AnularDocumentoDeVendaSimples extends AbstractStructBase
{
    /**
     * The documentoVenda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CabecDocERP
     */
    public $documentoVenda;
    /**
     * The motivoAnulacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $motivoAnulacao;
    /**
     * Constructor method for AnularDocumentoDeVendaSimples
     * @uses AnularDocumentoDeVendaSimples::setDocumentoVenda()
     * @uses AnularDocumentoDeVendaSimples::setMotivoAnulacao()
     * @param \StructType\CabecDocERP $documentoVenda
     * @param string $motivoAnulacao
     */
    public function __construct(\StructType\CabecDocERP $documentoVenda = null, $motivoAnulacao = null)
    {
        $this
            ->setDocumentoVenda($documentoVenda)
            ->setMotivoAnulacao($motivoAnulacao);
    }
    /**
     * Get documentoVenda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CabecDocERP|null
     */
    public function getDocumentoVenda()
    {
        return isset($this->documentoVenda) ? $this->documentoVenda : null;
    }
    /**
     * Set documentoVenda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CabecDocERP $documentoVenda
     * @return \StructType\AnularDocumentoDeVendaSimples
     */
    public function setDocumentoVenda(\StructType\CabecDocERP $documentoVenda = null)
    {
        if (is_null($documentoVenda) || (is_array($documentoVenda) && empty($documentoVenda))) {
            unset($this->documentoVenda);
        } else {
            $this->documentoVenda = $documentoVenda;
        }
        return $this;
    }
    /**
     * Get motivoAnulacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoAnulacao()
    {
        return isset($this->motivoAnulacao) ? $this->motivoAnulacao : null;
    }
    /**
     * Set motivoAnulacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoAnulacao
     * @return \StructType\AnularDocumentoDeVendaSimples
     */
    public function setMotivoAnulacao($motivoAnulacao = null)
    {
        // validation for constraint: string
        if (!is_null($motivoAnulacao) && !is_string($motivoAnulacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivoAnulacao)), __LINE__);
        }
        if (is_null($motivoAnulacao) || (is_array($motivoAnulacao) && empty($motivoAnulacao))) {
            unset($this->motivoAnulacao);
        } else {
            $this->motivoAnulacao = $motivoAnulacao;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\AnularDocumentoDeVendaSimples
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
