<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Transforma ServiceType
 * @subpackage Services
 */
class Transforma extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named TransformaDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransformaDocumentoVenda $parameters
     * @return \StructType\TransformaDocumentoVendaResponse|bool
     */
    public function TransformaDocumentoVenda(\StructType\TransformaDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TransformaDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransformaDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransformaDocumentoCompra $parameters
     * @return \StructType\TransformaDocumentoCompraResponse|bool
     */
    public function TransformaDocumentoCompra(\StructType\TransformaDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TransformaDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named TransformaDocumentoVendaMB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\TransformaDocumentoVendaMB $parameters
     * @return \StructType\TransformaDocumentoVendaMBResponse|bool
     */
    public function TransformaDocumentoVendaMB(\StructType\TransformaDocumentoVendaMB $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->TransformaDocumentoVendaMB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\TransformaDocumentoCompraResponse|\StructType\TransformaDocumentoVendaMBResponse|\StructType\TransformaDocumentoVendaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
