<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Atualiza ServiceType
 * @subpackage Services
 */
class Atualiza extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named AtualizaParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaParceiro $parameters
     * @return \StructType\AtualizaParceiroResponse|bool
     */
    public function AtualizaParceiro(\StructType\AtualizaParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaContaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaContaBancaria $parameters
     * @return \StructType\AtualizaContaBancariaResponse|bool
     */
    public function AtualizaContaBancaria(\StructType\AtualizaContaBancaria $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaContaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaConfiguracaoEasyPay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaConfiguracaoEasyPay $parameters
     * @return \StructType\AtualizaConfiguracaoEasyPayResponse|bool
     */
    public function AtualizaConfiguracaoEasyPay(\StructType\AtualizaConfiguracaoEasyPay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaConfiguracaoEasyPay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaVendedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaVendedor $parameters
     * @return \StructType\AtualizaVendedorResponse|bool
     */
    public function AtualizaVendedor(\StructType\AtualizaVendedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaVendedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaPais $parameters
     * @return \StructType\AtualizaPaisResponse|bool
     */
    public function AtualizaPais(\StructType\AtualizaPais $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaTipoContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaTipoContacto $parameters
     * @return \StructType\AtualizaTipoContactoResponse|bool
     */
    public function AtualizaTipoContacto(\StructType\AtualizaTipoContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaTipoContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaTipoParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaTipoParceiro $parameters
     * @return \StructType\AtualizaTipoParceiroResponse|bool
     */
    public function AtualizaTipoParceiro(\StructType\AtualizaTipoParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaTipoParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaContacto $parameters
     * @return \StructType\AtualizaContactoResponse|bool
     */
    public function AtualizaContacto(\StructType\AtualizaContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaTipoDocIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaTipoDocIdentificacao $parameters
     * @return \StructType\AtualizaTipoDocIdentificacaoResponse|bool
     */
    public function AtualizaTipoDocIdentificacao(\StructType\AtualizaTipoDocIdentificacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaTipoDocIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaArtigo $parameters
     * @return \StructType\AtualizaArtigoResponse|bool
     */
    public function AtualizaArtigo(\StructType\AtualizaArtigo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaArtigoMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaArtigoMoeda $parameters
     * @return \StructType\AtualizaArtigoMoedaResponse|bool
     */
    public function AtualizaArtigoMoeda(\StructType\AtualizaArtigoMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaArtigoMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaCliente $parameters
     * @return \StructType\AtualizaClienteResponse|bool
     */
    public function AtualizaCliente(\StructType\AtualizaCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaFamilia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaFamilia $parameters
     * @return \StructType\AtualizaFamiliaResponse|bool
     */
    public function AtualizaFamilia(\StructType\AtualizaFamilia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaFamilia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaFornecedor $parameters
     * @return \StructType\AtualizaFornecedorResponse|bool
     */
    public function AtualizaFornecedor(\StructType\AtualizaFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaDocumentoVenda $parameters
     * @return \StructType\AtualizaDocumentoVendaResponse|bool
     */
    public function AtualizaDocumentoVenda(\StructType\AtualizaDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaReferenciaMBDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaReferenciaMBDocumentoVenda $parameters
     * @return \StructType\AtualizaReferenciaMBDocumentoVendaResponse|bool
     */
    public function AtualizaReferenciaMBDocumentoVenda(\StructType\AtualizaReferenciaMBDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaReferenciaMBDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaDocumentoCompra $parameters
     * @return \StructType\AtualizaDocumentoCompraResponse|bool
     */
    public function AtualizaDocumentoCompra(\StructType\AtualizaDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named AtualizaDocumentoLiquidacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\AtualizaDocumentoLiquidacao $parameters
     * @return \StructType\AtualizaDocumentoLiquidacaoResponse|bool
     */
    public function AtualizaDocumentoLiquidacao(\StructType\AtualizaDocumentoLiquidacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->AtualizaDocumentoLiquidacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\AtualizaArtigoMoedaResponse|\StructType\AtualizaArtigoResponse|\StructType\AtualizaClienteResponse|\StructType\AtualizaConfiguracaoEasyPayResponse|\StructType\AtualizaContaBancariaResponse|\StructType\AtualizaContactoResponse|\StructType\AtualizaDocumentoCompraResponse|\StructType\AtualizaDocumentoLiquidacaoResponse|\StructType\AtualizaDocumentoVendaResponse|\StructType\AtualizaFamiliaResponse|\StructType\AtualizaFornecedorResponse|\StructType\AtualizaPaisResponse|\StructType\AtualizaParceiroResponse|\StructType\AtualizaReferenciaMBDocumentoVendaResponse|\StructType\AtualizaTipoContactoResponse|\StructType\AtualizaTipoDocIdentificacaoResponse|\StructType\AtualizaTipoParceiroResponse|\StructType\AtualizaVendedorResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
