<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfUnidadeERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfUnidadeERP
 * @subpackage Arrays
 */
class ArrayOfUnidadeERP extends AbstractStructArrayBase
{
    /**
     * The UnidadeERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\UnidadeERP[]
     */
    public $UnidadeERP;
    /**
     * Constructor method for ArrayOfUnidadeERP
     * @uses ArrayOfUnidadeERP::setUnidadeERP()
     * @param \StructType\UnidadeERP[] $unidadeERP
     */
    public function __construct(array $unidadeERP = array())
    {
        $this
            ->setUnidadeERP($unidadeERP);
    }
    /**
     * Get UnidadeERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\UnidadeERP[]|null
     */
    public function getUnidadeERP()
    {
        return isset($this->UnidadeERP) ? $this->UnidadeERP : null;
    }
    /**
     * Set UnidadeERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\UnidadeERP[] $unidadeERP
     * @return \ArrayType\ArrayOfUnidadeERP
     */
    public function setUnidadeERP(array $unidadeERP = array())
    {
        foreach ($unidadeERP as $arrayOfUnidadeERPUnidadeERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfUnidadeERPUnidadeERPItem instanceof \StructType\UnidadeERP) {
                throw new \InvalidArgumentException(sprintf('The UnidadeERP property can only contain items of \StructType\UnidadeERP, "%s" given', is_object($arrayOfUnidadeERPUnidadeERPItem) ? get_class($arrayOfUnidadeERPUnidadeERPItem) : gettype($arrayOfUnidadeERPUnidadeERPItem)), __LINE__);
            }
        }
        if (is_null($unidadeERP) || (is_array($unidadeERP) && empty($unidadeERP))) {
            unset($this->UnidadeERP);
        } else {
            $this->UnidadeERP = $unidadeERP;
        }
        return $this;
    }
    /**
     * Add item to UnidadeERP value
     * @throws \InvalidArgumentException
     * @param \StructType\UnidadeERP $item
     * @return \ArrayType\ArrayOfUnidadeERP
     */
    public function addToUnidadeERP(\StructType\UnidadeERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\UnidadeERP) {
            throw new \InvalidArgumentException(sprintf('The UnidadeERP property can only contain items of \StructType\UnidadeERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->UnidadeERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\UnidadeERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\UnidadeERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\UnidadeERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\UnidadeERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\UnidadeERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string UnidadeERP
     */
    public function getAttributeName()
    {
        return 'UnidadeERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfUnidadeERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
