<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfModelosERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfModelosERP
 * @subpackage Arrays
 */
class ArrayOfModelosERP extends AbstractStructArrayBase
{
    /**
     * The ModelosERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\ModelosERP[]
     */
    public $ModelosERP;
    /**
     * Constructor method for ArrayOfModelosERP
     * @uses ArrayOfModelosERP::setModelosERP()
     * @param \StructType\ModelosERP[] $modelosERP
     */
    public function __construct(array $modelosERP = array())
    {
        $this
            ->setModelosERP($modelosERP);
    }
    /**
     * Get ModelosERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\ModelosERP[]|null
     */
    public function getModelosERP()
    {
        return isset($this->ModelosERP) ? $this->ModelosERP : null;
    }
    /**
     * Set ModelosERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\ModelosERP[] $modelosERP
     * @return \ArrayType\ArrayOfModelosERP
     */
    public function setModelosERP(array $modelosERP = array())
    {
        foreach ($modelosERP as $arrayOfModelosERPModelosERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfModelosERPModelosERPItem instanceof \StructType\ModelosERP) {
                throw new \InvalidArgumentException(sprintf('The ModelosERP property can only contain items of \StructType\ModelosERP, "%s" given', is_object($arrayOfModelosERPModelosERPItem) ? get_class($arrayOfModelosERPModelosERPItem) : gettype($arrayOfModelosERPModelosERPItem)), __LINE__);
            }
        }
        if (is_null($modelosERP) || (is_array($modelosERP) && empty($modelosERP))) {
            unset($this->ModelosERP);
        } else {
            $this->ModelosERP = $modelosERP;
        }
        return $this;
    }
    /**
     * Add item to ModelosERP value
     * @throws \InvalidArgumentException
     * @param \StructType\ModelosERP $item
     * @return \ArrayType\ArrayOfModelosERP
     */
    public function addToModelosERP(\StructType\ModelosERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\ModelosERP) {
            throw new \InvalidArgumentException(sprintf('The ModelosERP property can only contain items of \StructType\ModelosERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->ModelosERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\ModelosERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\ModelosERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\ModelosERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\ModelosERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\ModelosERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string ModelosERP
     */
    public function getAttributeName()
    {
        return 'ModelosERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfModelosERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
