<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfMarcasERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfMarcasERP
 * @subpackage Arrays
 */
class ArrayOfMarcasERP extends AbstractStructArrayBase
{
    /**
     * The MarcasERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MarcasERP[]
     */
    public $MarcasERP;
    /**
     * Constructor method for ArrayOfMarcasERP
     * @uses ArrayOfMarcasERP::setMarcasERP()
     * @param \StructType\MarcasERP[] $marcasERP
     */
    public function __construct(array $marcasERP = array())
    {
        $this
            ->setMarcasERP($marcasERP);
    }
    /**
     * Get MarcasERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MarcasERP[]|null
     */
    public function getMarcasERP()
    {
        return isset($this->MarcasERP) ? $this->MarcasERP : null;
    }
    /**
     * Set MarcasERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\MarcasERP[] $marcasERP
     * @return \ArrayType\ArrayOfMarcasERP
     */
    public function setMarcasERP(array $marcasERP = array())
    {
        foreach ($marcasERP as $arrayOfMarcasERPMarcasERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfMarcasERPMarcasERPItem instanceof \StructType\MarcasERP) {
                throw new \InvalidArgumentException(sprintf('The MarcasERP property can only contain items of \StructType\MarcasERP, "%s" given', is_object($arrayOfMarcasERPMarcasERPItem) ? get_class($arrayOfMarcasERPMarcasERPItem) : gettype($arrayOfMarcasERPMarcasERPItem)), __LINE__);
            }
        }
        if (is_null($marcasERP) || (is_array($marcasERP) && empty($marcasERP))) {
            unset($this->MarcasERP);
        } else {
            $this->MarcasERP = $marcasERP;
        }
        return $this;
    }
    /**
     * Add item to MarcasERP value
     * @throws \InvalidArgumentException
     * @param \StructType\MarcasERP $item
     * @return \ArrayType\ArrayOfMarcasERP
     */
    public function addToMarcasERP(\StructType\MarcasERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\MarcasERP) {
            throw new \InvalidArgumentException(sprintf('The MarcasERP property can only contain items of \StructType\MarcasERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->MarcasERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\MarcasERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\MarcasERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\MarcasERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\MarcasERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\MarcasERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string MarcasERP
     */
    public function getAttributeName()
    {
        return 'MarcasERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfMarcasERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
