<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfLinhasDocTransERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfLinhasDocTransERP
 * @subpackage Arrays
 */
class ArrayOfLinhasDocTransERP extends AbstractStructArrayBase
{
    /**
     * The LinhasDocTransERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\LinhasDocTransERP[]
     */
    public $LinhasDocTransERP;
    /**
     * Constructor method for ArrayOfLinhasDocTransERP
     * @uses ArrayOfLinhasDocTransERP::setLinhasDocTransERP()
     * @param \StructType\LinhasDocTransERP[] $linhasDocTransERP
     */
    public function __construct(array $linhasDocTransERP = array())
    {
        $this
            ->setLinhasDocTransERP($linhasDocTransERP);
    }
    /**
     * Get LinhasDocTransERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\LinhasDocTransERP[]|null
     */
    public function getLinhasDocTransERP()
    {
        return isset($this->LinhasDocTransERP) ? $this->LinhasDocTransERP : null;
    }
    /**
     * Set LinhasDocTransERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\LinhasDocTransERP[] $linhasDocTransERP
     * @return \ArrayType\ArrayOfLinhasDocTransERP
     */
    public function setLinhasDocTransERP(array $linhasDocTransERP = array())
    {
        foreach ($linhasDocTransERP as $arrayOfLinhasDocTransERPLinhasDocTransERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfLinhasDocTransERPLinhasDocTransERPItem instanceof \StructType\LinhasDocTransERP) {
                throw new \InvalidArgumentException(sprintf('The LinhasDocTransERP property can only contain items of \StructType\LinhasDocTransERP, "%s" given', is_object($arrayOfLinhasDocTransERPLinhasDocTransERPItem) ? get_class($arrayOfLinhasDocTransERPLinhasDocTransERPItem) : gettype($arrayOfLinhasDocTransERPLinhasDocTransERPItem)), __LINE__);
            }
        }
        if (is_null($linhasDocTransERP) || (is_array($linhasDocTransERP) && empty($linhasDocTransERP))) {
            unset($this->LinhasDocTransERP);
        } else {
            $this->LinhasDocTransERP = $linhasDocTransERP;
        }
        return $this;
    }
    /**
     * Add item to LinhasDocTransERP value
     * @throws \InvalidArgumentException
     * @param \StructType\LinhasDocTransERP $item
     * @return \ArrayType\ArrayOfLinhasDocTransERP
     */
    public function addToLinhasDocTransERP(\StructType\LinhasDocTransERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\LinhasDocTransERP) {
            throw new \InvalidArgumentException(sprintf('The LinhasDocTransERP property can only contain items of \StructType\LinhasDocTransERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->LinhasDocTransERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\LinhasDocTransERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\LinhasDocTransERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\LinhasDocTransERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\LinhasDocTransERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\LinhasDocTransERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string LinhasDocTransERP
     */
    public function getAttributeName()
    {
        return 'LinhasDocTransERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfLinhasDocTransERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
