<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfIvaERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfIvaERP
 * @subpackage Arrays
 */
class ArrayOfIvaERP extends AbstractStructArrayBase
{
    /**
     * The IvaERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\IvaERP[]
     */
    public $IvaERP;
    /**
     * Constructor method for ArrayOfIvaERP
     * @uses ArrayOfIvaERP::setIvaERP()
     * @param \StructType\IvaERP[] $ivaERP
     */
    public function __construct(array $ivaERP = array())
    {
        $this
            ->setIvaERP($ivaERP);
    }
    /**
     * Get IvaERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\IvaERP[]|null
     */
    public function getIvaERP()
    {
        return isset($this->IvaERP) ? $this->IvaERP : null;
    }
    /**
     * Set IvaERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\IvaERP[] $ivaERP
     * @return \ArrayType\ArrayOfIvaERP
     */
    public function setIvaERP(array $ivaERP = array())
    {
        foreach ($ivaERP as $arrayOfIvaERPIvaERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfIvaERPIvaERPItem instanceof \StructType\IvaERP) {
                throw new \InvalidArgumentException(sprintf('The IvaERP property can only contain items of \StructType\IvaERP, "%s" given', is_object($arrayOfIvaERPIvaERPItem) ? get_class($arrayOfIvaERPIvaERPItem) : gettype($arrayOfIvaERPIvaERPItem)), __LINE__);
            }
        }
        if (is_null($ivaERP) || (is_array($ivaERP) && empty($ivaERP))) {
            unset($this->IvaERP);
        } else {
            $this->IvaERP = $ivaERP;
        }
        return $this;
    }
    /**
     * Add item to IvaERP value
     * @throws \InvalidArgumentException
     * @param \StructType\IvaERP $item
     * @return \ArrayType\ArrayOfIvaERP
     */
    public function addToIvaERP(\StructType\IvaERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\IvaERP) {
            throw new \InvalidArgumentException(sprintf('The IvaERP property can only contain items of \StructType\IvaERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->IvaERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\IvaERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\IvaERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\IvaERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\IvaERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\IvaERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string IvaERP
     */
    public function getAttributeName()
    {
        return 'IvaERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfIvaERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
