<?php

namespace ArrayType;

use \WsdlToPhp\PackageBase\AbstractStructArrayBase;

/**
 * This class stands for ArrayOfEmpresaERP ArrayType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ArrayOfEmpresaERP
 * @subpackage Arrays
 */
class ArrayOfEmpresaERP extends AbstractStructArrayBase
{
    /**
     * The EmpresaERP
     * Meta informations extracted from the WSDL
     * - maxOccurs: unbounded
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\EmpresaERP[]
     */
    public $EmpresaERP;
    /**
     * Constructor method for ArrayOfEmpresaERP
     * @uses ArrayOfEmpresaERP::setEmpresaERP()
     * @param \StructType\EmpresaERP[] $empresaERP
     */
    public function __construct(array $empresaERP = array())
    {
        $this
            ->setEmpresaERP($empresaERP);
    }
    /**
     * Get EmpresaERP value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\EmpresaERP[]|null
     */
    public function getEmpresaERP()
    {
        return isset($this->EmpresaERP) ? $this->EmpresaERP : null;
    }
    /**
     * Set EmpresaERP value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @throws \InvalidArgumentException
     * @param \StructType\EmpresaERP[] $empresaERP
     * @return \ArrayType\ArrayOfEmpresaERP
     */
    public function setEmpresaERP(array $empresaERP = array())
    {
        foreach ($empresaERP as $arrayOfEmpresaERPEmpresaERPItem) {
            // validation for constraint: itemType
            if (!$arrayOfEmpresaERPEmpresaERPItem instanceof \StructType\EmpresaERP) {
                throw new \InvalidArgumentException(sprintf('The EmpresaERP property can only contain items of \StructType\EmpresaERP, "%s" given', is_object($arrayOfEmpresaERPEmpresaERPItem) ? get_class($arrayOfEmpresaERPEmpresaERPItem) : gettype($arrayOfEmpresaERPEmpresaERPItem)), __LINE__);
            }
        }
        if (is_null($empresaERP) || (is_array($empresaERP) && empty($empresaERP))) {
            unset($this->EmpresaERP);
        } else {
            $this->EmpresaERP = $empresaERP;
        }
        return $this;
    }
    /**
     * Add item to EmpresaERP value
     * @throws \InvalidArgumentException
     * @param \StructType\EmpresaERP $item
     * @return \ArrayType\ArrayOfEmpresaERP
     */
    public function addToEmpresaERP(\StructType\EmpresaERP $item)
    {
        // validation for constraint: itemType
        if (!$item instanceof \StructType\EmpresaERP) {
            throw new \InvalidArgumentException(sprintf('The EmpresaERP property can only contain items of \StructType\EmpresaERP, "%s" given', is_object($item) ? get_class($item) : gettype($item)), __LINE__);
        }
        $this->EmpresaERP[] = $item;
        return $this;
    }
    /**
     * Returns the current element
     * @see AbstractStructArrayBase::current()
     * @return \StructType\EmpresaERP|null
     */
    public function current()
    {
        return parent::current();
    }
    /**
     * Returns the indexed element
     * @see AbstractStructArrayBase::item()
     * @param int $index
     * @return \StructType\EmpresaERP|null
     */
    public function item($index)
    {
        return parent::item($index);
    }
    /**
     * Returns the first element
     * @see AbstractStructArrayBase::first()
     * @return \StructType\EmpresaERP|null
     */
    public function first()
    {
        return parent::first();
    }
    /**
     * Returns the last element
     * @see AbstractStructArrayBase::last()
     * @return \StructType\EmpresaERP|null
     */
    public function last()
    {
        return parent::last();
    }
    /**
     * Returns the element at the offset
     * @see AbstractStructArrayBase::offsetGet()
     * @param int $offset
     * @return \StructType\EmpresaERP|null
     */
    public function offsetGet($offset)
    {
        return parent::offsetGet($offset);
    }
    /**
     * Returns the attribute name
     * @see AbstractStructArrayBase::getAttributeName()
     * @return string EmpresaERP
     */
    public function getAttributeName()
    {
        return 'EmpresaERP';
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructArrayBase::__set_state()
     * @uses AbstractStructArrayBase::__set_state()
     * @param array $array the exported values
     * @return \ArrayType\ArrayOfEmpresaERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
