<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for V_SDD_PendentesERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:V_SDD_PendentesERP
 * @subpackage Structs
 */
class V_SDD_PendentesERP extends AbstractStructBase
{
    /**
     * The Anulado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Anulado;
    /**
     * The DataAnulacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataAnulacao;
    /**
     * The DataDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDoc;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The Estabelecimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estabelecimento;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The Fechado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Fechado;
    /**
     * The IdHistorico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdHistorico;
    /**
     * The Modulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Modulo;
    /**
     * The Nome
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nome;
    /**
     * The NomeEstabelecimento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeEstabelecimento;
    /**
     * The NomeVendedor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NomeVendedor;
    /**
     * The NumDocInt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumDocInt;
    /**
     * The NumPrestacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumPrestacao;
    /**
     * The OrdemLiquidacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $OrdemLiquidacao;
    /**
     * The ReferenciaMB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenciaMB;
    /**
     * The ReferenciaMBEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ReferenciaMBEntidade;
    /**
     * The RespCobranca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RespCobranca;
    /**
     * The Serie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serie;
    /**
     * The TipoConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoConta;
    /**
     * The TipoDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDoc;
    /**
     * The TipoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidade;
    /**
     * The ValorPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPendente;
    /**
     * The ValorPendenteCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPendenteCredito;
    /**
     * The ValorPendenteDebito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPendenteDebito;
    /**
     * The ValorTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorTotal;
    /**
     * The ValorTotalCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorTotalCredito;
    /**
     * The ValorTotalDebito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorTotalDebito;
    /**
     * The id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $id;
    /**
     * The idDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $idDoc;
    /**
     * Constructor method for V_SDD_PendentesERP
     * @uses V_SDD_PendentesERP::setAnulado()
     * @uses V_SDD_PendentesERP::setDataAnulacao()
     * @uses V_SDD_PendentesERP::setDataDoc()
     * @uses V_SDD_PendentesERP::setDescricao()
     * @uses V_SDD_PendentesERP::setEntidade()
     * @uses V_SDD_PendentesERP::setEstabelecimento()
     * @uses V_SDD_PendentesERP::setEstado()
     * @uses V_SDD_PendentesERP::setFechado()
     * @uses V_SDD_PendentesERP::setIdHistorico()
     * @uses V_SDD_PendentesERP::setModulo()
     * @uses V_SDD_PendentesERP::setNome()
     * @uses V_SDD_PendentesERP::setNomeEstabelecimento()
     * @uses V_SDD_PendentesERP::setNomeVendedor()
     * @uses V_SDD_PendentesERP::setNumDocInt()
     * @uses V_SDD_PendentesERP::setNumPrestacao()
     * @uses V_SDD_PendentesERP::setOrdemLiquidacao()
     * @uses V_SDD_PendentesERP::setReferenciaMB()
     * @uses V_SDD_PendentesERP::setReferenciaMBEntidade()
     * @uses V_SDD_PendentesERP::setRespCobranca()
     * @uses V_SDD_PendentesERP::setSerie()
     * @uses V_SDD_PendentesERP::setTipoConta()
     * @uses V_SDD_PendentesERP::setTipoDoc()
     * @uses V_SDD_PendentesERP::setTipoEntidade()
     * @uses V_SDD_PendentesERP::setValorPendente()
     * @uses V_SDD_PendentesERP::setValorPendenteCredito()
     * @uses V_SDD_PendentesERP::setValorPendenteDebito()
     * @uses V_SDD_PendentesERP::setValorTotal()
     * @uses V_SDD_PendentesERP::setValorTotalCredito()
     * @uses V_SDD_PendentesERP::setValorTotalDebito()
     * @uses V_SDD_PendentesERP::setId()
     * @uses V_SDD_PendentesERP::setIdDoc()
     * @param bool $anulado
     * @param string $dataAnulacao
     * @param string $dataDoc
     * @param string $descricao
     * @param string $entidade
     * @param string $estabelecimento
     * @param string $estado
     * @param bool $fechado
     * @param string $idHistorico
     * @param string $modulo
     * @param string $nome
     * @param string $nomeEstabelecimento
     * @param string $nomeVendedor
     * @param int $numDocInt
     * @param int $numPrestacao
     * @param int $ordemLiquidacao
     * @param string $referenciaMB
     * @param string $referenciaMBEntidade
     * @param string $respCobranca
     * @param string $serie
     * @param string $tipoConta
     * @param string $tipoDoc
     * @param string $tipoEntidade
     * @param float $valorPendente
     * @param float $valorPendenteCredito
     * @param float $valorPendenteDebito
     * @param float $valorTotal
     * @param float $valorTotalCredito
     * @param float $valorTotalDebito
     * @param string $id
     * @param string $idDoc
     */
    public function __construct($anulado = null, $dataAnulacao = null, $dataDoc = null, $descricao = null, $entidade = null, $estabelecimento = null, $estado = null, $fechado = null, $idHistorico = null, $modulo = null, $nome = null, $nomeEstabelecimento = null, $nomeVendedor = null, $numDocInt = null, $numPrestacao = null, $ordemLiquidacao = null, $referenciaMB = null, $referenciaMBEntidade = null, $respCobranca = null, $serie = null, $tipoConta = null, $tipoDoc = null, $tipoEntidade = null, $valorPendente = null, $valorPendenteCredito = null, $valorPendenteDebito = null, $valorTotal = null, $valorTotalCredito = null, $valorTotalDebito = null, $id = null, $idDoc = null)
    {
        $this
            ->setAnulado($anulado)
            ->setDataAnulacao($dataAnulacao)
            ->setDataDoc($dataDoc)
            ->setDescricao($descricao)
            ->setEntidade($entidade)
            ->setEstabelecimento($estabelecimento)
            ->setEstado($estado)
            ->setFechado($fechado)
            ->setIdHistorico($idHistorico)
            ->setModulo($modulo)
            ->setNome($nome)
            ->setNomeEstabelecimento($nomeEstabelecimento)
            ->setNomeVendedor($nomeVendedor)
            ->setNumDocInt($numDocInt)
            ->setNumPrestacao($numPrestacao)
            ->setOrdemLiquidacao($ordemLiquidacao)
            ->setReferenciaMB($referenciaMB)
            ->setReferenciaMBEntidade($referenciaMBEntidade)
            ->setRespCobranca($respCobranca)
            ->setSerie($serie)
            ->setTipoConta($tipoConta)
            ->setTipoDoc($tipoDoc)
            ->setTipoEntidade($tipoEntidade)
            ->setValorPendente($valorPendente)
            ->setValorPendenteCredito($valorPendenteCredito)
            ->setValorPendenteDebito($valorPendenteDebito)
            ->setValorTotal($valorTotal)
            ->setValorTotalCredito($valorTotalCredito)
            ->setValorTotalDebito($valorTotalDebito)
            ->setId($id)
            ->setIdDoc($idDoc);
    }
    /**
     * Get Anulado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAnulado()
    {
        return isset($this->Anulado) ? $this->Anulado : null;
    }
    /**
     * Set Anulado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $anulado
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setAnulado($anulado = null)
    {
        // validation for constraint: boolean
        if (!is_null($anulado) && !is_bool($anulado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($anulado)), __LINE__);
        }
        if (is_null($anulado) || (is_array($anulado) && empty($anulado))) {
            unset($this->Anulado);
        } else {
            $this->Anulado = $anulado;
        }
        return $this;
    }
    /**
     * Get DataAnulacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataAnulacao()
    {
        return isset($this->DataAnulacao) ? $this->DataAnulacao : null;
    }
    /**
     * Set DataAnulacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataAnulacao
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setDataAnulacao($dataAnulacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataAnulacao) && !is_string($dataAnulacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataAnulacao)), __LINE__);
        }
        if (is_null($dataAnulacao) || (is_array($dataAnulacao) && empty($dataAnulacao))) {
            unset($this->DataAnulacao);
        } else {
            $this->DataAnulacao = $dataAnulacao;
        }
        return $this;
    }
    /**
     * Get DataDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDoc()
    {
        return isset($this->DataDoc) ? $this->DataDoc : null;
    }
    /**
     * Set DataDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDoc
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setDataDoc($dataDoc = null)
    {
        // validation for constraint: string
        if (!is_null($dataDoc) && !is_string($dataDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDoc)), __LINE__);
        }
        if (is_null($dataDoc) || (is_array($dataDoc) && empty($dataDoc))) {
            unset($this->DataDoc);
        } else {
            $this->DataDoc = $dataDoc;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get Estabelecimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstabelecimento()
    {
        return isset($this->Estabelecimento) ? $this->Estabelecimento : null;
    }
    /**
     * Set Estabelecimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estabelecimento
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setEstabelecimento($estabelecimento = null)
    {
        // validation for constraint: string
        if (!is_null($estabelecimento) && !is_string($estabelecimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estabelecimento)), __LINE__);
        }
        if (is_null($estabelecimento) || (is_array($estabelecimento) && empty($estabelecimento))) {
            unset($this->Estabelecimento);
        } else {
            $this->Estabelecimento = $estabelecimento;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get Fechado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFechado()
    {
        return isset($this->Fechado) ? $this->Fechado : null;
    }
    /**
     * Set Fechado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fechado
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setFechado($fechado = null)
    {
        // validation for constraint: boolean
        if (!is_null($fechado) && !is_bool($fechado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fechado)), __LINE__);
        }
        if (is_null($fechado) || (is_array($fechado) && empty($fechado))) {
            unset($this->Fechado);
        } else {
            $this->Fechado = $fechado;
        }
        return $this;
    }
    /**
     * Get IdHistorico value
     * @return string|null
     */
    public function getIdHistorico()
    {
        return $this->IdHistorico;
    }
    /**
     * Set IdHistorico value
     * @param string $idHistorico
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setIdHistorico($idHistorico = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idHistorico) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idHistorico, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idHistorico) && !is_string($idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idHistorico)), __LINE__);
        }
        $this->IdHistorico = $idHistorico;
        return $this;
    }
    /**
     * Get Modulo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModulo()
    {
        return isset($this->Modulo) ? $this->Modulo : null;
    }
    /**
     * Set Modulo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modulo
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setModulo($modulo = null)
    {
        // validation for constraint: string
        if (!is_null($modulo) && !is_string($modulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modulo)), __LINE__);
        }
        if (is_null($modulo) || (is_array($modulo) && empty($modulo))) {
            unset($this->Modulo);
        } else {
            $this->Modulo = $modulo;
        }
        return $this;
    }
    /**
     * Get Nome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNome()
    {
        return isset($this->Nome) ? $this->Nome : null;
    }
    /**
     * Set Nome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nome
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setNome($nome = null)
    {
        // validation for constraint: string
        if (!is_null($nome) && !is_string($nome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nome)), __LINE__);
        }
        if (is_null($nome) || (is_array($nome) && empty($nome))) {
            unset($this->Nome);
        } else {
            $this->Nome = $nome;
        }
        return $this;
    }
    /**
     * Get NomeEstabelecimento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeEstabelecimento()
    {
        return isset($this->NomeEstabelecimento) ? $this->NomeEstabelecimento : null;
    }
    /**
     * Set NomeEstabelecimento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeEstabelecimento
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setNomeEstabelecimento($nomeEstabelecimento = null)
    {
        // validation for constraint: string
        if (!is_null($nomeEstabelecimento) && !is_string($nomeEstabelecimento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeEstabelecimento)), __LINE__);
        }
        if (is_null($nomeEstabelecimento) || (is_array($nomeEstabelecimento) && empty($nomeEstabelecimento))) {
            unset($this->NomeEstabelecimento);
        } else {
            $this->NomeEstabelecimento = $nomeEstabelecimento;
        }
        return $this;
    }
    /**
     * Get NomeVendedor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNomeVendedor()
    {
        return isset($this->NomeVendedor) ? $this->NomeVendedor : null;
    }
    /**
     * Set NomeVendedor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nomeVendedor
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setNomeVendedor($nomeVendedor = null)
    {
        // validation for constraint: string
        if (!is_null($nomeVendedor) && !is_string($nomeVendedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nomeVendedor)), __LINE__);
        }
        if (is_null($nomeVendedor) || (is_array($nomeVendedor) && empty($nomeVendedor))) {
            unset($this->NomeVendedor);
        } else {
            $this->NomeVendedor = $nomeVendedor;
        }
        return $this;
    }
    /**
     * Get NumDocInt value
     * @return int|null
     */
    public function getNumDocInt()
    {
        return $this->NumDocInt;
    }
    /**
     * Set NumDocInt value
     * @param int $numDocInt
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setNumDocInt($numDocInt = null)
    {
        // validation for constraint: int
        if (!is_null($numDocInt) && !is_numeric($numDocInt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDocInt)), __LINE__);
        }
        $this->NumDocInt = $numDocInt;
        return $this;
    }
    /**
     * Get NumPrestacao value
     * @return int|null
     */
    public function getNumPrestacao()
    {
        return $this->NumPrestacao;
    }
    /**
     * Set NumPrestacao value
     * @param int $numPrestacao
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setNumPrestacao($numPrestacao = null)
    {
        // validation for constraint: int
        if (!is_null($numPrestacao) && !is_numeric($numPrestacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numPrestacao)), __LINE__);
        }
        $this->NumPrestacao = $numPrestacao;
        return $this;
    }
    /**
     * Get OrdemLiquidacao value
     * @return int|null
     */
    public function getOrdemLiquidacao()
    {
        return $this->OrdemLiquidacao;
    }
    /**
     * Set OrdemLiquidacao value
     * @param int $ordemLiquidacao
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setOrdemLiquidacao($ordemLiquidacao = null)
    {
        // validation for constraint: int
        if (!is_null($ordemLiquidacao) && !is_numeric($ordemLiquidacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ordemLiquidacao)), __LINE__);
        }
        $this->OrdemLiquidacao = $ordemLiquidacao;
        return $this;
    }
    /**
     * Get ReferenciaMB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenciaMB()
    {
        return isset($this->ReferenciaMB) ? $this->ReferenciaMB : null;
    }
    /**
     * Set ReferenciaMB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenciaMB
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setReferenciaMB($referenciaMB = null)
    {
        // validation for constraint: string
        if (!is_null($referenciaMB) && !is_string($referenciaMB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenciaMB)), __LINE__);
        }
        if (is_null($referenciaMB) || (is_array($referenciaMB) && empty($referenciaMB))) {
            unset($this->ReferenciaMB);
        } else {
            $this->ReferenciaMB = $referenciaMB;
        }
        return $this;
    }
    /**
     * Get ReferenciaMBEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getReferenciaMBEntidade()
    {
        return isset($this->ReferenciaMBEntidade) ? $this->ReferenciaMBEntidade : null;
    }
    /**
     * Set ReferenciaMBEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $referenciaMBEntidade
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setReferenciaMBEntidade($referenciaMBEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($referenciaMBEntidade) && !is_string($referenciaMBEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($referenciaMBEntidade)), __LINE__);
        }
        if (is_null($referenciaMBEntidade) || (is_array($referenciaMBEntidade) && empty($referenciaMBEntidade))) {
            unset($this->ReferenciaMBEntidade);
        } else {
            $this->ReferenciaMBEntidade = $referenciaMBEntidade;
        }
        return $this;
    }
    /**
     * Get RespCobranca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCobranca()
    {
        return isset($this->RespCobranca) ? $this->RespCobranca : null;
    }
    /**
     * Set RespCobranca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCobranca
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setRespCobranca($respCobranca = null)
    {
        // validation for constraint: string
        if (!is_null($respCobranca) && !is_string($respCobranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCobranca)), __LINE__);
        }
        if (is_null($respCobranca) || (is_array($respCobranca) && empty($respCobranca))) {
            unset($this->RespCobranca);
        } else {
            $this->RespCobranca = $respCobranca;
        }
        return $this;
    }
    /**
     * Get Serie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerie()
    {
        return isset($this->Serie) ? $this->Serie : null;
    }
    /**
     * Set Serie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serie
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serie)), __LINE__);
        }
        if (is_null($serie) || (is_array($serie) && empty($serie))) {
            unset($this->Serie);
        } else {
            $this->Serie = $serie;
        }
        return $this;
    }
    /**
     * Get TipoConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoConta()
    {
        return isset($this->TipoConta) ? $this->TipoConta : null;
    }
    /**
     * Set TipoConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoConta
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setTipoConta($tipoConta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoConta) && !is_string($tipoConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoConta)), __LINE__);
        }
        if (is_null($tipoConta) || (is_array($tipoConta) && empty($tipoConta))) {
            unset($this->TipoConta);
        } else {
            $this->TipoConta = $tipoConta;
        }
        return $this;
    }
    /**
     * Get TipoDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDoc()
    {
        return isset($this->TipoDoc) ? $this->TipoDoc : null;
    }
    /**
     * Set TipoDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDoc
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setTipoDoc($tipoDoc = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDoc) && !is_string($tipoDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDoc)), __LINE__);
        }
        if (is_null($tipoDoc) || (is_array($tipoDoc) && empty($tipoDoc))) {
            unset($this->TipoDoc);
        } else {
            $this->TipoDoc = $tipoDoc;
        }
        return $this;
    }
    /**
     * Get TipoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidade()
    {
        return isset($this->TipoEntidade) ? $this->TipoEntidade : null;
    }
    /**
     * Set TipoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidade
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setTipoEntidade($tipoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidade) && !is_string($tipoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidade)), __LINE__);
        }
        if (is_null($tipoEntidade) || (is_array($tipoEntidade) && empty($tipoEntidade))) {
            unset($this->TipoEntidade);
        } else {
            $this->TipoEntidade = $tipoEntidade;
        }
        return $this;
    }
    /**
     * Get ValorPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPendente()
    {
        return isset($this->ValorPendente) ? $this->ValorPendente : null;
    }
    /**
     * Set ValorPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPendente
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setValorPendente($valorPendente = null)
    {
        if (is_null($valorPendente) || (is_array($valorPendente) && empty($valorPendente))) {
            unset($this->ValorPendente);
        } else {
            $this->ValorPendente = $valorPendente;
        }
        return $this;
    }
    /**
     * Get ValorPendenteCredito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPendenteCredito()
    {
        return isset($this->ValorPendenteCredito) ? $this->ValorPendenteCredito : null;
    }
    /**
     * Set ValorPendenteCredito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPendenteCredito
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setValorPendenteCredito($valorPendenteCredito = null)
    {
        if (is_null($valorPendenteCredito) || (is_array($valorPendenteCredito) && empty($valorPendenteCredito))) {
            unset($this->ValorPendenteCredito);
        } else {
            $this->ValorPendenteCredito = $valorPendenteCredito;
        }
        return $this;
    }
    /**
     * Get ValorPendenteDebito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPendenteDebito()
    {
        return isset($this->ValorPendenteDebito) ? $this->ValorPendenteDebito : null;
    }
    /**
     * Set ValorPendenteDebito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPendenteDebito
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setValorPendenteDebito($valorPendenteDebito = null)
    {
        if (is_null($valorPendenteDebito) || (is_array($valorPendenteDebito) && empty($valorPendenteDebito))) {
            unset($this->ValorPendenteDebito);
        } else {
            $this->ValorPendenteDebito = $valorPendenteDebito;
        }
        return $this;
    }
    /**
     * Get ValorTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorTotal()
    {
        return isset($this->ValorTotal) ? $this->ValorTotal : null;
    }
    /**
     * Set ValorTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorTotal
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setValorTotal($valorTotal = null)
    {
        if (is_null($valorTotal) || (is_array($valorTotal) && empty($valorTotal))) {
            unset($this->ValorTotal);
        } else {
            $this->ValorTotal = $valorTotal;
        }
        return $this;
    }
    /**
     * Get ValorTotalCredito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorTotalCredito()
    {
        return isset($this->ValorTotalCredito) ? $this->ValorTotalCredito : null;
    }
    /**
     * Set ValorTotalCredito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorTotalCredito
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setValorTotalCredito($valorTotalCredito = null)
    {
        if (is_null($valorTotalCredito) || (is_array($valorTotalCredito) && empty($valorTotalCredito))) {
            unset($this->ValorTotalCredito);
        } else {
            $this->ValorTotalCredito = $valorTotalCredito;
        }
        return $this;
    }
    /**
     * Get ValorTotalDebito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorTotalDebito()
    {
        return isset($this->ValorTotalDebito) ? $this->ValorTotalDebito : null;
    }
    /**
     * Set ValorTotalDebito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorTotalDebito
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setValorTotalDebito($valorTotalDebito = null)
    {
        if (is_null($valorTotalDebito) || (is_array($valorTotalDebito) && empty($valorTotalDebito))) {
            unset($this->ValorTotalDebito);
        } else {
            $this->ValorTotalDebito = $valorTotalDebito;
        }
        return $this;
    }
    /**
     * Get id value
     * @return string|null
     */
    public function getId()
    {
        return $this->id;
    }
    /**
     * Set id value
     * @param string $id
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->id = $id;
        return $this;
    }
    /**
     * Get idDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdDoc()
    {
        return isset($this->idDoc) ? $this->idDoc : null;
    }
    /**
     * Set idDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idDoc
     * @return \StructType\V_SDD_PendentesERP
     */
    public function setIdDoc($idDoc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idDoc) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idDoc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idDoc) && !is_string($idDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idDoc)), __LINE__);
        }
        if (is_null($idDoc) || (is_array($idDoc) && empty($idDoc))) {
            unset($this->idDoc);
        } else {
            $this->idDoc = $idDoc;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\V_SDD_PendentesERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
