<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for PendentesERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:PendentesERP
 * @subpackage Structs
 */
class PendentesERP extends AbstractStructBase
{
    /**
     * The Avalista
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Avalista;
    /**
     * The Cambio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Cambio;
    /**
     * The CambioADataDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CambioADataDoc;
    /**
     * The CambioMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CambioMAlt;
    /**
     * The CambioMBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CambioMBase;
    /**
     * The CambioMoedaConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMoedaConta;
    /**
     * The CodIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIva;
    /**
     * The Comissao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Comissao;
    /**
     * The CondPag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CondPag;
    /**
     * The Conta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Conta;
    /**
     * The ContaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCBL;
    /**
     * The ContaDomiciliacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaDomiciliacao;
    /**
     * The ContraValor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ContraValor;
    /**
     * The DataDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDoc;
    /**
     * The DataIntroducao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $DataIntroducao;
    /**
     * The DataPrevTes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataPrevTes;
    /**
     * The DataVenc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataVenc;
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The EntidadeComercial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntidadeComercial;
    /**
     * The EntidadeRemessa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EntidadeRemessa;
    /**
     * The EspacoFiscal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EspacoFiscal;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The Filial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Filial;
    /**
     * The IdCabecMovCbl
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCabecMovCbl;
    /**
     * The IdCessao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCessao;
    /**
     * The IdGDOC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdGDOC;
    /**
     * The IdHistorico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdHistorico;
    /**
     * The IdMovCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdMovCBL;
    /**
     * The ImpostoSelo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ImpostoSelo;
    /**
     * The ImpostoSeloLivrancas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ImpostoSeloLivrancas;
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The ModoPag
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModoPag;
    /**
     * The Modulo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Modulo;
    /**
     * The Moeda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Moeda;
    /**
     * The MoedaConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MoedaConta;
    /**
     * The MoedaDaUEM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MoedaDaUEM;
    /**
     * The NIB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NIB;
    /**
     * The NumAceite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumAceite;
    /**
     * The NumAvisos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumAvisos;
    /**
     * The NumContribAvalista
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumContribAvalista;
    /**
     * The NumDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumDoc;
    /**
     * The NumDocInt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumDocInt;
    /**
     * The NumPrestacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumPrestacao;
    /**
     * The NumRemessa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumRemessa;
    /**
     * The NumTransferencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumTransferencia;
    /**
     * The ObraID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObraID;
    /**
     * The Origem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $Origem;
    /**
     * The Percentagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Percentagem;
    /**
     * The Plafond
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Plafond;
    /**
     * The Portes
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Portes;
    /**
     * The Postecipado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Postecipado;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The RegimeIvaReembolsos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $RegimeIvaReembolsos;
    /**
     * The RespCobranca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RespCobranca;
    /**
     * The Serie
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Serie;
    /**
     * The TaxaJuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaJuro;
    /**
     * The TipoConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoConta;
    /**
     * The TipoDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDoc;
    /**
     * The TipoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidade;
    /**
     * The TipoEntidadeComercial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidadeComercial;
    /**
     * The TipoLancamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoLancamento;
    /**
     * The TipoOperacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoOperacao;
    /**
     * The TipoPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoPendente;
    /**
     * The TotalIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIva;
    /**
     * The TotalRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalRecargo;
    /**
     * The ValorPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorPendente;
    /**
     * The ValorRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorRetencao;
    /**
     * The ValorRetencaoGarantia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoGarantia;
    /**
     * The ValorRetencaoGarantiaPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoGarantiaPendente;
    /**
     * The ValorRetencaoPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRetencaoPendente;
    /**
     * The ValorTotal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorTotal;
    /**
     * The Vendedor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Vendedor;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * The WBSItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBSItem;
    /**
     * Constructor method for PendentesERP
     * @uses PendentesERP::setAvalista()
     * @uses PendentesERP::setCambio()
     * @uses PendentesERP::setCambioADataDoc()
     * @uses PendentesERP::setCambioMAlt()
     * @uses PendentesERP::setCambioMBase()
     * @uses PendentesERP::setCambioMoedaConta()
     * @uses PendentesERP::setCodIva()
     * @uses PendentesERP::setComissao()
     * @uses PendentesERP::setCondPag()
     * @uses PendentesERP::setConta()
     * @uses PendentesERP::setContaCBL()
     * @uses PendentesERP::setContaDomiciliacao()
     * @uses PendentesERP::setContraValor()
     * @uses PendentesERP::setDataDoc()
     * @uses PendentesERP::setDataIntroducao()
     * @uses PendentesERP::setDataPrevTes()
     * @uses PendentesERP::setDataVenc()
     * @uses PendentesERP::setEntidade()
     * @uses PendentesERP::setEntidadeComercial()
     * @uses PendentesERP::setEntidadeRemessa()
     * @uses PendentesERP::setEspacoFiscal()
     * @uses PendentesERP::setEstado()
     * @uses PendentesERP::setFilial()
     * @uses PendentesERP::setIdCabecMovCbl()
     * @uses PendentesERP::setIdCessao()
     * @uses PendentesERP::setIdGDOC()
     * @uses PendentesERP::setIdHistorico()
     * @uses PendentesERP::setIdMovCBL()
     * @uses PendentesERP::setImpostoSelo()
     * @uses PendentesERP::setImpostoSeloLivrancas()
     * @uses PendentesERP::setItemId()
     * @uses PendentesERP::setModoPag()
     * @uses PendentesERP::setModulo()
     * @uses PendentesERP::setMoeda()
     * @uses PendentesERP::setMoedaConta()
     * @uses PendentesERP::setMoedaDaUEM()
     * @uses PendentesERP::setNIB()
     * @uses PendentesERP::setNumAceite()
     * @uses PendentesERP::setNumAvisos()
     * @uses PendentesERP::setNumContribAvalista()
     * @uses PendentesERP::setNumDoc()
     * @uses PendentesERP::setNumDocInt()
     * @uses PendentesERP::setNumPrestacao()
     * @uses PendentesERP::setNumRemessa()
     * @uses PendentesERP::setNumTransferencia()
     * @uses PendentesERP::setObraID()
     * @uses PendentesERP::setOrigem()
     * @uses PendentesERP::setPercentagem()
     * @uses PendentesERP::setPlafond()
     * @uses PendentesERP::setPortes()
     * @uses PendentesERP::setPostecipado()
     * @uses PendentesERP::setProtegida()
     * @uses PendentesERP::setRegimeIvaReembolsos()
     * @uses PendentesERP::setRespCobranca()
     * @uses PendentesERP::setSerie()
     * @uses PendentesERP::setTaxaJuro()
     * @uses PendentesERP::setTipoConta()
     * @uses PendentesERP::setTipoDoc()
     * @uses PendentesERP::setTipoEntidade()
     * @uses PendentesERP::setTipoEntidadeComercial()
     * @uses PendentesERP::setTipoLancamento()
     * @uses PendentesERP::setTipoOperacao()
     * @uses PendentesERP::setTipoPendente()
     * @uses PendentesERP::setTotalIva()
     * @uses PendentesERP::setTotalRecargo()
     * @uses PendentesERP::setValorPendente()
     * @uses PendentesERP::setValorRetencao()
     * @uses PendentesERP::setValorRetencaoGarantia()
     * @uses PendentesERP::setValorRetencaoGarantiaPendente()
     * @uses PendentesERP::setValorRetencaoPendente()
     * @uses PendentesERP::setValorTotal()
     * @uses PendentesERP::setVendedor()
     * @uses PendentesERP::setVersaoUltAct()
     * @uses PendentesERP::setWBSItem()
     * @param string $avalista
     * @param float $cambio
     * @param bool $cambioADataDoc
     * @param float $cambioMAlt
     * @param float $cambioMBase
     * @param float $cambioMoedaConta
     * @param string $codIva
     * @param float $comissao
     * @param string $condPag
     * @param string $conta
     * @param string $contaCBL
     * @param string $contaDomiciliacao
     * @param float $contraValor
     * @param string $dataDoc
     * @param string $dataIntroducao
     * @param string $dataPrevTes
     * @param string $dataVenc
     * @param string $entidade
     * @param string $entidadeComercial
     * @param string $entidadeRemessa
     * @param int $espacoFiscal
     * @param string $estado
     * @param string $filial
     * @param string $idCabecMovCbl
     * @param string $idCessao
     * @param string $idGDOC
     * @param string $idHistorico
     * @param string $idMovCBL
     * @param float $impostoSelo
     * @param float $impostoSeloLivrancas
     * @param int $itemId
     * @param string $modoPag
     * @param string $modulo
     * @param string $moeda
     * @param string $moedaConta
     * @param bool $moedaDaUEM
     * @param string $nIB
     * @param string $numAceite
     * @param int $numAvisos
     * @param string $numContribAvalista
     * @param string $numDoc
     * @param int $numDocInt
     * @param int $numPrestacao
     * @param int $numRemessa
     * @param int $numTransferencia
     * @param string $obraID
     * @param int $origem
     * @param bool $percentagem
     * @param float $plafond
     * @param float $portes
     * @param bool $postecipado
     * @param bool $protegida
     * @param int $regimeIvaReembolsos
     * @param string $respCobranca
     * @param string $serie
     * @param float $taxaJuro
     * @param string $tipoConta
     * @param string $tipoDoc
     * @param string $tipoEntidade
     * @param string $tipoEntidadeComercial
     * @param string $tipoLancamento
     * @param string $tipoOperacao
     * @param string $tipoPendente
     * @param float $totalIva
     * @param float $totalRecargo
     * @param float $valorPendente
     * @param float $valorRetencao
     * @param float $valorRetencaoGarantia
     * @param float $valorRetencaoGarantiaPendente
     * @param float $valorRetencaoPendente
     * @param float $valorTotal
     * @param string $vendedor
     * @param string $versaoUltAct
     * @param string $wBSItem
     */
    public function __construct($avalista = null, $cambio = null, $cambioADataDoc = null, $cambioMAlt = null, $cambioMBase = null, $cambioMoedaConta = null, $codIva = null, $comissao = null, $condPag = null, $conta = null, $contaCBL = null, $contaDomiciliacao = null, $contraValor = null, $dataDoc = null, $dataIntroducao = null, $dataPrevTes = null, $dataVenc = null, $entidade = null, $entidadeComercial = null, $entidadeRemessa = null, $espacoFiscal = null, $estado = null, $filial = null, $idCabecMovCbl = null, $idCessao = null, $idGDOC = null, $idHistorico = null, $idMovCBL = null, $impostoSelo = null, $impostoSeloLivrancas = null, $itemId = null, $modoPag = null, $modulo = null, $moeda = null, $moedaConta = null, $moedaDaUEM = null, $nIB = null, $numAceite = null, $numAvisos = null, $numContribAvalista = null, $numDoc = null, $numDocInt = null, $numPrestacao = null, $numRemessa = null, $numTransferencia = null, $obraID = null, $origem = null, $percentagem = null, $plafond = null, $portes = null, $postecipado = null, $protegida = null, $regimeIvaReembolsos = null, $respCobranca = null, $serie = null, $taxaJuro = null, $tipoConta = null, $tipoDoc = null, $tipoEntidade = null, $tipoEntidadeComercial = null, $tipoLancamento = null, $tipoOperacao = null, $tipoPendente = null, $totalIva = null, $totalRecargo = null, $valorPendente = null, $valorRetencao = null, $valorRetencaoGarantia = null, $valorRetencaoGarantiaPendente = null, $valorRetencaoPendente = null, $valorTotal = null, $vendedor = null, $versaoUltAct = null, $wBSItem = null)
    {
        $this
            ->setAvalista($avalista)
            ->setCambio($cambio)
            ->setCambioADataDoc($cambioADataDoc)
            ->setCambioMAlt($cambioMAlt)
            ->setCambioMBase($cambioMBase)
            ->setCambioMoedaConta($cambioMoedaConta)
            ->setCodIva($codIva)
            ->setComissao($comissao)
            ->setCondPag($condPag)
            ->setConta($conta)
            ->setContaCBL($contaCBL)
            ->setContaDomiciliacao($contaDomiciliacao)
            ->setContraValor($contraValor)
            ->setDataDoc($dataDoc)
            ->setDataIntroducao($dataIntroducao)
            ->setDataPrevTes($dataPrevTes)
            ->setDataVenc($dataVenc)
            ->setEntidade($entidade)
            ->setEntidadeComercial($entidadeComercial)
            ->setEntidadeRemessa($entidadeRemessa)
            ->setEspacoFiscal($espacoFiscal)
            ->setEstado($estado)
            ->setFilial($filial)
            ->setIdCabecMovCbl($idCabecMovCbl)
            ->setIdCessao($idCessao)
            ->setIdGDOC($idGDOC)
            ->setIdHistorico($idHistorico)
            ->setIdMovCBL($idMovCBL)
            ->setImpostoSelo($impostoSelo)
            ->setImpostoSeloLivrancas($impostoSeloLivrancas)
            ->setItemId($itemId)
            ->setModoPag($modoPag)
            ->setModulo($modulo)
            ->setMoeda($moeda)
            ->setMoedaConta($moedaConta)
            ->setMoedaDaUEM($moedaDaUEM)
            ->setNIB($nIB)
            ->setNumAceite($numAceite)
            ->setNumAvisos($numAvisos)
            ->setNumContribAvalista($numContribAvalista)
            ->setNumDoc($numDoc)
            ->setNumDocInt($numDocInt)
            ->setNumPrestacao($numPrestacao)
            ->setNumRemessa($numRemessa)
            ->setNumTransferencia($numTransferencia)
            ->setObraID($obraID)
            ->setOrigem($origem)
            ->setPercentagem($percentagem)
            ->setPlafond($plafond)
            ->setPortes($portes)
            ->setPostecipado($postecipado)
            ->setProtegida($protegida)
            ->setRegimeIvaReembolsos($regimeIvaReembolsos)
            ->setRespCobranca($respCobranca)
            ->setSerie($serie)
            ->setTaxaJuro($taxaJuro)
            ->setTipoConta($tipoConta)
            ->setTipoDoc($tipoDoc)
            ->setTipoEntidade($tipoEntidade)
            ->setTipoEntidadeComercial($tipoEntidadeComercial)
            ->setTipoLancamento($tipoLancamento)
            ->setTipoOperacao($tipoOperacao)
            ->setTipoPendente($tipoPendente)
            ->setTotalIva($totalIva)
            ->setTotalRecargo($totalRecargo)
            ->setValorPendente($valorPendente)
            ->setValorRetencao($valorRetencao)
            ->setValorRetencaoGarantia($valorRetencaoGarantia)
            ->setValorRetencaoGarantiaPendente($valorRetencaoGarantiaPendente)
            ->setValorRetencaoPendente($valorRetencaoPendente)
            ->setValorTotal($valorTotal)
            ->setVendedor($vendedor)
            ->setVersaoUltAct($versaoUltAct)
            ->setWBSItem($wBSItem);
    }
    /**
     * Get Avalista value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAvalista()
    {
        return isset($this->Avalista) ? $this->Avalista : null;
    }
    /**
     * Set Avalista value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $avalista
     * @return \StructType\PendentesERP
     */
    public function setAvalista($avalista = null)
    {
        // validation for constraint: string
        if (!is_null($avalista) && !is_string($avalista)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($avalista)), __LINE__);
        }
        if (is_null($avalista) || (is_array($avalista) && empty($avalista))) {
            unset($this->Avalista);
        } else {
            $this->Avalista = $avalista;
        }
        return $this;
    }
    /**
     * Get Cambio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambio()
    {
        return isset($this->Cambio) ? $this->Cambio : null;
    }
    /**
     * Set Cambio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambio
     * @return \StructType\PendentesERP
     */
    public function setCambio($cambio = null)
    {
        if (is_null($cambio) || (is_array($cambio) && empty($cambio))) {
            unset($this->Cambio);
        } else {
            $this->Cambio = $cambio;
        }
        return $this;
    }
    /**
     * Get CambioADataDoc value
     * @return bool|null
     */
    public function getCambioADataDoc()
    {
        return $this->CambioADataDoc;
    }
    /**
     * Set CambioADataDoc value
     * @param bool $cambioADataDoc
     * @return \StructType\PendentesERP
     */
    public function setCambioADataDoc($cambioADataDoc = null)
    {
        // validation for constraint: boolean
        if (!is_null($cambioADataDoc) && !is_bool($cambioADataDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($cambioADataDoc)), __LINE__);
        }
        $this->CambioADataDoc = $cambioADataDoc;
        return $this;
    }
    /**
     * Get CambioMAlt value
     * @return float|null
     */
    public function getCambioMAlt()
    {
        return $this->CambioMAlt;
    }
    /**
     * Set CambioMAlt value
     * @param float $cambioMAlt
     * @return \StructType\PendentesERP
     */
    public function setCambioMAlt($cambioMAlt = null)
    {
        $this->CambioMAlt = $cambioMAlt;
        return $this;
    }
    /**
     * Get CambioMBase value
     * @return float|null
     */
    public function getCambioMBase()
    {
        return $this->CambioMBase;
    }
    /**
     * Set CambioMBase value
     * @param float $cambioMBase
     * @return \StructType\PendentesERP
     */
    public function setCambioMBase($cambioMBase = null)
    {
        $this->CambioMBase = $cambioMBase;
        return $this;
    }
    /**
     * Get CambioMoedaConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMoedaConta()
    {
        return isset($this->CambioMoedaConta) ? $this->CambioMoedaConta : null;
    }
    /**
     * Set CambioMoedaConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMoedaConta
     * @return \StructType\PendentesERP
     */
    public function setCambioMoedaConta($cambioMoedaConta = null)
    {
        if (is_null($cambioMoedaConta) || (is_array($cambioMoedaConta) && empty($cambioMoedaConta))) {
            unset($this->CambioMoedaConta);
        } else {
            $this->CambioMoedaConta = $cambioMoedaConta;
        }
        return $this;
    }
    /**
     * Get CodIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIva()
    {
        return isset($this->CodIva) ? $this->CodIva : null;
    }
    /**
     * Set CodIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIva
     * @return \StructType\PendentesERP
     */
    public function setCodIva($codIva = null)
    {
        // validation for constraint: string
        if (!is_null($codIva) && !is_string($codIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIva)), __LINE__);
        }
        if (is_null($codIva) || (is_array($codIva) && empty($codIva))) {
            unset($this->CodIva);
        } else {
            $this->CodIva = $codIva;
        }
        return $this;
    }
    /**
     * Get Comissao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getComissao()
    {
        return isset($this->Comissao) ? $this->Comissao : null;
    }
    /**
     * Set Comissao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $comissao
     * @return \StructType\PendentesERP
     */
    public function setComissao($comissao = null)
    {
        if (is_null($comissao) || (is_array($comissao) && empty($comissao))) {
            unset($this->Comissao);
        } else {
            $this->Comissao = $comissao;
        }
        return $this;
    }
    /**
     * Get CondPag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCondPag()
    {
        return isset($this->CondPag) ? $this->CondPag : null;
    }
    /**
     * Set CondPag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $condPag
     * @return \StructType\PendentesERP
     */
    public function setCondPag($condPag = null)
    {
        // validation for constraint: string
        if (!is_null($condPag) && !is_string($condPag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($condPag)), __LINE__);
        }
        if (is_null($condPag) || (is_array($condPag) && empty($condPag))) {
            unset($this->CondPag);
        } else {
            $this->CondPag = $condPag;
        }
        return $this;
    }
    /**
     * Get Conta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConta()
    {
        return isset($this->Conta) ? $this->Conta : null;
    }
    /**
     * Set Conta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conta
     * @return \StructType\PendentesERP
     */
    public function setConta($conta = null)
    {
        // validation for constraint: string
        if (!is_null($conta) && !is_string($conta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conta)), __LINE__);
        }
        if (is_null($conta) || (is_array($conta) && empty($conta))) {
            unset($this->Conta);
        } else {
            $this->Conta = $conta;
        }
        return $this;
    }
    /**
     * Get ContaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCBL()
    {
        return isset($this->ContaCBL) ? $this->ContaCBL : null;
    }
    /**
     * Set ContaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCBL
     * @return \StructType\PendentesERP
     */
    public function setContaCBL($contaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($contaCBL) && !is_string($contaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaCBL)), __LINE__);
        }
        if (is_null($contaCBL) || (is_array($contaCBL) && empty($contaCBL))) {
            unset($this->ContaCBL);
        } else {
            $this->ContaCBL = $contaCBL;
        }
        return $this;
    }
    /**
     * Get ContaDomiciliacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaDomiciliacao()
    {
        return isset($this->ContaDomiciliacao) ? $this->ContaDomiciliacao : null;
    }
    /**
     * Set ContaDomiciliacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaDomiciliacao
     * @return \StructType\PendentesERP
     */
    public function setContaDomiciliacao($contaDomiciliacao = null)
    {
        // validation for constraint: string
        if (!is_null($contaDomiciliacao) && !is_string($contaDomiciliacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaDomiciliacao)), __LINE__);
        }
        if (is_null($contaDomiciliacao) || (is_array($contaDomiciliacao) && empty($contaDomiciliacao))) {
            unset($this->ContaDomiciliacao);
        } else {
            $this->ContaDomiciliacao = $contaDomiciliacao;
        }
        return $this;
    }
    /**
     * Get ContraValor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getContraValor()
    {
        return isset($this->ContraValor) ? $this->ContraValor : null;
    }
    /**
     * Set ContraValor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $contraValor
     * @return \StructType\PendentesERP
     */
    public function setContraValor($contraValor = null)
    {
        if (is_null($contraValor) || (is_array($contraValor) && empty($contraValor))) {
            unset($this->ContraValor);
        } else {
            $this->ContraValor = $contraValor;
        }
        return $this;
    }
    /**
     * Get DataDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDoc()
    {
        return isset($this->DataDoc) ? $this->DataDoc : null;
    }
    /**
     * Set DataDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDoc
     * @return \StructType\PendentesERP
     */
    public function setDataDoc($dataDoc = null)
    {
        // validation for constraint: string
        if (!is_null($dataDoc) && !is_string($dataDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDoc)), __LINE__);
        }
        if (is_null($dataDoc) || (is_array($dataDoc) && empty($dataDoc))) {
            unset($this->DataDoc);
        } else {
            $this->DataDoc = $dataDoc;
        }
        return $this;
    }
    /**
     * Get DataIntroducao value
     * @return string|null
     */
    public function getDataIntroducao()
    {
        return $this->DataIntroducao;
    }
    /**
     * Set DataIntroducao value
     * @param string $dataIntroducao
     * @return \StructType\PendentesERP
     */
    public function setDataIntroducao($dataIntroducao = null)
    {
        // validation for constraint: string
        if (!is_null($dataIntroducao) && !is_string($dataIntroducao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataIntroducao)), __LINE__);
        }
        $this->DataIntroducao = $dataIntroducao;
        return $this;
    }
    /**
     * Get DataPrevTes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataPrevTes()
    {
        return isset($this->DataPrevTes) ? $this->DataPrevTes : null;
    }
    /**
     * Set DataPrevTes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataPrevTes
     * @return \StructType\PendentesERP
     */
    public function setDataPrevTes($dataPrevTes = null)
    {
        // validation for constraint: string
        if (!is_null($dataPrevTes) && !is_string($dataPrevTes)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataPrevTes)), __LINE__);
        }
        if (is_null($dataPrevTes) || (is_array($dataPrevTes) && empty($dataPrevTes))) {
            unset($this->DataPrevTes);
        } else {
            $this->DataPrevTes = $dataPrevTes;
        }
        return $this;
    }
    /**
     * Get DataVenc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataVenc()
    {
        return isset($this->DataVenc) ? $this->DataVenc : null;
    }
    /**
     * Set DataVenc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataVenc
     * @return \StructType\PendentesERP
     */
    public function setDataVenc($dataVenc = null)
    {
        // validation for constraint: string
        if (!is_null($dataVenc) && !is_string($dataVenc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataVenc)), __LINE__);
        }
        if (is_null($dataVenc) || (is_array($dataVenc) && empty($dataVenc))) {
            unset($this->DataVenc);
        } else {
            $this->DataVenc = $dataVenc;
        }
        return $this;
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\PendentesERP
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get EntidadeComercial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidadeComercial()
    {
        return isset($this->EntidadeComercial) ? $this->EntidadeComercial : null;
    }
    /**
     * Set EntidadeComercial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidadeComercial
     * @return \StructType\PendentesERP
     */
    public function setEntidadeComercial($entidadeComercial = null)
    {
        // validation for constraint: string
        if (!is_null($entidadeComercial) && !is_string($entidadeComercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidadeComercial)), __LINE__);
        }
        if (is_null($entidadeComercial) || (is_array($entidadeComercial) && empty($entidadeComercial))) {
            unset($this->EntidadeComercial);
        } else {
            $this->EntidadeComercial = $entidadeComercial;
        }
        return $this;
    }
    /**
     * Get EntidadeRemessa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidadeRemessa()
    {
        return isset($this->EntidadeRemessa) ? $this->EntidadeRemessa : null;
    }
    /**
     * Set EntidadeRemessa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidadeRemessa
     * @return \StructType\PendentesERP
     */
    public function setEntidadeRemessa($entidadeRemessa = null)
    {
        // validation for constraint: string
        if (!is_null($entidadeRemessa) && !is_string($entidadeRemessa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidadeRemessa)), __LINE__);
        }
        if (is_null($entidadeRemessa) || (is_array($entidadeRemessa) && empty($entidadeRemessa))) {
            unset($this->EntidadeRemessa);
        } else {
            $this->EntidadeRemessa = $entidadeRemessa;
        }
        return $this;
    }
    /**
     * Get EspacoFiscal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEspacoFiscal()
    {
        return isset($this->EspacoFiscal) ? $this->EspacoFiscal : null;
    }
    /**
     * Set EspacoFiscal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $espacoFiscal
     * @return \StructType\PendentesERP
     */
    public function setEspacoFiscal($espacoFiscal = null)
    {
        // validation for constraint: int
        if (!is_null($espacoFiscal) && !is_numeric($espacoFiscal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($espacoFiscal)), __LINE__);
        }
        if (is_null($espacoFiscal) || (is_array($espacoFiscal) && empty($espacoFiscal))) {
            unset($this->EspacoFiscal);
        } else {
            $this->EspacoFiscal = $espacoFiscal;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \StructType\PendentesERP
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get Filial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFilial()
    {
        return isset($this->Filial) ? $this->Filial : null;
    }
    /**
     * Set Filial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $filial
     * @return \StructType\PendentesERP
     */
    public function setFilial($filial = null)
    {
        // validation for constraint: string
        if (!is_null($filial) && !is_string($filial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($filial)), __LINE__);
        }
        if (is_null($filial) || (is_array($filial) && empty($filial))) {
            unset($this->Filial);
        } else {
            $this->Filial = $filial;
        }
        return $this;
    }
    /**
     * Get IdCabecMovCbl value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCabecMovCbl()
    {
        return isset($this->IdCabecMovCbl) ? $this->IdCabecMovCbl : null;
    }
    /**
     * Set IdCabecMovCbl value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCabecMovCbl
     * @return \StructType\PendentesERP
     */
    public function setIdCabecMovCbl($idCabecMovCbl = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCabecMovCbl) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCabecMovCbl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCabecMovCbl, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCabecMovCbl) && !is_string($idCabecMovCbl)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCabecMovCbl)), __LINE__);
        }
        if (is_null($idCabecMovCbl) || (is_array($idCabecMovCbl) && empty($idCabecMovCbl))) {
            unset($this->IdCabecMovCbl);
        } else {
            $this->IdCabecMovCbl = $idCabecMovCbl;
        }
        return $this;
    }
    /**
     * Get IdCessao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdCessao()
    {
        return isset($this->IdCessao) ? $this->IdCessao : null;
    }
    /**
     * Set IdCessao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idCessao
     * @return \StructType\PendentesERP
     */
    public function setIdCessao($idCessao = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCessao) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCessao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCessao, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCessao) && !is_string($idCessao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCessao)), __LINE__);
        }
        if (is_null($idCessao) || (is_array($idCessao) && empty($idCessao))) {
            unset($this->IdCessao);
        } else {
            $this->IdCessao = $idCessao;
        }
        return $this;
    }
    /**
     * Get IdGDOC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdGDOC()
    {
        return isset($this->IdGDOC) ? $this->IdGDOC : null;
    }
    /**
     * Set IdGDOC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idGDOC
     * @return \StructType\PendentesERP
     */
    public function setIdGDOC($idGDOC = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idGDOC) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idGDOC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idGDOC, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idGDOC) && !is_string($idGDOC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idGDOC)), __LINE__);
        }
        if (is_null($idGDOC) || (is_array($idGDOC) && empty($idGDOC))) {
            unset($this->IdGDOC);
        } else {
            $this->IdGDOC = $idGDOC;
        }
        return $this;
    }
    /**
     * Get IdHistorico value
     * @return string|null
     */
    public function getIdHistorico()
    {
        return $this->IdHistorico;
    }
    /**
     * Set IdHistorico value
     * @param string $idHistorico
     * @return \StructType\PendentesERP
     */
    public function setIdHistorico($idHistorico = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idHistorico) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idHistorico, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idHistorico) && !is_string($idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idHistorico)), __LINE__);
        }
        $this->IdHistorico = $idHistorico;
        return $this;
    }
    /**
     * Get IdMovCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdMovCBL()
    {
        return isset($this->IdMovCBL) ? $this->IdMovCBL : null;
    }
    /**
     * Set IdMovCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idMovCBL
     * @return \StructType\PendentesERP
     */
    public function setIdMovCBL($idMovCBL = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idMovCBL) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idMovCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idMovCBL, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idMovCBL) && !is_string($idMovCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idMovCBL)), __LINE__);
        }
        if (is_null($idMovCBL) || (is_array($idMovCBL) && empty($idMovCBL))) {
            unset($this->IdMovCBL);
        } else {
            $this->IdMovCBL = $idMovCBL;
        }
        return $this;
    }
    /**
     * Get ImpostoSelo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getImpostoSelo()
    {
        return isset($this->ImpostoSelo) ? $this->ImpostoSelo : null;
    }
    /**
     * Set ImpostoSelo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $impostoSelo
     * @return \StructType\PendentesERP
     */
    public function setImpostoSelo($impostoSelo = null)
    {
        if (is_null($impostoSelo) || (is_array($impostoSelo) && empty($impostoSelo))) {
            unset($this->ImpostoSelo);
        } else {
            $this->ImpostoSelo = $impostoSelo;
        }
        return $this;
    }
    /**
     * Get ImpostoSeloLivrancas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getImpostoSeloLivrancas()
    {
        return isset($this->ImpostoSeloLivrancas) ? $this->ImpostoSeloLivrancas : null;
    }
    /**
     * Set ImpostoSeloLivrancas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $impostoSeloLivrancas
     * @return \StructType\PendentesERP
     */
    public function setImpostoSeloLivrancas($impostoSeloLivrancas = null)
    {
        if (is_null($impostoSeloLivrancas) || (is_array($impostoSeloLivrancas) && empty($impostoSeloLivrancas))) {
            unset($this->ImpostoSeloLivrancas);
        } else {
            $this->ImpostoSeloLivrancas = $impostoSeloLivrancas;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \StructType\PendentesERP
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get ModoPag value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModoPag()
    {
        return isset($this->ModoPag) ? $this->ModoPag : null;
    }
    /**
     * Set ModoPag value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modoPag
     * @return \StructType\PendentesERP
     */
    public function setModoPag($modoPag = null)
    {
        // validation for constraint: string
        if (!is_null($modoPag) && !is_string($modoPag)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modoPag)), __LINE__);
        }
        if (is_null($modoPag) || (is_array($modoPag) && empty($modoPag))) {
            unset($this->ModoPag);
        } else {
            $this->ModoPag = $modoPag;
        }
        return $this;
    }
    /**
     * Get Modulo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModulo()
    {
        return isset($this->Modulo) ? $this->Modulo : null;
    }
    /**
     * Set Modulo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modulo
     * @return \StructType\PendentesERP
     */
    public function setModulo($modulo = null)
    {
        // validation for constraint: string
        if (!is_null($modulo) && !is_string($modulo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modulo)), __LINE__);
        }
        if (is_null($modulo) || (is_array($modulo) && empty($modulo))) {
            unset($this->Modulo);
        } else {
            $this->Modulo = $modulo;
        }
        return $this;
    }
    /**
     * Get Moeda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoeda()
    {
        return isset($this->Moeda) ? $this->Moeda : null;
    }
    /**
     * Set Moeda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moeda
     * @return \StructType\PendentesERP
     */
    public function setMoeda($moeda = null)
    {
        // validation for constraint: string
        if (!is_null($moeda) && !is_string($moeda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moeda)), __LINE__);
        }
        if (is_null($moeda) || (is_array($moeda) && empty($moeda))) {
            unset($this->Moeda);
        } else {
            $this->Moeda = $moeda;
        }
        return $this;
    }
    /**
     * Get MoedaConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoedaConta()
    {
        return isset($this->MoedaConta) ? $this->MoedaConta : null;
    }
    /**
     * Set MoedaConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moedaConta
     * @return \StructType\PendentesERP
     */
    public function setMoedaConta($moedaConta = null)
    {
        // validation for constraint: string
        if (!is_null($moedaConta) && !is_string($moedaConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moedaConta)), __LINE__);
        }
        if (is_null($moedaConta) || (is_array($moedaConta) && empty($moedaConta))) {
            unset($this->MoedaConta);
        } else {
            $this->MoedaConta = $moedaConta;
        }
        return $this;
    }
    /**
     * Get MoedaDaUEM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMoedaDaUEM()
    {
        return isset($this->MoedaDaUEM) ? $this->MoedaDaUEM : null;
    }
    /**
     * Set MoedaDaUEM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $moedaDaUEM
     * @return \StructType\PendentesERP
     */
    public function setMoedaDaUEM($moedaDaUEM = null)
    {
        // validation for constraint: boolean
        if (!is_null($moedaDaUEM) && !is_bool($moedaDaUEM)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($moedaDaUEM)), __LINE__);
        }
        if (is_null($moedaDaUEM) || (is_array($moedaDaUEM) && empty($moedaDaUEM))) {
            unset($this->MoedaDaUEM);
        } else {
            $this->MoedaDaUEM = $moedaDaUEM;
        }
        return $this;
    }
    /**
     * Get NIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNIB()
    {
        return isset($this->NIB) ? $this->NIB : null;
    }
    /**
     * Set NIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nIB
     * @return \StructType\PendentesERP
     */
    public function setNIB($nIB = null)
    {
        // validation for constraint: string
        if (!is_null($nIB) && !is_string($nIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIB)), __LINE__);
        }
        if (is_null($nIB) || (is_array($nIB) && empty($nIB))) {
            unset($this->NIB);
        } else {
            $this->NIB = $nIB;
        }
        return $this;
    }
    /**
     * Get NumAceite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumAceite()
    {
        return isset($this->NumAceite) ? $this->NumAceite : null;
    }
    /**
     * Set NumAceite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numAceite
     * @return \StructType\PendentesERP
     */
    public function setNumAceite($numAceite = null)
    {
        // validation for constraint: string
        if (!is_null($numAceite) && !is_string($numAceite)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numAceite)), __LINE__);
        }
        if (is_null($numAceite) || (is_array($numAceite) && empty($numAceite))) {
            unset($this->NumAceite);
        } else {
            $this->NumAceite = $numAceite;
        }
        return $this;
    }
    /**
     * Get NumAvisos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumAvisos()
    {
        return isset($this->NumAvisos) ? $this->NumAvisos : null;
    }
    /**
     * Set NumAvisos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numAvisos
     * @return \StructType\PendentesERP
     */
    public function setNumAvisos($numAvisos = null)
    {
        // validation for constraint: int
        if (!is_null($numAvisos) && !is_numeric($numAvisos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numAvisos)), __LINE__);
        }
        if (is_null($numAvisos) || (is_array($numAvisos) && empty($numAvisos))) {
            unset($this->NumAvisos);
        } else {
            $this->NumAvisos = $numAvisos;
        }
        return $this;
    }
    /**
     * Get NumContribAvalista value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumContribAvalista()
    {
        return isset($this->NumContribAvalista) ? $this->NumContribAvalista : null;
    }
    /**
     * Set NumContribAvalista value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numContribAvalista
     * @return \StructType\PendentesERP
     */
    public function setNumContribAvalista($numContribAvalista = null)
    {
        // validation for constraint: string
        if (!is_null($numContribAvalista) && !is_string($numContribAvalista)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numContribAvalista)), __LINE__);
        }
        if (is_null($numContribAvalista) || (is_array($numContribAvalista) && empty($numContribAvalista))) {
            unset($this->NumContribAvalista);
        } else {
            $this->NumContribAvalista = $numContribAvalista;
        }
        return $this;
    }
    /**
     * Get NumDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumDoc()
    {
        return isset($this->NumDoc) ? $this->NumDoc : null;
    }
    /**
     * Set NumDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numDoc
     * @return \StructType\PendentesERP
     */
    public function setNumDoc($numDoc = null)
    {
        // validation for constraint: string
        if (!is_null($numDoc) && !is_string($numDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numDoc)), __LINE__);
        }
        if (is_null($numDoc) || (is_array($numDoc) && empty($numDoc))) {
            unset($this->NumDoc);
        } else {
            $this->NumDoc = $numDoc;
        }
        return $this;
    }
    /**
     * Get NumDocInt value
     * @return int|null
     */
    public function getNumDocInt()
    {
        return $this->NumDocInt;
    }
    /**
     * Set NumDocInt value
     * @param int $numDocInt
     * @return \StructType\PendentesERP
     */
    public function setNumDocInt($numDocInt = null)
    {
        // validation for constraint: int
        if (!is_null($numDocInt) && !is_numeric($numDocInt)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDocInt)), __LINE__);
        }
        $this->NumDocInt = $numDocInt;
        return $this;
    }
    /**
     * Get NumPrestacao value
     * @return int|null
     */
    public function getNumPrestacao()
    {
        return $this->NumPrestacao;
    }
    /**
     * Set NumPrestacao value
     * @param int $numPrestacao
     * @return \StructType\PendentesERP
     */
    public function setNumPrestacao($numPrestacao = null)
    {
        // validation for constraint: int
        if (!is_null($numPrestacao) && !is_numeric($numPrestacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numPrestacao)), __LINE__);
        }
        $this->NumPrestacao = $numPrestacao;
        return $this;
    }
    /**
     * Get NumRemessa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumRemessa()
    {
        return isset($this->NumRemessa) ? $this->NumRemessa : null;
    }
    /**
     * Set NumRemessa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numRemessa
     * @return \StructType\PendentesERP
     */
    public function setNumRemessa($numRemessa = null)
    {
        // validation for constraint: int
        if (!is_null($numRemessa) && !is_numeric($numRemessa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numRemessa)), __LINE__);
        }
        if (is_null($numRemessa) || (is_array($numRemessa) && empty($numRemessa))) {
            unset($this->NumRemessa);
        } else {
            $this->NumRemessa = $numRemessa;
        }
        return $this;
    }
    /**
     * Get NumTransferencia value
     * @return int|null
     */
    public function getNumTransferencia()
    {
        return $this->NumTransferencia;
    }
    /**
     * Set NumTransferencia value
     * @param int $numTransferencia
     * @return \StructType\PendentesERP
     */
    public function setNumTransferencia($numTransferencia = null)
    {
        // validation for constraint: int
        if (!is_null($numTransferencia) && !is_numeric($numTransferencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numTransferencia)), __LINE__);
        }
        $this->NumTransferencia = $numTransferencia;
        return $this;
    }
    /**
     * Get ObraID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObraID()
    {
        return isset($this->ObraID) ? $this->ObraID : null;
    }
    /**
     * Set ObraID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $obraID
     * @return \StructType\PendentesERP
     */
    public function setObraID($obraID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($obraID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $obraID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($obraID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($obraID) && !is_string($obraID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obraID)), __LINE__);
        }
        if (is_null($obraID) || (is_array($obraID) && empty($obraID))) {
            unset($this->ObraID);
        } else {
            $this->ObraID = $obraID;
        }
        return $this;
    }
    /**
     * Get Origem value
     * @return int|null
     */
    public function getOrigem()
    {
        return $this->Origem;
    }
    /**
     * Set Origem value
     * @param int $origem
     * @return \StructType\PendentesERP
     */
    public function setOrigem($origem = null)
    {
        // validation for constraint: int
        if (!is_null($origem) && !is_numeric($origem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($origem)), __LINE__);
        }
        $this->Origem = $origem;
        return $this;
    }
    /**
     * Get Percentagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPercentagem()
    {
        return isset($this->Percentagem) ? $this->Percentagem : null;
    }
    /**
     * Set Percentagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $percentagem
     * @return \StructType\PendentesERP
     */
    public function setPercentagem($percentagem = null)
    {
        // validation for constraint: boolean
        if (!is_null($percentagem) && !is_bool($percentagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($percentagem)), __LINE__);
        }
        if (is_null($percentagem) || (is_array($percentagem) && empty($percentagem))) {
            unset($this->Percentagem);
        } else {
            $this->Percentagem = $percentagem;
        }
        return $this;
    }
    /**
     * Get Plafond value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlafond()
    {
        return isset($this->Plafond) ? $this->Plafond : null;
    }
    /**
     * Set Plafond value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $plafond
     * @return \StructType\PendentesERP
     */
    public function setPlafond($plafond = null)
    {
        if (is_null($plafond) || (is_array($plafond) && empty($plafond))) {
            unset($this->Plafond);
        } else {
            $this->Plafond = $plafond;
        }
        return $this;
    }
    /**
     * Get Portes value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPortes()
    {
        return isset($this->Portes) ? $this->Portes : null;
    }
    /**
     * Set Portes value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $portes
     * @return \StructType\PendentesERP
     */
    public function setPortes($portes = null)
    {
        if (is_null($portes) || (is_array($portes) && empty($portes))) {
            unset($this->Portes);
        } else {
            $this->Portes = $portes;
        }
        return $this;
    }
    /**
     * Get Postecipado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPostecipado()
    {
        return isset($this->Postecipado) ? $this->Postecipado : null;
    }
    /**
     * Set Postecipado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $postecipado
     * @return \StructType\PendentesERP
     */
    public function setPostecipado($postecipado = null)
    {
        // validation for constraint: boolean
        if (!is_null($postecipado) && !is_bool($postecipado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($postecipado)), __LINE__);
        }
        if (is_null($postecipado) || (is_array($postecipado) && empty($postecipado))) {
            unset($this->Postecipado);
        } else {
            $this->Postecipado = $postecipado;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\PendentesERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get RegimeIvaReembolsos value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getRegimeIvaReembolsos()
    {
        return isset($this->RegimeIvaReembolsos) ? $this->RegimeIvaReembolsos : null;
    }
    /**
     * Set RegimeIvaReembolsos value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $regimeIvaReembolsos
     * @return \StructType\PendentesERP
     */
    public function setRegimeIvaReembolsos($regimeIvaReembolsos = null)
    {
        // validation for constraint: int
        if (!is_null($regimeIvaReembolsos) && !is_numeric($regimeIvaReembolsos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($regimeIvaReembolsos)), __LINE__);
        }
        if (is_null($regimeIvaReembolsos) || (is_array($regimeIvaReembolsos) && empty($regimeIvaReembolsos))) {
            unset($this->RegimeIvaReembolsos);
        } else {
            $this->RegimeIvaReembolsos = $regimeIvaReembolsos;
        }
        return $this;
    }
    /**
     * Get RespCobranca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespCobranca()
    {
        return isset($this->RespCobranca) ? $this->RespCobranca : null;
    }
    /**
     * Set RespCobranca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respCobranca
     * @return \StructType\PendentesERP
     */
    public function setRespCobranca($respCobranca = null)
    {
        // validation for constraint: string
        if (!is_null($respCobranca) && !is_string($respCobranca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respCobranca)), __LINE__);
        }
        if (is_null($respCobranca) || (is_array($respCobranca) && empty($respCobranca))) {
            unset($this->RespCobranca);
        } else {
            $this->RespCobranca = $respCobranca;
        }
        return $this;
    }
    /**
     * Get Serie value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerie()
    {
        return isset($this->Serie) ? $this->Serie : null;
    }
    /**
     * Set Serie value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serie
     * @return \StructType\PendentesERP
     */
    public function setSerie($serie = null)
    {
        // validation for constraint: string
        if (!is_null($serie) && !is_string($serie)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serie)), __LINE__);
        }
        if (is_null($serie) || (is_array($serie) && empty($serie))) {
            unset($this->Serie);
        } else {
            $this->Serie = $serie;
        }
        return $this;
    }
    /**
     * Get TaxaJuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaJuro()
    {
        return isset($this->TaxaJuro) ? $this->TaxaJuro : null;
    }
    /**
     * Set TaxaJuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaJuro
     * @return \StructType\PendentesERP
     */
    public function setTaxaJuro($taxaJuro = null)
    {
        if (is_null($taxaJuro) || (is_array($taxaJuro) && empty($taxaJuro))) {
            unset($this->TaxaJuro);
        } else {
            $this->TaxaJuro = $taxaJuro;
        }
        return $this;
    }
    /**
     * Get TipoConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoConta()
    {
        return isset($this->TipoConta) ? $this->TipoConta : null;
    }
    /**
     * Set TipoConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoConta
     * @return \StructType\PendentesERP
     */
    public function setTipoConta($tipoConta = null)
    {
        // validation for constraint: string
        if (!is_null($tipoConta) && !is_string($tipoConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoConta)), __LINE__);
        }
        if (is_null($tipoConta) || (is_array($tipoConta) && empty($tipoConta))) {
            unset($this->TipoConta);
        } else {
            $this->TipoConta = $tipoConta;
        }
        return $this;
    }
    /**
     * Get TipoDoc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDoc()
    {
        return isset($this->TipoDoc) ? $this->TipoDoc : null;
    }
    /**
     * Set TipoDoc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDoc
     * @return \StructType\PendentesERP
     */
    public function setTipoDoc($tipoDoc = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDoc) && !is_string($tipoDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDoc)), __LINE__);
        }
        if (is_null($tipoDoc) || (is_array($tipoDoc) && empty($tipoDoc))) {
            unset($this->TipoDoc);
        } else {
            $this->TipoDoc = $tipoDoc;
        }
        return $this;
    }
    /**
     * Get TipoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidade()
    {
        return isset($this->TipoEntidade) ? $this->TipoEntidade : null;
    }
    /**
     * Set TipoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidade
     * @return \StructType\PendentesERP
     */
    public function setTipoEntidade($tipoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidade) && !is_string($tipoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidade)), __LINE__);
        }
        if (is_null($tipoEntidade) || (is_array($tipoEntidade) && empty($tipoEntidade))) {
            unset($this->TipoEntidade);
        } else {
            $this->TipoEntidade = $tipoEntidade;
        }
        return $this;
    }
    /**
     * Get TipoEntidadeComercial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidadeComercial()
    {
        return isset($this->TipoEntidadeComercial) ? $this->TipoEntidadeComercial : null;
    }
    /**
     * Set TipoEntidadeComercial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidadeComercial
     * @return \StructType\PendentesERP
     */
    public function setTipoEntidadeComercial($tipoEntidadeComercial = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidadeComercial) && !is_string($tipoEntidadeComercial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidadeComercial)), __LINE__);
        }
        if (is_null($tipoEntidadeComercial) || (is_array($tipoEntidadeComercial) && empty($tipoEntidadeComercial))) {
            unset($this->TipoEntidadeComercial);
        } else {
            $this->TipoEntidadeComercial = $tipoEntidadeComercial;
        }
        return $this;
    }
    /**
     * Get TipoLancamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoLancamento()
    {
        return isset($this->TipoLancamento) ? $this->TipoLancamento : null;
    }
    /**
     * Set TipoLancamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoLancamento
     * @return \StructType\PendentesERP
     */
    public function setTipoLancamento($tipoLancamento = null)
    {
        // validation for constraint: string
        if (!is_null($tipoLancamento) && !is_string($tipoLancamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoLancamento)), __LINE__);
        }
        if (is_null($tipoLancamento) || (is_array($tipoLancamento) && empty($tipoLancamento))) {
            unset($this->TipoLancamento);
        } else {
            $this->TipoLancamento = $tipoLancamento;
        }
        return $this;
    }
    /**
     * Get TipoOperacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoOperacao()
    {
        return isset($this->TipoOperacao) ? $this->TipoOperacao : null;
    }
    /**
     * Set TipoOperacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoOperacao
     * @return \StructType\PendentesERP
     */
    public function setTipoOperacao($tipoOperacao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoOperacao) && !is_string($tipoOperacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoOperacao)), __LINE__);
        }
        if (is_null($tipoOperacao) || (is_array($tipoOperacao) && empty($tipoOperacao))) {
            unset($this->TipoOperacao);
        } else {
            $this->TipoOperacao = $tipoOperacao;
        }
        return $this;
    }
    /**
     * Get TipoPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoPendente()
    {
        return isset($this->TipoPendente) ? $this->TipoPendente : null;
    }
    /**
     * Set TipoPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoPendente
     * @return \StructType\PendentesERP
     */
    public function setTipoPendente($tipoPendente = null)
    {
        // validation for constraint: string
        if (!is_null($tipoPendente) && !is_string($tipoPendente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoPendente)), __LINE__);
        }
        if (is_null($tipoPendente) || (is_array($tipoPendente) && empty($tipoPendente))) {
            unset($this->TipoPendente);
        } else {
            $this->TipoPendente = $tipoPendente;
        }
        return $this;
    }
    /**
     * Get TotalIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIva()
    {
        return isset($this->TotalIva) ? $this->TotalIva : null;
    }
    /**
     * Set TotalIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIva
     * @return \StructType\PendentesERP
     */
    public function setTotalIva($totalIva = null)
    {
        if (is_null($totalIva) || (is_array($totalIva) && empty($totalIva))) {
            unset($this->TotalIva);
        } else {
            $this->TotalIva = $totalIva;
        }
        return $this;
    }
    /**
     * Get TotalRecargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalRecargo()
    {
        return isset($this->TotalRecargo) ? $this->TotalRecargo : null;
    }
    /**
     * Set TotalRecargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalRecargo
     * @return \StructType\PendentesERP
     */
    public function setTotalRecargo($totalRecargo = null)
    {
        if (is_null($totalRecargo) || (is_array($totalRecargo) && empty($totalRecargo))) {
            unset($this->TotalRecargo);
        } else {
            $this->TotalRecargo = $totalRecargo;
        }
        return $this;
    }
    /**
     * Get ValorPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorPendente()
    {
        return isset($this->ValorPendente) ? $this->ValorPendente : null;
    }
    /**
     * Set ValorPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorPendente
     * @return \StructType\PendentesERP
     */
    public function setValorPendente($valorPendente = null)
    {
        if (is_null($valorPendente) || (is_array($valorPendente) && empty($valorPendente))) {
            unset($this->ValorPendente);
        } else {
            $this->ValorPendente = $valorPendente;
        }
        return $this;
    }
    /**
     * Get ValorRetencao value
     * @return float|null
     */
    public function getValorRetencao()
    {
        return $this->ValorRetencao;
    }
    /**
     * Set ValorRetencao value
     * @param float $valorRetencao
     * @return \StructType\PendentesERP
     */
    public function setValorRetencao($valorRetencao = null)
    {
        $this->ValorRetencao = $valorRetencao;
        return $this;
    }
    /**
     * Get ValorRetencaoGarantia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoGarantia()
    {
        return isset($this->ValorRetencaoGarantia) ? $this->ValorRetencaoGarantia : null;
    }
    /**
     * Set ValorRetencaoGarantia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoGarantia
     * @return \StructType\PendentesERP
     */
    public function setValorRetencaoGarantia($valorRetencaoGarantia = null)
    {
        if (is_null($valorRetencaoGarantia) || (is_array($valorRetencaoGarantia) && empty($valorRetencaoGarantia))) {
            unset($this->ValorRetencaoGarantia);
        } else {
            $this->ValorRetencaoGarantia = $valorRetencaoGarantia;
        }
        return $this;
    }
    /**
     * Get ValorRetencaoGarantiaPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoGarantiaPendente()
    {
        return isset($this->ValorRetencaoGarantiaPendente) ? $this->ValorRetencaoGarantiaPendente : null;
    }
    /**
     * Set ValorRetencaoGarantiaPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoGarantiaPendente
     * @return \StructType\PendentesERP
     */
    public function setValorRetencaoGarantiaPendente($valorRetencaoGarantiaPendente = null)
    {
        if (is_null($valorRetencaoGarantiaPendente) || (is_array($valorRetencaoGarantiaPendente) && empty($valorRetencaoGarantiaPendente))) {
            unset($this->ValorRetencaoGarantiaPendente);
        } else {
            $this->ValorRetencaoGarantiaPendente = $valorRetencaoGarantiaPendente;
        }
        return $this;
    }
    /**
     * Get ValorRetencaoPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRetencaoPendente()
    {
        return isset($this->ValorRetencaoPendente) ? $this->ValorRetencaoPendente : null;
    }
    /**
     * Set ValorRetencaoPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRetencaoPendente
     * @return \StructType\PendentesERP
     */
    public function setValorRetencaoPendente($valorRetencaoPendente = null)
    {
        if (is_null($valorRetencaoPendente) || (is_array($valorRetencaoPendente) && empty($valorRetencaoPendente))) {
            unset($this->ValorRetencaoPendente);
        } else {
            $this->ValorRetencaoPendente = $valorRetencaoPendente;
        }
        return $this;
    }
    /**
     * Get ValorTotal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorTotal()
    {
        return isset($this->ValorTotal) ? $this->ValorTotal : null;
    }
    /**
     * Set ValorTotal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorTotal
     * @return \StructType\PendentesERP
     */
    public function setValorTotal($valorTotal = null)
    {
        if (is_null($valorTotal) || (is_array($valorTotal) && empty($valorTotal))) {
            unset($this->ValorTotal);
        } else {
            $this->ValorTotal = $valorTotal;
        }
        return $this;
    }
    /**
     * Get Vendedor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVendedor()
    {
        return isset($this->Vendedor) ? $this->Vendedor : null;
    }
    /**
     * Set Vendedor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vendedor
     * @return \StructType\PendentesERP
     */
    public function setVendedor($vendedor = null)
    {
        // validation for constraint: string
        if (!is_null($vendedor) && !is_string($vendedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendedor)), __LINE__);
        }
        if (is_null($vendedor) || (is_array($vendedor) && empty($vendedor))) {
            unset($this->Vendedor);
        } else {
            $this->Vendedor = $vendedor;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\PendentesERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Get WBSItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBSItem()
    {
        return isset($this->WBSItem) ? $this->WBSItem : null;
    }
    /**
     * Set WBSItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBSItem
     * @return \StructType\PendentesERP
     */
    public function setWBSItem($wBSItem = null)
    {
        // validation for constraint: string
        if (!is_null($wBSItem) && !is_string($wBSItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wBSItem)), __LINE__);
        }
        if (is_null($wBSItem) || (is_array($wBSItem) && empty($wBSItem))) {
            unset($this->WBSItem);
        } else {
            $this->WBSItem = $wBSItem;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\PendentesERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
