<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for MarcasERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:MarcasERP
 * @subpackage Structs
 */
class MarcasERP extends AbstractStructBase
{
    /**
     * The DataUltimaActualizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataUltimaActualizacao;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Marca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Marca;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for MarcasERP
     * @uses MarcasERP::setDataUltimaActualizacao()
     * @uses MarcasERP::setDescricao()
     * @uses MarcasERP::setMarca()
     * @uses MarcasERP::setProtegida()
     * @uses MarcasERP::setVersaoUltAct()
     * @param string $dataUltimaActualizacao
     * @param string $descricao
     * @param string $marca
     * @param bool $protegida
     * @param string $versaoUltAct
     */
    public function __construct($dataUltimaActualizacao = null, $descricao = null, $marca = null, $protegida = null, $versaoUltAct = null)
    {
        $this
            ->setDataUltimaActualizacao($dataUltimaActualizacao)
            ->setDescricao($descricao)
            ->setMarca($marca)
            ->setProtegida($protegida)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get DataUltimaActualizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataUltimaActualizacao()
    {
        return isset($this->DataUltimaActualizacao) ? $this->DataUltimaActualizacao : null;
    }
    /**
     * Set DataUltimaActualizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataUltimaActualizacao
     * @return \StructType\MarcasERP
     */
    public function setDataUltimaActualizacao($dataUltimaActualizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataUltimaActualizacao) && !is_string($dataUltimaActualizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataUltimaActualizacao)), __LINE__);
        }
        if (is_null($dataUltimaActualizacao) || (is_array($dataUltimaActualizacao) && empty($dataUltimaActualizacao))) {
            unset($this->DataUltimaActualizacao);
        } else {
            $this->DataUltimaActualizacao = $dataUltimaActualizacao;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\MarcasERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Marca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarca()
    {
        return isset($this->Marca) ? $this->Marca : null;
    }
    /**
     * Set Marca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marca
     * @return \StructType\MarcasERP
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marca)), __LINE__);
        }
        if (is_null($marca) || (is_array($marca) && empty($marca))) {
            unset($this->Marca);
        } else {
            $this->Marca = $marca;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\MarcasERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\MarcasERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\MarcasERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
