<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for LinhasDocERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:LinhasDocERP
 * @subpackage Structs
 */
class LinhasDocERP extends AbstractStructBase
{
    /**
     * The AlternativaGPR
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AlternativaGPR;
    /**
     * The AnaliticaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $AnaliticaCBL;
    /**
     * The Ano
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Ano;
    /**
     * The Armazem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Armazem;
    /**
     * The Arred
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Arred;
    /**
     * The Artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Artigo;
    /**
     * The AutoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $AutoID;
    /**
     * The B2BNumLinhaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $B2BNumLinhaOrig;
    /**
     * The BaseCalculoIncidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseCalculoIncidencia;
    /**
     * The BaseIncidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $BaseIncidencia;
    /**
     * The CCustoCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CCustoCBL;
    /**
     * The CDU_LinVar1ENC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_LinVar1ENC;
    /**
     * The CDU_LinVar2ENC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_LinVar2ENC;
    /**
     * The CDU_LinVar3ENC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_LinVar3ENC;
    /**
     * The CDU_LinVar4ENC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_LinVar4ENC;
    /**
     * The CDU_LinVar5ENC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_LinVar5ENC;
    /**
     * The CambioDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioDocOrig;
    /**
     * The CambioMAltDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMAltDocOrig;
    /**
     * The CambioMBaseDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $CambioMBaseDocOrig;
    /**
     * The CategoriaID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $CategoriaID;
    /**
     * The ClasseID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ClasseID;
    /**
     * The CodIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIva;
    /**
     * The CodIvaEcotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIvaEcotaxa;
    /**
     * The CodIvaIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodIvaIEC;
    /**
     * The Comissao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Comissao;
    /**
     * The ContaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCBL;
    /**
     * The ContaOrcamCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaOrcamCBL;
    /**
     * The ContratoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ContratoID;
    /**
     * The CustoPrevisto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $CustoPrevisto;
    /**
     * The Data
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Data;
    /**
     * The DataEntrega
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataEntrega;
    /**
     * The DataSaida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataSaida;
    /**
     * The Desconto1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Desconto1;
    /**
     * The Desconto2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Desconto2;
    /**
     * The Desconto3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Desconto3;
    /**
     * The DescontoComercial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DescontoComercial;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The Devolucao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Devolucao;
    /**
     * The DifArredondamentoMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamentoMAlt;
    /**
     * The DifArredondamentoMBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifArredondamentoMBase;
    /**
     * The DifCambioMAlt
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifCambioMAlt;
    /**
     * The DifCambioMBase
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifCambioMBase;
    /**
     * The DifPCMedio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $DifPCMedio;
    /**
     * The Ecotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Ecotaxa;
    /**
     * The EstadoAdi
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoAdi;
    /**
     * The EstadoPendente
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $EstadoPendente;
    /**
     * The FactorConv
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $FactorConv;
    /**
     * The Formula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Formula;
    /**
     * The FuncionalCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FuncionalCBL;
    /**
     * The IDB2BLinhaOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDB2BLinhaOrig;
    /**
     * The IDLinhaEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDLinhaEstorno;
    /**
     * The Id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $Id;
    /**
     * The IdCabecDoc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCabecDoc;
    /**
     * The IdHistorico
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdHistorico;
    /**
     * The IdLinhaOrigemCopia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhaOrigemCopia;
    /**
     * The IdLinhaPai
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdLinhaPai;
    /**
     * The IncidenciaIS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IncidenciaIS;
    /**
     * The IntrastatMassaLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IntrastatMassaLiq;
    /**
     * The IntrastatPaisOrigem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntrastatPaisOrigem;
    /**
     * The IntrastatPautal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntrastatPautal;
    /**
     * The IntrastatRegiao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IntrastatRegiao;
    /**
     * The IntrastatValorLiq
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $IntrastatValorLiq;
    /**
     * The ItemCod
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemCod;
    /**
     * The ItemDesc
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ItemDesc;
    /**
     * The ItemId
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $ItemId;
    /**
     * The IvaNaoDedutivel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IvaNaoDedutivel;
    /**
     * The IvaRegraCalculo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $IvaRegraCalculo;
    /**
     * The IvaValorDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $IvaValorDesconto;
    /**
     * The LinhasEstados
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLinhasDocStatusERP
     */
    public $LinhasEstados;
    /**
     * The LinhasTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \ArrayType\ArrayOfLinhasDocTransERP
     */
    public $LinhasTrans;
    /**
     * The Localizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Localizacao;
    /**
     * The Lote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Lote;
    /**
     * The Margem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $Margem;
    /**
     * The ModuloOrigemCopia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModuloOrigemCopia;
    /**
     * The MoedaDocOrig
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MoedaDocOrig;
    /**
     * The MotivoEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoEstorno;
    /**
     * The MovSTK
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovSTK;
    /**
     * The NumLinha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $NumLinha;
    /**
     * The NumLinhaSTKGerada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumLinhaSTKGerada;
    /**
     * The ObraID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ObraID;
    /**
     * The OrganicaCBL
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $OrganicaCBL;
    /**
     * The PCM
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PCM;
    /**
     * The PCMDevolucao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PCMDevolucao;
    /**
     * The PercIncidenciaIVA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PercIncidenciaIVA;
    /**
     * The PercIvaDedutivel
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercIvaDedutivel;
    /**
     * The PercentagemMargem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $PercentagemMargem;
    /**
     * The PrecUnit
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PrecUnit;
    /**
     * The PrecoLiquido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PrecoLiquido;
    /**
     * The ProcessoID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $ProcessoID;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The QntFormula
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $QntFormula;
    /**
     * The Quantidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Quantidade;
    /**
     * The RegimeIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RegimeIva;
    /**
     * The RegraCalculoIncidencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $RegraCalculoIncidencia;
    /**
     * The Seccao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Seccao;
    /**
     * The Selo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Selo;
    /**
     * The SubEmpID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $SubEmpID;
    /**
     * The SujeitoRetencao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $SujeitoRetencao;
    /**
     * The TaxaIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaIva;
    /**
     * The TaxaIvaEcotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaIvaEcotaxa;
    /**
     * The TaxaIvaIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaIvaIEC;
    /**
     * The TaxaRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TaxaRecargo;
    /**
     * The TipoAuto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoAuto;
    /**
     * The TipoCustoPrevisto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $TipoCustoPrevisto;
    /**
     * The TipoLinha
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoLinha;
    /**
     * The TipoOperacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoOperacao;
    /**
     * The TotalDA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDA;
    /**
     * The TotalDC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDC;
    /**
     * The TotalDF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalDF;
    /**
     * The TotalEcotaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $TotalEcotaxa;
    /**
     * The TotalIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIEC;
    /**
     * The TotalIliquido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIliquido;
    /**
     * The TotalIva
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalIva;
    /**
     * The TotalRecargo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $TotalRecargo;
    /**
     * The Unidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Unidade;
    /**
     * The ValorIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorIEC;
    /**
     * The ValorIS
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorIS;
    /**
     * The ValorLiquidoDesconto
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var float
     */
    public $ValorLiquidoDesconto;
    /**
     * The VariavelA
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VariavelA;
    /**
     * The VariavelB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VariavelB;
    /**
     * The VariavelC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $VariavelC;
    /**
     * The Vendedor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Vendedor;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * The WBSItem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $WBSItem;
    /**
     * Constructor method for LinhasDocERP
     * @uses LinhasDocERP::setAlternativaGPR()
     * @uses LinhasDocERP::setAnaliticaCBL()
     * @uses LinhasDocERP::setAno()
     * @uses LinhasDocERP::setArmazem()
     * @uses LinhasDocERP::setArred()
     * @uses LinhasDocERP::setArtigo()
     * @uses LinhasDocERP::setAutoID()
     * @uses LinhasDocERP::setB2BNumLinhaOrig()
     * @uses LinhasDocERP::setBaseCalculoIncidencia()
     * @uses LinhasDocERP::setBaseIncidencia()
     * @uses LinhasDocERP::setCCustoCBL()
     * @uses LinhasDocERP::setCDU_LinVar1ENC()
     * @uses LinhasDocERP::setCDU_LinVar2ENC()
     * @uses LinhasDocERP::setCDU_LinVar3ENC()
     * @uses LinhasDocERP::setCDU_LinVar4ENC()
     * @uses LinhasDocERP::setCDU_LinVar5ENC()
     * @uses LinhasDocERP::setCambioDocOrig()
     * @uses LinhasDocERP::setCambioMAltDocOrig()
     * @uses LinhasDocERP::setCambioMBaseDocOrig()
     * @uses LinhasDocERP::setCategoriaID()
     * @uses LinhasDocERP::setClasseID()
     * @uses LinhasDocERP::setCodIva()
     * @uses LinhasDocERP::setCodIvaEcotaxa()
     * @uses LinhasDocERP::setCodIvaIEC()
     * @uses LinhasDocERP::setComissao()
     * @uses LinhasDocERP::setContaCBL()
     * @uses LinhasDocERP::setContaOrcamCBL()
     * @uses LinhasDocERP::setContratoID()
     * @uses LinhasDocERP::setCustoPrevisto()
     * @uses LinhasDocERP::setData()
     * @uses LinhasDocERP::setDataEntrega()
     * @uses LinhasDocERP::setDataSaida()
     * @uses LinhasDocERP::setDesconto1()
     * @uses LinhasDocERP::setDesconto2()
     * @uses LinhasDocERP::setDesconto3()
     * @uses LinhasDocERP::setDescontoComercial()
     * @uses LinhasDocERP::setDescricao()
     * @uses LinhasDocERP::setDevolucao()
     * @uses LinhasDocERP::setDifArredondamentoMAlt()
     * @uses LinhasDocERP::setDifArredondamentoMBase()
     * @uses LinhasDocERP::setDifCambioMAlt()
     * @uses LinhasDocERP::setDifCambioMBase()
     * @uses LinhasDocERP::setDifPCMedio()
     * @uses LinhasDocERP::setEcotaxa()
     * @uses LinhasDocERP::setEstadoAdi()
     * @uses LinhasDocERP::setEstadoPendente()
     * @uses LinhasDocERP::setFactorConv()
     * @uses LinhasDocERP::setFormula()
     * @uses LinhasDocERP::setFuncionalCBL()
     * @uses LinhasDocERP::setIDB2BLinhaOrig()
     * @uses LinhasDocERP::setIDLinhaEstorno()
     * @uses LinhasDocERP::setId()
     * @uses LinhasDocERP::setIdCabecDoc()
     * @uses LinhasDocERP::setIdHistorico()
     * @uses LinhasDocERP::setIdLinhaOrigemCopia()
     * @uses LinhasDocERP::setIdLinhaPai()
     * @uses LinhasDocERP::setIncidenciaIS()
     * @uses LinhasDocERP::setIntrastatMassaLiq()
     * @uses LinhasDocERP::setIntrastatPaisOrigem()
     * @uses LinhasDocERP::setIntrastatPautal()
     * @uses LinhasDocERP::setIntrastatRegiao()
     * @uses LinhasDocERP::setIntrastatValorLiq()
     * @uses LinhasDocERP::setItemCod()
     * @uses LinhasDocERP::setItemDesc()
     * @uses LinhasDocERP::setItemId()
     * @uses LinhasDocERP::setIvaNaoDedutivel()
     * @uses LinhasDocERP::setIvaRegraCalculo()
     * @uses LinhasDocERP::setIvaValorDesconto()
     * @uses LinhasDocERP::setLinhasEstados()
     * @uses LinhasDocERP::setLinhasTrans()
     * @uses LinhasDocERP::setLocalizacao()
     * @uses LinhasDocERP::setLote()
     * @uses LinhasDocERP::setMargem()
     * @uses LinhasDocERP::setModuloOrigemCopia()
     * @uses LinhasDocERP::setMoedaDocOrig()
     * @uses LinhasDocERP::setMotivoEstorno()
     * @uses LinhasDocERP::setMovSTK()
     * @uses LinhasDocERP::setNumLinha()
     * @uses LinhasDocERP::setNumLinhaSTKGerada()
     * @uses LinhasDocERP::setObraID()
     * @uses LinhasDocERP::setOrganicaCBL()
     * @uses LinhasDocERP::setPCM()
     * @uses LinhasDocERP::setPCMDevolucao()
     * @uses LinhasDocERP::setPercIncidenciaIVA()
     * @uses LinhasDocERP::setPercIvaDedutivel()
     * @uses LinhasDocERP::setPercentagemMargem()
     * @uses LinhasDocERP::setPrecUnit()
     * @uses LinhasDocERP::setPrecoLiquido()
     * @uses LinhasDocERP::setProcessoID()
     * @uses LinhasDocERP::setProtegida()
     * @uses LinhasDocERP::setQntFormula()
     * @uses LinhasDocERP::setQuantidade()
     * @uses LinhasDocERP::setRegimeIva()
     * @uses LinhasDocERP::setRegraCalculoIncidencia()
     * @uses LinhasDocERP::setSeccao()
     * @uses LinhasDocERP::setSelo()
     * @uses LinhasDocERP::setSubEmpID()
     * @uses LinhasDocERP::setSujeitoRetencao()
     * @uses LinhasDocERP::setTaxaIva()
     * @uses LinhasDocERP::setTaxaIvaEcotaxa()
     * @uses LinhasDocERP::setTaxaIvaIEC()
     * @uses LinhasDocERP::setTaxaRecargo()
     * @uses LinhasDocERP::setTipoAuto()
     * @uses LinhasDocERP::setTipoCustoPrevisto()
     * @uses LinhasDocERP::setTipoLinha()
     * @uses LinhasDocERP::setTipoOperacao()
     * @uses LinhasDocERP::setTotalDA()
     * @uses LinhasDocERP::setTotalDC()
     * @uses LinhasDocERP::setTotalDF()
     * @uses LinhasDocERP::setTotalEcotaxa()
     * @uses LinhasDocERP::setTotalIEC()
     * @uses LinhasDocERP::setTotalIliquido()
     * @uses LinhasDocERP::setTotalIva()
     * @uses LinhasDocERP::setTotalRecargo()
     * @uses LinhasDocERP::setUnidade()
     * @uses LinhasDocERP::setValorIEC()
     * @uses LinhasDocERP::setValorIS()
     * @uses LinhasDocERP::setValorLiquidoDesconto()
     * @uses LinhasDocERP::setVariavelA()
     * @uses LinhasDocERP::setVariavelB()
     * @uses LinhasDocERP::setVariavelC()
     * @uses LinhasDocERP::setVendedor()
     * @uses LinhasDocERP::setVersaoUltAct()
     * @uses LinhasDocERP::setWBSItem()
     * @param string $alternativaGPR
     * @param string $analiticaCBL
     * @param int $ano
     * @param string $armazem
     * @param int $arred
     * @param string $artigo
     * @param string $autoID
     * @param int $b2BNumLinhaOrig
     * @param float $baseCalculoIncidencia
     * @param float $baseIncidencia
     * @param string $cCustoCBL
     * @param string $cDU_LinVar1ENC
     * @param string $cDU_LinVar2ENC
     * @param string $cDU_LinVar3ENC
     * @param string $cDU_LinVar4ENC
     * @param string $cDU_LinVar5ENC
     * @param float $cambioDocOrig
     * @param float $cambioMAltDocOrig
     * @param float $cambioMBaseDocOrig
     * @param int $categoriaID
     * @param int $classeID
     * @param string $codIva
     * @param string $codIvaEcotaxa
     * @param string $codIvaIEC
     * @param float $comissao
     * @param string $contaCBL
     * @param string $contaOrcamCBL
     * @param string $contratoID
     * @param float $custoPrevisto
     * @param string $data
     * @param string $dataEntrega
     * @param string $dataSaida
     * @param float $desconto1
     * @param float $desconto2
     * @param float $desconto3
     * @param float $descontoComercial
     * @param string $descricao
     * @param bool $devolucao
     * @param float $difArredondamentoMAlt
     * @param float $difArredondamentoMBase
     * @param float $difCambioMAlt
     * @param float $difCambioMBase
     * @param float $difPCMedio
     * @param float $ecotaxa
     * @param string $estadoAdi
     * @param string $estadoPendente
     * @param float $factorConv
     * @param string $formula
     * @param string $funcionalCBL
     * @param string $iDB2BLinhaOrig
     * @param string $iDLinhaEstorno
     * @param string $id
     * @param string $idCabecDoc
     * @param string $idHistorico
     * @param string $idLinhaOrigemCopia
     * @param string $idLinhaPai
     * @param float $incidenciaIS
     * @param float $intrastatMassaLiq
     * @param string $intrastatPaisOrigem
     * @param string $intrastatPautal
     * @param string $intrastatRegiao
     * @param float $intrastatValorLiq
     * @param string $itemCod
     * @param string $itemDesc
     * @param int $itemId
     * @param float $ivaNaoDedutivel
     * @param int $ivaRegraCalculo
     * @param float $ivaValorDesconto
     * @param \ArrayType\ArrayOfLinhasDocStatusERP $linhasEstados
     * @param \ArrayType\ArrayOfLinhasDocTransERP $linhasTrans
     * @param string $localizacao
     * @param string $lote
     * @param float $margem
     * @param string $moduloOrigemCopia
     * @param string $moedaDocOrig
     * @param string $motivoEstorno
     * @param string $movSTK
     * @param int $numLinha
     * @param int $numLinhaSTKGerada
     * @param string $obraID
     * @param string $organicaCBL
     * @param float $pCM
     * @param float $pCMDevolucao
     * @param float $percIncidenciaIVA
     * @param float $percIvaDedutivel
     * @param float $percentagemMargem
     * @param float $precUnit
     * @param float $precoLiquido
     * @param string $processoID
     * @param bool $protegida
     * @param float $qntFormula
     * @param float $quantidade
     * @param string $regimeIva
     * @param string $regraCalculoIncidencia
     * @param string $seccao
     * @param string $selo
     * @param int $subEmpID
     * @param bool $sujeitoRetencao
     * @param float $taxaIva
     * @param float $taxaIvaEcotaxa
     * @param float $taxaIvaIEC
     * @param float $taxaRecargo
     * @param string $tipoAuto
     * @param string $tipoCustoPrevisto
     * @param string $tipoLinha
     * @param string $tipoOperacao
     * @param float $totalDA
     * @param float $totalDC
     * @param float $totalDF
     * @param float $totalEcotaxa
     * @param float $totalIEC
     * @param float $totalIliquido
     * @param float $totalIva
     * @param float $totalRecargo
     * @param string $unidade
     * @param float $valorIEC
     * @param float $valorIS
     * @param float $valorLiquidoDesconto
     * @param float $variavelA
     * @param float $variavelB
     * @param float $variavelC
     * @param string $vendedor
     * @param string $versaoUltAct
     * @param string $wBSItem
     */
    public function __construct($alternativaGPR = null, $analiticaCBL = null, $ano = null, $armazem = null, $arred = null, $artigo = null, $autoID = null, $b2BNumLinhaOrig = null, $baseCalculoIncidencia = null, $baseIncidencia = null, $cCustoCBL = null, $cDU_LinVar1ENC = null, $cDU_LinVar2ENC = null, $cDU_LinVar3ENC = null, $cDU_LinVar4ENC = null, $cDU_LinVar5ENC = null, $cambioDocOrig = null, $cambioMAltDocOrig = null, $cambioMBaseDocOrig = null, $categoriaID = null, $classeID = null, $codIva = null, $codIvaEcotaxa = null, $codIvaIEC = null, $comissao = null, $contaCBL = null, $contaOrcamCBL = null, $contratoID = null, $custoPrevisto = null, $data = null, $dataEntrega = null, $dataSaida = null, $desconto1 = null, $desconto2 = null, $desconto3 = null, $descontoComercial = null, $descricao = null, $devolucao = null, $difArredondamentoMAlt = null, $difArredondamentoMBase = null, $difCambioMAlt = null, $difCambioMBase = null, $difPCMedio = null, $ecotaxa = null, $estadoAdi = null, $estadoPendente = null, $factorConv = null, $formula = null, $funcionalCBL = null, $iDB2BLinhaOrig = null, $iDLinhaEstorno = null, $id = null, $idCabecDoc = null, $idHistorico = null, $idLinhaOrigemCopia = null, $idLinhaPai = null, $incidenciaIS = null, $intrastatMassaLiq = null, $intrastatPaisOrigem = null, $intrastatPautal = null, $intrastatRegiao = null, $intrastatValorLiq = null, $itemCod = null, $itemDesc = null, $itemId = null, $ivaNaoDedutivel = null, $ivaRegraCalculo = null, $ivaValorDesconto = null, \ArrayType\ArrayOfLinhasDocStatusERP $linhasEstados = null, \ArrayType\ArrayOfLinhasDocTransERP $linhasTrans = null, $localizacao = null, $lote = null, $margem = null, $moduloOrigemCopia = null, $moedaDocOrig = null, $motivoEstorno = null, $movSTK = null, $numLinha = null, $numLinhaSTKGerada = null, $obraID = null, $organicaCBL = null, $pCM = null, $pCMDevolucao = null, $percIncidenciaIVA = null, $percIvaDedutivel = null, $percentagemMargem = null, $precUnit = null, $precoLiquido = null, $processoID = null, $protegida = null, $qntFormula = null, $quantidade = null, $regimeIva = null, $regraCalculoIncidencia = null, $seccao = null, $selo = null, $subEmpID = null, $sujeitoRetencao = null, $taxaIva = null, $taxaIvaEcotaxa = null, $taxaIvaIEC = null, $taxaRecargo = null, $tipoAuto = null, $tipoCustoPrevisto = null, $tipoLinha = null, $tipoOperacao = null, $totalDA = null, $totalDC = null, $totalDF = null, $totalEcotaxa = null, $totalIEC = null, $totalIliquido = null, $totalIva = null, $totalRecargo = null, $unidade = null, $valorIEC = null, $valorIS = null, $valorLiquidoDesconto = null, $variavelA = null, $variavelB = null, $variavelC = null, $vendedor = null, $versaoUltAct = null, $wBSItem = null)
    {
        $this
            ->setAlternativaGPR($alternativaGPR)
            ->setAnaliticaCBL($analiticaCBL)
            ->setAno($ano)
            ->setArmazem($armazem)
            ->setArred($arred)
            ->setArtigo($artigo)
            ->setAutoID($autoID)
            ->setB2BNumLinhaOrig($b2BNumLinhaOrig)
            ->setBaseCalculoIncidencia($baseCalculoIncidencia)
            ->setBaseIncidencia($baseIncidencia)
            ->setCCustoCBL($cCustoCBL)
            ->setCDU_LinVar1ENC($cDU_LinVar1ENC)
            ->setCDU_LinVar2ENC($cDU_LinVar2ENC)
            ->setCDU_LinVar3ENC($cDU_LinVar3ENC)
            ->setCDU_LinVar4ENC($cDU_LinVar4ENC)
            ->setCDU_LinVar5ENC($cDU_LinVar5ENC)
            ->setCambioDocOrig($cambioDocOrig)
            ->setCambioMAltDocOrig($cambioMAltDocOrig)
            ->setCambioMBaseDocOrig($cambioMBaseDocOrig)
            ->setCategoriaID($categoriaID)
            ->setClasseID($classeID)
            ->setCodIva($codIva)
            ->setCodIvaEcotaxa($codIvaEcotaxa)
            ->setCodIvaIEC($codIvaIEC)
            ->setComissao($comissao)
            ->setContaCBL($contaCBL)
            ->setContaOrcamCBL($contaOrcamCBL)
            ->setContratoID($contratoID)
            ->setCustoPrevisto($custoPrevisto)
            ->setData($data)
            ->setDataEntrega($dataEntrega)
            ->setDataSaida($dataSaida)
            ->setDesconto1($desconto1)
            ->setDesconto2($desconto2)
            ->setDesconto3($desconto3)
            ->setDescontoComercial($descontoComercial)
            ->setDescricao($descricao)
            ->setDevolucao($devolucao)
            ->setDifArredondamentoMAlt($difArredondamentoMAlt)
            ->setDifArredondamentoMBase($difArredondamentoMBase)
            ->setDifCambioMAlt($difCambioMAlt)
            ->setDifCambioMBase($difCambioMBase)
            ->setDifPCMedio($difPCMedio)
            ->setEcotaxa($ecotaxa)
            ->setEstadoAdi($estadoAdi)
            ->setEstadoPendente($estadoPendente)
            ->setFactorConv($factorConv)
            ->setFormula($formula)
            ->setFuncionalCBL($funcionalCBL)
            ->setIDB2BLinhaOrig($iDB2BLinhaOrig)
            ->setIDLinhaEstorno($iDLinhaEstorno)
            ->setId($id)
            ->setIdCabecDoc($idCabecDoc)
            ->setIdHistorico($idHistorico)
            ->setIdLinhaOrigemCopia($idLinhaOrigemCopia)
            ->setIdLinhaPai($idLinhaPai)
            ->setIncidenciaIS($incidenciaIS)
            ->setIntrastatMassaLiq($intrastatMassaLiq)
            ->setIntrastatPaisOrigem($intrastatPaisOrigem)
            ->setIntrastatPautal($intrastatPautal)
            ->setIntrastatRegiao($intrastatRegiao)
            ->setIntrastatValorLiq($intrastatValorLiq)
            ->setItemCod($itemCod)
            ->setItemDesc($itemDesc)
            ->setItemId($itemId)
            ->setIvaNaoDedutivel($ivaNaoDedutivel)
            ->setIvaRegraCalculo($ivaRegraCalculo)
            ->setIvaValorDesconto($ivaValorDesconto)
            ->setLinhasEstados($linhasEstados)
            ->setLinhasTrans($linhasTrans)
            ->setLocalizacao($localizacao)
            ->setLote($lote)
            ->setMargem($margem)
            ->setModuloOrigemCopia($moduloOrigemCopia)
            ->setMoedaDocOrig($moedaDocOrig)
            ->setMotivoEstorno($motivoEstorno)
            ->setMovSTK($movSTK)
            ->setNumLinha($numLinha)
            ->setNumLinhaSTKGerada($numLinhaSTKGerada)
            ->setObraID($obraID)
            ->setOrganicaCBL($organicaCBL)
            ->setPCM($pCM)
            ->setPCMDevolucao($pCMDevolucao)
            ->setPercIncidenciaIVA($percIncidenciaIVA)
            ->setPercIvaDedutivel($percIvaDedutivel)
            ->setPercentagemMargem($percentagemMargem)
            ->setPrecUnit($precUnit)
            ->setPrecoLiquido($precoLiquido)
            ->setProcessoID($processoID)
            ->setProtegida($protegida)
            ->setQntFormula($qntFormula)
            ->setQuantidade($quantidade)
            ->setRegimeIva($regimeIva)
            ->setRegraCalculoIncidencia($regraCalculoIncidencia)
            ->setSeccao($seccao)
            ->setSelo($selo)
            ->setSubEmpID($subEmpID)
            ->setSujeitoRetencao($sujeitoRetencao)
            ->setTaxaIva($taxaIva)
            ->setTaxaIvaEcotaxa($taxaIvaEcotaxa)
            ->setTaxaIvaIEC($taxaIvaIEC)
            ->setTaxaRecargo($taxaRecargo)
            ->setTipoAuto($tipoAuto)
            ->setTipoCustoPrevisto($tipoCustoPrevisto)
            ->setTipoLinha($tipoLinha)
            ->setTipoOperacao($tipoOperacao)
            ->setTotalDA($totalDA)
            ->setTotalDC($totalDC)
            ->setTotalDF($totalDF)
            ->setTotalEcotaxa($totalEcotaxa)
            ->setTotalIEC($totalIEC)
            ->setTotalIliquido($totalIliquido)
            ->setTotalIva($totalIva)
            ->setTotalRecargo($totalRecargo)
            ->setUnidade($unidade)
            ->setValorIEC($valorIEC)
            ->setValorIS($valorIS)
            ->setValorLiquidoDesconto($valorLiquidoDesconto)
            ->setVariavelA($variavelA)
            ->setVariavelB($variavelB)
            ->setVariavelC($variavelC)
            ->setVendedor($vendedor)
            ->setVersaoUltAct($versaoUltAct)
            ->setWBSItem($wBSItem);
    }
    /**
     * Get AlternativaGPR value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAlternativaGPR()
    {
        return isset($this->AlternativaGPR) ? $this->AlternativaGPR : null;
    }
    /**
     * Set AlternativaGPR value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $alternativaGPR
     * @return \StructType\LinhasDocERP
     */
    public function setAlternativaGPR($alternativaGPR = null)
    {
        // validation for constraint: string
        if (!is_null($alternativaGPR) && !is_string($alternativaGPR)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($alternativaGPR)), __LINE__);
        }
        if (is_null($alternativaGPR) || (is_array($alternativaGPR) && empty($alternativaGPR))) {
            unset($this->AlternativaGPR);
        } else {
            $this->AlternativaGPR = $alternativaGPR;
        }
        return $this;
    }
    /**
     * Get AnaliticaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAnaliticaCBL()
    {
        return isset($this->AnaliticaCBL) ? $this->AnaliticaCBL : null;
    }
    /**
     * Set AnaliticaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $analiticaCBL
     * @return \StructType\LinhasDocERP
     */
    public function setAnaliticaCBL($analiticaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($analiticaCBL) && !is_string($analiticaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($analiticaCBL)), __LINE__);
        }
        if (is_null($analiticaCBL) || (is_array($analiticaCBL) && empty($analiticaCBL))) {
            unset($this->AnaliticaCBL);
        } else {
            $this->AnaliticaCBL = $analiticaCBL;
        }
        return $this;
    }
    /**
     * Get Ano value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getAno()
    {
        return isset($this->Ano) ? $this->Ano : null;
    }
    /**
     * Set Ano value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $ano
     * @return \StructType\LinhasDocERP
     */
    public function setAno($ano = null)
    {
        // validation for constraint: int
        if (!is_null($ano) && !is_numeric($ano)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ano)), __LINE__);
        }
        if (is_null($ano) || (is_array($ano) && empty($ano))) {
            unset($this->Ano);
        } else {
            $this->Ano = $ano;
        }
        return $this;
    }
    /**
     * Get Armazem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArmazem()
    {
        return isset($this->Armazem) ? $this->Armazem : null;
    }
    /**
     * Set Armazem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $armazem
     * @return \StructType\LinhasDocERP
     */
    public function setArmazem($armazem = null)
    {
        // validation for constraint: string
        if (!is_null($armazem) && !is_string($armazem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($armazem)), __LINE__);
        }
        if (is_null($armazem) || (is_array($armazem) && empty($armazem))) {
            unset($this->Armazem);
        } else {
            $this->Armazem = $armazem;
        }
        return $this;
    }
    /**
     * Get Arred value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getArred()
    {
        return isset($this->Arred) ? $this->Arred : null;
    }
    /**
     * Set Arred value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $arred
     * @return \StructType\LinhasDocERP
     */
    public function setArred($arred = null)
    {
        // validation for constraint: int
        if (!is_null($arred) && !is_numeric($arred)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($arred)), __LINE__);
        }
        if (is_null($arred) || (is_array($arred) && empty($arred))) {
            unset($this->Arred);
        } else {
            $this->Arred = $arred;
        }
        return $this;
    }
    /**
     * Get Artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->Artigo) ? $this->Artigo : null;
    }
    /**
     * Set Artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\LinhasDocERP
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->Artigo);
        } else {
            $this->Artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get AutoID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAutoID()
    {
        return isset($this->AutoID) ? $this->AutoID : null;
    }
    /**
     * Set AutoID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $autoID
     * @return \StructType\LinhasDocERP
     */
    public function setAutoID($autoID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($autoID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $autoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($autoID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($autoID) && !is_string($autoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($autoID)), __LINE__);
        }
        if (is_null($autoID) || (is_array($autoID) && empty($autoID))) {
            unset($this->AutoID);
        } else {
            $this->AutoID = $autoID;
        }
        return $this;
    }
    /**
     * Get B2BNumLinhaOrig value
     * @return int|null
     */
    public function getB2BNumLinhaOrig()
    {
        return $this->B2BNumLinhaOrig;
    }
    /**
     * Set B2BNumLinhaOrig value
     * @param int $b2BNumLinhaOrig
     * @return \StructType\LinhasDocERP
     */
    public function setB2BNumLinhaOrig($b2BNumLinhaOrig = null)
    {
        // validation for constraint: int
        if (!is_null($b2BNumLinhaOrig) && !is_numeric($b2BNumLinhaOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($b2BNumLinhaOrig)), __LINE__);
        }
        $this->B2BNumLinhaOrig = $b2BNumLinhaOrig;
        return $this;
    }
    /**
     * Get BaseCalculoIncidencia value
     * @return float|null
     */
    public function getBaseCalculoIncidencia()
    {
        return $this->BaseCalculoIncidencia;
    }
    /**
     * Set BaseCalculoIncidencia value
     * @param float $baseCalculoIncidencia
     * @return \StructType\LinhasDocERP
     */
    public function setBaseCalculoIncidencia($baseCalculoIncidencia = null)
    {
        $this->BaseCalculoIncidencia = $baseCalculoIncidencia;
        return $this;
    }
    /**
     * Get BaseIncidencia value
     * @return float|null
     */
    public function getBaseIncidencia()
    {
        return $this->BaseIncidencia;
    }
    /**
     * Set BaseIncidencia value
     * @param float $baseIncidencia
     * @return \StructType\LinhasDocERP
     */
    public function setBaseIncidencia($baseIncidencia = null)
    {
        $this->BaseIncidencia = $baseIncidencia;
        return $this;
    }
    /**
     * Get CCustoCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCCustoCBL()
    {
        return isset($this->CCustoCBL) ? $this->CCustoCBL : null;
    }
    /**
     * Set CCustoCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cCustoCBL
     * @return \StructType\LinhasDocERP
     */
    public function setCCustoCBL($cCustoCBL = null)
    {
        // validation for constraint: string
        if (!is_null($cCustoCBL) && !is_string($cCustoCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cCustoCBL)), __LINE__);
        }
        if (is_null($cCustoCBL) || (is_array($cCustoCBL) && empty($cCustoCBL))) {
            unset($this->CCustoCBL);
        } else {
            $this->CCustoCBL = $cCustoCBL;
        }
        return $this;
    }
    /**
     * Get CDU_LinVar1ENC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_LinVar1ENC()
    {
        return isset($this->CDU_LinVar1ENC) ? $this->CDU_LinVar1ENC : null;
    }
    /**
     * Set CDU_LinVar1ENC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_LinVar1ENC
     * @return \StructType\LinhasDocERP
     */
    public function setCDU_LinVar1ENC($cDU_LinVar1ENC = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_LinVar1ENC) && !is_string($cDU_LinVar1ENC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_LinVar1ENC)), __LINE__);
        }
        if (is_null($cDU_LinVar1ENC) || (is_array($cDU_LinVar1ENC) && empty($cDU_LinVar1ENC))) {
            unset($this->CDU_LinVar1ENC);
        } else {
            $this->CDU_LinVar1ENC = $cDU_LinVar1ENC;
        }
        return $this;
    }
    /**
     * Get CDU_LinVar2ENC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_LinVar2ENC()
    {
        return isset($this->CDU_LinVar2ENC) ? $this->CDU_LinVar2ENC : null;
    }
    /**
     * Set CDU_LinVar2ENC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_LinVar2ENC
     * @return \StructType\LinhasDocERP
     */
    public function setCDU_LinVar2ENC($cDU_LinVar2ENC = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_LinVar2ENC) && !is_string($cDU_LinVar2ENC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_LinVar2ENC)), __LINE__);
        }
        if (is_null($cDU_LinVar2ENC) || (is_array($cDU_LinVar2ENC) && empty($cDU_LinVar2ENC))) {
            unset($this->CDU_LinVar2ENC);
        } else {
            $this->CDU_LinVar2ENC = $cDU_LinVar2ENC;
        }
        return $this;
    }
    /**
     * Get CDU_LinVar3ENC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_LinVar3ENC()
    {
        return isset($this->CDU_LinVar3ENC) ? $this->CDU_LinVar3ENC : null;
    }
    /**
     * Set CDU_LinVar3ENC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_LinVar3ENC
     * @return \StructType\LinhasDocERP
     */
    public function setCDU_LinVar3ENC($cDU_LinVar3ENC = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_LinVar3ENC) && !is_string($cDU_LinVar3ENC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_LinVar3ENC)), __LINE__);
        }
        if (is_null($cDU_LinVar3ENC) || (is_array($cDU_LinVar3ENC) && empty($cDU_LinVar3ENC))) {
            unset($this->CDU_LinVar3ENC);
        } else {
            $this->CDU_LinVar3ENC = $cDU_LinVar3ENC;
        }
        return $this;
    }
    /**
     * Get CDU_LinVar4ENC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_LinVar4ENC()
    {
        return isset($this->CDU_LinVar4ENC) ? $this->CDU_LinVar4ENC : null;
    }
    /**
     * Set CDU_LinVar4ENC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_LinVar4ENC
     * @return \StructType\LinhasDocERP
     */
    public function setCDU_LinVar4ENC($cDU_LinVar4ENC = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_LinVar4ENC) && !is_string($cDU_LinVar4ENC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_LinVar4ENC)), __LINE__);
        }
        if (is_null($cDU_LinVar4ENC) || (is_array($cDU_LinVar4ENC) && empty($cDU_LinVar4ENC))) {
            unset($this->CDU_LinVar4ENC);
        } else {
            $this->CDU_LinVar4ENC = $cDU_LinVar4ENC;
        }
        return $this;
    }
    /**
     * Get CDU_LinVar5ENC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_LinVar5ENC()
    {
        return isset($this->CDU_LinVar5ENC) ? $this->CDU_LinVar5ENC : null;
    }
    /**
     * Set CDU_LinVar5ENC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_LinVar5ENC
     * @return \StructType\LinhasDocERP
     */
    public function setCDU_LinVar5ENC($cDU_LinVar5ENC = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_LinVar5ENC) && !is_string($cDU_LinVar5ENC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_LinVar5ENC)), __LINE__);
        }
        if (is_null($cDU_LinVar5ENC) || (is_array($cDU_LinVar5ENC) && empty($cDU_LinVar5ENC))) {
            unset($this->CDU_LinVar5ENC);
        } else {
            $this->CDU_LinVar5ENC = $cDU_LinVar5ENC;
        }
        return $this;
    }
    /**
     * Get CambioDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioDocOrig()
    {
        return isset($this->CambioDocOrig) ? $this->CambioDocOrig : null;
    }
    /**
     * Set CambioDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioDocOrig
     * @return \StructType\LinhasDocERP
     */
    public function setCambioDocOrig($cambioDocOrig = null)
    {
        if (is_null($cambioDocOrig) || (is_array($cambioDocOrig) && empty($cambioDocOrig))) {
            unset($this->CambioDocOrig);
        } else {
            $this->CambioDocOrig = $cambioDocOrig;
        }
        return $this;
    }
    /**
     * Get CambioMAltDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMAltDocOrig()
    {
        return isset($this->CambioMAltDocOrig) ? $this->CambioMAltDocOrig : null;
    }
    /**
     * Set CambioMAltDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMAltDocOrig
     * @return \StructType\LinhasDocERP
     */
    public function setCambioMAltDocOrig($cambioMAltDocOrig = null)
    {
        if (is_null($cambioMAltDocOrig) || (is_array($cambioMAltDocOrig) && empty($cambioMAltDocOrig))) {
            unset($this->CambioMAltDocOrig);
        } else {
            $this->CambioMAltDocOrig = $cambioMAltDocOrig;
        }
        return $this;
    }
    /**
     * Get CambioMBaseDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getCambioMBaseDocOrig()
    {
        return isset($this->CambioMBaseDocOrig) ? $this->CambioMBaseDocOrig : null;
    }
    /**
     * Set CambioMBaseDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $cambioMBaseDocOrig
     * @return \StructType\LinhasDocERP
     */
    public function setCambioMBaseDocOrig($cambioMBaseDocOrig = null)
    {
        if (is_null($cambioMBaseDocOrig) || (is_array($cambioMBaseDocOrig) && empty($cambioMBaseDocOrig))) {
            unset($this->CambioMBaseDocOrig);
        } else {
            $this->CambioMBaseDocOrig = $cambioMBaseDocOrig;
        }
        return $this;
    }
    /**
     * Get CategoriaID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getCategoriaID()
    {
        return isset($this->CategoriaID) ? $this->CategoriaID : null;
    }
    /**
     * Set CategoriaID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $categoriaID
     * @return \StructType\LinhasDocERP
     */
    public function setCategoriaID($categoriaID = null)
    {
        // validation for constraint: int
        if (!is_null($categoriaID) && !is_numeric($categoriaID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($categoriaID)), __LINE__);
        }
        if (is_null($categoriaID) || (is_array($categoriaID) && empty($categoriaID))) {
            unset($this->CategoriaID);
        } else {
            $this->CategoriaID = $categoriaID;
        }
        return $this;
    }
    /**
     * Get ClasseID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getClasseID()
    {
        return isset($this->ClasseID) ? $this->ClasseID : null;
    }
    /**
     * Set ClasseID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $classeID
     * @return \StructType\LinhasDocERP
     */
    public function setClasseID($classeID = null)
    {
        // validation for constraint: int
        if (!is_null($classeID) && !is_numeric($classeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($classeID)), __LINE__);
        }
        if (is_null($classeID) || (is_array($classeID) && empty($classeID))) {
            unset($this->ClasseID);
        } else {
            $this->ClasseID = $classeID;
        }
        return $this;
    }
    /**
     * Get CodIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIva()
    {
        return isset($this->CodIva) ? $this->CodIva : null;
    }
    /**
     * Set CodIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIva
     * @return \StructType\LinhasDocERP
     */
    public function setCodIva($codIva = null)
    {
        // validation for constraint: string
        if (!is_null($codIva) && !is_string($codIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIva)), __LINE__);
        }
        if (is_null($codIva) || (is_array($codIva) && empty($codIva))) {
            unset($this->CodIva);
        } else {
            $this->CodIva = $codIva;
        }
        return $this;
    }
    /**
     * Get CodIvaEcotaxa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIvaEcotaxa()
    {
        return isset($this->CodIvaEcotaxa) ? $this->CodIvaEcotaxa : null;
    }
    /**
     * Set CodIvaEcotaxa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIvaEcotaxa
     * @return \StructType\LinhasDocERP
     */
    public function setCodIvaEcotaxa($codIvaEcotaxa = null)
    {
        // validation for constraint: string
        if (!is_null($codIvaEcotaxa) && !is_string($codIvaEcotaxa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIvaEcotaxa)), __LINE__);
        }
        if (is_null($codIvaEcotaxa) || (is_array($codIvaEcotaxa) && empty($codIvaEcotaxa))) {
            unset($this->CodIvaEcotaxa);
        } else {
            $this->CodIvaEcotaxa = $codIvaEcotaxa;
        }
        return $this;
    }
    /**
     * Get CodIvaIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodIvaIEC()
    {
        return isset($this->CodIvaIEC) ? $this->CodIvaIEC : null;
    }
    /**
     * Set CodIvaIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codIvaIEC
     * @return \StructType\LinhasDocERP
     */
    public function setCodIvaIEC($codIvaIEC = null)
    {
        // validation for constraint: string
        if (!is_null($codIvaIEC) && !is_string($codIvaIEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codIvaIEC)), __LINE__);
        }
        if (is_null($codIvaIEC) || (is_array($codIvaIEC) && empty($codIvaIEC))) {
            unset($this->CodIvaIEC);
        } else {
            $this->CodIvaIEC = $codIvaIEC;
        }
        return $this;
    }
    /**
     * Get Comissao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getComissao()
    {
        return isset($this->Comissao) ? $this->Comissao : null;
    }
    /**
     * Set Comissao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $comissao
     * @return \StructType\LinhasDocERP
     */
    public function setComissao($comissao = null)
    {
        if (is_null($comissao) || (is_array($comissao) && empty($comissao))) {
            unset($this->Comissao);
        } else {
            $this->Comissao = $comissao;
        }
        return $this;
    }
    /**
     * Get ContaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCBL()
    {
        return isset($this->ContaCBL) ? $this->ContaCBL : null;
    }
    /**
     * Set ContaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCBL
     * @return \StructType\LinhasDocERP
     */
    public function setContaCBL($contaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($contaCBL) && !is_string($contaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaCBL)), __LINE__);
        }
        if (is_null($contaCBL) || (is_array($contaCBL) && empty($contaCBL))) {
            unset($this->ContaCBL);
        } else {
            $this->ContaCBL = $contaCBL;
        }
        return $this;
    }
    /**
     * Get ContaOrcamCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaOrcamCBL()
    {
        return isset($this->ContaOrcamCBL) ? $this->ContaOrcamCBL : null;
    }
    /**
     * Set ContaOrcamCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaOrcamCBL
     * @return \StructType\LinhasDocERP
     */
    public function setContaOrcamCBL($contaOrcamCBL = null)
    {
        // validation for constraint: string
        if (!is_null($contaOrcamCBL) && !is_string($contaOrcamCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaOrcamCBL)), __LINE__);
        }
        if (is_null($contaOrcamCBL) || (is_array($contaOrcamCBL) && empty($contaOrcamCBL))) {
            unset($this->ContaOrcamCBL);
        } else {
            $this->ContaOrcamCBL = $contaOrcamCBL;
        }
        return $this;
    }
    /**
     * Get ContratoID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContratoID()
    {
        return isset($this->ContratoID) ? $this->ContratoID : null;
    }
    /**
     * Set ContratoID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contratoID
     * @return \StructType\LinhasDocERP
     */
    public function setContratoID($contratoID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($contratoID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $contratoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($contratoID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($contratoID) && !is_string($contratoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contratoID)), __LINE__);
        }
        if (is_null($contratoID) || (is_array($contratoID) && empty($contratoID))) {
            unset($this->ContratoID);
        } else {
            $this->ContratoID = $contratoID;
        }
        return $this;
    }
    /**
     * Get CustoPrevisto value
     * @return float|null
     */
    public function getCustoPrevisto()
    {
        return $this->CustoPrevisto;
    }
    /**
     * Set CustoPrevisto value
     * @param float $custoPrevisto
     * @return \StructType\LinhasDocERP
     */
    public function setCustoPrevisto($custoPrevisto = null)
    {
        $this->CustoPrevisto = $custoPrevisto;
        return $this;
    }
    /**
     * Get Data value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getData()
    {
        return isset($this->Data) ? $this->Data : null;
    }
    /**
     * Set Data value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $data
     * @return \StructType\LinhasDocERP
     */
    public function setData($data = null)
    {
        // validation for constraint: string
        if (!is_null($data) && !is_string($data)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($data)), __LINE__);
        }
        if (is_null($data) || (is_array($data) && empty($data))) {
            unset($this->Data);
        } else {
            $this->Data = $data;
        }
        return $this;
    }
    /**
     * Get DataEntrega value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataEntrega()
    {
        return isset($this->DataEntrega) ? $this->DataEntrega : null;
    }
    /**
     * Set DataEntrega value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataEntrega
     * @return \StructType\LinhasDocERP
     */
    public function setDataEntrega($dataEntrega = null)
    {
        // validation for constraint: string
        if (!is_null($dataEntrega) && !is_string($dataEntrega)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataEntrega)), __LINE__);
        }
        if (is_null($dataEntrega) || (is_array($dataEntrega) && empty($dataEntrega))) {
            unset($this->DataEntrega);
        } else {
            $this->DataEntrega = $dataEntrega;
        }
        return $this;
    }
    /**
     * Get DataSaida value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataSaida()
    {
        return isset($this->DataSaida) ? $this->DataSaida : null;
    }
    /**
     * Set DataSaida value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataSaida
     * @return \StructType\LinhasDocERP
     */
    public function setDataSaida($dataSaida = null)
    {
        // validation for constraint: string
        if (!is_null($dataSaida) && !is_string($dataSaida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataSaida)), __LINE__);
        }
        if (is_null($dataSaida) || (is_array($dataSaida) && empty($dataSaida))) {
            unset($this->DataSaida);
        } else {
            $this->DataSaida = $dataSaida;
        }
        return $this;
    }
    /**
     * Get Desconto1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDesconto1()
    {
        return isset($this->Desconto1) ? $this->Desconto1 : null;
    }
    /**
     * Set Desconto1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $desconto1
     * @return \StructType\LinhasDocERP
     */
    public function setDesconto1($desconto1 = null)
    {
        if (is_null($desconto1) || (is_array($desconto1) && empty($desconto1))) {
            unset($this->Desconto1);
        } else {
            $this->Desconto1 = $desconto1;
        }
        return $this;
    }
    /**
     * Get Desconto2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDesconto2()
    {
        return isset($this->Desconto2) ? $this->Desconto2 : null;
    }
    /**
     * Set Desconto2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $desconto2
     * @return \StructType\LinhasDocERP
     */
    public function setDesconto2($desconto2 = null)
    {
        if (is_null($desconto2) || (is_array($desconto2) && empty($desconto2))) {
            unset($this->Desconto2);
        } else {
            $this->Desconto2 = $desconto2;
        }
        return $this;
    }
    /**
     * Get Desconto3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDesconto3()
    {
        return isset($this->Desconto3) ? $this->Desconto3 : null;
    }
    /**
     * Set Desconto3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $desconto3
     * @return \StructType\LinhasDocERP
     */
    public function setDesconto3($desconto3 = null)
    {
        if (is_null($desconto3) || (is_array($desconto3) && empty($desconto3))) {
            unset($this->Desconto3);
        } else {
            $this->Desconto3 = $desconto3;
        }
        return $this;
    }
    /**
     * Get DescontoComercial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDescontoComercial()
    {
        return isset($this->DescontoComercial) ? $this->DescontoComercial : null;
    }
    /**
     * Set DescontoComercial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $descontoComercial
     * @return \StructType\LinhasDocERP
     */
    public function setDescontoComercial($descontoComercial = null)
    {
        if (is_null($descontoComercial) || (is_array($descontoComercial) && empty($descontoComercial))) {
            unset($this->DescontoComercial);
        } else {
            $this->DescontoComercial = $descontoComercial;
        }
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\LinhasDocERP
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get Devolucao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDevolucao()
    {
        return isset($this->Devolucao) ? $this->Devolucao : null;
    }
    /**
     * Set Devolucao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $devolucao
     * @return \StructType\LinhasDocERP
     */
    public function setDevolucao($devolucao = null)
    {
        // validation for constraint: boolean
        if (!is_null($devolucao) && !is_bool($devolucao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($devolucao)), __LINE__);
        }
        if (is_null($devolucao) || (is_array($devolucao) && empty($devolucao))) {
            unset($this->Devolucao);
        } else {
            $this->Devolucao = $devolucao;
        }
        return $this;
    }
    /**
     * Get DifArredondamentoMAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamentoMAlt()
    {
        return isset($this->DifArredondamentoMAlt) ? $this->DifArredondamentoMAlt : null;
    }
    /**
     * Set DifArredondamentoMAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamentoMAlt
     * @return \StructType\LinhasDocERP
     */
    public function setDifArredondamentoMAlt($difArredondamentoMAlt = null)
    {
        if (is_null($difArredondamentoMAlt) || (is_array($difArredondamentoMAlt) && empty($difArredondamentoMAlt))) {
            unset($this->DifArredondamentoMAlt);
        } else {
            $this->DifArredondamentoMAlt = $difArredondamentoMAlt;
        }
        return $this;
    }
    /**
     * Get DifArredondamentoMBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifArredondamentoMBase()
    {
        return isset($this->DifArredondamentoMBase) ? $this->DifArredondamentoMBase : null;
    }
    /**
     * Set DifArredondamentoMBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difArredondamentoMBase
     * @return \StructType\LinhasDocERP
     */
    public function setDifArredondamentoMBase($difArredondamentoMBase = null)
    {
        if (is_null($difArredondamentoMBase) || (is_array($difArredondamentoMBase) && empty($difArredondamentoMBase))) {
            unset($this->DifArredondamentoMBase);
        } else {
            $this->DifArredondamentoMBase = $difArredondamentoMBase;
        }
        return $this;
    }
    /**
     * Get DifCambioMAlt value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifCambioMAlt()
    {
        return isset($this->DifCambioMAlt) ? $this->DifCambioMAlt : null;
    }
    /**
     * Set DifCambioMAlt value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difCambioMAlt
     * @return \StructType\LinhasDocERP
     */
    public function setDifCambioMAlt($difCambioMAlt = null)
    {
        if (is_null($difCambioMAlt) || (is_array($difCambioMAlt) && empty($difCambioMAlt))) {
            unset($this->DifCambioMAlt);
        } else {
            $this->DifCambioMAlt = $difCambioMAlt;
        }
        return $this;
    }
    /**
     * Get DifCambioMBase value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifCambioMBase()
    {
        return isset($this->DifCambioMBase) ? $this->DifCambioMBase : null;
    }
    /**
     * Set DifCambioMBase value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difCambioMBase
     * @return \StructType\LinhasDocERP
     */
    public function setDifCambioMBase($difCambioMBase = null)
    {
        if (is_null($difCambioMBase) || (is_array($difCambioMBase) && empty($difCambioMBase))) {
            unset($this->DifCambioMBase);
        } else {
            $this->DifCambioMBase = $difCambioMBase;
        }
        return $this;
    }
    /**
     * Get DifPCMedio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getDifPCMedio()
    {
        return isset($this->DifPCMedio) ? $this->DifPCMedio : null;
    }
    /**
     * Set DifPCMedio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $difPCMedio
     * @return \StructType\LinhasDocERP
     */
    public function setDifPCMedio($difPCMedio = null)
    {
        if (is_null($difPCMedio) || (is_array($difPCMedio) && empty($difPCMedio))) {
            unset($this->DifPCMedio);
        } else {
            $this->DifPCMedio = $difPCMedio;
        }
        return $this;
    }
    /**
     * Get Ecotaxa value
     * @return float|null
     */
    public function getEcotaxa()
    {
        return $this->Ecotaxa;
    }
    /**
     * Set Ecotaxa value
     * @param float $ecotaxa
     * @return \StructType\LinhasDocERP
     */
    public function setEcotaxa($ecotaxa = null)
    {
        $this->Ecotaxa = $ecotaxa;
        return $this;
    }
    /**
     * Get EstadoAdi value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoAdi()
    {
        return isset($this->EstadoAdi) ? $this->EstadoAdi : null;
    }
    /**
     * Set EstadoAdi value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoAdi
     * @return \StructType\LinhasDocERP
     */
    public function setEstadoAdi($estadoAdi = null)
    {
        // validation for constraint: string
        if (!is_null($estadoAdi) && !is_string($estadoAdi)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoAdi)), __LINE__);
        }
        if (is_null($estadoAdi) || (is_array($estadoAdi) && empty($estadoAdi))) {
            unset($this->EstadoAdi);
        } else {
            $this->EstadoAdi = $estadoAdi;
        }
        return $this;
    }
    /**
     * Get EstadoPendente value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstadoPendente()
    {
        return isset($this->EstadoPendente) ? $this->EstadoPendente : null;
    }
    /**
     * Set EstadoPendente value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estadoPendente
     * @return \StructType\LinhasDocERP
     */
    public function setEstadoPendente($estadoPendente = null)
    {
        // validation for constraint: string
        if (!is_null($estadoPendente) && !is_string($estadoPendente)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estadoPendente)), __LINE__);
        }
        if (is_null($estadoPendente) || (is_array($estadoPendente) && empty($estadoPendente))) {
            unset($this->EstadoPendente);
        } else {
            $this->EstadoPendente = $estadoPendente;
        }
        return $this;
    }
    /**
     * Get FactorConv value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getFactorConv()
    {
        return isset($this->FactorConv) ? $this->FactorConv : null;
    }
    /**
     * Set FactorConv value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $factorConv
     * @return \StructType\LinhasDocERP
     */
    public function setFactorConv($factorConv = null)
    {
        if (is_null($factorConv) || (is_array($factorConv) && empty($factorConv))) {
            unset($this->FactorConv);
        } else {
            $this->FactorConv = $factorConv;
        }
        return $this;
    }
    /**
     * Get Formula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFormula()
    {
        return isset($this->Formula) ? $this->Formula : null;
    }
    /**
     * Set Formula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $formula
     * @return \StructType\LinhasDocERP
     */
    public function setFormula($formula = null)
    {
        // validation for constraint: string
        if (!is_null($formula) && !is_string($formula)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($formula)), __LINE__);
        }
        if (is_null($formula) || (is_array($formula) && empty($formula))) {
            unset($this->Formula);
        } else {
            $this->Formula = $formula;
        }
        return $this;
    }
    /**
     * Get FuncionalCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFuncionalCBL()
    {
        return isset($this->FuncionalCBL) ? $this->FuncionalCBL : null;
    }
    /**
     * Set FuncionalCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $funcionalCBL
     * @return \StructType\LinhasDocERP
     */
    public function setFuncionalCBL($funcionalCBL = null)
    {
        // validation for constraint: string
        if (!is_null($funcionalCBL) && !is_string($funcionalCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($funcionalCBL)), __LINE__);
        }
        if (is_null($funcionalCBL) || (is_array($funcionalCBL) && empty($funcionalCBL))) {
            unset($this->FuncionalCBL);
        } else {
            $this->FuncionalCBL = $funcionalCBL;
        }
        return $this;
    }
    /**
     * Get IDB2BLinhaOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDB2BLinhaOrig()
    {
        return isset($this->IDB2BLinhaOrig) ? $this->IDB2BLinhaOrig : null;
    }
    /**
     * Set IDB2BLinhaOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDB2BLinhaOrig
     * @return \StructType\LinhasDocERP
     */
    public function setIDB2BLinhaOrig($iDB2BLinhaOrig = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDB2BLinhaOrig) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDB2BLinhaOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDB2BLinhaOrig, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDB2BLinhaOrig) && !is_string($iDB2BLinhaOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDB2BLinhaOrig)), __LINE__);
        }
        if (is_null($iDB2BLinhaOrig) || (is_array($iDB2BLinhaOrig) && empty($iDB2BLinhaOrig))) {
            unset($this->IDB2BLinhaOrig);
        } else {
            $this->IDB2BLinhaOrig = $iDB2BLinhaOrig;
        }
        return $this;
    }
    /**
     * Get IDLinhaEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDLinhaEstorno()
    {
        return isset($this->IDLinhaEstorno) ? $this->IDLinhaEstorno : null;
    }
    /**
     * Set IDLinhaEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDLinhaEstorno
     * @return \StructType\LinhasDocERP
     */
    public function setIDLinhaEstorno($iDLinhaEstorno = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDLinhaEstorno) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDLinhaEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDLinhaEstorno, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDLinhaEstorno) && !is_string($iDLinhaEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDLinhaEstorno)), __LINE__);
        }
        if (is_null($iDLinhaEstorno) || (is_array($iDLinhaEstorno) && empty($iDLinhaEstorno))) {
            unset($this->IDLinhaEstorno);
        } else {
            $this->IDLinhaEstorno = $iDLinhaEstorno;
        }
        return $this;
    }
    /**
     * Get Id value
     * @return string|null
     */
    public function getId()
    {
        return $this->Id;
    }
    /**
     * Set Id value
     * @param string $id
     * @return \StructType\LinhasDocERP
     */
    public function setId($id = null)
    {
        // validation for constraint: pattern
        if (is_scalar($id) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($id, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($id) && !is_string($id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($id)), __LINE__);
        }
        $this->Id = $id;
        return $this;
    }
    /**
     * Get IdCabecDoc value
     * @return string|null
     */
    public function getIdCabecDoc()
    {
        return $this->IdCabecDoc;
    }
    /**
     * Set IdCabecDoc value
     * @param string $idCabecDoc
     * @return \StructType\LinhasDocERP
     */
    public function setIdCabecDoc($idCabecDoc = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCabecDoc) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCabecDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCabecDoc, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCabecDoc) && !is_string($idCabecDoc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCabecDoc)), __LINE__);
        }
        $this->IdCabecDoc = $idCabecDoc;
        return $this;
    }
    /**
     * Get IdHistorico value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdHistorico()
    {
        return isset($this->IdHistorico) ? $this->IdHistorico : null;
    }
    /**
     * Set IdHistorico value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idHistorico
     * @return \StructType\LinhasDocERP
     */
    public function setIdHistorico($idHistorico = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idHistorico) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idHistorico, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idHistorico) && !is_string($idHistorico)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idHistorico)), __LINE__);
        }
        if (is_null($idHistorico) || (is_array($idHistorico) && empty($idHistorico))) {
            unset($this->IdHistorico);
        } else {
            $this->IdHistorico = $idHistorico;
        }
        return $this;
    }
    /**
     * Get IdLinhaOrigemCopia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhaOrigemCopia()
    {
        return isset($this->IdLinhaOrigemCopia) ? $this->IdLinhaOrigemCopia : null;
    }
    /**
     * Set IdLinhaOrigemCopia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhaOrigemCopia
     * @return \StructType\LinhasDocERP
     */
    public function setIdLinhaOrigemCopia($idLinhaOrigemCopia = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhaOrigemCopia) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhaOrigemCopia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhaOrigemCopia, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhaOrigemCopia) && !is_string($idLinhaOrigemCopia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhaOrigemCopia)), __LINE__);
        }
        if (is_null($idLinhaOrigemCopia) || (is_array($idLinhaOrigemCopia) && empty($idLinhaOrigemCopia))) {
            unset($this->IdLinhaOrigemCopia);
        } else {
            $this->IdLinhaOrigemCopia = $idLinhaOrigemCopia;
        }
        return $this;
    }
    /**
     * Get IdLinhaPai value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdLinhaPai()
    {
        return isset($this->IdLinhaPai) ? $this->IdLinhaPai : null;
    }
    /**
     * Set IdLinhaPai value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idLinhaPai
     * @return \StructType\LinhasDocERP
     */
    public function setIdLinhaPai($idLinhaPai = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idLinhaPai) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idLinhaPai)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idLinhaPai, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idLinhaPai) && !is_string($idLinhaPai)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idLinhaPai)), __LINE__);
        }
        if (is_null($idLinhaPai) || (is_array($idLinhaPai) && empty($idLinhaPai))) {
            unset($this->IdLinhaPai);
        } else {
            $this->IdLinhaPai = $idLinhaPai;
        }
        return $this;
    }
    /**
     * Get IncidenciaIS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIncidenciaIS()
    {
        return isset($this->IncidenciaIS) ? $this->IncidenciaIS : null;
    }
    /**
     * Set IncidenciaIS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $incidenciaIS
     * @return \StructType\LinhasDocERP
     */
    public function setIncidenciaIS($incidenciaIS = null)
    {
        if (is_null($incidenciaIS) || (is_array($incidenciaIS) && empty($incidenciaIS))) {
            unset($this->IncidenciaIS);
        } else {
            $this->IncidenciaIS = $incidenciaIS;
        }
        return $this;
    }
    /**
     * Get IntrastatMassaLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIntrastatMassaLiq()
    {
        return isset($this->IntrastatMassaLiq) ? $this->IntrastatMassaLiq : null;
    }
    /**
     * Set IntrastatMassaLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $intrastatMassaLiq
     * @return \StructType\LinhasDocERP
     */
    public function setIntrastatMassaLiq($intrastatMassaLiq = null)
    {
        if (is_null($intrastatMassaLiq) || (is_array($intrastatMassaLiq) && empty($intrastatMassaLiq))) {
            unset($this->IntrastatMassaLiq);
        } else {
            $this->IntrastatMassaLiq = $intrastatMassaLiq;
        }
        return $this;
    }
    /**
     * Get IntrastatPaisOrigem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntrastatPaisOrigem()
    {
        return isset($this->IntrastatPaisOrigem) ? $this->IntrastatPaisOrigem : null;
    }
    /**
     * Set IntrastatPaisOrigem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intrastatPaisOrigem
     * @return \StructType\LinhasDocERP
     */
    public function setIntrastatPaisOrigem($intrastatPaisOrigem = null)
    {
        // validation for constraint: string
        if (!is_null($intrastatPaisOrigem) && !is_string($intrastatPaisOrigem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intrastatPaisOrigem)), __LINE__);
        }
        if (is_null($intrastatPaisOrigem) || (is_array($intrastatPaisOrigem) && empty($intrastatPaisOrigem))) {
            unset($this->IntrastatPaisOrigem);
        } else {
            $this->IntrastatPaisOrigem = $intrastatPaisOrigem;
        }
        return $this;
    }
    /**
     * Get IntrastatPautal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntrastatPautal()
    {
        return isset($this->IntrastatPautal) ? $this->IntrastatPautal : null;
    }
    /**
     * Set IntrastatPautal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intrastatPautal
     * @return \StructType\LinhasDocERP
     */
    public function setIntrastatPautal($intrastatPautal = null)
    {
        // validation for constraint: string
        if (!is_null($intrastatPautal) && !is_string($intrastatPautal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intrastatPautal)), __LINE__);
        }
        if (is_null($intrastatPautal) || (is_array($intrastatPautal) && empty($intrastatPautal))) {
            unset($this->IntrastatPautal);
        } else {
            $this->IntrastatPautal = $intrastatPautal;
        }
        return $this;
    }
    /**
     * Get IntrastatRegiao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIntrastatRegiao()
    {
        return isset($this->IntrastatRegiao) ? $this->IntrastatRegiao : null;
    }
    /**
     * Set IntrastatRegiao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $intrastatRegiao
     * @return \StructType\LinhasDocERP
     */
    public function setIntrastatRegiao($intrastatRegiao = null)
    {
        // validation for constraint: string
        if (!is_null($intrastatRegiao) && !is_string($intrastatRegiao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($intrastatRegiao)), __LINE__);
        }
        if (is_null($intrastatRegiao) || (is_array($intrastatRegiao) && empty($intrastatRegiao))) {
            unset($this->IntrastatRegiao);
        } else {
            $this->IntrastatRegiao = $intrastatRegiao;
        }
        return $this;
    }
    /**
     * Get IntrastatValorLiq value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getIntrastatValorLiq()
    {
        return isset($this->IntrastatValorLiq) ? $this->IntrastatValorLiq : null;
    }
    /**
     * Set IntrastatValorLiq value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $intrastatValorLiq
     * @return \StructType\LinhasDocERP
     */
    public function setIntrastatValorLiq($intrastatValorLiq = null)
    {
        if (is_null($intrastatValorLiq) || (is_array($intrastatValorLiq) && empty($intrastatValorLiq))) {
            unset($this->IntrastatValorLiq);
        } else {
            $this->IntrastatValorLiq = $intrastatValorLiq;
        }
        return $this;
    }
    /**
     * Get ItemCod value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemCod()
    {
        return isset($this->ItemCod) ? $this->ItemCod : null;
    }
    /**
     * Set ItemCod value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemCod
     * @return \StructType\LinhasDocERP
     */
    public function setItemCod($itemCod = null)
    {
        // validation for constraint: string
        if (!is_null($itemCod) && !is_string($itemCod)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemCod)), __LINE__);
        }
        if (is_null($itemCod) || (is_array($itemCod) && empty($itemCod))) {
            unset($this->ItemCod);
        } else {
            $this->ItemCod = $itemCod;
        }
        return $this;
    }
    /**
     * Get ItemDesc value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getItemDesc()
    {
        return isset($this->ItemDesc) ? $this->ItemDesc : null;
    }
    /**
     * Set ItemDesc value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $itemDesc
     * @return \StructType\LinhasDocERP
     */
    public function setItemDesc($itemDesc = null)
    {
        // validation for constraint: string
        if (!is_null($itemDesc) && !is_string($itemDesc)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($itemDesc)), __LINE__);
        }
        if (is_null($itemDesc) || (is_array($itemDesc) && empty($itemDesc))) {
            unset($this->ItemDesc);
        } else {
            $this->ItemDesc = $itemDesc;
        }
        return $this;
    }
    /**
     * Get ItemId value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getItemId()
    {
        return isset($this->ItemId) ? $this->ItemId : null;
    }
    /**
     * Set ItemId value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $itemId
     * @return \StructType\LinhasDocERP
     */
    public function setItemId($itemId = null)
    {
        // validation for constraint: int
        if (!is_null($itemId) && !is_numeric($itemId)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($itemId)), __LINE__);
        }
        if (is_null($itemId) || (is_array($itemId) && empty($itemId))) {
            unset($this->ItemId);
        } else {
            $this->ItemId = $itemId;
        }
        return $this;
    }
    /**
     * Get IvaNaoDedutivel value
     * @return float|null
     */
    public function getIvaNaoDedutivel()
    {
        return $this->IvaNaoDedutivel;
    }
    /**
     * Set IvaNaoDedutivel value
     * @param float $ivaNaoDedutivel
     * @return \StructType\LinhasDocERP
     */
    public function setIvaNaoDedutivel($ivaNaoDedutivel = null)
    {
        $this->IvaNaoDedutivel = $ivaNaoDedutivel;
        return $this;
    }
    /**
     * Get IvaRegraCalculo value
     * @return int|null
     */
    public function getIvaRegraCalculo()
    {
        return $this->IvaRegraCalculo;
    }
    /**
     * Set IvaRegraCalculo value
     * @param int $ivaRegraCalculo
     * @return \StructType\LinhasDocERP
     */
    public function setIvaRegraCalculo($ivaRegraCalculo = null)
    {
        // validation for constraint: int
        if (!is_null($ivaRegraCalculo) && !is_numeric($ivaRegraCalculo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($ivaRegraCalculo)), __LINE__);
        }
        $this->IvaRegraCalculo = $ivaRegraCalculo;
        return $this;
    }
    /**
     * Get IvaValorDesconto value
     * @return float|null
     */
    public function getIvaValorDesconto()
    {
        return $this->IvaValorDesconto;
    }
    /**
     * Set IvaValorDesconto value
     * @param float $ivaValorDesconto
     * @return \StructType\LinhasDocERP
     */
    public function setIvaValorDesconto($ivaValorDesconto = null)
    {
        $this->IvaValorDesconto = $ivaValorDesconto;
        return $this;
    }
    /**
     * Get LinhasEstados value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLinhasDocStatusERP|null
     */
    public function getLinhasEstados()
    {
        return isset($this->LinhasEstados) ? $this->LinhasEstados : null;
    }
    /**
     * Set LinhasEstados value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLinhasDocStatusERP $linhasEstados
     * @return \StructType\LinhasDocERP
     */
    public function setLinhasEstados(\ArrayType\ArrayOfLinhasDocStatusERP $linhasEstados = null)
    {
        if (is_null($linhasEstados) || (is_array($linhasEstados) && empty($linhasEstados))) {
            unset($this->LinhasEstados);
        } else {
            $this->LinhasEstados = $linhasEstados;
        }
        return $this;
    }
    /**
     * Get LinhasTrans value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \ArrayType\ArrayOfLinhasDocTransERP|null
     */
    public function getLinhasTrans()
    {
        return isset($this->LinhasTrans) ? $this->LinhasTrans : null;
    }
    /**
     * Set LinhasTrans value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \ArrayType\ArrayOfLinhasDocTransERP $linhasTrans
     * @return \StructType\LinhasDocERP
     */
    public function setLinhasTrans(\ArrayType\ArrayOfLinhasDocTransERP $linhasTrans = null)
    {
        if (is_null($linhasTrans) || (is_array($linhasTrans) && empty($linhasTrans))) {
            unset($this->LinhasTrans);
        } else {
            $this->LinhasTrans = $linhasTrans;
        }
        return $this;
    }
    /**
     * Get Localizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalizacao()
    {
        return isset($this->Localizacao) ? $this->Localizacao : null;
    }
    /**
     * Set Localizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localizacao
     * @return \StructType\LinhasDocERP
     */
    public function setLocalizacao($localizacao = null)
    {
        // validation for constraint: string
        if (!is_null($localizacao) && !is_string($localizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localizacao)), __LINE__);
        }
        if (is_null($localizacao) || (is_array($localizacao) && empty($localizacao))) {
            unset($this->Localizacao);
        } else {
            $this->Localizacao = $localizacao;
        }
        return $this;
    }
    /**
     * Get Lote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLote()
    {
        return isset($this->Lote) ? $this->Lote : null;
    }
    /**
     * Set Lote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lote
     * @return \StructType\LinhasDocERP
     */
    public function setLote($lote = null)
    {
        // validation for constraint: string
        if (!is_null($lote) && !is_string($lote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lote)), __LINE__);
        }
        if (is_null($lote) || (is_array($lote) && empty($lote))) {
            unset($this->Lote);
        } else {
            $this->Lote = $lote;
        }
        return $this;
    }
    /**
     * Get Margem value
     * @return float|null
     */
    public function getMargem()
    {
        return $this->Margem;
    }
    /**
     * Set Margem value
     * @param float $margem
     * @return \StructType\LinhasDocERP
     */
    public function setMargem($margem = null)
    {
        $this->Margem = $margem;
        return $this;
    }
    /**
     * Get ModuloOrigemCopia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModuloOrigemCopia()
    {
        return isset($this->ModuloOrigemCopia) ? $this->ModuloOrigemCopia : null;
    }
    /**
     * Set ModuloOrigemCopia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moduloOrigemCopia
     * @return \StructType\LinhasDocERP
     */
    public function setModuloOrigemCopia($moduloOrigemCopia = null)
    {
        // validation for constraint: string
        if (!is_null($moduloOrigemCopia) && !is_string($moduloOrigemCopia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moduloOrigemCopia)), __LINE__);
        }
        if (is_null($moduloOrigemCopia) || (is_array($moduloOrigemCopia) && empty($moduloOrigemCopia))) {
            unset($this->ModuloOrigemCopia);
        } else {
            $this->ModuloOrigemCopia = $moduloOrigemCopia;
        }
        return $this;
    }
    /**
     * Get MoedaDocOrig value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoedaDocOrig()
    {
        return isset($this->MoedaDocOrig) ? $this->MoedaDocOrig : null;
    }
    /**
     * Set MoedaDocOrig value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moedaDocOrig
     * @return \StructType\LinhasDocERP
     */
    public function setMoedaDocOrig($moedaDocOrig = null)
    {
        // validation for constraint: string
        if (!is_null($moedaDocOrig) && !is_string($moedaDocOrig)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moedaDocOrig)), __LINE__);
        }
        if (is_null($moedaDocOrig) || (is_array($moedaDocOrig) && empty($moedaDocOrig))) {
            unset($this->MoedaDocOrig);
        } else {
            $this->MoedaDocOrig = $moedaDocOrig;
        }
        return $this;
    }
    /**
     * Get MotivoEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoEstorno()
    {
        return isset($this->MotivoEstorno) ? $this->MotivoEstorno : null;
    }
    /**
     * Set MotivoEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoEstorno
     * @return \StructType\LinhasDocERP
     */
    public function setMotivoEstorno($motivoEstorno = null)
    {
        // validation for constraint: string
        if (!is_null($motivoEstorno) && !is_string($motivoEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivoEstorno)), __LINE__);
        }
        if (is_null($motivoEstorno) || (is_array($motivoEstorno) && empty($motivoEstorno))) {
            unset($this->MotivoEstorno);
        } else {
            $this->MotivoEstorno = $motivoEstorno;
        }
        return $this;
    }
    /**
     * Get MovSTK value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovSTK()
    {
        return isset($this->MovSTK) ? $this->MovSTK : null;
    }
    /**
     * Set MovSTK value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movSTK
     * @return \StructType\LinhasDocERP
     */
    public function setMovSTK($movSTK = null)
    {
        // validation for constraint: string
        if (!is_null($movSTK) && !is_string($movSTK)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($movSTK)), __LINE__);
        }
        if (is_null($movSTK) || (is_array($movSTK) && empty($movSTK))) {
            unset($this->MovSTK);
        } else {
            $this->MovSTK = $movSTK;
        }
        return $this;
    }
    /**
     * Get NumLinha value
     * @return int|null
     */
    public function getNumLinha()
    {
        return $this->NumLinha;
    }
    /**
     * Set NumLinha value
     * @param int $numLinha
     * @return \StructType\LinhasDocERP
     */
    public function setNumLinha($numLinha = null)
    {
        // validation for constraint: int
        if (!is_null($numLinha) && !is_numeric($numLinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numLinha)), __LINE__);
        }
        $this->NumLinha = $numLinha;
        return $this;
    }
    /**
     * Get NumLinhaSTKGerada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumLinhaSTKGerada()
    {
        return isset($this->NumLinhaSTKGerada) ? $this->NumLinhaSTKGerada : null;
    }
    /**
     * Set NumLinhaSTKGerada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numLinhaSTKGerada
     * @return \StructType\LinhasDocERP
     */
    public function setNumLinhaSTKGerada($numLinhaSTKGerada = null)
    {
        // validation for constraint: int
        if (!is_null($numLinhaSTKGerada) && !is_numeric($numLinhaSTKGerada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numLinhaSTKGerada)), __LINE__);
        }
        if (is_null($numLinhaSTKGerada) || (is_array($numLinhaSTKGerada) && empty($numLinhaSTKGerada))) {
            unset($this->NumLinhaSTKGerada);
        } else {
            $this->NumLinhaSTKGerada = $numLinhaSTKGerada;
        }
        return $this;
    }
    /**
     * Get ObraID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getObraID()
    {
        return isset($this->ObraID) ? $this->ObraID : null;
    }
    /**
     * Set ObraID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $obraID
     * @return \StructType\LinhasDocERP
     */
    public function setObraID($obraID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($obraID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $obraID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($obraID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($obraID) && !is_string($obraID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($obraID)), __LINE__);
        }
        if (is_null($obraID) || (is_array($obraID) && empty($obraID))) {
            unset($this->ObraID);
        } else {
            $this->ObraID = $obraID;
        }
        return $this;
    }
    /**
     * Get OrganicaCBL value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getOrganicaCBL()
    {
        return isset($this->OrganicaCBL) ? $this->OrganicaCBL : null;
    }
    /**
     * Set OrganicaCBL value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $organicaCBL
     * @return \StructType\LinhasDocERP
     */
    public function setOrganicaCBL($organicaCBL = null)
    {
        // validation for constraint: string
        if (!is_null($organicaCBL) && !is_string($organicaCBL)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($organicaCBL)), __LINE__);
        }
        if (is_null($organicaCBL) || (is_array($organicaCBL) && empty($organicaCBL))) {
            unset($this->OrganicaCBL);
        } else {
            $this->OrganicaCBL = $organicaCBL;
        }
        return $this;
    }
    /**
     * Get PCM value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPCM()
    {
        return isset($this->PCM) ? $this->PCM : null;
    }
    /**
     * Set PCM value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pCM
     * @return \StructType\LinhasDocERP
     */
    public function setPCM($pCM = null)
    {
        if (is_null($pCM) || (is_array($pCM) && empty($pCM))) {
            unset($this->PCM);
        } else {
            $this->PCM = $pCM;
        }
        return $this;
    }
    /**
     * Get PCMDevolucao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPCMDevolucao()
    {
        return isset($this->PCMDevolucao) ? $this->PCMDevolucao : null;
    }
    /**
     * Set PCMDevolucao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $pCMDevolucao
     * @return \StructType\LinhasDocERP
     */
    public function setPCMDevolucao($pCMDevolucao = null)
    {
        if (is_null($pCMDevolucao) || (is_array($pCMDevolucao) && empty($pCMDevolucao))) {
            unset($this->PCMDevolucao);
        } else {
            $this->PCMDevolucao = $pCMDevolucao;
        }
        return $this;
    }
    /**
     * Get PercIncidenciaIVA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPercIncidenciaIVA()
    {
        return isset($this->PercIncidenciaIVA) ? $this->PercIncidenciaIVA : null;
    }
    /**
     * Set PercIncidenciaIVA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $percIncidenciaIVA
     * @return \StructType\LinhasDocERP
     */
    public function setPercIncidenciaIVA($percIncidenciaIVA = null)
    {
        if (is_null($percIncidenciaIVA) || (is_array($percIncidenciaIVA) && empty($percIncidenciaIVA))) {
            unset($this->PercIncidenciaIVA);
        } else {
            $this->PercIncidenciaIVA = $percIncidenciaIVA;
        }
        return $this;
    }
    /**
     * Get PercIvaDedutivel value
     * @return float|null
     */
    public function getPercIvaDedutivel()
    {
        return $this->PercIvaDedutivel;
    }
    /**
     * Set PercIvaDedutivel value
     * @param float $percIvaDedutivel
     * @return \StructType\LinhasDocERP
     */
    public function setPercIvaDedutivel($percIvaDedutivel = null)
    {
        $this->PercIvaDedutivel = $percIvaDedutivel;
        return $this;
    }
    /**
     * Get PercentagemMargem value
     * @return float|null
     */
    public function getPercentagemMargem()
    {
        return $this->PercentagemMargem;
    }
    /**
     * Set PercentagemMargem value
     * @param float $percentagemMargem
     * @return \StructType\LinhasDocERP
     */
    public function setPercentagemMargem($percentagemMargem = null)
    {
        $this->PercentagemMargem = $percentagemMargem;
        return $this;
    }
    /**
     * Get PrecUnit value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrecUnit()
    {
        return isset($this->PrecUnit) ? $this->PrecUnit : null;
    }
    /**
     * Set PrecUnit value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $precUnit
     * @return \StructType\LinhasDocERP
     */
    public function setPrecUnit($precUnit = null)
    {
        if (is_null($precUnit) || (is_array($precUnit) && empty($precUnit))) {
            unset($this->PrecUnit);
        } else {
            $this->PrecUnit = $precUnit;
        }
        return $this;
    }
    /**
     * Get PrecoLiquido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPrecoLiquido()
    {
        return isset($this->PrecoLiquido) ? $this->PrecoLiquido : null;
    }
    /**
     * Set PrecoLiquido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $precoLiquido
     * @return \StructType\LinhasDocERP
     */
    public function setPrecoLiquido($precoLiquido = null)
    {
        if (is_null($precoLiquido) || (is_array($precoLiquido) && empty($precoLiquido))) {
            unset($this->PrecoLiquido);
        } else {
            $this->PrecoLiquido = $precoLiquido;
        }
        return $this;
    }
    /**
     * Get ProcessoID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getProcessoID()
    {
        return isset($this->ProcessoID) ? $this->ProcessoID : null;
    }
    /**
     * Set ProcessoID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $processoID
     * @return \StructType\LinhasDocERP
     */
    public function setProcessoID($processoID = null)
    {
        // validation for constraint: pattern
        if (is_scalar($processoID) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $processoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($processoID, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($processoID) && !is_string($processoID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($processoID)), __LINE__);
        }
        if (is_null($processoID) || (is_array($processoID) && empty($processoID))) {
            unset($this->ProcessoID);
        } else {
            $this->ProcessoID = $processoID;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\LinhasDocERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get QntFormula value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQntFormula()
    {
        return isset($this->QntFormula) ? $this->QntFormula : null;
    }
    /**
     * Set QntFormula value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $qntFormula
     * @return \StructType\LinhasDocERP
     */
    public function setQntFormula($qntFormula = null)
    {
        if (is_null($qntFormula) || (is_array($qntFormula) && empty($qntFormula))) {
            unset($this->QntFormula);
        } else {
            $this->QntFormula = $qntFormula;
        }
        return $this;
    }
    /**
     * Get Quantidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getQuantidade()
    {
        return isset($this->Quantidade) ? $this->Quantidade : null;
    }
    /**
     * Set Quantidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $quantidade
     * @return \StructType\LinhasDocERP
     */
    public function setQuantidade($quantidade = null)
    {
        if (is_null($quantidade) || (is_array($quantidade) && empty($quantidade))) {
            unset($this->Quantidade);
        } else {
            $this->Quantidade = $quantidade;
        }
        return $this;
    }
    /**
     * Get RegimeIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRegimeIva()
    {
        return isset($this->RegimeIva) ? $this->RegimeIva : null;
    }
    /**
     * Set RegimeIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $regimeIva
     * @return \StructType\LinhasDocERP
     */
    public function setRegimeIva($regimeIva = null)
    {
        // validation for constraint: string
        if (!is_null($regimeIva) && !is_string($regimeIva)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regimeIva)), __LINE__);
        }
        if (is_null($regimeIva) || (is_array($regimeIva) && empty($regimeIva))) {
            unset($this->RegimeIva);
        } else {
            $this->RegimeIva = $regimeIva;
        }
        return $this;
    }
    /**
     * Get RegraCalculoIncidencia value
     * @return string|null
     */
    public function getRegraCalculoIncidencia()
    {
        return $this->RegraCalculoIncidencia;
    }
    /**
     * Set RegraCalculoIncidencia value
     * @param string $regraCalculoIncidencia
     * @return \StructType\LinhasDocERP
     */
    public function setRegraCalculoIncidencia($regraCalculoIncidencia = null)
    {
        // validation for constraint: string
        if (!is_null($regraCalculoIncidencia) && !is_string($regraCalculoIncidencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($regraCalculoIncidencia)), __LINE__);
        }
        $this->RegraCalculoIncidencia = $regraCalculoIncidencia;
        return $this;
    }
    /**
     * Get Seccao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSeccao()
    {
        return isset($this->Seccao) ? $this->Seccao : null;
    }
    /**
     * Set Seccao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $seccao
     * @return \StructType\LinhasDocERP
     */
    public function setSeccao($seccao = null)
    {
        // validation for constraint: string
        if (!is_null($seccao) && !is_string($seccao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($seccao)), __LINE__);
        }
        if (is_null($seccao) || (is_array($seccao) && empty($seccao))) {
            unset($this->Seccao);
        } else {
            $this->Seccao = $seccao;
        }
        return $this;
    }
    /**
     * Get Selo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSelo()
    {
        return isset($this->Selo) ? $this->Selo : null;
    }
    /**
     * Set Selo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $selo
     * @return \StructType\LinhasDocERP
     */
    public function setSelo($selo = null)
    {
        // validation for constraint: string
        if (!is_null($selo) && !is_string($selo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($selo)), __LINE__);
        }
        if (is_null($selo) || (is_array($selo) && empty($selo))) {
            unset($this->Selo);
        } else {
            $this->Selo = $selo;
        }
        return $this;
    }
    /**
     * Get SubEmpID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getSubEmpID()
    {
        return isset($this->SubEmpID) ? $this->SubEmpID : null;
    }
    /**
     * Set SubEmpID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $subEmpID
     * @return \StructType\LinhasDocERP
     */
    public function setSubEmpID($subEmpID = null)
    {
        // validation for constraint: int
        if (!is_null($subEmpID) && !is_numeric($subEmpID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($subEmpID)), __LINE__);
        }
        if (is_null($subEmpID) || (is_array($subEmpID) && empty($subEmpID))) {
            unset($this->SubEmpID);
        } else {
            $this->SubEmpID = $subEmpID;
        }
        return $this;
    }
    /**
     * Get SujeitoRetencao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getSujeitoRetencao()
    {
        return isset($this->SujeitoRetencao) ? $this->SujeitoRetencao : null;
    }
    /**
     * Set SujeitoRetencao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $sujeitoRetencao
     * @return \StructType\LinhasDocERP
     */
    public function setSujeitoRetencao($sujeitoRetencao = null)
    {
        // validation for constraint: boolean
        if (!is_null($sujeitoRetencao) && !is_bool($sujeitoRetencao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($sujeitoRetencao)), __LINE__);
        }
        if (is_null($sujeitoRetencao) || (is_array($sujeitoRetencao) && empty($sujeitoRetencao))) {
            unset($this->SujeitoRetencao);
        } else {
            $this->SujeitoRetencao = $sujeitoRetencao;
        }
        return $this;
    }
    /**
     * Get TaxaIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaIva()
    {
        return isset($this->TaxaIva) ? $this->TaxaIva : null;
    }
    /**
     * Set TaxaIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaIva
     * @return \StructType\LinhasDocERP
     */
    public function setTaxaIva($taxaIva = null)
    {
        if (is_null($taxaIva) || (is_array($taxaIva) && empty($taxaIva))) {
            unset($this->TaxaIva);
        } else {
            $this->TaxaIva = $taxaIva;
        }
        return $this;
    }
    /**
     * Get TaxaIvaEcotaxa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaIvaEcotaxa()
    {
        return isset($this->TaxaIvaEcotaxa) ? $this->TaxaIvaEcotaxa : null;
    }
    /**
     * Set TaxaIvaEcotaxa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaIvaEcotaxa
     * @return \StructType\LinhasDocERP
     */
    public function setTaxaIvaEcotaxa($taxaIvaEcotaxa = null)
    {
        if (is_null($taxaIvaEcotaxa) || (is_array($taxaIvaEcotaxa) && empty($taxaIvaEcotaxa))) {
            unset($this->TaxaIvaEcotaxa);
        } else {
            $this->TaxaIvaEcotaxa = $taxaIvaEcotaxa;
        }
        return $this;
    }
    /**
     * Get TaxaIvaIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaIvaIEC()
    {
        return isset($this->TaxaIvaIEC) ? $this->TaxaIvaIEC : null;
    }
    /**
     * Set TaxaIvaIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaIvaIEC
     * @return \StructType\LinhasDocERP
     */
    public function setTaxaIvaIEC($taxaIvaIEC = null)
    {
        if (is_null($taxaIvaIEC) || (is_array($taxaIvaIEC) && empty($taxaIvaIEC))) {
            unset($this->TaxaIvaIEC);
        } else {
            $this->TaxaIvaIEC = $taxaIvaIEC;
        }
        return $this;
    }
    /**
     * Get TaxaRecargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxaRecargo()
    {
        return isset($this->TaxaRecargo) ? $this->TaxaRecargo : null;
    }
    /**
     * Set TaxaRecargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxaRecargo
     * @return \StructType\LinhasDocERP
     */
    public function setTaxaRecargo($taxaRecargo = null)
    {
        if (is_null($taxaRecargo) || (is_array($taxaRecargo) && empty($taxaRecargo))) {
            unset($this->TaxaRecargo);
        } else {
            $this->TaxaRecargo = $taxaRecargo;
        }
        return $this;
    }
    /**
     * Get TipoAuto value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoAuto()
    {
        return isset($this->TipoAuto) ? $this->TipoAuto : null;
    }
    /**
     * Set TipoAuto value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoAuto
     * @return \StructType\LinhasDocERP
     */
    public function setTipoAuto($tipoAuto = null)
    {
        // validation for constraint: string
        if (!is_null($tipoAuto) && !is_string($tipoAuto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoAuto)), __LINE__);
        }
        if (is_null($tipoAuto) || (is_array($tipoAuto) && empty($tipoAuto))) {
            unset($this->TipoAuto);
        } else {
            $this->TipoAuto = $tipoAuto;
        }
        return $this;
    }
    /**
     * Get TipoCustoPrevisto value
     * @return string|null
     */
    public function getTipoCustoPrevisto()
    {
        return $this->TipoCustoPrevisto;
    }
    /**
     * Set TipoCustoPrevisto value
     * @param string $tipoCustoPrevisto
     * @return \StructType\LinhasDocERP
     */
    public function setTipoCustoPrevisto($tipoCustoPrevisto = null)
    {
        // validation for constraint: string
        if (!is_null($tipoCustoPrevisto) && !is_string($tipoCustoPrevisto)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoCustoPrevisto)), __LINE__);
        }
        $this->TipoCustoPrevisto = $tipoCustoPrevisto;
        return $this;
    }
    /**
     * Get TipoLinha value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoLinha()
    {
        return isset($this->TipoLinha) ? $this->TipoLinha : null;
    }
    /**
     * Set TipoLinha value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoLinha
     * @return \StructType\LinhasDocERP
     */
    public function setTipoLinha($tipoLinha = null)
    {
        // validation for constraint: string
        if (!is_null($tipoLinha) && !is_string($tipoLinha)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoLinha)), __LINE__);
        }
        if (is_null($tipoLinha) || (is_array($tipoLinha) && empty($tipoLinha))) {
            unset($this->TipoLinha);
        } else {
            $this->TipoLinha = $tipoLinha;
        }
        return $this;
    }
    /**
     * Get TipoOperacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoOperacao()
    {
        return isset($this->TipoOperacao) ? $this->TipoOperacao : null;
    }
    /**
     * Set TipoOperacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoOperacao
     * @return \StructType\LinhasDocERP
     */
    public function setTipoOperacao($tipoOperacao = null)
    {
        // validation for constraint: string
        if (!is_null($tipoOperacao) && !is_string($tipoOperacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoOperacao)), __LINE__);
        }
        if (is_null($tipoOperacao) || (is_array($tipoOperacao) && empty($tipoOperacao))) {
            unset($this->TipoOperacao);
        } else {
            $this->TipoOperacao = $tipoOperacao;
        }
        return $this;
    }
    /**
     * Get TotalDA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDA()
    {
        return isset($this->TotalDA) ? $this->TotalDA : null;
    }
    /**
     * Set TotalDA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDA
     * @return \StructType\LinhasDocERP
     */
    public function setTotalDA($totalDA = null)
    {
        if (is_null($totalDA) || (is_array($totalDA) && empty($totalDA))) {
            unset($this->TotalDA);
        } else {
            $this->TotalDA = $totalDA;
        }
        return $this;
    }
    /**
     * Get TotalDC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDC()
    {
        return isset($this->TotalDC) ? $this->TotalDC : null;
    }
    /**
     * Set TotalDC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDC
     * @return \StructType\LinhasDocERP
     */
    public function setTotalDC($totalDC = null)
    {
        if (is_null($totalDC) || (is_array($totalDC) && empty($totalDC))) {
            unset($this->TotalDC);
        } else {
            $this->TotalDC = $totalDC;
        }
        return $this;
    }
    /**
     * Get TotalDF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalDF()
    {
        return isset($this->TotalDF) ? $this->TotalDF : null;
    }
    /**
     * Set TotalDF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalDF
     * @return \StructType\LinhasDocERP
     */
    public function setTotalDF($totalDF = null)
    {
        if (is_null($totalDF) || (is_array($totalDF) && empty($totalDF))) {
            unset($this->TotalDF);
        } else {
            $this->TotalDF = $totalDF;
        }
        return $this;
    }
    /**
     * Get TotalEcotaxa value
     * @return float|null
     */
    public function getTotalEcotaxa()
    {
        return $this->TotalEcotaxa;
    }
    /**
     * Set TotalEcotaxa value
     * @param float $totalEcotaxa
     * @return \StructType\LinhasDocERP
     */
    public function setTotalEcotaxa($totalEcotaxa = null)
    {
        $this->TotalEcotaxa = $totalEcotaxa;
        return $this;
    }
    /**
     * Get TotalIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIEC()
    {
        return isset($this->TotalIEC) ? $this->TotalIEC : null;
    }
    /**
     * Set TotalIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIEC
     * @return \StructType\LinhasDocERP
     */
    public function setTotalIEC($totalIEC = null)
    {
        if (is_null($totalIEC) || (is_array($totalIEC) && empty($totalIEC))) {
            unset($this->TotalIEC);
        } else {
            $this->TotalIEC = $totalIEC;
        }
        return $this;
    }
    /**
     * Get TotalIliquido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIliquido()
    {
        return isset($this->TotalIliquido) ? $this->TotalIliquido : null;
    }
    /**
     * Set TotalIliquido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIliquido
     * @return \StructType\LinhasDocERP
     */
    public function setTotalIliquido($totalIliquido = null)
    {
        if (is_null($totalIliquido) || (is_array($totalIliquido) && empty($totalIliquido))) {
            unset($this->TotalIliquido);
        } else {
            $this->TotalIliquido = $totalIliquido;
        }
        return $this;
    }
    /**
     * Get TotalIva value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalIva()
    {
        return isset($this->TotalIva) ? $this->TotalIva : null;
    }
    /**
     * Set TotalIva value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalIva
     * @return \StructType\LinhasDocERP
     */
    public function setTotalIva($totalIva = null)
    {
        if (is_null($totalIva) || (is_array($totalIva) && empty($totalIva))) {
            unset($this->TotalIva);
        } else {
            $this->TotalIva = $totalIva;
        }
        return $this;
    }
    /**
     * Get TotalRecargo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTotalRecargo()
    {
        return isset($this->TotalRecargo) ? $this->TotalRecargo : null;
    }
    /**
     * Set TotalRecargo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $totalRecargo
     * @return \StructType\LinhasDocERP
     */
    public function setTotalRecargo($totalRecargo = null)
    {
        if (is_null($totalRecargo) || (is_array($totalRecargo) && empty($totalRecargo))) {
            unset($this->TotalRecargo);
        } else {
            $this->TotalRecargo = $totalRecargo;
        }
        return $this;
    }
    /**
     * Get Unidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidade()
    {
        return isset($this->Unidade) ? $this->Unidade : null;
    }
    /**
     * Set Unidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidade
     * @return \StructType\LinhasDocERP
     */
    public function setUnidade($unidade = null)
    {
        // validation for constraint: string
        if (!is_null($unidade) && !is_string($unidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidade)), __LINE__);
        }
        if (is_null($unidade) || (is_array($unidade) && empty($unidade))) {
            unset($this->Unidade);
        } else {
            $this->Unidade = $unidade;
        }
        return $this;
    }
    /**
     * Get ValorIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorIEC()
    {
        return isset($this->ValorIEC) ? $this->ValorIEC : null;
    }
    /**
     * Set ValorIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorIEC
     * @return \StructType\LinhasDocERP
     */
    public function setValorIEC($valorIEC = null)
    {
        if (is_null($valorIEC) || (is_array($valorIEC) && empty($valorIEC))) {
            unset($this->ValorIEC);
        } else {
            $this->ValorIEC = $valorIEC;
        }
        return $this;
    }
    /**
     * Get ValorIS value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorIS()
    {
        return isset($this->ValorIS) ? $this->ValorIS : null;
    }
    /**
     * Set ValorIS value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorIS
     * @return \StructType\LinhasDocERP
     */
    public function setValorIS($valorIS = null)
    {
        if (is_null($valorIS) || (is_array($valorIS) && empty($valorIS))) {
            unset($this->ValorIS);
        } else {
            $this->ValorIS = $valorIS;
        }
        return $this;
    }
    /**
     * Get ValorLiquidoDesconto value
     * @return float|null
     */
    public function getValorLiquidoDesconto()
    {
        return $this->ValorLiquidoDesconto;
    }
    /**
     * Set ValorLiquidoDesconto value
     * @param float $valorLiquidoDesconto
     * @return \StructType\LinhasDocERP
     */
    public function setValorLiquidoDesconto($valorLiquidoDesconto = null)
    {
        $this->ValorLiquidoDesconto = $valorLiquidoDesconto;
        return $this;
    }
    /**
     * Get VariavelA value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVariavelA()
    {
        return isset($this->VariavelA) ? $this->VariavelA : null;
    }
    /**
     * Set VariavelA value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $variavelA
     * @return \StructType\LinhasDocERP
     */
    public function setVariavelA($variavelA = null)
    {
        if (is_null($variavelA) || (is_array($variavelA) && empty($variavelA))) {
            unset($this->VariavelA);
        } else {
            $this->VariavelA = $variavelA;
        }
        return $this;
    }
    /**
     * Get VariavelB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVariavelB()
    {
        return isset($this->VariavelB) ? $this->VariavelB : null;
    }
    /**
     * Set VariavelB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $variavelB
     * @return \StructType\LinhasDocERP
     */
    public function setVariavelB($variavelB = null)
    {
        if (is_null($variavelB) || (is_array($variavelB) && empty($variavelB))) {
            unset($this->VariavelB);
        } else {
            $this->VariavelB = $variavelB;
        }
        return $this;
    }
    /**
     * Get VariavelC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getVariavelC()
    {
        return isset($this->VariavelC) ? $this->VariavelC : null;
    }
    /**
     * Set VariavelC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $variavelC
     * @return \StructType\LinhasDocERP
     */
    public function setVariavelC($variavelC = null)
    {
        if (is_null($variavelC) || (is_array($variavelC) && empty($variavelC))) {
            unset($this->VariavelC);
        } else {
            $this->VariavelC = $variavelC;
        }
        return $this;
    }
    /**
     * Get Vendedor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getVendedor()
    {
        return isset($this->Vendedor) ? $this->Vendedor : null;
    }
    /**
     * Set Vendedor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $vendedor
     * @return \StructType\LinhasDocERP
     */
    public function setVendedor($vendedor = null)
    {
        // validation for constraint: string
        if (!is_null($vendedor) && !is_string($vendedor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($vendedor)), __LINE__);
        }
        if (is_null($vendedor) || (is_array($vendedor) && empty($vendedor))) {
            unset($this->Vendedor);
        } else {
            $this->Vendedor = $vendedor;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\LinhasDocERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Get WBSItem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getWBSItem()
    {
        return isset($this->WBSItem) ? $this->WBSItem : null;
    }
    /**
     * Set WBSItem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $wBSItem
     * @return \StructType\LinhasDocERP
     */
    public function setWBSItem($wBSItem = null)
    {
        // validation for constraint: string
        if (!is_null($wBSItem) && !is_string($wBSItem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($wBSItem)), __LINE__);
        }
        if (is_null($wBSItem) || (is_array($wBSItem) && empty($wBSItem))) {
            unset($this->WBSItem);
        } else {
            $this->WBSItem = $wBSItem;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\LinhasDocERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
