<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExisteModelo StructType
 * @subpackage Structs
 */
class ExisteModelo extends AbstractStructBase
{
    /**
     * The marca
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $marca;
    /**
     * The modelo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $modelo;
    /**
     * Constructor method for ExisteModelo
     * @uses ExisteModelo::setMarca()
     * @uses ExisteModelo::setModelo()
     * @param string $marca
     * @param string $modelo
     */
    public function __construct($marca = null, $modelo = null)
    {
        $this
            ->setMarca($marca)
            ->setModelo($modelo);
    }
    /**
     * Get marca value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMarca()
    {
        return isset($this->marca) ? $this->marca : null;
    }
    /**
     * Set marca value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $marca
     * @return \StructType\ExisteModelo
     */
    public function setMarca($marca = null)
    {
        // validation for constraint: string
        if (!is_null($marca) && !is_string($marca)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($marca)), __LINE__);
        }
        if (is_null($marca) || (is_array($marca) && empty($marca))) {
            unset($this->marca);
        } else {
            $this->marca = $marca;
        }
        return $this;
    }
    /**
     * Get modelo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModelo()
    {
        return isset($this->modelo) ? $this->modelo : null;
    }
    /**
     * Set modelo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modelo
     * @return \StructType\ExisteModelo
     */
    public function setModelo($modelo = null)
    {
        // validation for constraint: string
        if (!is_null($modelo) && !is_string($modelo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modelo)), __LINE__);
        }
        if (is_null($modelo) || (is_array($modelo) && empty($modelo))) {
            unset($this->modelo);
        } else {
            $this->modelo = $modelo;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExisteModelo
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
