<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ExisteArtigoLote StructType
 * @subpackage Structs
 */
class ExisteArtigoLote extends AbstractStructBase
{
    /**
     * The artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artigo;
    /**
     * The lote
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $lote;
    /**
     * Constructor method for ExisteArtigoLote
     * @uses ExisteArtigoLote::setArtigo()
     * @uses ExisteArtigoLote::setLote()
     * @param string $artigo
     * @param string $lote
     */
    public function __construct($artigo = null, $lote = null)
    {
        $this
            ->setArtigo($artigo)
            ->setLote($lote);
    }
    /**
     * Get artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->artigo) ? $this->artigo : null;
    }
    /**
     * Set artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\ExisteArtigoLote
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->artigo);
        } else {
            $this->artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get lote value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLote()
    {
        return isset($this->lote) ? $this->lote : null;
    }
    /**
     * Set lote value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $lote
     * @return \StructType\ExisteArtigoLote
     */
    public function setLote($lote = null)
    {
        // validation for constraint: string
        if (!is_null($lote) && !is_string($lote)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($lote)), __LINE__);
        }
        if (is_null($lote) || (is_array($lote) && empty($lote))) {
            unset($this->lote);
        } else {
            $this->lote = $lote;
        }
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ExisteArtigoLote
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
