<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EstornarDocumentoDeCompra StructType
 * @subpackage Structs
 */
class EstornarDocumentoDeCompra extends AbstractStructBase
{
    /**
     * The documentoCompra
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\CabecComprasERP
     */
    public $documentoCompra;
    /**
     * The motivoEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var \StructType\MotivosEstornoERP
     */
    public $motivoEstorno;
    /**
     * The dateEstorno
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $dateEstorno;
    /**
     * Constructor method for EstornarDocumentoDeCompra
     * @uses EstornarDocumentoDeCompra::setDocumentoCompra()
     * @uses EstornarDocumentoDeCompra::setMotivoEstorno()
     * @uses EstornarDocumentoDeCompra::setDateEstorno()
     * @param \StructType\CabecComprasERP $documentoCompra
     * @param \StructType\MotivosEstornoERP $motivoEstorno
     * @param string $dateEstorno
     */
    public function __construct(\StructType\CabecComprasERP $documentoCompra = null, \StructType\MotivosEstornoERP $motivoEstorno = null, $dateEstorno = null)
    {
        $this
            ->setDocumentoCompra($documentoCompra)
            ->setMotivoEstorno($motivoEstorno)
            ->setDateEstorno($dateEstorno);
    }
    /**
     * Get documentoCompra value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\CabecComprasERP|null
     */
    public function getDocumentoCompra()
    {
        return isset($this->documentoCompra) ? $this->documentoCompra : null;
    }
    /**
     * Set documentoCompra value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\CabecComprasERP $documentoCompra
     * @return \StructType\EstornarDocumentoDeCompra
     */
    public function setDocumentoCompra(\StructType\CabecComprasERP $documentoCompra = null)
    {
        if (is_null($documentoCompra) || (is_array($documentoCompra) && empty($documentoCompra))) {
            unset($this->documentoCompra);
        } else {
            $this->documentoCompra = $documentoCompra;
        }
        return $this;
    }
    /**
     * Get motivoEstorno value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return \StructType\MotivosEstornoERP|null
     */
    public function getMotivoEstorno()
    {
        return isset($this->motivoEstorno) ? $this->motivoEstorno : null;
    }
    /**
     * Set motivoEstorno value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param \StructType\MotivosEstornoERP $motivoEstorno
     * @return \StructType\EstornarDocumentoDeCompra
     */
    public function setMotivoEstorno(\StructType\MotivosEstornoERP $motivoEstorno = null)
    {
        if (is_null($motivoEstorno) || (is_array($motivoEstorno) && empty($motivoEstorno))) {
            unset($this->motivoEstorno);
        } else {
            $this->motivoEstorno = $motivoEstorno;
        }
        return $this;
    }
    /**
     * Get dateEstorno value
     * @return string|null
     */
    public function getDateEstorno()
    {
        return $this->dateEstorno;
    }
    /**
     * Set dateEstorno value
     * @param string $dateEstorno
     * @return \StructType\EstornarDocumentoDeCompra
     */
    public function setDateEstorno($dateEstorno = null)
    {
        // validation for constraint: string
        if (!is_null($dateEstorno) && !is_string($dateEstorno)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dateEstorno)), __LINE__);
        }
        $this->dateEstorno = $dateEstorno;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EstornarDocumentoDeCompra
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
