<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for EditaArtigoMoedaXML StructType
 * @subpackage Structs
 */
class EditaArtigoMoedaXML extends AbstractStructBase
{
    /**
     * The artigo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $artigo;
    /**
     * The moeda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $moeda;
    /**
     * The unidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $unidade;
    /**
     * The forceRefresh
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $forceRefresh;
    /**
     * Constructor method for EditaArtigoMoedaXML
     * @uses EditaArtigoMoedaXML::setArtigo()
     * @uses EditaArtigoMoedaXML::setMoeda()
     * @uses EditaArtigoMoedaXML::setUnidade()
     * @uses EditaArtigoMoedaXML::setForceRefresh()
     * @param string $artigo
     * @param string $moeda
     * @param string $unidade
     * @param bool $forceRefresh
     */
    public function __construct($artigo = null, $moeda = null, $unidade = null, $forceRefresh = null)
    {
        $this
            ->setArtigo($artigo)
            ->setMoeda($moeda)
            ->setUnidade($unidade)
            ->setForceRefresh($forceRefresh);
    }
    /**
     * Get artigo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getArtigo()
    {
        return isset($this->artigo) ? $this->artigo : null;
    }
    /**
     * Set artigo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $artigo
     * @return \StructType\EditaArtigoMoedaXML
     */
    public function setArtigo($artigo = null)
    {
        // validation for constraint: string
        if (!is_null($artigo) && !is_string($artigo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($artigo)), __LINE__);
        }
        if (is_null($artigo) || (is_array($artigo) && empty($artigo))) {
            unset($this->artigo);
        } else {
            $this->artigo = $artigo;
        }
        return $this;
    }
    /**
     * Get moeda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoeda()
    {
        return isset($this->moeda) ? $this->moeda : null;
    }
    /**
     * Set moeda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moeda
     * @return \StructType\EditaArtigoMoedaXML
     */
    public function setMoeda($moeda = null)
    {
        // validation for constraint: string
        if (!is_null($moeda) && !is_string($moeda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moeda)), __LINE__);
        }
        if (is_null($moeda) || (is_array($moeda) && empty($moeda))) {
            unset($this->moeda);
        } else {
            $this->moeda = $moeda;
        }
        return $this;
    }
    /**
     * Get unidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUnidade()
    {
        return isset($this->unidade) ? $this->unidade : null;
    }
    /**
     * Set unidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $unidade
     * @return \StructType\EditaArtigoMoedaXML
     */
    public function setUnidade($unidade = null)
    {
        // validation for constraint: string
        if (!is_null($unidade) && !is_string($unidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($unidade)), __LINE__);
        }
        if (is_null($unidade) || (is_array($unidade) && empty($unidade))) {
            unset($this->unidade);
        } else {
            $this->unidade = $unidade;
        }
        return $this;
    }
    /**
     * Get forceRefresh value
     * @return bool|null
     */
    public function getForceRefresh()
    {
        return $this->forceRefresh;
    }
    /**
     * Set forceRefresh value
     * @param bool $forceRefresh
     * @return \StructType\EditaArtigoMoedaXML
     */
    public function setForceRefresh($forceRefresh = null)
    {
        // validation for constraint: boolean
        if (!is_null($forceRefresh) && !is_bool($forceRefresh)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($forceRefresh)), __LINE__);
        }
        $this->forceRefresh = $forceRefresh;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\EditaArtigoMoedaXML
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
