<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ContasBancariasERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ContasBancariasERP
 * @subpackage Structs
 */
class ContasBancariasERP extends AbstractStructBase
{
    /**
     * The Agencia
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Agencia;
    /**
     * The Banco
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Banco;
    /**
     * The CDU_IDCredor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CDU_IDCredor;
    /**
     * The CodigoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $CodigoEntidade;
    /**
     * The Comissao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Comissao;
    /**
     * The Conta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Conta;
    /**
     * The ContaAssociada
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaAssociada;
    /**
     * The ContaCartaoEmpresa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaCartaoEmpresa;
    /**
     * The ContaTerceiros
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ContaTerceiros;
    /**
     * The DataDiarioCaixa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataDiarioCaixa;
    /**
     * The DataUltimaActualizacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataUltimaActualizacao;
    /**
     * The DescAgen
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescAgen;
    /**
     * The DescBanco
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DescBanco;
    /**
     * The DiaContagem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DiaContagem;
    /**
     * The DiaPagamento
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DiaPagamento;
    /**
     * The DiarioCaixa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $DiarioCaixa;
    /**
     * The EncargosBanco
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $EncargosBanco;
    /**
     * The Entidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entidade;
    /**
     * The Escalao1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Escalao1;
    /**
     * The Escalao2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Escalao2;
    /**
     * The Escalao3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Escalao3;
    /**
     * The Escalao4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Escalao4;
    /**
     * The Escalao5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Escalao5;
    /**
     * The Escalao6
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Escalao6;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Estado;
    /**
     * The ExcluirTipoMovEuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExcluirTipoMovEuro;
    /**
     * The FaxGestor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $FaxGestor;
    /**
     * The FundoManeio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $FundoManeio;
    /**
     * The Gestor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Gestor;
    /**
     * The IBAN
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IBAN;
    /**
     * The IDDiarioCaixa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true | true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IDDiarioCaixa;
    /**
     * The IdSepa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $IdSepa;
    /**
     * The LancaTalaoDividido
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $LancaTalaoDividido;
    /**
     * The Limite
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Limite;
    /**
     * The LocalEmissao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalEmissao;
    /**
     * The LocalEmissaoEuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $LocalEmissaoEuro;
    /**
     * The Maximo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Maximo;
    /**
     * The Minimo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Minimo;
    /**
     * The Moeda
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Moeda;
    /**
     * The MoedaSerie2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MoedaSerie2;
    /**
     * The MostraTDep
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MostraTDep;
    /**
     * The MostraTransCHQ
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MostraTransCHQ;
    /**
     * The MostraTransVal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $MostraTransVal;
    /**
     * The MovComissaoAut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovComissaoAut;
    /**
     * The MovimentoAut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovimentoAut;
    /**
     * The MovimentoTaxa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MovimentoTaxa;
    /**
     * The NIB
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NIB;
    /**
     * The NIF
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NIF;
    /**
     * The NivelAlerta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NivelAlerta;
    /**
     * The Notas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Notas;
    /**
     * The NumActualTalao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumActualTalao;
    /**
     * The NumConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumConta;
    /**
     * The NumDiasMargem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumDiasMargem;
    /**
     * The NumeradorRemessas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumeradorRemessas;
    /**
     * The NumeroActual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroActual;
    /**
     * The NumeroActualEuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroActualEuro;
    /**
     * The NumeroCedenteRem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroCedenteRem;
    /**
     * The NumeroFolhaCofre
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $NumeroFolhaCofre;
    /**
     * The NumeroInicial
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroInicial;
    /**
     * The NumeroInicialEuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NumeroInicialEuro;
    /**
     * The Pais
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Pais;
    /**
     * The PermiteSaldoZero
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $PermiteSaldoZero;
    /**
     * The PlafondRemessas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $PlafondRemessas;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Quantidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $Quantidade;
    /**
     * The QuantidadeEuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $QuantidadeEuro;
    /**
     * The RespFundoManeio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $RespFundoManeio;
    /**
     * The SWIFT
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SWIFT;
    /**
     * The SerieAut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieAut;
    /**
     * The SerieLivro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieLivro;
    /**
     * The SerieLivroEuro
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieLivroEuro;
    /**
     * The SerieTalaoDeposito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieTalaoDeposito;
    /**
     * The SufixoRem
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SufixoRem;
    /**
     * The Taxa1
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxa1;
    /**
     * The Taxa2
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxa2;
    /**
     * The Taxa3
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxa3;
    /**
     * The Taxa4
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxa4;
    /**
     * The Taxa5
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxa5;
    /**
     * The Taxa6
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $Taxa6;
    /**
     * The TefGestor
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TefGestor;
    /**
     * The TipoConta
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $TipoConta;
    /**
     * The TipoDocAut
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoDocAut;
    /**
     * The TipoEntidade
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TipoEntidade;
    /**
     * The TitCodPost
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitCodPost;
    /**
     * The TitLocal
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitLocal;
    /**
     * The TitMora
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitMora;
    /**
     * The TitNome
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $TitNome;
    /**
     * The ValorFundoManeio
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorFundoManeio;
    /**
     * The ValorRemessas
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var float
     */
    public $ValorRemessas;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for ContasBancariasERP
     * @uses ContasBancariasERP::setAgencia()
     * @uses ContasBancariasERP::setBanco()
     * @uses ContasBancariasERP::setCDU_IDCredor()
     * @uses ContasBancariasERP::setCodigoEntidade()
     * @uses ContasBancariasERP::setComissao()
     * @uses ContasBancariasERP::setConta()
     * @uses ContasBancariasERP::setContaAssociada()
     * @uses ContasBancariasERP::setContaCartaoEmpresa()
     * @uses ContasBancariasERP::setContaTerceiros()
     * @uses ContasBancariasERP::setDataDiarioCaixa()
     * @uses ContasBancariasERP::setDataUltimaActualizacao()
     * @uses ContasBancariasERP::setDescAgen()
     * @uses ContasBancariasERP::setDescBanco()
     * @uses ContasBancariasERP::setDiaContagem()
     * @uses ContasBancariasERP::setDiaPagamento()
     * @uses ContasBancariasERP::setDiarioCaixa()
     * @uses ContasBancariasERP::setEncargosBanco()
     * @uses ContasBancariasERP::setEntidade()
     * @uses ContasBancariasERP::setEscalao1()
     * @uses ContasBancariasERP::setEscalao2()
     * @uses ContasBancariasERP::setEscalao3()
     * @uses ContasBancariasERP::setEscalao4()
     * @uses ContasBancariasERP::setEscalao5()
     * @uses ContasBancariasERP::setEscalao6()
     * @uses ContasBancariasERP::setEstado()
     * @uses ContasBancariasERP::setExcluirTipoMovEuro()
     * @uses ContasBancariasERP::setFaxGestor()
     * @uses ContasBancariasERP::setFundoManeio()
     * @uses ContasBancariasERP::setGestor()
     * @uses ContasBancariasERP::setIBAN()
     * @uses ContasBancariasERP::setIDDiarioCaixa()
     * @uses ContasBancariasERP::setIdSepa()
     * @uses ContasBancariasERP::setLancaTalaoDividido()
     * @uses ContasBancariasERP::setLimite()
     * @uses ContasBancariasERP::setLocalEmissao()
     * @uses ContasBancariasERP::setLocalEmissaoEuro()
     * @uses ContasBancariasERP::setMaximo()
     * @uses ContasBancariasERP::setMinimo()
     * @uses ContasBancariasERP::setMoeda()
     * @uses ContasBancariasERP::setMoedaSerie2()
     * @uses ContasBancariasERP::setMostraTDep()
     * @uses ContasBancariasERP::setMostraTransCHQ()
     * @uses ContasBancariasERP::setMostraTransVal()
     * @uses ContasBancariasERP::setMovComissaoAut()
     * @uses ContasBancariasERP::setMovimentoAut()
     * @uses ContasBancariasERP::setMovimentoTaxa()
     * @uses ContasBancariasERP::setNIB()
     * @uses ContasBancariasERP::setNIF()
     * @uses ContasBancariasERP::setNivelAlerta()
     * @uses ContasBancariasERP::setNotas()
     * @uses ContasBancariasERP::setNumActualTalao()
     * @uses ContasBancariasERP::setNumConta()
     * @uses ContasBancariasERP::setNumDiasMargem()
     * @uses ContasBancariasERP::setNumeradorRemessas()
     * @uses ContasBancariasERP::setNumeroActual()
     * @uses ContasBancariasERP::setNumeroActualEuro()
     * @uses ContasBancariasERP::setNumeroCedenteRem()
     * @uses ContasBancariasERP::setNumeroFolhaCofre()
     * @uses ContasBancariasERP::setNumeroInicial()
     * @uses ContasBancariasERP::setNumeroInicialEuro()
     * @uses ContasBancariasERP::setPais()
     * @uses ContasBancariasERP::setPermiteSaldoZero()
     * @uses ContasBancariasERP::setPlafondRemessas()
     * @uses ContasBancariasERP::setProtegida()
     * @uses ContasBancariasERP::setQuantidade()
     * @uses ContasBancariasERP::setQuantidadeEuro()
     * @uses ContasBancariasERP::setRespFundoManeio()
     * @uses ContasBancariasERP::setSWIFT()
     * @uses ContasBancariasERP::setSerieAut()
     * @uses ContasBancariasERP::setSerieLivro()
     * @uses ContasBancariasERP::setSerieLivroEuro()
     * @uses ContasBancariasERP::setSerieTalaoDeposito()
     * @uses ContasBancariasERP::setSufixoRem()
     * @uses ContasBancariasERP::setTaxa1()
     * @uses ContasBancariasERP::setTaxa2()
     * @uses ContasBancariasERP::setTaxa3()
     * @uses ContasBancariasERP::setTaxa4()
     * @uses ContasBancariasERP::setTaxa5()
     * @uses ContasBancariasERP::setTaxa6()
     * @uses ContasBancariasERP::setTefGestor()
     * @uses ContasBancariasERP::setTipoConta()
     * @uses ContasBancariasERP::setTipoDocAut()
     * @uses ContasBancariasERP::setTipoEntidade()
     * @uses ContasBancariasERP::setTitCodPost()
     * @uses ContasBancariasERP::setTitLocal()
     * @uses ContasBancariasERP::setTitMora()
     * @uses ContasBancariasERP::setTitNome()
     * @uses ContasBancariasERP::setValorFundoManeio()
     * @uses ContasBancariasERP::setValorRemessas()
     * @uses ContasBancariasERP::setVersaoUltAct()
     * @param string $agencia
     * @param string $banco
     * @param string $cDU_IDCredor
     * @param string $codigoEntidade
     * @param float $comissao
     * @param string $conta
     * @param string $contaAssociada
     * @param string $contaCartaoEmpresa
     * @param bool $contaTerceiros
     * @param string $dataDiarioCaixa
     * @param string $dataUltimaActualizacao
     * @param string $descAgen
     * @param string $descBanco
     * @param int $diaContagem
     * @param int $diaPagamento
     * @param int $diarioCaixa
     * @param bool $encargosBanco
     * @param string $entidade
     * @param float $escalao1
     * @param float $escalao2
     * @param float $escalao3
     * @param float $escalao4
     * @param float $escalao5
     * @param float $escalao6
     * @param bool $estado
     * @param bool $excluirTipoMovEuro
     * @param string $faxGestor
     * @param bool $fundoManeio
     * @param string $gestor
     * @param string $iBAN
     * @param string $iDDiarioCaixa
     * @param string $idSepa
     * @param bool $lancaTalaoDividido
     * @param float $limite
     * @param string $localEmissao
     * @param string $localEmissaoEuro
     * @param float $maximo
     * @param float $minimo
     * @param string $moeda
     * @param string $moedaSerie2
     * @param bool $mostraTDep
     * @param bool $mostraTransCHQ
     * @param bool $mostraTransVal
     * @param string $movComissaoAut
     * @param string $movimentoAut
     * @param string $movimentoTaxa
     * @param string $nIB
     * @param string $nIF
     * @param int $nivelAlerta
     * @param string $notas
     * @param int $numActualTalao
     * @param string $numConta
     * @param int $numDiasMargem
     * @param int $numeradorRemessas
     * @param string $numeroActual
     * @param string $numeroActualEuro
     * @param string $numeroCedenteRem
     * @param int $numeroFolhaCofre
     * @param string $numeroInicial
     * @param string $numeroInicialEuro
     * @param string $pais
     * @param bool $permiteSaldoZero
     * @param float $plafondRemessas
     * @param bool $protegida
     * @param int $quantidade
     * @param int $quantidadeEuro
     * @param string $respFundoManeio
     * @param string $sWIFT
     * @param string $serieAut
     * @param string $serieLivro
     * @param string $serieLivroEuro
     * @param string $serieTalaoDeposito
     * @param string $sufixoRem
     * @param float $taxa1
     * @param float $taxa2
     * @param float $taxa3
     * @param float $taxa4
     * @param float $taxa5
     * @param float $taxa6
     * @param string $tefGestor
     * @param int $tipoConta
     * @param string $tipoDocAut
     * @param string $tipoEntidade
     * @param string $titCodPost
     * @param string $titLocal
     * @param string $titMora
     * @param string $titNome
     * @param float $valorFundoManeio
     * @param float $valorRemessas
     * @param string $versaoUltAct
     */
    public function __construct($agencia = null, $banco = null, $cDU_IDCredor = null, $codigoEntidade = null, $comissao = null, $conta = null, $contaAssociada = null, $contaCartaoEmpresa = null, $contaTerceiros = null, $dataDiarioCaixa = null, $dataUltimaActualizacao = null, $descAgen = null, $descBanco = null, $diaContagem = null, $diaPagamento = null, $diarioCaixa = null, $encargosBanco = null, $entidade = null, $escalao1 = null, $escalao2 = null, $escalao3 = null, $escalao4 = null, $escalao5 = null, $escalao6 = null, $estado = null, $excluirTipoMovEuro = null, $faxGestor = null, $fundoManeio = null, $gestor = null, $iBAN = null, $iDDiarioCaixa = null, $idSepa = null, $lancaTalaoDividido = null, $limite = null, $localEmissao = null, $localEmissaoEuro = null, $maximo = null, $minimo = null, $moeda = null, $moedaSerie2 = null, $mostraTDep = null, $mostraTransCHQ = null, $mostraTransVal = null, $movComissaoAut = null, $movimentoAut = null, $movimentoTaxa = null, $nIB = null, $nIF = null, $nivelAlerta = null, $notas = null, $numActualTalao = null, $numConta = null, $numDiasMargem = null, $numeradorRemessas = null, $numeroActual = null, $numeroActualEuro = null, $numeroCedenteRem = null, $numeroFolhaCofre = null, $numeroInicial = null, $numeroInicialEuro = null, $pais = null, $permiteSaldoZero = null, $plafondRemessas = null, $protegida = null, $quantidade = null, $quantidadeEuro = null, $respFundoManeio = null, $sWIFT = null, $serieAut = null, $serieLivro = null, $serieLivroEuro = null, $serieTalaoDeposito = null, $sufixoRem = null, $taxa1 = null, $taxa2 = null, $taxa3 = null, $taxa4 = null, $taxa5 = null, $taxa6 = null, $tefGestor = null, $tipoConta = null, $tipoDocAut = null, $tipoEntidade = null, $titCodPost = null, $titLocal = null, $titMora = null, $titNome = null, $valorFundoManeio = null, $valorRemessas = null, $versaoUltAct = null)
    {
        $this
            ->setAgencia($agencia)
            ->setBanco($banco)
            ->setCDU_IDCredor($cDU_IDCredor)
            ->setCodigoEntidade($codigoEntidade)
            ->setComissao($comissao)
            ->setConta($conta)
            ->setContaAssociada($contaAssociada)
            ->setContaCartaoEmpresa($contaCartaoEmpresa)
            ->setContaTerceiros($contaTerceiros)
            ->setDataDiarioCaixa($dataDiarioCaixa)
            ->setDataUltimaActualizacao($dataUltimaActualizacao)
            ->setDescAgen($descAgen)
            ->setDescBanco($descBanco)
            ->setDiaContagem($diaContagem)
            ->setDiaPagamento($diaPagamento)
            ->setDiarioCaixa($diarioCaixa)
            ->setEncargosBanco($encargosBanco)
            ->setEntidade($entidade)
            ->setEscalao1($escalao1)
            ->setEscalao2($escalao2)
            ->setEscalao3($escalao3)
            ->setEscalao4($escalao4)
            ->setEscalao5($escalao5)
            ->setEscalao6($escalao6)
            ->setEstado($estado)
            ->setExcluirTipoMovEuro($excluirTipoMovEuro)
            ->setFaxGestor($faxGestor)
            ->setFundoManeio($fundoManeio)
            ->setGestor($gestor)
            ->setIBAN($iBAN)
            ->setIDDiarioCaixa($iDDiarioCaixa)
            ->setIdSepa($idSepa)
            ->setLancaTalaoDividido($lancaTalaoDividido)
            ->setLimite($limite)
            ->setLocalEmissao($localEmissao)
            ->setLocalEmissaoEuro($localEmissaoEuro)
            ->setMaximo($maximo)
            ->setMinimo($minimo)
            ->setMoeda($moeda)
            ->setMoedaSerie2($moedaSerie2)
            ->setMostraTDep($mostraTDep)
            ->setMostraTransCHQ($mostraTransCHQ)
            ->setMostraTransVal($mostraTransVal)
            ->setMovComissaoAut($movComissaoAut)
            ->setMovimentoAut($movimentoAut)
            ->setMovimentoTaxa($movimentoTaxa)
            ->setNIB($nIB)
            ->setNIF($nIF)
            ->setNivelAlerta($nivelAlerta)
            ->setNotas($notas)
            ->setNumActualTalao($numActualTalao)
            ->setNumConta($numConta)
            ->setNumDiasMargem($numDiasMargem)
            ->setNumeradorRemessas($numeradorRemessas)
            ->setNumeroActual($numeroActual)
            ->setNumeroActualEuro($numeroActualEuro)
            ->setNumeroCedenteRem($numeroCedenteRem)
            ->setNumeroFolhaCofre($numeroFolhaCofre)
            ->setNumeroInicial($numeroInicial)
            ->setNumeroInicialEuro($numeroInicialEuro)
            ->setPais($pais)
            ->setPermiteSaldoZero($permiteSaldoZero)
            ->setPlafondRemessas($plafondRemessas)
            ->setProtegida($protegida)
            ->setQuantidade($quantidade)
            ->setQuantidadeEuro($quantidadeEuro)
            ->setRespFundoManeio($respFundoManeio)
            ->setSWIFT($sWIFT)
            ->setSerieAut($serieAut)
            ->setSerieLivro($serieLivro)
            ->setSerieLivroEuro($serieLivroEuro)
            ->setSerieTalaoDeposito($serieTalaoDeposito)
            ->setSufixoRem($sufixoRem)
            ->setTaxa1($taxa1)
            ->setTaxa2($taxa2)
            ->setTaxa3($taxa3)
            ->setTaxa4($taxa4)
            ->setTaxa5($taxa5)
            ->setTaxa6($taxa6)
            ->setTefGestor($tefGestor)
            ->setTipoConta($tipoConta)
            ->setTipoDocAut($tipoDocAut)
            ->setTipoEntidade($tipoEntidade)
            ->setTitCodPost($titCodPost)
            ->setTitLocal($titLocal)
            ->setTitMora($titMora)
            ->setTitNome($titNome)
            ->setValorFundoManeio($valorFundoManeio)
            ->setValorRemessas($valorRemessas)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get Agencia value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getAgencia()
    {
        return isset($this->Agencia) ? $this->Agencia : null;
    }
    /**
     * Set Agencia value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $agencia
     * @return \StructType\ContasBancariasERP
     */
    public function setAgencia($agencia = null)
    {
        // validation for constraint: string
        if (!is_null($agencia) && !is_string($agencia)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($agencia)), __LINE__);
        }
        if (is_null($agencia) || (is_array($agencia) && empty($agencia))) {
            unset($this->Agencia);
        } else {
            $this->Agencia = $agencia;
        }
        return $this;
    }
    /**
     * Get Banco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getBanco()
    {
        return isset($this->Banco) ? $this->Banco : null;
    }
    /**
     * Set Banco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $banco
     * @return \StructType\ContasBancariasERP
     */
    public function setBanco($banco = null)
    {
        // validation for constraint: string
        if (!is_null($banco) && !is_string($banco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($banco)), __LINE__);
        }
        if (is_null($banco) || (is_array($banco) && empty($banco))) {
            unset($this->Banco);
        } else {
            $this->Banco = $banco;
        }
        return $this;
    }
    /**
     * Get CDU_IDCredor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCDU_IDCredor()
    {
        return isset($this->CDU_IDCredor) ? $this->CDU_IDCredor : null;
    }
    /**
     * Set CDU_IDCredor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cDU_IDCredor
     * @return \StructType\ContasBancariasERP
     */
    public function setCDU_IDCredor($cDU_IDCredor = null)
    {
        // validation for constraint: string
        if (!is_null($cDU_IDCredor) && !is_string($cDU_IDCredor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cDU_IDCredor)), __LINE__);
        }
        if (is_null($cDU_IDCredor) || (is_array($cDU_IDCredor) && empty($cDU_IDCredor))) {
            unset($this->CDU_IDCredor);
        } else {
            $this->CDU_IDCredor = $cDU_IDCredor;
        }
        return $this;
    }
    /**
     * Get CodigoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCodigoEntidade()
    {
        return isset($this->CodigoEntidade) ? $this->CodigoEntidade : null;
    }
    /**
     * Set CodigoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $codigoEntidade
     * @return \StructType\ContasBancariasERP
     */
    public function setCodigoEntidade($codigoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($codigoEntidade) && !is_string($codigoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($codigoEntidade)), __LINE__);
        }
        if (is_null($codigoEntidade) || (is_array($codigoEntidade) && empty($codigoEntidade))) {
            unset($this->CodigoEntidade);
        } else {
            $this->CodigoEntidade = $codigoEntidade;
        }
        return $this;
    }
    /**
     * Get Comissao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getComissao()
    {
        return isset($this->Comissao) ? $this->Comissao : null;
    }
    /**
     * Set Comissao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $comissao
     * @return \StructType\ContasBancariasERP
     */
    public function setComissao($comissao = null)
    {
        if (is_null($comissao) || (is_array($comissao) && empty($comissao))) {
            unset($this->Comissao);
        } else {
            $this->Comissao = $comissao;
        }
        return $this;
    }
    /**
     * Get Conta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getConta()
    {
        return isset($this->Conta) ? $this->Conta : null;
    }
    /**
     * Set Conta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $conta
     * @return \StructType\ContasBancariasERP
     */
    public function setConta($conta = null)
    {
        // validation for constraint: string
        if (!is_null($conta) && !is_string($conta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($conta)), __LINE__);
        }
        if (is_null($conta) || (is_array($conta) && empty($conta))) {
            unset($this->Conta);
        } else {
            $this->Conta = $conta;
        }
        return $this;
    }
    /**
     * Get ContaAssociada value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaAssociada()
    {
        return isset($this->ContaAssociada) ? $this->ContaAssociada : null;
    }
    /**
     * Set ContaAssociada value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaAssociada
     * @return \StructType\ContasBancariasERP
     */
    public function setContaAssociada($contaAssociada = null)
    {
        // validation for constraint: string
        if (!is_null($contaAssociada) && !is_string($contaAssociada)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaAssociada)), __LINE__);
        }
        if (is_null($contaAssociada) || (is_array($contaAssociada) && empty($contaAssociada))) {
            unset($this->ContaAssociada);
        } else {
            $this->ContaAssociada = $contaAssociada;
        }
        return $this;
    }
    /**
     * Get ContaCartaoEmpresa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaCartaoEmpresa()
    {
        return isset($this->ContaCartaoEmpresa) ? $this->ContaCartaoEmpresa : null;
    }
    /**
     * Set ContaCartaoEmpresa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaCartaoEmpresa
     * @return \StructType\ContasBancariasERP
     */
    public function setContaCartaoEmpresa($contaCartaoEmpresa = null)
    {
        // validation for constraint: string
        if (!is_null($contaCartaoEmpresa) && !is_string($contaCartaoEmpresa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaCartaoEmpresa)), __LINE__);
        }
        if (is_null($contaCartaoEmpresa) || (is_array($contaCartaoEmpresa) && empty($contaCartaoEmpresa))) {
            unset($this->ContaCartaoEmpresa);
        } else {
            $this->ContaCartaoEmpresa = $contaCartaoEmpresa;
        }
        return $this;
    }
    /**
     * Get ContaTerceiros value
     * @return bool|null
     */
    public function getContaTerceiros()
    {
        return $this->ContaTerceiros;
    }
    /**
     * Set ContaTerceiros value
     * @param bool $contaTerceiros
     * @return \StructType\ContasBancariasERP
     */
    public function setContaTerceiros($contaTerceiros = null)
    {
        // validation for constraint: boolean
        if (!is_null($contaTerceiros) && !is_bool($contaTerceiros)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($contaTerceiros)), __LINE__);
        }
        $this->ContaTerceiros = $contaTerceiros;
        return $this;
    }
    /**
     * Get DataDiarioCaixa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataDiarioCaixa()
    {
        return isset($this->DataDiarioCaixa) ? $this->DataDiarioCaixa : null;
    }
    /**
     * Set DataDiarioCaixa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataDiarioCaixa
     * @return \StructType\ContasBancariasERP
     */
    public function setDataDiarioCaixa($dataDiarioCaixa = null)
    {
        // validation for constraint: string
        if (!is_null($dataDiarioCaixa) && !is_string($dataDiarioCaixa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataDiarioCaixa)), __LINE__);
        }
        if (is_null($dataDiarioCaixa) || (is_array($dataDiarioCaixa) && empty($dataDiarioCaixa))) {
            unset($this->DataDiarioCaixa);
        } else {
            $this->DataDiarioCaixa = $dataDiarioCaixa;
        }
        return $this;
    }
    /**
     * Get DataUltimaActualizacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataUltimaActualizacao()
    {
        return isset($this->DataUltimaActualizacao) ? $this->DataUltimaActualizacao : null;
    }
    /**
     * Set DataUltimaActualizacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataUltimaActualizacao
     * @return \StructType\ContasBancariasERP
     */
    public function setDataUltimaActualizacao($dataUltimaActualizacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataUltimaActualizacao) && !is_string($dataUltimaActualizacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataUltimaActualizacao)), __LINE__);
        }
        if (is_null($dataUltimaActualizacao) || (is_array($dataUltimaActualizacao) && empty($dataUltimaActualizacao))) {
            unset($this->DataUltimaActualizacao);
        } else {
            $this->DataUltimaActualizacao = $dataUltimaActualizacao;
        }
        return $this;
    }
    /**
     * Get DescAgen value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescAgen()
    {
        return isset($this->DescAgen) ? $this->DescAgen : null;
    }
    /**
     * Set DescAgen value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descAgen
     * @return \StructType\ContasBancariasERP
     */
    public function setDescAgen($descAgen = null)
    {
        // validation for constraint: string
        if (!is_null($descAgen) && !is_string($descAgen)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descAgen)), __LINE__);
        }
        if (is_null($descAgen) || (is_array($descAgen) && empty($descAgen))) {
            unset($this->DescAgen);
        } else {
            $this->DescAgen = $descAgen;
        }
        return $this;
    }
    /**
     * Get DescBanco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescBanco()
    {
        return isset($this->DescBanco) ? $this->DescBanco : null;
    }
    /**
     * Set DescBanco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descBanco
     * @return \StructType\ContasBancariasERP
     */
    public function setDescBanco($descBanco = null)
    {
        // validation for constraint: string
        if (!is_null($descBanco) && !is_string($descBanco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descBanco)), __LINE__);
        }
        if (is_null($descBanco) || (is_array($descBanco) && empty($descBanco))) {
            unset($this->DescBanco);
        } else {
            $this->DescBanco = $descBanco;
        }
        return $this;
    }
    /**
     * Get DiaContagem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDiaContagem()
    {
        return isset($this->DiaContagem) ? $this->DiaContagem : null;
    }
    /**
     * Set DiaContagem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $diaContagem
     * @return \StructType\ContasBancariasERP
     */
    public function setDiaContagem($diaContagem = null)
    {
        // validation for constraint: int
        if (!is_null($diaContagem) && !is_numeric($diaContagem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diaContagem)), __LINE__);
        }
        if (is_null($diaContagem) || (is_array($diaContagem) && empty($diaContagem))) {
            unset($this->DiaContagem);
        } else {
            $this->DiaContagem = $diaContagem;
        }
        return $this;
    }
    /**
     * Get DiaPagamento value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDiaPagamento()
    {
        return isset($this->DiaPagamento) ? $this->DiaPagamento : null;
    }
    /**
     * Set DiaPagamento value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $diaPagamento
     * @return \StructType\ContasBancariasERP
     */
    public function setDiaPagamento($diaPagamento = null)
    {
        // validation for constraint: int
        if (!is_null($diaPagamento) && !is_numeric($diaPagamento)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diaPagamento)), __LINE__);
        }
        if (is_null($diaPagamento) || (is_array($diaPagamento) && empty($diaPagamento))) {
            unset($this->DiaPagamento);
        } else {
            $this->DiaPagamento = $diaPagamento;
        }
        return $this;
    }
    /**
     * Get DiarioCaixa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getDiarioCaixa()
    {
        return isset($this->DiarioCaixa) ? $this->DiarioCaixa : null;
    }
    /**
     * Set DiarioCaixa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $diarioCaixa
     * @return \StructType\ContasBancariasERP
     */
    public function setDiarioCaixa($diarioCaixa = null)
    {
        // validation for constraint: int
        if (!is_null($diarioCaixa) && !is_numeric($diarioCaixa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diarioCaixa)), __LINE__);
        }
        if (is_null($diarioCaixa) || (is_array($diarioCaixa) && empty($diarioCaixa))) {
            unset($this->DiarioCaixa);
        } else {
            $this->DiarioCaixa = $diarioCaixa;
        }
        return $this;
    }
    /**
     * Get EncargosBanco value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEncargosBanco()
    {
        return isset($this->EncargosBanco) ? $this->EncargosBanco : null;
    }
    /**
     * Set EncargosBanco value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $encargosBanco
     * @return \StructType\ContasBancariasERP
     */
    public function setEncargosBanco($encargosBanco = null)
    {
        // validation for constraint: boolean
        if (!is_null($encargosBanco) && !is_bool($encargosBanco)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($encargosBanco)), __LINE__);
        }
        if (is_null($encargosBanco) || (is_array($encargosBanco) && empty($encargosBanco))) {
            unset($this->EncargosBanco);
        } else {
            $this->EncargosBanco = $encargosBanco;
        }
        return $this;
    }
    /**
     * Get Entidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntidade()
    {
        return isset($this->Entidade) ? $this->Entidade : null;
    }
    /**
     * Set Entidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entidade
     * @return \StructType\ContasBancariasERP
     */
    public function setEntidade($entidade = null)
    {
        // validation for constraint: string
        if (!is_null($entidade) && !is_string($entidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entidade)), __LINE__);
        }
        if (is_null($entidade) || (is_array($entidade) && empty($entidade))) {
            unset($this->Entidade);
        } else {
            $this->Entidade = $entidade;
        }
        return $this;
    }
    /**
     * Get Escalao1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEscalao1()
    {
        return isset($this->Escalao1) ? $this->Escalao1 : null;
    }
    /**
     * Set Escalao1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $escalao1
     * @return \StructType\ContasBancariasERP
     */
    public function setEscalao1($escalao1 = null)
    {
        if (is_null($escalao1) || (is_array($escalao1) && empty($escalao1))) {
            unset($this->Escalao1);
        } else {
            $this->Escalao1 = $escalao1;
        }
        return $this;
    }
    /**
     * Get Escalao2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEscalao2()
    {
        return isset($this->Escalao2) ? $this->Escalao2 : null;
    }
    /**
     * Set Escalao2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $escalao2
     * @return \StructType\ContasBancariasERP
     */
    public function setEscalao2($escalao2 = null)
    {
        if (is_null($escalao2) || (is_array($escalao2) && empty($escalao2))) {
            unset($this->Escalao2);
        } else {
            $this->Escalao2 = $escalao2;
        }
        return $this;
    }
    /**
     * Get Escalao3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEscalao3()
    {
        return isset($this->Escalao3) ? $this->Escalao3 : null;
    }
    /**
     * Set Escalao3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $escalao3
     * @return \StructType\ContasBancariasERP
     */
    public function setEscalao3($escalao3 = null)
    {
        if (is_null($escalao3) || (is_array($escalao3) && empty($escalao3))) {
            unset($this->Escalao3);
        } else {
            $this->Escalao3 = $escalao3;
        }
        return $this;
    }
    /**
     * Get Escalao4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEscalao4()
    {
        return isset($this->Escalao4) ? $this->Escalao4 : null;
    }
    /**
     * Set Escalao4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $escalao4
     * @return \StructType\ContasBancariasERP
     */
    public function setEscalao4($escalao4 = null)
    {
        if (is_null($escalao4) || (is_array($escalao4) && empty($escalao4))) {
            unset($this->Escalao4);
        } else {
            $this->Escalao4 = $escalao4;
        }
        return $this;
    }
    /**
     * Get Escalao5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEscalao5()
    {
        return isset($this->Escalao5) ? $this->Escalao5 : null;
    }
    /**
     * Set Escalao5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $escalao5
     * @return \StructType\ContasBancariasERP
     */
    public function setEscalao5($escalao5 = null)
    {
        if (is_null($escalao5) || (is_array($escalao5) && empty($escalao5))) {
            unset($this->Escalao5);
        } else {
            $this->Escalao5 = $escalao5;
        }
        return $this;
    }
    /**
     * Get Escalao6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getEscalao6()
    {
        return isset($this->Escalao6) ? $this->Escalao6 : null;
    }
    /**
     * Set Escalao6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $escalao6
     * @return \StructType\ContasBancariasERP
     */
    public function setEscalao6($escalao6 = null)
    {
        if (is_null($escalao6) || (is_array($escalao6) && empty($escalao6))) {
            unset($this->Escalao6);
        } else {
            $this->Escalao6 = $escalao6;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $estado
     * @return \StructType\ContasBancariasERP
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: boolean
        if (!is_null($estado) && !is_bool($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get ExcluirTipoMovEuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExcluirTipoMovEuro()
    {
        return isset($this->ExcluirTipoMovEuro) ? $this->ExcluirTipoMovEuro : null;
    }
    /**
     * Set ExcluirTipoMovEuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $excluirTipoMovEuro
     * @return \StructType\ContasBancariasERP
     */
    public function setExcluirTipoMovEuro($excluirTipoMovEuro = null)
    {
        // validation for constraint: boolean
        if (!is_null($excluirTipoMovEuro) && !is_bool($excluirTipoMovEuro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($excluirTipoMovEuro)), __LINE__);
        }
        if (is_null($excluirTipoMovEuro) || (is_array($excluirTipoMovEuro) && empty($excluirTipoMovEuro))) {
            unset($this->ExcluirTipoMovEuro);
        } else {
            $this->ExcluirTipoMovEuro = $excluirTipoMovEuro;
        }
        return $this;
    }
    /**
     * Get FaxGestor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFaxGestor()
    {
        return isset($this->FaxGestor) ? $this->FaxGestor : null;
    }
    /**
     * Set FaxGestor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $faxGestor
     * @return \StructType\ContasBancariasERP
     */
    public function setFaxGestor($faxGestor = null)
    {
        // validation for constraint: string
        if (!is_null($faxGestor) && !is_string($faxGestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($faxGestor)), __LINE__);
        }
        if (is_null($faxGestor) || (is_array($faxGestor) && empty($faxGestor))) {
            unset($this->FaxGestor);
        } else {
            $this->FaxGestor = $faxGestor;
        }
        return $this;
    }
    /**
     * Get FundoManeio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFundoManeio()
    {
        return isset($this->FundoManeio) ? $this->FundoManeio : null;
    }
    /**
     * Set FundoManeio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fundoManeio
     * @return \StructType\ContasBancariasERP
     */
    public function setFundoManeio($fundoManeio = null)
    {
        // validation for constraint: boolean
        if (!is_null($fundoManeio) && !is_bool($fundoManeio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fundoManeio)), __LINE__);
        }
        if (is_null($fundoManeio) || (is_array($fundoManeio) && empty($fundoManeio))) {
            unset($this->FundoManeio);
        } else {
            $this->FundoManeio = $fundoManeio;
        }
        return $this;
    }
    /**
     * Get Gestor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getGestor()
    {
        return isset($this->Gestor) ? $this->Gestor : null;
    }
    /**
     * Set Gestor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $gestor
     * @return \StructType\ContasBancariasERP
     */
    public function setGestor($gestor = null)
    {
        // validation for constraint: string
        if (!is_null($gestor) && !is_string($gestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($gestor)), __LINE__);
        }
        if (is_null($gestor) || (is_array($gestor) && empty($gestor))) {
            unset($this->Gestor);
        } else {
            $this->Gestor = $gestor;
        }
        return $this;
    }
    /**
     * Get IBAN value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIBAN()
    {
        return isset($this->IBAN) ? $this->IBAN : null;
    }
    /**
     * Set IBAN value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iBAN
     * @return \StructType\ContasBancariasERP
     */
    public function setIBAN($iBAN = null)
    {
        // validation for constraint: string
        if (!is_null($iBAN) && !is_string($iBAN)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iBAN)), __LINE__);
        }
        if (is_null($iBAN) || (is_array($iBAN) && empty($iBAN))) {
            unset($this->IBAN);
        } else {
            $this->IBAN = $iBAN;
        }
        return $this;
    }
    /**
     * Get IDDiarioCaixa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIDDiarioCaixa()
    {
        return isset($this->IDDiarioCaixa) ? $this->IDDiarioCaixa : null;
    }
    /**
     * Set IDDiarioCaixa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $iDDiarioCaixa
     * @return \StructType\ContasBancariasERP
     */
    public function setIDDiarioCaixa($iDDiarioCaixa = null)
    {
        // validation for constraint: pattern
        if (is_scalar($iDDiarioCaixa) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $iDDiarioCaixa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($iDDiarioCaixa, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($iDDiarioCaixa) && !is_string($iDDiarioCaixa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($iDDiarioCaixa)), __LINE__);
        }
        if (is_null($iDDiarioCaixa) || (is_array($iDDiarioCaixa) && empty($iDDiarioCaixa))) {
            unset($this->IDDiarioCaixa);
        } else {
            $this->IDDiarioCaixa = $iDDiarioCaixa;
        }
        return $this;
    }
    /**
     * Get IdSepa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getIdSepa()
    {
        return isset($this->IdSepa) ? $this->IdSepa : null;
    }
    /**
     * Set IdSepa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $idSepa
     * @return \StructType\ContasBancariasERP
     */
    public function setIdSepa($idSepa = null)
    {
        // validation for constraint: string
        if (!is_null($idSepa) && !is_string($idSepa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idSepa)), __LINE__);
        }
        if (is_null($idSepa) || (is_array($idSepa) && empty($idSepa))) {
            unset($this->IdSepa);
        } else {
            $this->IdSepa = $idSepa;
        }
        return $this;
    }
    /**
     * Get LancaTalaoDividido value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getLancaTalaoDividido()
    {
        return isset($this->LancaTalaoDividido) ? $this->LancaTalaoDividido : null;
    }
    /**
     * Set LancaTalaoDividido value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $lancaTalaoDividido
     * @return \StructType\ContasBancariasERP
     */
    public function setLancaTalaoDividido($lancaTalaoDividido = null)
    {
        // validation for constraint: boolean
        if (!is_null($lancaTalaoDividido) && !is_bool($lancaTalaoDividido)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($lancaTalaoDividido)), __LINE__);
        }
        if (is_null($lancaTalaoDividido) || (is_array($lancaTalaoDividido) && empty($lancaTalaoDividido))) {
            unset($this->LancaTalaoDividido);
        } else {
            $this->LancaTalaoDividido = $lancaTalaoDividido;
        }
        return $this;
    }
    /**
     * Get Limite value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getLimite()
    {
        return isset($this->Limite) ? $this->Limite : null;
    }
    /**
     * Set Limite value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $limite
     * @return \StructType\ContasBancariasERP
     */
    public function setLimite($limite = null)
    {
        if (is_null($limite) || (is_array($limite) && empty($limite))) {
            unset($this->Limite);
        } else {
            $this->Limite = $limite;
        }
        return $this;
    }
    /**
     * Get LocalEmissao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalEmissao()
    {
        return isset($this->LocalEmissao) ? $this->LocalEmissao : null;
    }
    /**
     * Set LocalEmissao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localEmissao
     * @return \StructType\ContasBancariasERP
     */
    public function setLocalEmissao($localEmissao = null)
    {
        // validation for constraint: string
        if (!is_null($localEmissao) && !is_string($localEmissao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localEmissao)), __LINE__);
        }
        if (is_null($localEmissao) || (is_array($localEmissao) && empty($localEmissao))) {
            unset($this->LocalEmissao);
        } else {
            $this->LocalEmissao = $localEmissao;
        }
        return $this;
    }
    /**
     * Get LocalEmissaoEuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLocalEmissaoEuro()
    {
        return isset($this->LocalEmissaoEuro) ? $this->LocalEmissaoEuro : null;
    }
    /**
     * Set LocalEmissaoEuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $localEmissaoEuro
     * @return \StructType\ContasBancariasERP
     */
    public function setLocalEmissaoEuro($localEmissaoEuro = null)
    {
        // validation for constraint: string
        if (!is_null($localEmissaoEuro) && !is_string($localEmissaoEuro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($localEmissaoEuro)), __LINE__);
        }
        if (is_null($localEmissaoEuro) || (is_array($localEmissaoEuro) && empty($localEmissaoEuro))) {
            unset($this->LocalEmissaoEuro);
        } else {
            $this->LocalEmissaoEuro = $localEmissaoEuro;
        }
        return $this;
    }
    /**
     * Get Maximo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMaximo()
    {
        return isset($this->Maximo) ? $this->Maximo : null;
    }
    /**
     * Set Maximo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $maximo
     * @return \StructType\ContasBancariasERP
     */
    public function setMaximo($maximo = null)
    {
        if (is_null($maximo) || (is_array($maximo) && empty($maximo))) {
            unset($this->Maximo);
        } else {
            $this->Maximo = $maximo;
        }
        return $this;
    }
    /**
     * Get Minimo value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getMinimo()
    {
        return isset($this->Minimo) ? $this->Minimo : null;
    }
    /**
     * Set Minimo value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $minimo
     * @return \StructType\ContasBancariasERP
     */
    public function setMinimo($minimo = null)
    {
        if (is_null($minimo) || (is_array($minimo) && empty($minimo))) {
            unset($this->Minimo);
        } else {
            $this->Minimo = $minimo;
        }
        return $this;
    }
    /**
     * Get Moeda value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoeda()
    {
        return isset($this->Moeda) ? $this->Moeda : null;
    }
    /**
     * Set Moeda value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moeda
     * @return \StructType\ContasBancariasERP
     */
    public function setMoeda($moeda = null)
    {
        // validation for constraint: string
        if (!is_null($moeda) && !is_string($moeda)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moeda)), __LINE__);
        }
        if (is_null($moeda) || (is_array($moeda) && empty($moeda))) {
            unset($this->Moeda);
        } else {
            $this->Moeda = $moeda;
        }
        return $this;
    }
    /**
     * Get MoedaSerie2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMoedaSerie2()
    {
        return isset($this->MoedaSerie2) ? $this->MoedaSerie2 : null;
    }
    /**
     * Set MoedaSerie2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moedaSerie2
     * @return \StructType\ContasBancariasERP
     */
    public function setMoedaSerie2($moedaSerie2 = null)
    {
        // validation for constraint: string
        if (!is_null($moedaSerie2) && !is_string($moedaSerie2)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moedaSerie2)), __LINE__);
        }
        if (is_null($moedaSerie2) || (is_array($moedaSerie2) && empty($moedaSerie2))) {
            unset($this->MoedaSerie2);
        } else {
            $this->MoedaSerie2 = $moedaSerie2;
        }
        return $this;
    }
    /**
     * Get MostraTDep value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMostraTDep()
    {
        return isset($this->MostraTDep) ? $this->MostraTDep : null;
    }
    /**
     * Set MostraTDep value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mostraTDep
     * @return \StructType\ContasBancariasERP
     */
    public function setMostraTDep($mostraTDep = null)
    {
        // validation for constraint: boolean
        if (!is_null($mostraTDep) && !is_bool($mostraTDep)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mostraTDep)), __LINE__);
        }
        if (is_null($mostraTDep) || (is_array($mostraTDep) && empty($mostraTDep))) {
            unset($this->MostraTDep);
        } else {
            $this->MostraTDep = $mostraTDep;
        }
        return $this;
    }
    /**
     * Get MostraTransCHQ value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMostraTransCHQ()
    {
        return isset($this->MostraTransCHQ) ? $this->MostraTransCHQ : null;
    }
    /**
     * Set MostraTransCHQ value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mostraTransCHQ
     * @return \StructType\ContasBancariasERP
     */
    public function setMostraTransCHQ($mostraTransCHQ = null)
    {
        // validation for constraint: boolean
        if (!is_null($mostraTransCHQ) && !is_bool($mostraTransCHQ)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mostraTransCHQ)), __LINE__);
        }
        if (is_null($mostraTransCHQ) || (is_array($mostraTransCHQ) && empty($mostraTransCHQ))) {
            unset($this->MostraTransCHQ);
        } else {
            $this->MostraTransCHQ = $mostraTransCHQ;
        }
        return $this;
    }
    /**
     * Get MostraTransVal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getMostraTransVal()
    {
        return isset($this->MostraTransVal) ? $this->MostraTransVal : null;
    }
    /**
     * Set MostraTransVal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $mostraTransVal
     * @return \StructType\ContasBancariasERP
     */
    public function setMostraTransVal($mostraTransVal = null)
    {
        // validation for constraint: boolean
        if (!is_null($mostraTransVal) && !is_bool($mostraTransVal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mostraTransVal)), __LINE__);
        }
        if (is_null($mostraTransVal) || (is_array($mostraTransVal) && empty($mostraTransVal))) {
            unset($this->MostraTransVal);
        } else {
            $this->MostraTransVal = $mostraTransVal;
        }
        return $this;
    }
    /**
     * Get MovComissaoAut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovComissaoAut()
    {
        return isset($this->MovComissaoAut) ? $this->MovComissaoAut : null;
    }
    /**
     * Set MovComissaoAut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movComissaoAut
     * @return \StructType\ContasBancariasERP
     */
    public function setMovComissaoAut($movComissaoAut = null)
    {
        // validation for constraint: string
        if (!is_null($movComissaoAut) && !is_string($movComissaoAut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($movComissaoAut)), __LINE__);
        }
        if (is_null($movComissaoAut) || (is_array($movComissaoAut) && empty($movComissaoAut))) {
            unset($this->MovComissaoAut);
        } else {
            $this->MovComissaoAut = $movComissaoAut;
        }
        return $this;
    }
    /**
     * Get MovimentoAut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovimentoAut()
    {
        return isset($this->MovimentoAut) ? $this->MovimentoAut : null;
    }
    /**
     * Set MovimentoAut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movimentoAut
     * @return \StructType\ContasBancariasERP
     */
    public function setMovimentoAut($movimentoAut = null)
    {
        // validation for constraint: string
        if (!is_null($movimentoAut) && !is_string($movimentoAut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($movimentoAut)), __LINE__);
        }
        if (is_null($movimentoAut) || (is_array($movimentoAut) && empty($movimentoAut))) {
            unset($this->MovimentoAut);
        } else {
            $this->MovimentoAut = $movimentoAut;
        }
        return $this;
    }
    /**
     * Get MovimentoTaxa value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMovimentoTaxa()
    {
        return isset($this->MovimentoTaxa) ? $this->MovimentoTaxa : null;
    }
    /**
     * Set MovimentoTaxa value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $movimentoTaxa
     * @return \StructType\ContasBancariasERP
     */
    public function setMovimentoTaxa($movimentoTaxa = null)
    {
        // validation for constraint: string
        if (!is_null($movimentoTaxa) && !is_string($movimentoTaxa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($movimentoTaxa)), __LINE__);
        }
        if (is_null($movimentoTaxa) || (is_array($movimentoTaxa) && empty($movimentoTaxa))) {
            unset($this->MovimentoTaxa);
        } else {
            $this->MovimentoTaxa = $movimentoTaxa;
        }
        return $this;
    }
    /**
     * Get NIB value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNIB()
    {
        return isset($this->NIB) ? $this->NIB : null;
    }
    /**
     * Set NIB value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nIB
     * @return \StructType\ContasBancariasERP
     */
    public function setNIB($nIB = null)
    {
        // validation for constraint: string
        if (!is_null($nIB) && !is_string($nIB)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIB)), __LINE__);
        }
        if (is_null($nIB) || (is_array($nIB) && empty($nIB))) {
            unset($this->NIB);
        } else {
            $this->NIB = $nIB;
        }
        return $this;
    }
    /**
     * Get NIF value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNIF()
    {
        return isset($this->NIF) ? $this->NIF : null;
    }
    /**
     * Set NIF value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nIF
     * @return \StructType\ContasBancariasERP
     */
    public function setNIF($nIF = null)
    {
        // validation for constraint: string
        if (!is_null($nIF) && !is_string($nIF)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nIF)), __LINE__);
        }
        if (is_null($nIF) || (is_array($nIF) && empty($nIF))) {
            unset($this->NIF);
        } else {
            $this->NIF = $nIF;
        }
        return $this;
    }
    /**
     * Get NivelAlerta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNivelAlerta()
    {
        return isset($this->NivelAlerta) ? $this->NivelAlerta : null;
    }
    /**
     * Set NivelAlerta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $nivelAlerta
     * @return \StructType\ContasBancariasERP
     */
    public function setNivelAlerta($nivelAlerta = null)
    {
        // validation for constraint: int
        if (!is_null($nivelAlerta) && !is_numeric($nivelAlerta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($nivelAlerta)), __LINE__);
        }
        if (is_null($nivelAlerta) || (is_array($nivelAlerta) && empty($nivelAlerta))) {
            unset($this->NivelAlerta);
        } else {
            $this->NivelAlerta = $nivelAlerta;
        }
        return $this;
    }
    /**
     * Get Notas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotas()
    {
        return isset($this->Notas) ? $this->Notas : null;
    }
    /**
     * Set Notas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notas
     * @return \StructType\ContasBancariasERP
     */
    public function setNotas($notas = null)
    {
        // validation for constraint: string
        if (!is_null($notas) && !is_string($notas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notas)), __LINE__);
        }
        if (is_null($notas) || (is_array($notas) && empty($notas))) {
            unset($this->Notas);
        } else {
            $this->Notas = $notas;
        }
        return $this;
    }
    /**
     * Get NumActualTalao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumActualTalao()
    {
        return isset($this->NumActualTalao) ? $this->NumActualTalao : null;
    }
    /**
     * Set NumActualTalao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numActualTalao
     * @return \StructType\ContasBancariasERP
     */
    public function setNumActualTalao($numActualTalao = null)
    {
        // validation for constraint: int
        if (!is_null($numActualTalao) && !is_numeric($numActualTalao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numActualTalao)), __LINE__);
        }
        if (is_null($numActualTalao) || (is_array($numActualTalao) && empty($numActualTalao))) {
            unset($this->NumActualTalao);
        } else {
            $this->NumActualTalao = $numActualTalao;
        }
        return $this;
    }
    /**
     * Get NumConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumConta()
    {
        return isset($this->NumConta) ? $this->NumConta : null;
    }
    /**
     * Set NumConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numConta
     * @return \StructType\ContasBancariasERP
     */
    public function setNumConta($numConta = null)
    {
        // validation for constraint: string
        if (!is_null($numConta) && !is_string($numConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numConta)), __LINE__);
        }
        if (is_null($numConta) || (is_array($numConta) && empty($numConta))) {
            unset($this->NumConta);
        } else {
            $this->NumConta = $numConta;
        }
        return $this;
    }
    /**
     * Get NumDiasMargem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumDiasMargem()
    {
        return isset($this->NumDiasMargem) ? $this->NumDiasMargem : null;
    }
    /**
     * Set NumDiasMargem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numDiasMargem
     * @return \StructType\ContasBancariasERP
     */
    public function setNumDiasMargem($numDiasMargem = null)
    {
        // validation for constraint: int
        if (!is_null($numDiasMargem) && !is_numeric($numDiasMargem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numDiasMargem)), __LINE__);
        }
        if (is_null($numDiasMargem) || (is_array($numDiasMargem) && empty($numDiasMargem))) {
            unset($this->NumDiasMargem);
        } else {
            $this->NumDiasMargem = $numDiasMargem;
        }
        return $this;
    }
    /**
     * Get NumeradorRemessas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumeradorRemessas()
    {
        return isset($this->NumeradorRemessas) ? $this->NumeradorRemessas : null;
    }
    /**
     * Set NumeradorRemessas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numeradorRemessas
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeradorRemessas($numeradorRemessas = null)
    {
        // validation for constraint: int
        if (!is_null($numeradorRemessas) && !is_numeric($numeradorRemessas)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeradorRemessas)), __LINE__);
        }
        if (is_null($numeradorRemessas) || (is_array($numeradorRemessas) && empty($numeradorRemessas))) {
            unset($this->NumeradorRemessas);
        } else {
            $this->NumeradorRemessas = $numeradorRemessas;
        }
        return $this;
    }
    /**
     * Get NumeroActual value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroActual()
    {
        return isset($this->NumeroActual) ? $this->NumeroActual : null;
    }
    /**
     * Set NumeroActual value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroActual
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeroActual($numeroActual = null)
    {
        // validation for constraint: string
        if (!is_null($numeroActual) && !is_string($numeroActual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroActual)), __LINE__);
        }
        if (is_null($numeroActual) || (is_array($numeroActual) && empty($numeroActual))) {
            unset($this->NumeroActual);
        } else {
            $this->NumeroActual = $numeroActual;
        }
        return $this;
    }
    /**
     * Get NumeroActualEuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroActualEuro()
    {
        return isset($this->NumeroActualEuro) ? $this->NumeroActualEuro : null;
    }
    /**
     * Set NumeroActualEuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroActualEuro
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeroActualEuro($numeroActualEuro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroActualEuro) && !is_string($numeroActualEuro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroActualEuro)), __LINE__);
        }
        if (is_null($numeroActualEuro) || (is_array($numeroActualEuro) && empty($numeroActualEuro))) {
            unset($this->NumeroActualEuro);
        } else {
            $this->NumeroActualEuro = $numeroActualEuro;
        }
        return $this;
    }
    /**
     * Get NumeroCedenteRem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroCedenteRem()
    {
        return isset($this->NumeroCedenteRem) ? $this->NumeroCedenteRem : null;
    }
    /**
     * Set NumeroCedenteRem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroCedenteRem
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeroCedenteRem($numeroCedenteRem = null)
    {
        // validation for constraint: string
        if (!is_null($numeroCedenteRem) && !is_string($numeroCedenteRem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroCedenteRem)), __LINE__);
        }
        if (is_null($numeroCedenteRem) || (is_array($numeroCedenteRem) && empty($numeroCedenteRem))) {
            unset($this->NumeroCedenteRem);
        } else {
            $this->NumeroCedenteRem = $numeroCedenteRem;
        }
        return $this;
    }
    /**
     * Get NumeroFolhaCofre value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getNumeroFolhaCofre()
    {
        return isset($this->NumeroFolhaCofre) ? $this->NumeroFolhaCofre : null;
    }
    /**
     * Set NumeroFolhaCofre value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $numeroFolhaCofre
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeroFolhaCofre($numeroFolhaCofre = null)
    {
        // validation for constraint: int
        if (!is_null($numeroFolhaCofre) && !is_numeric($numeroFolhaCofre)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($numeroFolhaCofre)), __LINE__);
        }
        if (is_null($numeroFolhaCofre) || (is_array($numeroFolhaCofre) && empty($numeroFolhaCofre))) {
            unset($this->NumeroFolhaCofre);
        } else {
            $this->NumeroFolhaCofre = $numeroFolhaCofre;
        }
        return $this;
    }
    /**
     * Get NumeroInicial value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroInicial()
    {
        return isset($this->NumeroInicial) ? $this->NumeroInicial : null;
    }
    /**
     * Set NumeroInicial value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroInicial
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeroInicial($numeroInicial = null)
    {
        // validation for constraint: string
        if (!is_null($numeroInicial) && !is_string($numeroInicial)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroInicial)), __LINE__);
        }
        if (is_null($numeroInicial) || (is_array($numeroInicial) && empty($numeroInicial))) {
            unset($this->NumeroInicial);
        } else {
            $this->NumeroInicial = $numeroInicial;
        }
        return $this;
    }
    /**
     * Get NumeroInicialEuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumeroInicialEuro()
    {
        return isset($this->NumeroInicialEuro) ? $this->NumeroInicialEuro : null;
    }
    /**
     * Set NumeroInicialEuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $numeroInicialEuro
     * @return \StructType\ContasBancariasERP
     */
    public function setNumeroInicialEuro($numeroInicialEuro = null)
    {
        // validation for constraint: string
        if (!is_null($numeroInicialEuro) && !is_string($numeroInicialEuro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($numeroInicialEuro)), __LINE__);
        }
        if (is_null($numeroInicialEuro) || (is_array($numeroInicialEuro) && empty($numeroInicialEuro))) {
            unset($this->NumeroInicialEuro);
        } else {
            $this->NumeroInicialEuro = $numeroInicialEuro;
        }
        return $this;
    }
    /**
     * Get Pais value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPais()
    {
        return isset($this->Pais) ? $this->Pais : null;
    }
    /**
     * Set Pais value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $pais
     * @return \StructType\ContasBancariasERP
     */
    public function setPais($pais = null)
    {
        // validation for constraint: string
        if (!is_null($pais) && !is_string($pais)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($pais)), __LINE__);
        }
        if (is_null($pais) || (is_array($pais) && empty($pais))) {
            unset($this->Pais);
        } else {
            $this->Pais = $pais;
        }
        return $this;
    }
    /**
     * Get PermiteSaldoZero value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getPermiteSaldoZero()
    {
        return isset($this->PermiteSaldoZero) ? $this->PermiteSaldoZero : null;
    }
    /**
     * Set PermiteSaldoZero value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $permiteSaldoZero
     * @return \StructType\ContasBancariasERP
     */
    public function setPermiteSaldoZero($permiteSaldoZero = null)
    {
        // validation for constraint: boolean
        if (!is_null($permiteSaldoZero) && !is_bool($permiteSaldoZero)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($permiteSaldoZero)), __LINE__);
        }
        if (is_null($permiteSaldoZero) || (is_array($permiteSaldoZero) && empty($permiteSaldoZero))) {
            unset($this->PermiteSaldoZero);
        } else {
            $this->PermiteSaldoZero = $permiteSaldoZero;
        }
        return $this;
    }
    /**
     * Get PlafondRemessas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getPlafondRemessas()
    {
        return isset($this->PlafondRemessas) ? $this->PlafondRemessas : null;
    }
    /**
     * Set PlafondRemessas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $plafondRemessas
     * @return \StructType\ContasBancariasERP
     */
    public function setPlafondRemessas($plafondRemessas = null)
    {
        if (is_null($plafondRemessas) || (is_array($plafondRemessas) && empty($plafondRemessas))) {
            unset($this->PlafondRemessas);
        } else {
            $this->PlafondRemessas = $plafondRemessas;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ContasBancariasERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Quantidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantidade()
    {
        return isset($this->Quantidade) ? $this->Quantidade : null;
    }
    /**
     * Set Quantidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantidade
     * @return \StructType\ContasBancariasERP
     */
    public function setQuantidade($quantidade = null)
    {
        // validation for constraint: int
        if (!is_null($quantidade) && !is_numeric($quantidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantidade)), __LINE__);
        }
        if (is_null($quantidade) || (is_array($quantidade) && empty($quantidade))) {
            unset($this->Quantidade);
        } else {
            $this->Quantidade = $quantidade;
        }
        return $this;
    }
    /**
     * Get QuantidadeEuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getQuantidadeEuro()
    {
        return isset($this->QuantidadeEuro) ? $this->QuantidadeEuro : null;
    }
    /**
     * Set QuantidadeEuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $quantidadeEuro
     * @return \StructType\ContasBancariasERP
     */
    public function setQuantidadeEuro($quantidadeEuro = null)
    {
        // validation for constraint: int
        if (!is_null($quantidadeEuro) && !is_numeric($quantidadeEuro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($quantidadeEuro)), __LINE__);
        }
        if (is_null($quantidadeEuro) || (is_array($quantidadeEuro) && empty($quantidadeEuro))) {
            unset($this->QuantidadeEuro);
        } else {
            $this->QuantidadeEuro = $quantidadeEuro;
        }
        return $this;
    }
    /**
     * Get RespFundoManeio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getRespFundoManeio()
    {
        return isset($this->RespFundoManeio) ? $this->RespFundoManeio : null;
    }
    /**
     * Set RespFundoManeio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $respFundoManeio
     * @return \StructType\ContasBancariasERP
     */
    public function setRespFundoManeio($respFundoManeio = null)
    {
        // validation for constraint: string
        if (!is_null($respFundoManeio) && !is_string($respFundoManeio)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($respFundoManeio)), __LINE__);
        }
        if (is_null($respFundoManeio) || (is_array($respFundoManeio) && empty($respFundoManeio))) {
            unset($this->RespFundoManeio);
        } else {
            $this->RespFundoManeio = $respFundoManeio;
        }
        return $this;
    }
    /**
     * Get SWIFT value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSWIFT()
    {
        return isset($this->SWIFT) ? $this->SWIFT : null;
    }
    /**
     * Set SWIFT value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sWIFT
     * @return \StructType\ContasBancariasERP
     */
    public function setSWIFT($sWIFT = null)
    {
        // validation for constraint: string
        if (!is_null($sWIFT) && !is_string($sWIFT)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sWIFT)), __LINE__);
        }
        if (is_null($sWIFT) || (is_array($sWIFT) && empty($sWIFT))) {
            unset($this->SWIFT);
        } else {
            $this->SWIFT = $sWIFT;
        }
        return $this;
    }
    /**
     * Get SerieAut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieAut()
    {
        return isset($this->SerieAut) ? $this->SerieAut : null;
    }
    /**
     * Set SerieAut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieAut
     * @return \StructType\ContasBancariasERP
     */
    public function setSerieAut($serieAut = null)
    {
        // validation for constraint: string
        if (!is_null($serieAut) && !is_string($serieAut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieAut)), __LINE__);
        }
        if (is_null($serieAut) || (is_array($serieAut) && empty($serieAut))) {
            unset($this->SerieAut);
        } else {
            $this->SerieAut = $serieAut;
        }
        return $this;
    }
    /**
     * Get SerieLivro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieLivro()
    {
        return isset($this->SerieLivro) ? $this->SerieLivro : null;
    }
    /**
     * Set SerieLivro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieLivro
     * @return \StructType\ContasBancariasERP
     */
    public function setSerieLivro($serieLivro = null)
    {
        // validation for constraint: string
        if (!is_null($serieLivro) && !is_string($serieLivro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieLivro)), __LINE__);
        }
        if (is_null($serieLivro) || (is_array($serieLivro) && empty($serieLivro))) {
            unset($this->SerieLivro);
        } else {
            $this->SerieLivro = $serieLivro;
        }
        return $this;
    }
    /**
     * Get SerieLivroEuro value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieLivroEuro()
    {
        return isset($this->SerieLivroEuro) ? $this->SerieLivroEuro : null;
    }
    /**
     * Set SerieLivroEuro value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieLivroEuro
     * @return \StructType\ContasBancariasERP
     */
    public function setSerieLivroEuro($serieLivroEuro = null)
    {
        // validation for constraint: string
        if (!is_null($serieLivroEuro) && !is_string($serieLivroEuro)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieLivroEuro)), __LINE__);
        }
        if (is_null($serieLivroEuro) || (is_array($serieLivroEuro) && empty($serieLivroEuro))) {
            unset($this->SerieLivroEuro);
        } else {
            $this->SerieLivroEuro = $serieLivroEuro;
        }
        return $this;
    }
    /**
     * Get SerieTalaoDeposito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieTalaoDeposito()
    {
        return isset($this->SerieTalaoDeposito) ? $this->SerieTalaoDeposito : null;
    }
    /**
     * Set SerieTalaoDeposito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieTalaoDeposito
     * @return \StructType\ContasBancariasERP
     */
    public function setSerieTalaoDeposito($serieTalaoDeposito = null)
    {
        // validation for constraint: string
        if (!is_null($serieTalaoDeposito) && !is_string($serieTalaoDeposito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieTalaoDeposito)), __LINE__);
        }
        if (is_null($serieTalaoDeposito) || (is_array($serieTalaoDeposito) && empty($serieTalaoDeposito))) {
            unset($this->SerieTalaoDeposito);
        } else {
            $this->SerieTalaoDeposito = $serieTalaoDeposito;
        }
        return $this;
    }
    /**
     * Get SufixoRem value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSufixoRem()
    {
        return isset($this->SufixoRem) ? $this->SufixoRem : null;
    }
    /**
     * Set SufixoRem value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $sufixoRem
     * @return \StructType\ContasBancariasERP
     */
    public function setSufixoRem($sufixoRem = null)
    {
        // validation for constraint: string
        if (!is_null($sufixoRem) && !is_string($sufixoRem)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($sufixoRem)), __LINE__);
        }
        if (is_null($sufixoRem) || (is_array($sufixoRem) && empty($sufixoRem))) {
            unset($this->SufixoRem);
        } else {
            $this->SufixoRem = $sufixoRem;
        }
        return $this;
    }
    /**
     * Get Taxa1 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxa1()
    {
        return isset($this->Taxa1) ? $this->Taxa1 : null;
    }
    /**
     * Set Taxa1 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxa1
     * @return \StructType\ContasBancariasERP
     */
    public function setTaxa1($taxa1 = null)
    {
        if (is_null($taxa1) || (is_array($taxa1) && empty($taxa1))) {
            unset($this->Taxa1);
        } else {
            $this->Taxa1 = $taxa1;
        }
        return $this;
    }
    /**
     * Get Taxa2 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxa2()
    {
        return isset($this->Taxa2) ? $this->Taxa2 : null;
    }
    /**
     * Set Taxa2 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxa2
     * @return \StructType\ContasBancariasERP
     */
    public function setTaxa2($taxa2 = null)
    {
        if (is_null($taxa2) || (is_array($taxa2) && empty($taxa2))) {
            unset($this->Taxa2);
        } else {
            $this->Taxa2 = $taxa2;
        }
        return $this;
    }
    /**
     * Get Taxa3 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxa3()
    {
        return isset($this->Taxa3) ? $this->Taxa3 : null;
    }
    /**
     * Set Taxa3 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxa3
     * @return \StructType\ContasBancariasERP
     */
    public function setTaxa3($taxa3 = null)
    {
        if (is_null($taxa3) || (is_array($taxa3) && empty($taxa3))) {
            unset($this->Taxa3);
        } else {
            $this->Taxa3 = $taxa3;
        }
        return $this;
    }
    /**
     * Get Taxa4 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxa4()
    {
        return isset($this->Taxa4) ? $this->Taxa4 : null;
    }
    /**
     * Set Taxa4 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxa4
     * @return \StructType\ContasBancariasERP
     */
    public function setTaxa4($taxa4 = null)
    {
        if (is_null($taxa4) || (is_array($taxa4) && empty($taxa4))) {
            unset($this->Taxa4);
        } else {
            $this->Taxa4 = $taxa4;
        }
        return $this;
    }
    /**
     * Get Taxa5 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxa5()
    {
        return isset($this->Taxa5) ? $this->Taxa5 : null;
    }
    /**
     * Set Taxa5 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxa5
     * @return \StructType\ContasBancariasERP
     */
    public function setTaxa5($taxa5 = null)
    {
        if (is_null($taxa5) || (is_array($taxa5) && empty($taxa5))) {
            unset($this->Taxa5);
        } else {
            $this->Taxa5 = $taxa5;
        }
        return $this;
    }
    /**
     * Get Taxa6 value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getTaxa6()
    {
        return isset($this->Taxa6) ? $this->Taxa6 : null;
    }
    /**
     * Set Taxa6 value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $taxa6
     * @return \StructType\ContasBancariasERP
     */
    public function setTaxa6($taxa6 = null)
    {
        if (is_null($taxa6) || (is_array($taxa6) && empty($taxa6))) {
            unset($this->Taxa6);
        } else {
            $this->Taxa6 = $taxa6;
        }
        return $this;
    }
    /**
     * Get TefGestor value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTefGestor()
    {
        return isset($this->TefGestor) ? $this->TefGestor : null;
    }
    /**
     * Set TefGestor value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tefGestor
     * @return \StructType\ContasBancariasERP
     */
    public function setTefGestor($tefGestor = null)
    {
        // validation for constraint: string
        if (!is_null($tefGestor) && !is_string($tefGestor)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tefGestor)), __LINE__);
        }
        if (is_null($tefGestor) || (is_array($tefGestor) && empty($tefGestor))) {
            unset($this->TefGestor);
        } else {
            $this->TefGestor = $tefGestor;
        }
        return $this;
    }
    /**
     * Get TipoConta value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getTipoConta()
    {
        return isset($this->TipoConta) ? $this->TipoConta : null;
    }
    /**
     * Set TipoConta value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $tipoConta
     * @return \StructType\ContasBancariasERP
     */
    public function setTipoConta($tipoConta = null)
    {
        // validation for constraint: int
        if (!is_null($tipoConta) && !is_numeric($tipoConta)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($tipoConta)), __LINE__);
        }
        if (is_null($tipoConta) || (is_array($tipoConta) && empty($tipoConta))) {
            unset($this->TipoConta);
        } else {
            $this->TipoConta = $tipoConta;
        }
        return $this;
    }
    /**
     * Get TipoDocAut value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoDocAut()
    {
        return isset($this->TipoDocAut) ? $this->TipoDocAut : null;
    }
    /**
     * Set TipoDocAut value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoDocAut
     * @return \StructType\ContasBancariasERP
     */
    public function setTipoDocAut($tipoDocAut = null)
    {
        // validation for constraint: string
        if (!is_null($tipoDocAut) && !is_string($tipoDocAut)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoDocAut)), __LINE__);
        }
        if (is_null($tipoDocAut) || (is_array($tipoDocAut) && empty($tipoDocAut))) {
            unset($this->TipoDocAut);
        } else {
            $this->TipoDocAut = $tipoDocAut;
        }
        return $this;
    }
    /**
     * Get TipoEntidade value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTipoEntidade()
    {
        return isset($this->TipoEntidade) ? $this->TipoEntidade : null;
    }
    /**
     * Set TipoEntidade value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $tipoEntidade
     * @return \StructType\ContasBancariasERP
     */
    public function setTipoEntidade($tipoEntidade = null)
    {
        // validation for constraint: string
        if (!is_null($tipoEntidade) && !is_string($tipoEntidade)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($tipoEntidade)), __LINE__);
        }
        if (is_null($tipoEntidade) || (is_array($tipoEntidade) && empty($tipoEntidade))) {
            unset($this->TipoEntidade);
        } else {
            $this->TipoEntidade = $tipoEntidade;
        }
        return $this;
    }
    /**
     * Get TitCodPost value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitCodPost()
    {
        return isset($this->TitCodPost) ? $this->TitCodPost : null;
    }
    /**
     * Set TitCodPost value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titCodPost
     * @return \StructType\ContasBancariasERP
     */
    public function setTitCodPost($titCodPost = null)
    {
        // validation for constraint: string
        if (!is_null($titCodPost) && !is_string($titCodPost)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titCodPost)), __LINE__);
        }
        if (is_null($titCodPost) || (is_array($titCodPost) && empty($titCodPost))) {
            unset($this->TitCodPost);
        } else {
            $this->TitCodPost = $titCodPost;
        }
        return $this;
    }
    /**
     * Get TitLocal value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitLocal()
    {
        return isset($this->TitLocal) ? $this->TitLocal : null;
    }
    /**
     * Set TitLocal value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titLocal
     * @return \StructType\ContasBancariasERP
     */
    public function setTitLocal($titLocal = null)
    {
        // validation for constraint: string
        if (!is_null($titLocal) && !is_string($titLocal)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titLocal)), __LINE__);
        }
        if (is_null($titLocal) || (is_array($titLocal) && empty($titLocal))) {
            unset($this->TitLocal);
        } else {
            $this->TitLocal = $titLocal;
        }
        return $this;
    }
    /**
     * Get TitMora value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitMora()
    {
        return isset($this->TitMora) ? $this->TitMora : null;
    }
    /**
     * Set TitMora value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titMora
     * @return \StructType\ContasBancariasERP
     */
    public function setTitMora($titMora = null)
    {
        // validation for constraint: string
        if (!is_null($titMora) && !is_string($titMora)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titMora)), __LINE__);
        }
        if (is_null($titMora) || (is_array($titMora) && empty($titMora))) {
            unset($this->TitMora);
        } else {
            $this->TitMora = $titMora;
        }
        return $this;
    }
    /**
     * Get TitNome value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTitNome()
    {
        return isset($this->TitNome) ? $this->TitNome : null;
    }
    /**
     * Set TitNome value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $titNome
     * @return \StructType\ContasBancariasERP
     */
    public function setTitNome($titNome = null)
    {
        // validation for constraint: string
        if (!is_null($titNome) && !is_string($titNome)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($titNome)), __LINE__);
        }
        if (is_null($titNome) || (is_array($titNome) && empty($titNome))) {
            unset($this->TitNome);
        } else {
            $this->TitNome = $titNome;
        }
        return $this;
    }
    /**
     * Get ValorFundoManeio value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorFundoManeio()
    {
        return isset($this->ValorFundoManeio) ? $this->ValorFundoManeio : null;
    }
    /**
     * Set ValorFundoManeio value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorFundoManeio
     * @return \StructType\ContasBancariasERP
     */
    public function setValorFundoManeio($valorFundoManeio = null)
    {
        if (is_null($valorFundoManeio) || (is_array($valorFundoManeio) && empty($valorFundoManeio))) {
            unset($this->ValorFundoManeio);
        } else {
            $this->ValorFundoManeio = $valorFundoManeio;
        }
        return $this;
    }
    /**
     * Get ValorRemessas value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return float|null
     */
    public function getValorRemessas()
    {
        return isset($this->ValorRemessas) ? $this->ValorRemessas : null;
    }
    /**
     * Set ValorRemessas value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param float $valorRemessas
     * @return \StructType\ContasBancariasERP
     */
    public function setValorRemessas($valorRemessas = null)
    {
        if (is_null($valorRemessas) || (is_array($valorRemessas) && empty($valorRemessas))) {
            unset($this->ValorRemessas);
        } else {
            $this->ValorRemessas = $valorRemessas;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\ContasBancariasERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ContasBancariasERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
