<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for ConfigEasyPay StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:ConfigEasyPay
 * @subpackage Structs
 */
class ConfigEasyPay extends AbstractStructBase
{
    /**
     * The Alert
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Alert;
    /**
     * The Amex
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Amex;
    /**
     * The Cin
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Cin;
    /**
     * The Client_id
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Client_id;
    /**
     * The ContaBancaria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ContaBancaria;
    /**
     * The Country
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Country;
    /**
     * The Credit_Card_Title_From
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Credit_Card_Title_From;
    /**
     * The CriaNotaCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CriaNotaCredito;
    /**
     * The Date_End
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date_End;
    /**
     * The Date_Ini
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $Date_Ini;
    /**
     * The Dd
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Dd;
    /**
     * The Demo
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Demo;
    /**
     * The Descricao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Descricao;
    /**
     * The DiasPesquisaPagamentos
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $DiasPesquisaPagamentos;
    /**
     * The DocumentoCompensacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentoCompensacao;
    /**
     * The DocumentoLiquidacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DocumentoLiquidacao;
    /**
     * The EfetuaCompensacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $EfetuaCompensacao;
    /**
     * The Entity
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Entity;
    /**
     * The First
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $First;
    /**
     * The ID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ID;
    /**
     * The IntegracaoCRM365
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $IntegracaoCRM365;
    /**
     * The Last
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Last;
    /**
     * The Mb
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Mb;
    /**
     * The ModoRecebimentoCompensacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModoRecebimentoCompensacao;
    /**
     * The ModoRecebimentoLiquidacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModoRecebimentoLiquidacao;
    /**
     * The ModoRecebimentoNotaCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModoRecebimentoNotaCredito;
    /**
     * The ModuloNotaCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ModuloNotaCredito;
    /**
     * The Nib
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Nib;
    /**
     * The NotaCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $NotaCredito;
    /**
     * The Number
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Number;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The Public_Key
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Public_Key;
    /**
     * The SerieDocumentoCompensacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieDocumentoCompensacao;
    /**
     * The SerieDocumentoLiquidacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieDocumentoLiquidacao;
    /**
     * The SerieNotaCredito
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $SerieNotaCredito;
    /**
     * The Status
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Status;
    /**
     * The Transfer_Frequency
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Transfer_Frequency;
    /**
     * The ValidaIP
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $ValidaIP;
    /**
     * The Validation_code
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Validation_code;
    /**
     * The Visa
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Visa;
    /**
     * Constructor method for ConfigEasyPay
     * @uses ConfigEasyPay::setAlert()
     * @uses ConfigEasyPay::setAmex()
     * @uses ConfigEasyPay::setCin()
     * @uses ConfigEasyPay::setClient_id()
     * @uses ConfigEasyPay::setContaBancaria()
     * @uses ConfigEasyPay::setCountry()
     * @uses ConfigEasyPay::setCredit_Card_Title_From()
     * @uses ConfigEasyPay::setCriaNotaCredito()
     * @uses ConfigEasyPay::setDate_End()
     * @uses ConfigEasyPay::setDate_Ini()
     * @uses ConfigEasyPay::setDd()
     * @uses ConfigEasyPay::setDemo()
     * @uses ConfigEasyPay::setDescricao()
     * @uses ConfigEasyPay::setDiasPesquisaPagamentos()
     * @uses ConfigEasyPay::setDocumentoCompensacao()
     * @uses ConfigEasyPay::setDocumentoLiquidacao()
     * @uses ConfigEasyPay::setEfetuaCompensacao()
     * @uses ConfigEasyPay::setEntity()
     * @uses ConfigEasyPay::setFirst()
     * @uses ConfigEasyPay::setID()
     * @uses ConfigEasyPay::setIntegracaoCRM365()
     * @uses ConfigEasyPay::setLast()
     * @uses ConfigEasyPay::setMb()
     * @uses ConfigEasyPay::setModoRecebimentoCompensacao()
     * @uses ConfigEasyPay::setModoRecebimentoLiquidacao()
     * @uses ConfigEasyPay::setModoRecebimentoNotaCredito()
     * @uses ConfigEasyPay::setModuloNotaCredito()
     * @uses ConfigEasyPay::setNib()
     * @uses ConfigEasyPay::setNotaCredito()
     * @uses ConfigEasyPay::setNumber()
     * @uses ConfigEasyPay::setProtegida()
     * @uses ConfigEasyPay::setPublic_Key()
     * @uses ConfigEasyPay::setSerieDocumentoCompensacao()
     * @uses ConfigEasyPay::setSerieDocumentoLiquidacao()
     * @uses ConfigEasyPay::setSerieNotaCredito()
     * @uses ConfigEasyPay::setStatus()
     * @uses ConfigEasyPay::setTransfer_Frequency()
     * @uses ConfigEasyPay::setValidaIP()
     * @uses ConfigEasyPay::setValidation_code()
     * @uses ConfigEasyPay::setVisa()
     * @param bool $alert
     * @param bool $amex
     * @param string $cin
     * @param string $client_id
     * @param string $contaBancaria
     * @param string $country
     * @param string $credit_Card_Title_From
     * @param bool $criaNotaCredito
     * @param string $date_End
     * @param string $date_Ini
     * @param bool $dd
     * @param bool $demo
     * @param string $descricao
     * @param int $diasPesquisaPagamentos
     * @param string $documentoCompensacao
     * @param string $documentoLiquidacao
     * @param bool $efetuaCompensacao
     * @param string $entity
     * @param string $first
     * @param int $iD
     * @param bool $integracaoCRM365
     * @param string $last
     * @param bool $mb
     * @param string $modoRecebimentoCompensacao
     * @param string $modoRecebimentoLiquidacao
     * @param string $modoRecebimentoNotaCredito
     * @param string $moduloNotaCredito
     * @param string $nib
     * @param string $notaCredito
     * @param string $number
     * @param bool $protegida
     * @param string $public_Key
     * @param string $serieDocumentoCompensacao
     * @param string $serieDocumentoLiquidacao
     * @param string $serieNotaCredito
     * @param string $status
     * @param string $transfer_Frequency
     * @param bool $validaIP
     * @param string $validation_code
     * @param bool $visa
     */
    public function __construct($alert = null, $amex = null, $cin = null, $client_id = null, $contaBancaria = null, $country = null, $credit_Card_Title_From = null, $criaNotaCredito = null, $date_End = null, $date_Ini = null, $dd = null, $demo = null, $descricao = null, $diasPesquisaPagamentos = null, $documentoCompensacao = null, $documentoLiquidacao = null, $efetuaCompensacao = null, $entity = null, $first = null, $iD = null, $integracaoCRM365 = null, $last = null, $mb = null, $modoRecebimentoCompensacao = null, $modoRecebimentoLiquidacao = null, $modoRecebimentoNotaCredito = null, $moduloNotaCredito = null, $nib = null, $notaCredito = null, $number = null, $protegida = null, $public_Key = null, $serieDocumentoCompensacao = null, $serieDocumentoLiquidacao = null, $serieNotaCredito = null, $status = null, $transfer_Frequency = null, $validaIP = null, $validation_code = null, $visa = null)
    {
        $this
            ->setAlert($alert)
            ->setAmex($amex)
            ->setCin($cin)
            ->setClient_id($client_id)
            ->setContaBancaria($contaBancaria)
            ->setCountry($country)
            ->setCredit_Card_Title_From($credit_Card_Title_From)
            ->setCriaNotaCredito($criaNotaCredito)
            ->setDate_End($date_End)
            ->setDate_Ini($date_Ini)
            ->setDd($dd)
            ->setDemo($demo)
            ->setDescricao($descricao)
            ->setDiasPesquisaPagamentos($diasPesquisaPagamentos)
            ->setDocumentoCompensacao($documentoCompensacao)
            ->setDocumentoLiquidacao($documentoLiquidacao)
            ->setEfetuaCompensacao($efetuaCompensacao)
            ->setEntity($entity)
            ->setFirst($first)
            ->setID($iD)
            ->setIntegracaoCRM365($integracaoCRM365)
            ->setLast($last)
            ->setMb($mb)
            ->setModoRecebimentoCompensacao($modoRecebimentoCompensacao)
            ->setModoRecebimentoLiquidacao($modoRecebimentoLiquidacao)
            ->setModoRecebimentoNotaCredito($modoRecebimentoNotaCredito)
            ->setModuloNotaCredito($moduloNotaCredito)
            ->setNib($nib)
            ->setNotaCredito($notaCredito)
            ->setNumber($number)
            ->setProtegida($protegida)
            ->setPublic_Key($public_Key)
            ->setSerieDocumentoCompensacao($serieDocumentoCompensacao)
            ->setSerieDocumentoLiquidacao($serieDocumentoLiquidacao)
            ->setSerieNotaCredito($serieNotaCredito)
            ->setStatus($status)
            ->setTransfer_Frequency($transfer_Frequency)
            ->setValidaIP($validaIP)
            ->setValidation_code($validation_code)
            ->setVisa($visa);
    }
    /**
     * Get Alert value
     * @return bool|null
     */
    public function getAlert()
    {
        return $this->Alert;
    }
    /**
     * Set Alert value
     * @param bool $alert
     * @return \StructType\ConfigEasyPay
     */
    public function setAlert($alert = null)
    {
        // validation for constraint: boolean
        if (!is_null($alert) && !is_bool($alert)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($alert)), __LINE__);
        }
        $this->Alert = $alert;
        return $this;
    }
    /**
     * Get Amex value
     * @return bool|null
     */
    public function getAmex()
    {
        return $this->Amex;
    }
    /**
     * Set Amex value
     * @param bool $amex
     * @return \StructType\ConfigEasyPay
     */
    public function setAmex($amex = null)
    {
        // validation for constraint: boolean
        if (!is_null($amex) && !is_bool($amex)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($amex)), __LINE__);
        }
        $this->Amex = $amex;
        return $this;
    }
    /**
     * Get Cin value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCin()
    {
        return isset($this->Cin) ? $this->Cin : null;
    }
    /**
     * Set Cin value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $cin
     * @return \StructType\ConfigEasyPay
     */
    public function setCin($cin = null)
    {
        // validation for constraint: string
        if (!is_null($cin) && !is_string($cin)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($cin)), __LINE__);
        }
        if (is_null($cin) || (is_array($cin) && empty($cin))) {
            unset($this->Cin);
        } else {
            $this->Cin = $cin;
        }
        return $this;
    }
    /**
     * Get Client_id value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getClient_id()
    {
        return isset($this->Client_id) ? $this->Client_id : null;
    }
    /**
     * Set Client_id value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $client_id
     * @return \StructType\ConfigEasyPay
     */
    public function setClient_id($client_id = null)
    {
        // validation for constraint: string
        if (!is_null($client_id) && !is_string($client_id)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($client_id)), __LINE__);
        }
        if (is_null($client_id) || (is_array($client_id) && empty($client_id))) {
            unset($this->Client_id);
        } else {
            $this->Client_id = $client_id;
        }
        return $this;
    }
    /**
     * Get ContaBancaria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getContaBancaria()
    {
        return isset($this->ContaBancaria) ? $this->ContaBancaria : null;
    }
    /**
     * Set ContaBancaria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $contaBancaria
     * @return \StructType\ConfigEasyPay
     */
    public function setContaBancaria($contaBancaria = null)
    {
        // validation for constraint: string
        if (!is_null($contaBancaria) && !is_string($contaBancaria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($contaBancaria)), __LINE__);
        }
        if (is_null($contaBancaria) || (is_array($contaBancaria) && empty($contaBancaria))) {
            unset($this->ContaBancaria);
        } else {
            $this->ContaBancaria = $contaBancaria;
        }
        return $this;
    }
    /**
     * Get Country value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCountry()
    {
        return isset($this->Country) ? $this->Country : null;
    }
    /**
     * Set Country value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $country
     * @return \StructType\ConfigEasyPay
     */
    public function setCountry($country = null)
    {
        // validation for constraint: string
        if (!is_null($country) && !is_string($country)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($country)), __LINE__);
        }
        if (is_null($country) || (is_array($country) && empty($country))) {
            unset($this->Country);
        } else {
            $this->Country = $country;
        }
        return $this;
    }
    /**
     * Get Credit_Card_Title_From value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getCredit_Card_Title_From()
    {
        return isset($this->Credit_Card_Title_From) ? $this->Credit_Card_Title_From : null;
    }
    /**
     * Set Credit_Card_Title_From value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $credit_Card_Title_From
     * @return \StructType\ConfigEasyPay
     */
    public function setCredit_Card_Title_From($credit_Card_Title_From = null)
    {
        // validation for constraint: string
        if (!is_null($credit_Card_Title_From) && !is_string($credit_Card_Title_From)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($credit_Card_Title_From)), __LINE__);
        }
        if (is_null($credit_Card_Title_From) || (is_array($credit_Card_Title_From) && empty($credit_Card_Title_From))) {
            unset($this->Credit_Card_Title_From);
        } else {
            $this->Credit_Card_Title_From = $credit_Card_Title_From;
        }
        return $this;
    }
    /**
     * Get CriaNotaCredito value
     * @return bool|null
     */
    public function getCriaNotaCredito()
    {
        return $this->CriaNotaCredito;
    }
    /**
     * Set CriaNotaCredito value
     * @param bool $criaNotaCredito
     * @return \StructType\ConfigEasyPay
     */
    public function setCriaNotaCredito($criaNotaCredito = null)
    {
        // validation for constraint: boolean
        if (!is_null($criaNotaCredito) && !is_bool($criaNotaCredito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($criaNotaCredito)), __LINE__);
        }
        $this->CriaNotaCredito = $criaNotaCredito;
        return $this;
    }
    /**
     * Get Date_End value
     * @return string|null
     */
    public function getDate_End()
    {
        return $this->Date_End;
    }
    /**
     * Set Date_End value
     * @param string $date_End
     * @return \StructType\ConfigEasyPay
     */
    public function setDate_End($date_End = null)
    {
        // validation for constraint: string
        if (!is_null($date_End) && !is_string($date_End)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_End)), __LINE__);
        }
        $this->Date_End = $date_End;
        return $this;
    }
    /**
     * Get Date_Ini value
     * @return string|null
     */
    public function getDate_Ini()
    {
        return $this->Date_Ini;
    }
    /**
     * Set Date_Ini value
     * @param string $date_Ini
     * @return \StructType\ConfigEasyPay
     */
    public function setDate_Ini($date_Ini = null)
    {
        // validation for constraint: string
        if (!is_null($date_Ini) && !is_string($date_Ini)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($date_Ini)), __LINE__);
        }
        $this->Date_Ini = $date_Ini;
        return $this;
    }
    /**
     * Get Dd value
     * @return bool|null
     */
    public function getDd()
    {
        return $this->Dd;
    }
    /**
     * Set Dd value
     * @param bool $dd
     * @return \StructType\ConfigEasyPay
     */
    public function setDd($dd = null)
    {
        // validation for constraint: boolean
        if (!is_null($dd) && !is_bool($dd)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($dd)), __LINE__);
        }
        $this->Dd = $dd;
        return $this;
    }
    /**
     * Get Demo value
     * @return bool|null
     */
    public function getDemo()
    {
        return $this->Demo;
    }
    /**
     * Set Demo value
     * @param bool $demo
     * @return \StructType\ConfigEasyPay
     */
    public function setDemo($demo = null)
    {
        // validation for constraint: boolean
        if (!is_null($demo) && !is_bool($demo)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($demo)), __LINE__);
        }
        $this->Demo = $demo;
        return $this;
    }
    /**
     * Get Descricao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDescricao()
    {
        return isset($this->Descricao) ? $this->Descricao : null;
    }
    /**
     * Set Descricao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $descricao
     * @return \StructType\ConfigEasyPay
     */
    public function setDescricao($descricao = null)
    {
        // validation for constraint: string
        if (!is_null($descricao) && !is_string($descricao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($descricao)), __LINE__);
        }
        if (is_null($descricao) || (is_array($descricao) && empty($descricao))) {
            unset($this->Descricao);
        } else {
            $this->Descricao = $descricao;
        }
        return $this;
    }
    /**
     * Get DiasPesquisaPagamentos value
     * @return int|null
     */
    public function getDiasPesquisaPagamentos()
    {
        return $this->DiasPesquisaPagamentos;
    }
    /**
     * Set DiasPesquisaPagamentos value
     * @param int $diasPesquisaPagamentos
     * @return \StructType\ConfigEasyPay
     */
    public function setDiasPesquisaPagamentos($diasPesquisaPagamentos = null)
    {
        // validation for constraint: int
        if (!is_null($diasPesquisaPagamentos) && !is_numeric($diasPesquisaPagamentos)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($diasPesquisaPagamentos)), __LINE__);
        }
        $this->DiasPesquisaPagamentos = $diasPesquisaPagamentos;
        return $this;
    }
    /**
     * Get DocumentoCompensacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentoCompensacao()
    {
        return isset($this->DocumentoCompensacao) ? $this->DocumentoCompensacao : null;
    }
    /**
     * Set DocumentoCompensacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentoCompensacao
     * @return \StructType\ConfigEasyPay
     */
    public function setDocumentoCompensacao($documentoCompensacao = null)
    {
        // validation for constraint: string
        if (!is_null($documentoCompensacao) && !is_string($documentoCompensacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentoCompensacao)), __LINE__);
        }
        if (is_null($documentoCompensacao) || (is_array($documentoCompensacao) && empty($documentoCompensacao))) {
            unset($this->DocumentoCompensacao);
        } else {
            $this->DocumentoCompensacao = $documentoCompensacao;
        }
        return $this;
    }
    /**
     * Get DocumentoLiquidacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDocumentoLiquidacao()
    {
        return isset($this->DocumentoLiquidacao) ? $this->DocumentoLiquidacao : null;
    }
    /**
     * Set DocumentoLiquidacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $documentoLiquidacao
     * @return \StructType\ConfigEasyPay
     */
    public function setDocumentoLiquidacao($documentoLiquidacao = null)
    {
        // validation for constraint: string
        if (!is_null($documentoLiquidacao) && !is_string($documentoLiquidacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($documentoLiquidacao)), __LINE__);
        }
        if (is_null($documentoLiquidacao) || (is_array($documentoLiquidacao) && empty($documentoLiquidacao))) {
            unset($this->DocumentoLiquidacao);
        } else {
            $this->DocumentoLiquidacao = $documentoLiquidacao;
        }
        return $this;
    }
    /**
     * Get EfetuaCompensacao value
     * @return bool|null
     */
    public function getEfetuaCompensacao()
    {
        return $this->EfetuaCompensacao;
    }
    /**
     * Set EfetuaCompensacao value
     * @param bool $efetuaCompensacao
     * @return \StructType\ConfigEasyPay
     */
    public function setEfetuaCompensacao($efetuaCompensacao = null)
    {
        // validation for constraint: boolean
        if (!is_null($efetuaCompensacao) && !is_bool($efetuaCompensacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($efetuaCompensacao)), __LINE__);
        }
        $this->EfetuaCompensacao = $efetuaCompensacao;
        return $this;
    }
    /**
     * Get Entity value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEntity()
    {
        return isset($this->Entity) ? $this->Entity : null;
    }
    /**
     * Set Entity value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $entity
     * @return \StructType\ConfigEasyPay
     */
    public function setEntity($entity = null)
    {
        // validation for constraint: string
        if (!is_null($entity) && !is_string($entity)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($entity)), __LINE__);
        }
        if (is_null($entity) || (is_array($entity) && empty($entity))) {
            unset($this->Entity);
        } else {
            $this->Entity = $entity;
        }
        return $this;
    }
    /**
     * Get First value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getFirst()
    {
        return isset($this->First) ? $this->First : null;
    }
    /**
     * Set First value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $first
     * @return \StructType\ConfigEasyPay
     */
    public function setFirst($first = null)
    {
        // validation for constraint: string
        if (!is_null($first) && !is_string($first)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($first)), __LINE__);
        }
        if (is_null($first) || (is_array($first) && empty($first))) {
            unset($this->First);
        } else {
            $this->First = $first;
        }
        return $this;
    }
    /**
     * Get ID value
     * @return int|null
     */
    public function getID()
    {
        return $this->ID;
    }
    /**
     * Set ID value
     * @param int $iD
     * @return \StructType\ConfigEasyPay
     */
    public function setID($iD = null)
    {
        // validation for constraint: int
        if (!is_null($iD) && !is_numeric($iD)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($iD)), __LINE__);
        }
        $this->ID = $iD;
        return $this;
    }
    /**
     * Get IntegracaoCRM365 value
     * @return bool|null
     */
    public function getIntegracaoCRM365()
    {
        return $this->IntegracaoCRM365;
    }
    /**
     * Set IntegracaoCRM365 value
     * @param bool $integracaoCRM365
     * @return \StructType\ConfigEasyPay
     */
    public function setIntegracaoCRM365($integracaoCRM365 = null)
    {
        // validation for constraint: boolean
        if (!is_null($integracaoCRM365) && !is_bool($integracaoCRM365)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($integracaoCRM365)), __LINE__);
        }
        $this->IntegracaoCRM365 = $integracaoCRM365;
        return $this;
    }
    /**
     * Get Last value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getLast()
    {
        return isset($this->Last) ? $this->Last : null;
    }
    /**
     * Set Last value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $last
     * @return \StructType\ConfigEasyPay
     */
    public function setLast($last = null)
    {
        // validation for constraint: string
        if (!is_null($last) && !is_string($last)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($last)), __LINE__);
        }
        if (is_null($last) || (is_array($last) && empty($last))) {
            unset($this->Last);
        } else {
            $this->Last = $last;
        }
        return $this;
    }
    /**
     * Get Mb value
     * @return bool|null
     */
    public function getMb()
    {
        return $this->Mb;
    }
    /**
     * Set Mb value
     * @param bool $mb
     * @return \StructType\ConfigEasyPay
     */
    public function setMb($mb = null)
    {
        // validation for constraint: boolean
        if (!is_null($mb) && !is_bool($mb)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($mb)), __LINE__);
        }
        $this->Mb = $mb;
        return $this;
    }
    /**
     * Get ModoRecebimentoCompensacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModoRecebimentoCompensacao()
    {
        return isset($this->ModoRecebimentoCompensacao) ? $this->ModoRecebimentoCompensacao : null;
    }
    /**
     * Set ModoRecebimentoCompensacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modoRecebimentoCompensacao
     * @return \StructType\ConfigEasyPay
     */
    public function setModoRecebimentoCompensacao($modoRecebimentoCompensacao = null)
    {
        // validation for constraint: string
        if (!is_null($modoRecebimentoCompensacao) && !is_string($modoRecebimentoCompensacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modoRecebimentoCompensacao)), __LINE__);
        }
        if (is_null($modoRecebimentoCompensacao) || (is_array($modoRecebimentoCompensacao) && empty($modoRecebimentoCompensacao))) {
            unset($this->ModoRecebimentoCompensacao);
        } else {
            $this->ModoRecebimentoCompensacao = $modoRecebimentoCompensacao;
        }
        return $this;
    }
    /**
     * Get ModoRecebimentoLiquidacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModoRecebimentoLiquidacao()
    {
        return isset($this->ModoRecebimentoLiquidacao) ? $this->ModoRecebimentoLiquidacao : null;
    }
    /**
     * Set ModoRecebimentoLiquidacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modoRecebimentoLiquidacao
     * @return \StructType\ConfigEasyPay
     */
    public function setModoRecebimentoLiquidacao($modoRecebimentoLiquidacao = null)
    {
        // validation for constraint: string
        if (!is_null($modoRecebimentoLiquidacao) && !is_string($modoRecebimentoLiquidacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modoRecebimentoLiquidacao)), __LINE__);
        }
        if (is_null($modoRecebimentoLiquidacao) || (is_array($modoRecebimentoLiquidacao) && empty($modoRecebimentoLiquidacao))) {
            unset($this->ModoRecebimentoLiquidacao);
        } else {
            $this->ModoRecebimentoLiquidacao = $modoRecebimentoLiquidacao;
        }
        return $this;
    }
    /**
     * Get ModoRecebimentoNotaCredito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModoRecebimentoNotaCredito()
    {
        return isset($this->ModoRecebimentoNotaCredito) ? $this->ModoRecebimentoNotaCredito : null;
    }
    /**
     * Set ModoRecebimentoNotaCredito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $modoRecebimentoNotaCredito
     * @return \StructType\ConfigEasyPay
     */
    public function setModoRecebimentoNotaCredito($modoRecebimentoNotaCredito = null)
    {
        // validation for constraint: string
        if (!is_null($modoRecebimentoNotaCredito) && !is_string($modoRecebimentoNotaCredito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($modoRecebimentoNotaCredito)), __LINE__);
        }
        if (is_null($modoRecebimentoNotaCredito) || (is_array($modoRecebimentoNotaCredito) && empty($modoRecebimentoNotaCredito))) {
            unset($this->ModoRecebimentoNotaCredito);
        } else {
            $this->ModoRecebimentoNotaCredito = $modoRecebimentoNotaCredito;
        }
        return $this;
    }
    /**
     * Get ModuloNotaCredito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getModuloNotaCredito()
    {
        return isset($this->ModuloNotaCredito) ? $this->ModuloNotaCredito : null;
    }
    /**
     * Set ModuloNotaCredito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $moduloNotaCredito
     * @return \StructType\ConfigEasyPay
     */
    public function setModuloNotaCredito($moduloNotaCredito = null)
    {
        // validation for constraint: string
        if (!is_null($moduloNotaCredito) && !is_string($moduloNotaCredito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($moduloNotaCredito)), __LINE__);
        }
        if (is_null($moduloNotaCredito) || (is_array($moduloNotaCredito) && empty($moduloNotaCredito))) {
            unset($this->ModuloNotaCredito);
        } else {
            $this->ModuloNotaCredito = $moduloNotaCredito;
        }
        return $this;
    }
    /**
     * Get Nib value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNib()
    {
        return isset($this->Nib) ? $this->Nib : null;
    }
    /**
     * Set Nib value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $nib
     * @return \StructType\ConfigEasyPay
     */
    public function setNib($nib = null)
    {
        // validation for constraint: string
        if (!is_null($nib) && !is_string($nib)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($nib)), __LINE__);
        }
        if (is_null($nib) || (is_array($nib) && empty($nib))) {
            unset($this->Nib);
        } else {
            $this->Nib = $nib;
        }
        return $this;
    }
    /**
     * Get NotaCredito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNotaCredito()
    {
        return isset($this->NotaCredito) ? $this->NotaCredito : null;
    }
    /**
     * Set NotaCredito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $notaCredito
     * @return \StructType\ConfigEasyPay
     */
    public function setNotaCredito($notaCredito = null)
    {
        // validation for constraint: string
        if (!is_null($notaCredito) && !is_string($notaCredito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($notaCredito)), __LINE__);
        }
        if (is_null($notaCredito) || (is_array($notaCredito) && empty($notaCredito))) {
            unset($this->NotaCredito);
        } else {
            $this->NotaCredito = $notaCredito;
        }
        return $this;
    }
    /**
     * Get Number value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getNumber()
    {
        return isset($this->Number) ? $this->Number : null;
    }
    /**
     * Set Number value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $number
     * @return \StructType\ConfigEasyPay
     */
    public function setNumber($number = null)
    {
        // validation for constraint: string
        if (!is_null($number) && !is_string($number)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($number)), __LINE__);
        }
        if (is_null($number) || (is_array($number) && empty($number))) {
            unset($this->Number);
        } else {
            $this->Number = $number;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\ConfigEasyPay
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get Public_Key value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getPublic_Key()
    {
        return isset($this->Public_Key) ? $this->Public_Key : null;
    }
    /**
     * Set Public_Key value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $public_Key
     * @return \StructType\ConfigEasyPay
     */
    public function setPublic_Key($public_Key = null)
    {
        // validation for constraint: string
        if (!is_null($public_Key) && !is_string($public_Key)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($public_Key)), __LINE__);
        }
        if (is_null($public_Key) || (is_array($public_Key) && empty($public_Key))) {
            unset($this->Public_Key);
        } else {
            $this->Public_Key = $public_Key;
        }
        return $this;
    }
    /**
     * Get SerieDocumentoCompensacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieDocumentoCompensacao()
    {
        return isset($this->SerieDocumentoCompensacao) ? $this->SerieDocumentoCompensacao : null;
    }
    /**
     * Set SerieDocumentoCompensacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieDocumentoCompensacao
     * @return \StructType\ConfigEasyPay
     */
    public function setSerieDocumentoCompensacao($serieDocumentoCompensacao = null)
    {
        // validation for constraint: string
        if (!is_null($serieDocumentoCompensacao) && !is_string($serieDocumentoCompensacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieDocumentoCompensacao)), __LINE__);
        }
        if (is_null($serieDocumentoCompensacao) || (is_array($serieDocumentoCompensacao) && empty($serieDocumentoCompensacao))) {
            unset($this->SerieDocumentoCompensacao);
        } else {
            $this->SerieDocumentoCompensacao = $serieDocumentoCompensacao;
        }
        return $this;
    }
    /**
     * Get SerieDocumentoLiquidacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieDocumentoLiquidacao()
    {
        return isset($this->SerieDocumentoLiquidacao) ? $this->SerieDocumentoLiquidacao : null;
    }
    /**
     * Set SerieDocumentoLiquidacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieDocumentoLiquidacao
     * @return \StructType\ConfigEasyPay
     */
    public function setSerieDocumentoLiquidacao($serieDocumentoLiquidacao = null)
    {
        // validation for constraint: string
        if (!is_null($serieDocumentoLiquidacao) && !is_string($serieDocumentoLiquidacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieDocumentoLiquidacao)), __LINE__);
        }
        if (is_null($serieDocumentoLiquidacao) || (is_array($serieDocumentoLiquidacao) && empty($serieDocumentoLiquidacao))) {
            unset($this->SerieDocumentoLiquidacao);
        } else {
            $this->SerieDocumentoLiquidacao = $serieDocumentoLiquidacao;
        }
        return $this;
    }
    /**
     * Get SerieNotaCredito value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getSerieNotaCredito()
    {
        return isset($this->SerieNotaCredito) ? $this->SerieNotaCredito : null;
    }
    /**
     * Set SerieNotaCredito value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $serieNotaCredito
     * @return \StructType\ConfigEasyPay
     */
    public function setSerieNotaCredito($serieNotaCredito = null)
    {
        // validation for constraint: string
        if (!is_null($serieNotaCredito) && !is_string($serieNotaCredito)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($serieNotaCredito)), __LINE__);
        }
        if (is_null($serieNotaCredito) || (is_array($serieNotaCredito) && empty($serieNotaCredito))) {
            unset($this->SerieNotaCredito);
        } else {
            $this->SerieNotaCredito = $serieNotaCredito;
        }
        return $this;
    }
    /**
     * Get Status value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getStatus()
    {
        return isset($this->Status) ? $this->Status : null;
    }
    /**
     * Set Status value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $status
     * @return \StructType\ConfigEasyPay
     */
    public function setStatus($status = null)
    {
        // validation for constraint: string
        if (!is_null($status) && !is_string($status)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($status)), __LINE__);
        }
        if (is_null($status) || (is_array($status) && empty($status))) {
            unset($this->Status);
        } else {
            $this->Status = $status;
        }
        return $this;
    }
    /**
     * Get Transfer_Frequency value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getTransfer_Frequency()
    {
        return isset($this->Transfer_Frequency) ? $this->Transfer_Frequency : null;
    }
    /**
     * Set Transfer_Frequency value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $transfer_Frequency
     * @return \StructType\ConfigEasyPay
     */
    public function setTransfer_Frequency($transfer_Frequency = null)
    {
        // validation for constraint: string
        if (!is_null($transfer_Frequency) && !is_string($transfer_Frequency)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($transfer_Frequency)), __LINE__);
        }
        if (is_null($transfer_Frequency) || (is_array($transfer_Frequency) && empty($transfer_Frequency))) {
            unset($this->Transfer_Frequency);
        } else {
            $this->Transfer_Frequency = $transfer_Frequency;
        }
        return $this;
    }
    /**
     * Get ValidaIP value
     * @return bool|null
     */
    public function getValidaIP()
    {
        return $this->ValidaIP;
    }
    /**
     * Set ValidaIP value
     * @param bool $validaIP
     * @return \StructType\ConfigEasyPay
     */
    public function setValidaIP($validaIP = null)
    {
        // validation for constraint: boolean
        if (!is_null($validaIP) && !is_bool($validaIP)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($validaIP)), __LINE__);
        }
        $this->ValidaIP = $validaIP;
        return $this;
    }
    /**
     * Get Validation_code value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getValidation_code()
    {
        return isset($this->Validation_code) ? $this->Validation_code : null;
    }
    /**
     * Set Validation_code value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $validation_code
     * @return \StructType\ConfigEasyPay
     */
    public function setValidation_code($validation_code = null)
    {
        // validation for constraint: string
        if (!is_null($validation_code) && !is_string($validation_code)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($validation_code)), __LINE__);
        }
        if (is_null($validation_code) || (is_array($validation_code) && empty($validation_code))) {
            unset($this->Validation_code);
        } else {
            $this->Validation_code = $validation_code;
        }
        return $this;
    }
    /**
     * Get Visa value
     * @return bool|null
     */
    public function getVisa()
    {
        return $this->Visa;
    }
    /**
     * Set Visa value
     * @param bool $visa
     * @return \StructType\ConfigEasyPay
     */
    public function setVisa($visa = null)
    {
        // validation for constraint: boolean
        if (!is_null($visa) && !is_bool($visa)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($visa)), __LINE__);
        }
        $this->Visa = $visa;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\ConfigEasyPay
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
