<?php

namespace StructType;

use \WsdlToPhp\PackageBase\AbstractStructBase;

/**
 * This class stands for CabecComprasStatusERP StructType
 * Meta informations extracted from the WSDL
 * - nillable: true
 * - type: tns:CabecComprasStatusERP
 * @subpackage Structs
 */
class CabecComprasStatusERP extends AbstractStructBase
{
    /**
     * The ATDocCodeID
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $ATDocCodeID;
    /**
     * The ATTrataTrans
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var int
     */
    public $ATTrataTrans;
    /**
     * The Anulado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Anulado;
    /**
     * The CalculoManual
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $CalculoManual;
    /**
     * The DataAnulacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataAnulacao;
    /**
     * The DataImp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $DataImp;
    /**
     * The DocImp
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $DocImp;
    /**
     * The Estado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $Estado;
    /**
     * The EstadoIEC
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $EstadoIEC;
    /**
     * The ExportadoSAFTAuditoria
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $ExportadoSAFTAuditoria;
    /**
     * The Fechado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var bool
     */
    public $Fechado;
    /**
     * The IdCabecCompras
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * - pattern: [\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}
     * - type: tns:guid
     * @var string
     */
    public $IdCabecCompras;
    /**
     * The MotivoAnulacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $MotivoAnulacao;
    /**
     * The MovContab
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MovContab;
    /**
     * The MovImobilizado
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var int
     */
    public $MovImobilizado;
    /**
     * The Protegida
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var bool
     */
    public $Protegida;
    /**
     * The UtilizadorAnulacao
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * - nillable: true
     * @var string
     */
    public $UtilizadorAnulacao;
    /**
     * The VersaoUltAct
     * Meta informations extracted from the WSDL
     * - minOccurs: 0
     * @var string
     */
    public $VersaoUltAct;
    /**
     * Constructor method for CabecComprasStatusERP
     * @uses CabecComprasStatusERP::setATDocCodeID()
     * @uses CabecComprasStatusERP::setATTrataTrans()
     * @uses CabecComprasStatusERP::setAnulado()
     * @uses CabecComprasStatusERP::setCalculoManual()
     * @uses CabecComprasStatusERP::setDataAnulacao()
     * @uses CabecComprasStatusERP::setDataImp()
     * @uses CabecComprasStatusERP::setDocImp()
     * @uses CabecComprasStatusERP::setEstado()
     * @uses CabecComprasStatusERP::setEstadoIEC()
     * @uses CabecComprasStatusERP::setExportadoSAFTAuditoria()
     * @uses CabecComprasStatusERP::setFechado()
     * @uses CabecComprasStatusERP::setIdCabecCompras()
     * @uses CabecComprasStatusERP::setMotivoAnulacao()
     * @uses CabecComprasStatusERP::setMovContab()
     * @uses CabecComprasStatusERP::setMovImobilizado()
     * @uses CabecComprasStatusERP::setProtegida()
     * @uses CabecComprasStatusERP::setUtilizadorAnulacao()
     * @uses CabecComprasStatusERP::setVersaoUltAct()
     * @param string $aTDocCodeID
     * @param int $aTTrataTrans
     * @param bool $anulado
     * @param bool $calculoManual
     * @param string $dataAnulacao
     * @param string $dataImp
     * @param bool $docImp
     * @param string $estado
     * @param int $estadoIEC
     * @param bool $exportadoSAFTAuditoria
     * @param bool $fechado
     * @param string $idCabecCompras
     * @param string $motivoAnulacao
     * @param int $movContab
     * @param int $movImobilizado
     * @param bool $protegida
     * @param string $utilizadorAnulacao
     * @param string $versaoUltAct
     */
    public function __construct($aTDocCodeID = null, $aTTrataTrans = null, $anulado = null, $calculoManual = null, $dataAnulacao = null, $dataImp = null, $docImp = null, $estado = null, $estadoIEC = null, $exportadoSAFTAuditoria = null, $fechado = null, $idCabecCompras = null, $motivoAnulacao = null, $movContab = null, $movImobilizado = null, $protegida = null, $utilizadorAnulacao = null, $versaoUltAct = null)
    {
        $this
            ->setATDocCodeID($aTDocCodeID)
            ->setATTrataTrans($aTTrataTrans)
            ->setAnulado($anulado)
            ->setCalculoManual($calculoManual)
            ->setDataAnulacao($dataAnulacao)
            ->setDataImp($dataImp)
            ->setDocImp($docImp)
            ->setEstado($estado)
            ->setEstadoIEC($estadoIEC)
            ->setExportadoSAFTAuditoria($exportadoSAFTAuditoria)
            ->setFechado($fechado)
            ->setIdCabecCompras($idCabecCompras)
            ->setMotivoAnulacao($motivoAnulacao)
            ->setMovContab($movContab)
            ->setMovImobilizado($movImobilizado)
            ->setProtegida($protegida)
            ->setUtilizadorAnulacao($utilizadorAnulacao)
            ->setVersaoUltAct($versaoUltAct);
    }
    /**
     * Get ATDocCodeID value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getATDocCodeID()
    {
        return isset($this->ATDocCodeID) ? $this->ATDocCodeID : null;
    }
    /**
     * Set ATDocCodeID value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $aTDocCodeID
     * @return \StructType\CabecComprasStatusERP
     */
    public function setATDocCodeID($aTDocCodeID = null)
    {
        // validation for constraint: string
        if (!is_null($aTDocCodeID) && !is_string($aTDocCodeID)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($aTDocCodeID)), __LINE__);
        }
        if (is_null($aTDocCodeID) || (is_array($aTDocCodeID) && empty($aTDocCodeID))) {
            unset($this->ATDocCodeID);
        } else {
            $this->ATDocCodeID = $aTDocCodeID;
        }
        return $this;
    }
    /**
     * Get ATTrataTrans value
     * @return int|null
     */
    public function getATTrataTrans()
    {
        return $this->ATTrataTrans;
    }
    /**
     * Set ATTrataTrans value
     * @param int $aTTrataTrans
     * @return \StructType\CabecComprasStatusERP
     */
    public function setATTrataTrans($aTTrataTrans = null)
    {
        // validation for constraint: int
        if (!is_null($aTTrataTrans) && !is_numeric($aTTrataTrans)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($aTTrataTrans)), __LINE__);
        }
        $this->ATTrataTrans = $aTTrataTrans;
        return $this;
    }
    /**
     * Get Anulado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getAnulado()
    {
        return isset($this->Anulado) ? $this->Anulado : null;
    }
    /**
     * Set Anulado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $anulado
     * @return \StructType\CabecComprasStatusERP
     */
    public function setAnulado($anulado = null)
    {
        // validation for constraint: boolean
        if (!is_null($anulado) && !is_bool($anulado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($anulado)), __LINE__);
        }
        if (is_null($anulado) || (is_array($anulado) && empty($anulado))) {
            unset($this->Anulado);
        } else {
            $this->Anulado = $anulado;
        }
        return $this;
    }
    /**
     * Get CalculoManual value
     * @return bool|null
     */
    public function getCalculoManual()
    {
        return $this->CalculoManual;
    }
    /**
     * Set CalculoManual value
     * @param bool $calculoManual
     * @return \StructType\CabecComprasStatusERP
     */
    public function setCalculoManual($calculoManual = null)
    {
        // validation for constraint: boolean
        if (!is_null($calculoManual) && !is_bool($calculoManual)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($calculoManual)), __LINE__);
        }
        $this->CalculoManual = $calculoManual;
        return $this;
    }
    /**
     * Get DataAnulacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataAnulacao()
    {
        return isset($this->DataAnulacao) ? $this->DataAnulacao : null;
    }
    /**
     * Set DataAnulacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataAnulacao
     * @return \StructType\CabecComprasStatusERP
     */
    public function setDataAnulacao($dataAnulacao = null)
    {
        // validation for constraint: string
        if (!is_null($dataAnulacao) && !is_string($dataAnulacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataAnulacao)), __LINE__);
        }
        if (is_null($dataAnulacao) || (is_array($dataAnulacao) && empty($dataAnulacao))) {
            unset($this->DataAnulacao);
        } else {
            $this->DataAnulacao = $dataAnulacao;
        }
        return $this;
    }
    /**
     * Get DataImp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getDataImp()
    {
        return isset($this->DataImp) ? $this->DataImp : null;
    }
    /**
     * Set DataImp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $dataImp
     * @return \StructType\CabecComprasStatusERP
     */
    public function setDataImp($dataImp = null)
    {
        // validation for constraint: string
        if (!is_null($dataImp) && !is_string($dataImp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($dataImp)), __LINE__);
        }
        if (is_null($dataImp) || (is_array($dataImp) && empty($dataImp))) {
            unset($this->DataImp);
        } else {
            $this->DataImp = $dataImp;
        }
        return $this;
    }
    /**
     * Get DocImp value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getDocImp()
    {
        return isset($this->DocImp) ? $this->DocImp : null;
    }
    /**
     * Set DocImp value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $docImp
     * @return \StructType\CabecComprasStatusERP
     */
    public function setDocImp($docImp = null)
    {
        // validation for constraint: boolean
        if (!is_null($docImp) && !is_bool($docImp)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($docImp)), __LINE__);
        }
        if (is_null($docImp) || (is_array($docImp) && empty($docImp))) {
            unset($this->DocImp);
        } else {
            $this->DocImp = $docImp;
        }
        return $this;
    }
    /**
     * Get Estado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getEstado()
    {
        return isset($this->Estado) ? $this->Estado : null;
    }
    /**
     * Set Estado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $estado
     * @return \StructType\CabecComprasStatusERP
     */
    public function setEstado($estado = null)
    {
        // validation for constraint: string
        if (!is_null($estado) && !is_string($estado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($estado)), __LINE__);
        }
        if (is_null($estado) || (is_array($estado) && empty($estado))) {
            unset($this->Estado);
        } else {
            $this->Estado = $estado;
        }
        return $this;
    }
    /**
     * Get EstadoIEC value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getEstadoIEC()
    {
        return isset($this->EstadoIEC) ? $this->EstadoIEC : null;
    }
    /**
     * Set EstadoIEC value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $estadoIEC
     * @return \StructType\CabecComprasStatusERP
     */
    public function setEstadoIEC($estadoIEC = null)
    {
        // validation for constraint: int
        if (!is_null($estadoIEC) && !is_numeric($estadoIEC)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($estadoIEC)), __LINE__);
        }
        if (is_null($estadoIEC) || (is_array($estadoIEC) && empty($estadoIEC))) {
            unset($this->EstadoIEC);
        } else {
            $this->EstadoIEC = $estadoIEC;
        }
        return $this;
    }
    /**
     * Get ExportadoSAFTAuditoria value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getExportadoSAFTAuditoria()
    {
        return isset($this->ExportadoSAFTAuditoria) ? $this->ExportadoSAFTAuditoria : null;
    }
    /**
     * Set ExportadoSAFTAuditoria value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $exportadoSAFTAuditoria
     * @return \StructType\CabecComprasStatusERP
     */
    public function setExportadoSAFTAuditoria($exportadoSAFTAuditoria = null)
    {
        // validation for constraint: boolean
        if (!is_null($exportadoSAFTAuditoria) && !is_bool($exportadoSAFTAuditoria)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($exportadoSAFTAuditoria)), __LINE__);
        }
        if (is_null($exportadoSAFTAuditoria) || (is_array($exportadoSAFTAuditoria) && empty($exportadoSAFTAuditoria))) {
            unset($this->ExportadoSAFTAuditoria);
        } else {
            $this->ExportadoSAFTAuditoria = $exportadoSAFTAuditoria;
        }
        return $this;
    }
    /**
     * Get Fechado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return bool|null
     */
    public function getFechado()
    {
        return isset($this->Fechado) ? $this->Fechado : null;
    }
    /**
     * Set Fechado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param bool $fechado
     * @return \StructType\CabecComprasStatusERP
     */
    public function setFechado($fechado = null)
    {
        // validation for constraint: boolean
        if (!is_null($fechado) && !is_bool($fechado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($fechado)), __LINE__);
        }
        if (is_null($fechado) || (is_array($fechado) && empty($fechado))) {
            unset($this->Fechado);
        } else {
            $this->Fechado = $fechado;
        }
        return $this;
    }
    /**
     * Get IdCabecCompras value
     * @return string|null
     */
    public function getIdCabecCompras()
    {
        return $this->IdCabecCompras;
    }
    /**
     * Set IdCabecCompras value
     * @param string $idCabecCompras
     * @return \StructType\CabecComprasStatusERP
     */
    public function setIdCabecCompras($idCabecCompras = null)
    {
        // validation for constraint: pattern
        if (is_scalar($idCabecCompras) && !preg_match('/[\\da-fA-F]{8}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{4}-[\\da-fA-F]{12}/', $idCabecCompras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a scalar value that matches "[\da-fA-F]{8}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{4}-[\da-fA-F]{12}", "%s" given', var_export($idCabecCompras, true)), __LINE__);
        }
        // validation for constraint: string
        if (!is_null($idCabecCompras) && !is_string($idCabecCompras)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($idCabecCompras)), __LINE__);
        }
        $this->IdCabecCompras = $idCabecCompras;
        return $this;
    }
    /**
     * Get MotivoAnulacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getMotivoAnulacao()
    {
        return isset($this->MotivoAnulacao) ? $this->MotivoAnulacao : null;
    }
    /**
     * Set MotivoAnulacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $motivoAnulacao
     * @return \StructType\CabecComprasStatusERP
     */
    public function setMotivoAnulacao($motivoAnulacao = null)
    {
        // validation for constraint: string
        if (!is_null($motivoAnulacao) && !is_string($motivoAnulacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($motivoAnulacao)), __LINE__);
        }
        if (is_null($motivoAnulacao) || (is_array($motivoAnulacao) && empty($motivoAnulacao))) {
            unset($this->MotivoAnulacao);
        } else {
            $this->MotivoAnulacao = $motivoAnulacao;
        }
        return $this;
    }
    /**
     * Get MovContab value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMovContab()
    {
        return isset($this->MovContab) ? $this->MovContab : null;
    }
    /**
     * Set MovContab value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $movContab
     * @return \StructType\CabecComprasStatusERP
     */
    public function setMovContab($movContab = null)
    {
        // validation for constraint: int
        if (!is_null($movContab) && !is_numeric($movContab)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($movContab)), __LINE__);
        }
        if (is_null($movContab) || (is_array($movContab) && empty($movContab))) {
            unset($this->MovContab);
        } else {
            $this->MovContab = $movContab;
        }
        return $this;
    }
    /**
     * Get MovImobilizado value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return int|null
     */
    public function getMovImobilizado()
    {
        return isset($this->MovImobilizado) ? $this->MovImobilizado : null;
    }
    /**
     * Set MovImobilizado value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param int $movImobilizado
     * @return \StructType\CabecComprasStatusERP
     */
    public function setMovImobilizado($movImobilizado = null)
    {
        // validation for constraint: int
        if (!is_null($movImobilizado) && !is_numeric($movImobilizado)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a numeric value, "%s" given', gettype($movImobilizado)), __LINE__);
        }
        if (is_null($movImobilizado) || (is_array($movImobilizado) && empty($movImobilizado))) {
            unset($this->MovImobilizado);
        } else {
            $this->MovImobilizado = $movImobilizado;
        }
        return $this;
    }
    /**
     * Get Protegida value
     * @return bool|null
     */
    public function getProtegida()
    {
        return $this->Protegida;
    }
    /**
     * Set Protegida value
     * @param bool $protegida
     * @return \StructType\CabecComprasStatusERP
     */
    public function setProtegida($protegida = null)
    {
        // validation for constraint: boolean
        if (!is_null($protegida) && !is_bool($protegida)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a bool, "%s" given', gettype($protegida)), __LINE__);
        }
        $this->Protegida = $protegida;
        return $this;
    }
    /**
     * Get UtilizadorAnulacao value
     * An additional test has been added (isset) before returning the property value as
     * this property may have been unset before, due to the fact that this property is
     * removable from the request (nillable=true+minOccurs=0)
     * @return string|null
     */
    public function getUtilizadorAnulacao()
    {
        return isset($this->UtilizadorAnulacao) ? $this->UtilizadorAnulacao : null;
    }
    /**
     * Set UtilizadorAnulacao value
     * This property is removable from request (nillable=true+minOccurs=0), therefore
     * if the value assigned to this property is null, it is removed from this object
     * @param string $utilizadorAnulacao
     * @return \StructType\CabecComprasStatusERP
     */
    public function setUtilizadorAnulacao($utilizadorAnulacao = null)
    {
        // validation for constraint: string
        if (!is_null($utilizadorAnulacao) && !is_string($utilizadorAnulacao)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($utilizadorAnulacao)), __LINE__);
        }
        if (is_null($utilizadorAnulacao) || (is_array($utilizadorAnulacao) && empty($utilizadorAnulacao))) {
            unset($this->UtilizadorAnulacao);
        } else {
            $this->UtilizadorAnulacao = $utilizadorAnulacao;
        }
        return $this;
    }
    /**
     * Get VersaoUltAct value
     * @return string|null
     */
    public function getVersaoUltAct()
    {
        return $this->VersaoUltAct;
    }
    /**
     * Set VersaoUltAct value
     * @param string $versaoUltAct
     * @return \StructType\CabecComprasStatusERP
     */
    public function setVersaoUltAct($versaoUltAct = null)
    {
        // validation for constraint: string
        if (!is_null($versaoUltAct) && !is_string($versaoUltAct)) {
            throw new \InvalidArgumentException(sprintf('Invalid value, please provide a string, "%s" given', gettype($versaoUltAct)), __LINE__);
        }
        $this->VersaoUltAct = $versaoUltAct;
        return $this;
    }
    /**
     * Method called when an object has been exported with var_export() functions
     * It allows to return an object instantiated with the values
     * @see AbstractStructBase::__set_state()
     * @uses AbstractStructBase::__set_state()
     * @param array $array the exported values
     * @return \StructType\CabecComprasStatusERP
     */
    public static function __set_state(array $array)
    {
        return parent::__set_state($array);
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
