<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Imprime ServiceType
 * @subpackage Services
 */
class Imprime extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named ImprimeDocumentoVendaERP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImprimeDocumentoVendaERP $parameters
     * @return \StructType\ImprimeDocumentoVendaERPResponse|bool
     */
    public function ImprimeDocumentoVendaERP(\StructType\ImprimeDocumentoVendaERP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ImprimeDocumentoVendaERP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImprimeDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImprimeDocumentoVenda $parameters
     * @return \StructType\ImprimeDocumentoVendaResponse|bool
     */
    public function ImprimeDocumentoVenda(\StructType\ImprimeDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ImprimeDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named ImprimeDocumentoCompraERP
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\ImprimeDocumentoCompraERP $parameters
     * @return \StructType\ImprimeDocumentoCompraERPResponse|bool
     */
    public function ImprimeDocumentoCompraERP(\StructType\ImprimeDocumentoCompraERP $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->ImprimeDocumentoCompraERP($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\ImprimeDocumentoCompraERPResponse|\StructType\ImprimeDocumentoVendaERPResponse|\StructType\ImprimeDocumentoVendaResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
