<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Gerar ServiceType
 * @subpackage Services
 */
class Gerar extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named GerarReferenciaMB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GerarReferenciaMB $parameters
     * @return \StructType\GerarReferenciaMBResponse|bool
     */
    public function GerarReferenciaMB(\StructType\GerarReferenciaMB $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GerarReferenciaMB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named GerarReferenciaMBDocumento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\GerarReferenciaMBDocumento $parameters
     * @return \StructType\GerarReferenciaMBDocumentoResponse|bool
     */
    public function GerarReferenciaMBDocumento(\StructType\GerarReferenciaMBDocumento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->GerarReferenciaMBDocumento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\GerarReferenciaMBDocumentoResponse|\StructType\GerarReferenciaMBResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
