<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Edita ServiceType
 * @subpackage Services
 */
class Edita extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named EditaResumoRetencaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoRetencaoJSON $parameters
     * @return \StructType\EditaResumoRetencaoJSONResponse|bool
     */
    public function EditaResumoRetencaoJSON(\StructType\EditaResumoRetencaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoRetencaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoRetencaoLiqJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoRetencaoLiqJSON $parameters
     * @return \StructType\EditaResumoRetencaoLiqJSONResponse|bool
     */
    public function EditaResumoRetencaoLiqJSON(\StructType\EditaResumoRetencaoLiqJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoRetencaoLiqJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieCCTJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieCCTJSON $parameters
     * @return \StructType\EditaSerieCCTJSONResponse|bool
     */
    public function EditaSerieCCTJSON(\StructType\EditaSerieCCTJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieCCTJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieContratoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieContratoJSON $parameters
     * @return \StructType\EditaSerieContratoJSONResponse|bool
     */
    public function EditaSerieContratoJSON(\StructType\EditaSerieContratoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieContratoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieStockJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieStockJSON $parameters
     * @return \StructType\EditaSerieStockJSONResponse|bool
     */
    public function EditaSerieStockJSON(\StructType\EditaSerieStockJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieStockJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieVendasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieVendasJSON $parameters
     * @return \StructType\EditaSerieVendasJSONResponse|bool
     */
    public function EditaSerieVendasJSON(\StructType\EditaSerieVendasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieVendasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieComprasJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieComprasJSON $parameters
     * @return \StructType\EditaSerieComprasJSONResponse|bool
     */
    public function EditaSerieComprasJSON(\StructType\EditaSerieComprasJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieComprasJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoTerceiroJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoTerceiroJSON $parameters
     * @return \StructType\EditaTipoTerceiroJSONResponse|bool
     */
    public function EditaTipoTerceiroJSON(\StructType\EditaTipoTerceiroJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoTerceiroJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaUnidadeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaUnidadeJSON $parameters
     * @return \StructType\EditaUnidadeJSONResponse|bool
     */
    public function EditaUnidadeJSON(\StructType\EditaUnidadeJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaUnidadeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMarcaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMarcaXML $parameters
     * @return \StructType\EditaMarcaXMLResponse|bool
     */
    public function EditaMarcaXML(\StructType\EditaMarcaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMarcaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaModeloXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaModeloXML $parameters
     * @return \StructType\EditaModeloXMLResponse|bool
     */
    public function EditaModeloXML(\StructType\EditaModeloXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaModeloXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoedaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoedaXML $parameters
     * @return \StructType\EditaMoedaXMLResponse|bool
     */
    public function EditaMoedaXML(\StructType\EditaMoedaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoedaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoradaAlternativaClienteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoradaAlternativaClienteXML $parameters
     * @return \StructType\EditaMoradaAlternativaClienteXMLResponse|bool
     */
    public function EditaMoradaAlternativaClienteXML(\StructType\EditaMoradaAlternativaClienteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoradaAlternativaClienteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EditaMoradaAlternativaFornecedorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoradaAlternativaFornecedorXML $parameters
     * @return \StructType\EditaMoradaAlternativaFornecedorXMLResponse|bool
     */
    public function EditaMoradaAlternativaFornecedorXML(\StructType\EditaMoradaAlternativaFornecedorXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoradaAlternativaFornecedorXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMotivoEstornoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMotivoEstornoXML $parameters
     * @return \StructType\EditaMotivoEstornoXMLResponse|bool
     */
    public function EditaMotivoEstornoXML(\StructType\EditaMotivoEstornoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMotivoEstornoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMotivoIsencaoIVAXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMotivoIsencaoIVAXML $parameters
     * @return \StructType\EditaMotivoIsencaoIVAXMLResponse|bool
     */
    public function EditaMotivoIsencaoIVAXML(\StructType\EditaMotivoIsencaoIVAXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMotivoIsencaoIVAXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaOrigemContactoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaOrigemContactoXML $parameters
     * @return \StructType\EditaOrigemContactoXMLResponse|bool
     */
    public function EditaOrigemContactoXML(\StructType\EditaOrigemContactoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaOrigemContactoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaOutroTerceiroXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaOutroTerceiroXML $parameters
     * @return \StructType\EditaOutroTerceiroXMLResponse|bool
     */
    public function EditaOutroTerceiroXML(\StructType\EditaOutroTerceiroXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaOutroTerceiroXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPendenteIdXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPendenteIdXML $parameters
     * @return \StructType\EditaPendenteIdXMLResponse|bool
     */
    public function EditaPendenteIdXML(\StructType\EditaPendenteIdXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPendenteIdXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPendenteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPendenteXML $parameters
     * @return \StructType\EditaPendenteXMLResponse|bool
     */
    public function EditaPendenteXML(\StructType\EditaPendenteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPendenteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoIvaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoIvaXML $parameters
     * @return \StructType\EditaResumoIvaXMLResponse|bool
     */
    public function EditaResumoIvaXML(\StructType\EditaResumoIvaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoIvaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoRetencaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoRetencaoXML $parameters
     * @return \StructType\EditaResumoRetencaoXMLResponse|bool
     */
    public function EditaResumoRetencaoXML(\StructType\EditaResumoRetencaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoRetencaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoRetencaoLiqXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoRetencaoLiqXML $parameters
     * @return \StructType\EditaResumoRetencaoLiqXMLResponse|bool
     */
    public function EditaResumoRetencaoLiqXML(\StructType\EditaResumoRetencaoLiqXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoRetencaoLiqXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieCCTXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieCCTXML $parameters
     * @return \StructType\EditaSerieCCTXMLResponse|bool
     */
    public function EditaSerieCCTXML(\StructType\EditaSerieCCTXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieCCTXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieContratoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieContratoXML $parameters
     * @return \StructType\EditaSerieContratoXMLResponse|bool
     */
    public function EditaSerieContratoXML(\StructType\EditaSerieContratoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieContratoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieStockXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieStockXML $parameters
     * @return \StructType\EditaSerieStockXMLResponse|bool
     */
    public function EditaSerieStockXML(\StructType\EditaSerieStockXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieStockXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieVendasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieVendasXML $parameters
     * @return \StructType\EditaSerieVendasXMLResponse|bool
     */
    public function EditaSerieVendasXML(\StructType\EditaSerieVendasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieVendasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieComprasXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieComprasXML $parameters
     * @return \StructType\EditaSerieComprasXMLResponse|bool
     */
    public function EditaSerieComprasXML(\StructType\EditaSerieComprasXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieComprasXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoTerceiroXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoTerceiroXML $parameters
     * @return \StructType\EditaTipoTerceiroXMLResponse|bool
     */
    public function EditaTipoTerceiroXML(\StructType\EditaTipoTerceiroXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoTerceiroXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaUnidadeXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaUnidadeXML $parameters
     * @return \StructType\EditaUnidadeXMLResponse|bool
     */
    public function EditaUnidadeXML(\StructType\EditaUnidadeXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaUnidadeXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaConfiguracaoEasyPayJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaConfiguracaoEasyPayJSON $parameters
     * @return \StructType\EditaConfiguracaoEasyPayJSONResponse|bool
     */
    public function EditaConfiguracaoEasyPayJSON(\StructType\EditaConfiguracaoEasyPayJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaConfiguracaoEasyPayJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoArmazemJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoArmazemJSON $parameters
     * @return \StructType\EditaArtigoArmazemJSONResponse|bool
     */
    public function EditaArtigoArmazemJSON(\StructType\EditaArtigoArmazemJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoArmazemJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaVendedorJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaVendedorJSON $parameters
     * @return \StructType\EditaVendedorJSONResponse|bool
     */
    public function EditaVendedorJSON(\StructType\EditaVendedorJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaVendedorJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaModoExpedicaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaModoExpedicaoJSON $parameters
     * @return \StructType\EditaModoExpedicaoJSONResponse|bool
     */
    public function EditaModoExpedicaoJSON(\StructType\EditaModoExpedicaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaModoExpedicaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEmpresaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEmpresaJSON $parameters
     * @return \StructType\EditaEmpresaJSONResponse|bool
     */
    public function EditaEmpresaJSON(\StructType\EditaEmpresaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEmpresaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPaisJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPaisJSON $parameters
     * @return \StructType\EditaPaisJSONResponse|bool
     */
    public function EditaPaisJSON(\StructType\EditaPaisJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPaisJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaParceiroJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaParceiroJSON $parameters
     * @return \StructType\EditaParceiroJSONResponse|bool
     */
    public function EditaParceiroJSON(\StructType\EditaParceiroJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaParceiroJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoContactoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoContactoJSON $parameters
     * @return \StructType\EditaTipoContactoJSONResponse|bool
     */
    public function EditaTipoContactoJSON(\StructType\EditaTipoContactoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoContactoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstabelecimentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstabelecimentoJSON $parameters
     * @return \StructType\EditaEstabelecimentoJSONResponse|bool
     */
    public function EditaEstabelecimentoJSON(\StructType\EditaEstabelecimentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstabelecimentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoParceiroJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoParceiroJSON $parameters
     * @return \StructType\EditaTipoParceiroJSONResponse|bool
     */
    public function EditaTipoParceiroJSON(\StructType\EditaTipoParceiroJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoParceiroJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaContactoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaContactoJSON $parameters
     * @return \StructType\EditaContactoJSONResponse|bool
     */
    public function EditaContactoJSON(\StructType\EditaContactoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaContactoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArmazemJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArmazemJSON $parameters
     * @return \StructType\EditaArmazemJSONResponse|bool
     */
    public function EditaArmazemJSON(\StructType\EditaArmazemJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArmazemJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocIdentificacaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocIdentificacaoJSON $parameters
     * @return \StructType\EditaTipoDocIdentificacaoJSONResponse|bool
     */
    public function EditaTipoDocIdentificacaoJSON(\StructType\EditaTipoDocIdentificacaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocIdentificacaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArmazemLocalizacaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArmazemLocalizacaoJSON $parameters
     * @return \StructType\EditaArmazemLocalizacaoJSONResponse|bool
     */
    public function EditaArmazemLocalizacaoJSON(\StructType\EditaArmazemLocalizacaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArmazemLocalizacaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMetodoPagamentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMetodoPagamentoJSON $parameters
     * @return \StructType\EditaMetodoPagamentoJSONResponse|bool
     */
    public function EditaMetodoPagamentoJSON(\StructType\EditaMetodoPagamentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMetodoPagamentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaCondicaoPagamentoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaCondicaoPagamentoJSON $parameters
     * @return \StructType\EditaCondicaoPagamentoJSONResponse|bool
     */
    public function EditaCondicaoPagamentoJSON(\StructType\EditaCondicaoPagamentoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaCondicaoPagamentoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoJSON $parameters
     * @return \StructType\EditaArtigoJSONResponse|bool
     */
    public function EditaArtigoJSON(\StructType\EditaArtigoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoFornecedorJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoFornecedorJSON $parameters
     * @return \StructType\EditaArtigoFornecedorJSONResponse|bool
     */
    public function EditaArtigoFornecedorJSON(\StructType\EditaArtigoFornecedorJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoFornecedorJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoIdiomaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoIdiomaJSON $parameters
     * @return \StructType\EditaArtigoIdiomaJSONResponse|bool
     */
    public function EditaArtigoIdiomaJSON(\StructType\EditaArtigoIdiomaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoIdiomaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoLoteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoLoteJSON $parameters
     * @return \StructType\EditaArtigoLoteJSONResponse|bool
     */
    public function EditaArtigoLoteJSON(\StructType\EditaArtigoLoteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoLoteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoMoedaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoMoedaJSON $parameters
     * @return \StructType\EditaArtigoMoedaJSONResponse|bool
     */
    public function EditaArtigoMoedaJSON(\StructType\EditaArtigoMoedaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoMoedaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoUnidadeJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoUnidadeJSON $parameters
     * @return \StructType\EditaArtigoUnidadeJSONResponse|bool
     */
    public function EditaArtigoUnidadeJSON(\StructType\EditaArtigoUnidadeJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoUnidadeJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoCompraIdJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoCompraIdJSON $parameters
     * @return \StructType\EditaDocumentoCompraIdJSONResponse|bool
     */
    public function EditaDocumentoCompraIdJSON(\StructType\EditaDocumentoCompraIdJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoCompraIdJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoCompraJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoCompraJSON $parameters
     * @return \StructType\EditaDocumentoCompraJSONResponse|bool
     */
    public function EditaDocumentoCompraJSON(\StructType\EditaDocumentoCompraJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoCompraJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstadoDocumentoCompraJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstadoDocumentoCompraJSON $parameters
     * @return \StructType\EditaEstadoDocumentoCompraJSONResponse|bool
     */
    public function EditaEstadoDocumentoCompraJSON(\StructType\EditaEstadoDocumentoCompraJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstadoDocumentoCompraJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoVendaIdJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoVendaIdJSON $parameters
     * @return \StructType\EditaDocumentoVendaIdJSONResponse|bool
     */
    public function EditaDocumentoVendaIdJSON(\StructType\EditaDocumentoVendaIdJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoVendaIdJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoVendaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoVendaJSON $parameters
     * @return \StructType\EditaDocumentoVendaJSONResponse|bool
     */
    public function EditaDocumentoVendaJSON(\StructType\EditaDocumentoVendaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoVendaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstadoDocumentoVendaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstadoDocumentoVendaJSON $parameters
     * @return \StructType\EditaEstadoDocumentoVendaJSONResponse|bool
     */
    public function EditaEstadoDocumentoVendaJSON(\StructType\EditaEstadoDocumentoVendaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstadoDocumentoVendaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoInternoIdJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoInternoIdJSON $parameters
     * @return \StructType\EditaDocumentoInternoIdJSONResponse|bool
     */
    public function EditaDocumentoInternoIdJSON(\StructType\EditaDocumentoInternoIdJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoInternoIdJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoInternoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoInternoJSON $parameters
     * @return \StructType\EditaDocumentoInternoJSONResponse|bool
     */
    public function EditaDocumentoInternoJSON(\StructType\EditaDocumentoInternoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoInternoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoLiquidacaoIdJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoLiquidacaoIdJSON $parameters
     * @return \StructType\EditaDocumentoLiquidacaoIdJSONResponse|bool
     */
    public function EditaDocumentoLiquidacaoIdJSON(\StructType\EditaDocumentoLiquidacaoIdJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoLiquidacaoIdJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoLiquidacaoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoLiquidacaoJSON $parameters
     * @return \StructType\EditaDocumentoLiquidacaoJSONResponse|bool
     */
    public function EditaDocumentoLiquidacaoJSON(\StructType\EditaDocumentoLiquidacaoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoLiquidacaoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaClienteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaClienteJSON $parameters
     * @return \StructType\EditaClienteJSONResponse|bool
     */
    public function EditaClienteJSON(\StructType\EditaClienteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaClienteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaConcelhoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaConcelhoJSON $parameters
     * @return \StructType\EditaConcelhoJSONResponse|bool
     */
    public function EditaConcelhoJSON(\StructType\EditaConcelhoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaConcelhoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaContaBancariaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaContaBancariaJSON $parameters
     * @return \StructType\EditaContaBancariaJSONResponse|bool
     */
    public function EditaContaBancariaJSON(\StructType\EditaContaBancariaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaContaBancariaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDistritoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDistritoJSON $parameters
     * @return \StructType\EditaDistritoJSONResponse|bool
     */
    public function EditaDistritoJSON(\StructType\EditaDistritoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDistritoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EditaTipoDocumentoContaCorrenteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoContaCorrenteJSON $parameters
     * @return \StructType\EditaTipoDocumentoContaCorrenteJSONResponse|bool
     */
    public function EditaTipoDocumentoContaCorrenteJSON(\StructType\EditaTipoDocumentoContaCorrenteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoContaCorrenteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoCompraJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoCompraJSON $parameters
     * @return \StructType\EditaTipoDocumentoCompraJSONResponse|bool
     */
    public function EditaTipoDocumentoCompraJSON(\StructType\EditaTipoDocumentoCompraJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoCompraJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoInternoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoInternoJSON $parameters
     * @return \StructType\EditaTipoDocumentoInternoJSONResponse|bool
     */
    public function EditaTipoDocumentoInternoJSON(\StructType\EditaTipoDocumentoInternoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoInternoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentStockJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentStockJSON $parameters
     * @return \StructType\EditaTipoDocumentStockJSONResponse|bool
     */
    public function EditaTipoDocumentStockJSON(\StructType\EditaTipoDocumentStockJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentStockJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoVendaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoVendaJSON $parameters
     * @return \StructType\EditaTipoDocumentoVendaJSONResponse|bool
     */
    public function EditaTipoDocumentoVendaJSON(\StructType\EditaTipoDocumentoVendaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoVendaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFamiliaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFamiliaJSON $parameters
     * @return \StructType\EditaFamiliaJSONResponse|bool
     */
    public function EditaFamiliaJSON(\StructType\EditaFamiliaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFamiliaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFornecedorJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFornecedorJSON $parameters
     * @return \StructType\EditaFornecedorJSONResponse|bool
     */
    public function EditaFornecedorJSON(\StructType\EditaFornecedorJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFornecedorJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFreguesiaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFreguesiaJSON $parameters
     * @return \StructType\EditaFreguesiaJSONResponse|bool
     */
    public function EditaFreguesiaJSON(\StructType\EditaFreguesiaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFreguesiaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFuncionarioJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFuncionarioJSON $parameters
     * @return \StructType\EditaFuncionarioJSONResponse|bool
     */
    public function EditaFuncionarioJSON(\StructType\EditaFuncionarioJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFuncionarioJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaIvaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaIvaJSON $parameters
     * @return \StructType\EditaIvaJSONResponse|bool
     */
    public function EditaIvaJSON(\StructType\EditaIvaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaIvaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocJSON $parameters
     * @return \StructType\EditaLinhaDocJSONResponse|bool
     */
    public function EditaLinhaDocJSON(\StructType\EditaLinhaDocJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocStatusJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocStatusJSON $parameters
     * @return \StructType\EditaLinhaDocStatusJSONResponse|bool
     */
    public function EditaLinhaDocStatusJSON(\StructType\EditaLinhaDocStatusJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocStatusJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocTransJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocTransJSON $parameters
     * @return \StructType\EditaLinhaDocTransJSONResponse|bool
     */
    public function EditaLinhaDocTransJSON(\StructType\EditaLinhaDocTransJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocTransJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaInternosJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaInternosJSON $parameters
     * @return \StructType\EditaLinhaInternosJSONResponse|bool
     */
    public function EditaLinhaInternosJSON(\StructType\EditaLinhaInternosJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaInternosJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaInternosStatusJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaInternosStatusJSON $parameters
     * @return \StructType\EditaLinhaInternosStatusJSONResponse|bool
     */
    public function EditaLinhaInternosStatusJSON(\StructType\EditaLinhaInternosStatusJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaInternosStatusJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaLiqJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaLiqJSON $parameters
     * @return \StructType\EditaLinhaLiqJSONResponse|bool
     */
    public function EditaLinhaLiqJSON(\StructType\EditaLinhaLiqJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaLiqJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMarcaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMarcaJSON $parameters
     * @return \StructType\EditaMarcaJSONResponse|bool
     */
    public function EditaMarcaJSON(\StructType\EditaMarcaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMarcaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaModeloJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaModeloJSON $parameters
     * @return \StructType\EditaModeloJSONResponse|bool
     */
    public function EditaModeloJSON(\StructType\EditaModeloJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaModeloJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoedaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoedaJSON $parameters
     * @return \StructType\EditaMoedaJSONResponse|bool
     */
    public function EditaMoedaJSON(\StructType\EditaMoedaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoedaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoradaAlternativaClienteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoradaAlternativaClienteJSON $parameters
     * @return \StructType\EditaMoradaAlternativaClienteJSONResponse|bool
     */
    public function EditaMoradaAlternativaClienteJSON(\StructType\EditaMoradaAlternativaClienteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoradaAlternativaClienteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named
     * EditaMoradaAlternativaFornecedorJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoradaAlternativaFornecedorJSON $parameters
     * @return \StructType\EditaMoradaAlternativaFornecedorJSONResponse|bool
     */
    public function EditaMoradaAlternativaFornecedorJSON(\StructType\EditaMoradaAlternativaFornecedorJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoradaAlternativaFornecedorJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMotivoEstornoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMotivoEstornoJSON $parameters
     * @return \StructType\EditaMotivoEstornoJSONResponse|bool
     */
    public function EditaMotivoEstornoJSON(\StructType\EditaMotivoEstornoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMotivoEstornoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMotivoIsencaoIVAJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMotivoIsencaoIVAJSON $parameters
     * @return \StructType\EditaMotivoIsencaoIVAJSONResponse|bool
     */
    public function EditaMotivoIsencaoIVAJSON(\StructType\EditaMotivoIsencaoIVAJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMotivoIsencaoIVAJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaOrigemContactoJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaOrigemContactoJSON $parameters
     * @return \StructType\EditaOrigemContactoJSONResponse|bool
     */
    public function EditaOrigemContactoJSON(\StructType\EditaOrigemContactoJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaOrigemContactoJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaOutroTerceiroJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaOutroTerceiroJSON $parameters
     * @return \StructType\EditaOutroTerceiroJSONResponse|bool
     */
    public function EditaOutroTerceiroJSON(\StructType\EditaOutroTerceiroJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaOutroTerceiroJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPendenteIdJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPendenteIdJSON $parameters
     * @return \StructType\EditaPendenteIdJSONResponse|bool
     */
    public function EditaPendenteIdJSON(\StructType\EditaPendenteIdJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPendenteIdJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPendenteJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPendenteJSON $parameters
     * @return \StructType\EditaPendenteJSONResponse|bool
     */
    public function EditaPendenteJSON(\StructType\EditaPendenteJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPendenteJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoIvaJSON
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoIvaJSON $parameters
     * @return \StructType\EditaResumoIvaJSONResponse|bool
     */
    public function EditaResumoIvaJSON(\StructType\EditaResumoIvaJSON $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoIvaJSON($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoVenda $parameters
     * @return \StructType\EditaTipoDocumentoVendaResponse|bool
     */
    public function EditaTipoDocumentoVenda(\StructType\EditaTipoDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFamilia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFamilia $parameters
     * @return \StructType\EditaFamiliaResponse|bool
     */
    public function EditaFamilia(\StructType\EditaFamilia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFamilia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFornecedor $parameters
     * @return \StructType\EditaFornecedorResponse|bool
     */
    public function EditaFornecedor(\StructType\EditaFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFreguesia
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFreguesia $parameters
     * @return \StructType\EditaFreguesiaResponse|bool
     */
    public function EditaFreguesia(\StructType\EditaFreguesia $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFreguesia($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFuncionario
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFuncionario $parameters
     * @return \StructType\EditaFuncionarioResponse|bool
     */
    public function EditaFuncionario(\StructType\EditaFuncionario $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFuncionario($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaIva $parameters
     * @return \StructType\EditaIvaResponse|bool
     */
    public function EditaIva(\StructType\EditaIva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDoc
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDoc $parameters
     * @return \StructType\EditaLinhaDocResponse|bool
     */
    public function EditaLinhaDoc(\StructType\EditaLinhaDoc $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDoc($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocStatus $parameters
     * @return \StructType\EditaLinhaDocStatusResponse|bool
     */
    public function EditaLinhaDocStatus(\StructType\EditaLinhaDocStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocTrans
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocTrans $parameters
     * @return \StructType\EditaLinhaDocTransResponse|bool
     */
    public function EditaLinhaDocTrans(\StructType\EditaLinhaDocTrans $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocTrans($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaInternos
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaInternos $parameters
     * @return \StructType\EditaLinhaInternosResponse|bool
     */
    public function EditaLinhaInternos(\StructType\EditaLinhaInternos $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaInternos($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaInternosStatus
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaInternosStatus $parameters
     * @return \StructType\EditaLinhaInternosStatusResponse|bool
     */
    public function EditaLinhaInternosStatus(\StructType\EditaLinhaInternosStatus $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaInternosStatus($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaLiq
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaLiq $parameters
     * @return \StructType\EditaLinhaLiqResponse|bool
     */
    public function EditaLinhaLiq(\StructType\EditaLinhaLiq $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaLiq($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMarca
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMarca $parameters
     * @return \StructType\EditaMarcaResponse|bool
     */
    public function EditaMarca(\StructType\EditaMarca $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMarca($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaModelo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaModelo $parameters
     * @return \StructType\EditaModeloResponse|bool
     */
    public function EditaModelo(\StructType\EditaModelo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaModelo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoeda $parameters
     * @return \StructType\EditaMoedaResponse|bool
     */
    public function EditaMoeda(\StructType\EditaMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoradaAlternativaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoradaAlternativaCliente $parameters
     * @return \StructType\EditaMoradaAlternativaClienteResponse|bool
     */
    public function EditaMoradaAlternativaCliente(\StructType\EditaMoradaAlternativaCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoradaAlternativaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMoradaAlternativaFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMoradaAlternativaFornecedor $parameters
     * @return \StructType\EditaMoradaAlternativaFornecedorResponse|bool
     */
    public function EditaMoradaAlternativaFornecedor(\StructType\EditaMoradaAlternativaFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMoradaAlternativaFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMotivoEstorno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMotivoEstorno $parameters
     * @return \StructType\EditaMotivoEstornoResponse|bool
     */
    public function EditaMotivoEstorno(\StructType\EditaMotivoEstorno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMotivoEstorno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMotivoIsencaoIVA
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMotivoIsencaoIVA $parameters
     * @return \StructType\EditaMotivoIsencaoIVAResponse|bool
     */
    public function EditaMotivoIsencaoIVA(\StructType\EditaMotivoIsencaoIVA $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMotivoIsencaoIVA($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaOrigemContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaOrigemContacto $parameters
     * @return \StructType\EditaOrigemContactoResponse|bool
     */
    public function EditaOrigemContacto(\StructType\EditaOrigemContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaOrigemContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaOutroTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaOutroTerceiro $parameters
     * @return \StructType\EditaOutroTerceiroResponse|bool
     */
    public function EditaOutroTerceiro(\StructType\EditaOutroTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaOutroTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPendenteId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPendenteId $parameters
     * @return \StructType\EditaPendenteIdResponse|bool
     */
    public function EditaPendenteId(\StructType\EditaPendenteId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPendenteId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPendente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPendente $parameters
     * @return \StructType\EditaPendenteResponse|bool
     */
    public function EditaPendente(\StructType\EditaPendente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPendente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoIva
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoIva $parameters
     * @return \StructType\EditaResumoIvaResponse|bool
     */
    public function EditaResumoIva(\StructType\EditaResumoIva $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoIva($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoRetencao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoRetencao $parameters
     * @return \StructType\EditaResumoRetencaoResponse|bool
     */
    public function EditaResumoRetencao(\StructType\EditaResumoRetencao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoRetencao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaResumoRetencaoLiq
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaResumoRetencaoLiq $parameters
     * @return \StructType\EditaResumoRetencaoLiqResponse|bool
     */
    public function EditaResumoRetencaoLiq(\StructType\EditaResumoRetencaoLiq $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaResumoRetencaoLiq($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieCCT
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieCCT $parameters
     * @return \StructType\EditaSerieCCTResponse|bool
     */
    public function EditaSerieCCT(\StructType\EditaSerieCCT $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieCCT($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieContrato
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieContrato $parameters
     * @return \StructType\EditaSerieContratoResponse|bool
     */
    public function EditaSerieContrato(\StructType\EditaSerieContrato $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieContrato($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieStock $parameters
     * @return \StructType\EditaSerieStockResponse|bool
     */
    public function EditaSerieStock(\StructType\EditaSerieStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieVendas
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieVendas $parameters
     * @return \StructType\EditaSerieVendasResponse|bool
     */
    public function EditaSerieVendas(\StructType\EditaSerieVendas $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieVendas($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaSerieCompras
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaSerieCompras $parameters
     * @return \StructType\EditaSerieComprasResponse|bool
     */
    public function EditaSerieCompras(\StructType\EditaSerieCompras $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaSerieCompras($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoTerceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoTerceiro $parameters
     * @return \StructType\EditaTipoTerceiroResponse|bool
     */
    public function EditaTipoTerceiro(\StructType\EditaTipoTerceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoTerceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaUnidade $parameters
     * @return \StructType\EditaUnidadeResponse|bool
     */
    public function EditaUnidade(\StructType\EditaUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaConfiguracaoEasyPayXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaConfiguracaoEasyPayXML $parameters
     * @return \StructType\EditaConfiguracaoEasyPayXMLResponse|bool
     */
    public function EditaConfiguracaoEasyPayXML(\StructType\EditaConfiguracaoEasyPayXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaConfiguracaoEasyPayXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoArmazemXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoArmazemXML $parameters
     * @return \StructType\EditaArtigoArmazemXMLResponse|bool
     */
    public function EditaArtigoArmazemXML(\StructType\EditaArtigoArmazemXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoArmazemXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaVendedorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaVendedorXML $parameters
     * @return \StructType\EditaVendedorXMLResponse|bool
     */
    public function EditaVendedorXML(\StructType\EditaVendedorXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaVendedorXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaModoExpedicaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaModoExpedicaoXML $parameters
     * @return \StructType\EditaModoExpedicaoXMLResponse|bool
     */
    public function EditaModoExpedicaoXML(\StructType\EditaModoExpedicaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaModoExpedicaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEmpresaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEmpresaXML $parameters
     * @return \StructType\EditaEmpresaXMLResponse|bool
     */
    public function EditaEmpresaXML(\StructType\EditaEmpresaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEmpresaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPaisXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPaisXML $parameters
     * @return \StructType\EditaPaisXMLResponse|bool
     */
    public function EditaPaisXML(\StructType\EditaPaisXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPaisXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaParceiroXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaParceiroXML $parameters
     * @return \StructType\EditaParceiroXMLResponse|bool
     */
    public function EditaParceiroXML(\StructType\EditaParceiroXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaParceiroXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoContactoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoContactoXML $parameters
     * @return \StructType\EditaTipoContactoXMLResponse|bool
     */
    public function EditaTipoContactoXML(\StructType\EditaTipoContactoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoContactoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstabelecimentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstabelecimentoXML $parameters
     * @return \StructType\EditaEstabelecimentoXMLResponse|bool
     */
    public function EditaEstabelecimentoXML(\StructType\EditaEstabelecimentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstabelecimentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaContactoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaContactoXML $parameters
     * @return \StructType\EditaContactoXMLResponse|bool
     */
    public function EditaContactoXML(\StructType\EditaContactoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaContactoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArmazemXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArmazemXML $parameters
     * @return \StructType\EditaArmazemXMLResponse|bool
     */
    public function EditaArmazemXML(\StructType\EditaArmazemXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArmazemXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocIdentificacaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocIdentificacaoXML $parameters
     * @return \StructType\EditaTipoDocIdentificacaoXMLResponse|bool
     */
    public function EditaTipoDocIdentificacaoXML(\StructType\EditaTipoDocIdentificacaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocIdentificacaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArmazemLocalizacaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArmazemLocalizacaoXML $parameters
     * @return \StructType\EditaArmazemLocalizacaoXMLResponse|bool
     */
    public function EditaArmazemLocalizacaoXML(\StructType\EditaArmazemLocalizacaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArmazemLocalizacaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMetodoPagamentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMetodoPagamentoXML $parameters
     * @return \StructType\EditaMetodoPagamentoXMLResponse|bool
     */
    public function EditaMetodoPagamentoXML(\StructType\EditaMetodoPagamentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMetodoPagamentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaCondicaoPagamentoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaCondicaoPagamentoXML $parameters
     * @return \StructType\EditaCondicaoPagamentoXMLResponse|bool
     */
    public function EditaCondicaoPagamentoXML(\StructType\EditaCondicaoPagamentoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaCondicaoPagamentoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoXML $parameters
     * @return \StructType\EditaArtigoXMLResponse|bool
     */
    public function EditaArtigoXML(\StructType\EditaArtigoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoFornecedorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoFornecedorXML $parameters
     * @return \StructType\EditaArtigoFornecedorXMLResponse|bool
     */
    public function EditaArtigoFornecedorXML(\StructType\EditaArtigoFornecedorXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoFornecedorXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoIdiomaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoIdiomaXML $parameters
     * @return \StructType\EditaArtigoIdiomaXMLResponse|bool
     */
    public function EditaArtigoIdiomaXML(\StructType\EditaArtigoIdiomaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoIdiomaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoLoteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoLoteXML $parameters
     * @return \StructType\EditaArtigoLoteXMLResponse|bool
     */
    public function EditaArtigoLoteXML(\StructType\EditaArtigoLoteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoLoteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoMoedaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoMoedaXML $parameters
     * @return \StructType\EditaArtigoMoedaXMLResponse|bool
     */
    public function EditaArtigoMoedaXML(\StructType\EditaArtigoMoedaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoMoedaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoUnidadeXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoUnidadeXML $parameters
     * @return \StructType\EditaArtigoUnidadeXMLResponse|bool
     */
    public function EditaArtigoUnidadeXML(\StructType\EditaArtigoUnidadeXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoUnidadeXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoCompraIdXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoCompraIdXML $parameters
     * @return \StructType\EditaDocumentoCompraIdXMLResponse|bool
     */
    public function EditaDocumentoCompraIdXML(\StructType\EditaDocumentoCompraIdXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoCompraIdXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoCompraXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoCompraXML $parameters
     * @return \StructType\EditaDocumentoCompraXMLResponse|bool
     */
    public function EditaDocumentoCompraXML(\StructType\EditaDocumentoCompraXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoCompraXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstadoDocumentoCompraXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstadoDocumentoCompraXML $parameters
     * @return \StructType\EditaEstadoDocumentoCompraXMLResponse|bool
     */
    public function EditaEstadoDocumentoCompraXML(\StructType\EditaEstadoDocumentoCompraXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstadoDocumentoCompraXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoVendaIdXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoVendaIdXML $parameters
     * @return \StructType\EditaDocumentoVendaIdXMLResponse|bool
     */
    public function EditaDocumentoVendaIdXML(\StructType\EditaDocumentoVendaIdXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoVendaIdXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoVendaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoVendaXML $parameters
     * @return \StructType\EditaDocumentoVendaXMLResponse|bool
     */
    public function EditaDocumentoVendaXML(\StructType\EditaDocumentoVendaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoVendaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstadoDocumentoVendaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstadoDocumentoVendaXML $parameters
     * @return \StructType\EditaEstadoDocumentoVendaXMLResponse|bool
     */
    public function EditaEstadoDocumentoVendaXML(\StructType\EditaEstadoDocumentoVendaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstadoDocumentoVendaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoInternoIdXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoInternoIdXML $parameters
     * @return \StructType\EditaDocumentoInternoIdXMLResponse|bool
     */
    public function EditaDocumentoInternoIdXML(\StructType\EditaDocumentoInternoIdXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoInternoIdXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoInternoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoInternoXML $parameters
     * @return \StructType\EditaDocumentoInternoXMLResponse|bool
     */
    public function EditaDocumentoInternoXML(\StructType\EditaDocumentoInternoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoInternoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoLiquidacaoIdXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoLiquidacaoIdXML $parameters
     * @return \StructType\EditaDocumentoLiquidacaoIdXMLResponse|bool
     */
    public function EditaDocumentoLiquidacaoIdXML(\StructType\EditaDocumentoLiquidacaoIdXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoLiquidacaoIdXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoLiquidacaoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoLiquidacaoXML $parameters
     * @return \StructType\EditaDocumentoLiquidacaoXMLResponse|bool
     */
    public function EditaDocumentoLiquidacaoXML(\StructType\EditaDocumentoLiquidacaoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoLiquidacaoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaClienteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaClienteXML $parameters
     * @return \StructType\EditaClienteXMLResponse|bool
     */
    public function EditaClienteXML(\StructType\EditaClienteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaClienteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaConcelhoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaConcelhoXML $parameters
     * @return \StructType\EditaConcelhoXMLResponse|bool
     */
    public function EditaConcelhoXML(\StructType\EditaConcelhoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaConcelhoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaContaBancariaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaContaBancariaXML $parameters
     * @return \StructType\EditaContaBancariaXMLResponse|bool
     */
    public function EditaContaBancariaXML(\StructType\EditaContaBancariaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaContaBancariaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDistritoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDistritoXML $parameters
     * @return \StructType\EditaDistritoXMLResponse|bool
     */
    public function EditaDistritoXML(\StructType\EditaDistritoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDistritoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoContaCorrenteXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoContaCorrenteXML $parameters
     * @return \StructType\EditaTipoDocumentoContaCorrenteXMLResponse|bool
     */
    public function EditaTipoDocumentoContaCorrenteXML(\StructType\EditaTipoDocumentoContaCorrenteXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoContaCorrenteXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoCompraXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoCompraXML $parameters
     * @return \StructType\EditaTipoDocumentoCompraXMLResponse|bool
     */
    public function EditaTipoDocumentoCompraXML(\StructType\EditaTipoDocumentoCompraXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoCompraXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoInternoXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoInternoXML $parameters
     * @return \StructType\EditaTipoDocumentoInternoXMLResponse|bool
     */
    public function EditaTipoDocumentoInternoXML(\StructType\EditaTipoDocumentoInternoXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoInternoXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentStockXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentStockXML $parameters
     * @return \StructType\EditaTipoDocumentStockXMLResponse|bool
     */
    public function EditaTipoDocumentStockXML(\StructType\EditaTipoDocumentStockXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentStockXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEditaTipoParceiroXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEditaTipoParceiroXML $parameters
     * @return \StructType\EditaEditaTipoParceiroXMLResponse|bool
     */
    public function EditaEditaTipoParceiroXML(\StructType\EditaEditaTipoParceiroXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEditaTipoParceiroXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoVendaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoVendaXML $parameters
     * @return \StructType\EditaTipoDocumentoVendaXMLResponse|bool
     */
    public function EditaTipoDocumentoVendaXML(\StructType\EditaTipoDocumentoVendaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoVendaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFamiliaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFamiliaXML $parameters
     * @return \StructType\EditaFamiliaXMLResponse|bool
     */
    public function EditaFamiliaXML(\StructType\EditaFamiliaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFamiliaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFornecedorXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFornecedorXML $parameters
     * @return \StructType\EditaFornecedorXMLResponse|bool
     */
    public function EditaFornecedorXML(\StructType\EditaFornecedorXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFornecedorXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFreguesiaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFreguesiaXML $parameters
     * @return \StructType\EditaFreguesiaXMLResponse|bool
     */
    public function EditaFreguesiaXML(\StructType\EditaFreguesiaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFreguesiaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaFuncionarioXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaFuncionarioXML $parameters
     * @return \StructType\EditaFuncionarioXMLResponse|bool
     */
    public function EditaFuncionarioXML(\StructType\EditaFuncionarioXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaFuncionarioXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaIvaXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaIvaXML $parameters
     * @return \StructType\EditaIvaXMLResponse|bool
     */
    public function EditaIvaXML(\StructType\EditaIvaXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaIvaXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocXML $parameters
     * @return \StructType\EditaLinhaDocXMLResponse|bool
     */
    public function EditaLinhaDocXML(\StructType\EditaLinhaDocXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocStatusXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocStatusXML $parameters
     * @return \StructType\EditaLinhaDocStatusXMLResponse|bool
     */
    public function EditaLinhaDocStatusXML(\StructType\EditaLinhaDocStatusXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocStatusXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaDocTransXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaDocTransXML $parameters
     * @return \StructType\EditaLinhaDocTransXMLResponse|bool
     */
    public function EditaLinhaDocTransXML(\StructType\EditaLinhaDocTransXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaDocTransXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaInternosXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaInternosXML $parameters
     * @return \StructType\EditaLinhaInternosXMLResponse|bool
     */
    public function EditaLinhaInternosXML(\StructType\EditaLinhaInternosXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaInternosXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaInternosStatusXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaInternosStatusXML $parameters
     * @return \StructType\EditaLinhaInternosStatusXMLResponse|bool
     */
    public function EditaLinhaInternosStatusXML(\StructType\EditaLinhaInternosStatusXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaInternosStatusXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaLinhaLiqXML
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaLinhaLiqXML $parameters
     * @return \StructType\EditaLinhaLiqXMLResponse|bool
     */
    public function EditaLinhaLiqXML(\StructType\EditaLinhaLiqXML $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaLinhaLiqXML($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaConfiguracaoEasyPay
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaConfiguracaoEasyPay $parameters
     * @return \StructType\EditaConfiguracaoEasyPayResponse|bool
     */
    public function EditaConfiguracaoEasyPay(\StructType\EditaConfiguracaoEasyPay $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaConfiguracaoEasyPay($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoArmazem $parameters
     * @return \StructType\EditaArtigoArmazemResponse|bool
     */
    public function EditaArtigoArmazem(\StructType\EditaArtigoArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaVendedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaVendedor $parameters
     * @return \StructType\EditaVendedorResponse|bool
     */
    public function EditaVendedor(\StructType\EditaVendedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaVendedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaModoExpedicao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaModoExpedicao $parameters
     * @return \StructType\EditaModoExpedicaoResponse|bool
     */
    public function EditaModoExpedicao(\StructType\EditaModoExpedicao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaModoExpedicao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEmpresa
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEmpresa $parameters
     * @return \StructType\EditaEmpresaResponse|bool
     */
    public function EditaEmpresa(\StructType\EditaEmpresa $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEmpresa($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaPais
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaPais $parameters
     * @return \StructType\EditaPaisResponse|bool
     */
    public function EditaPais(\StructType\EditaPais $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaPais($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaParceiro $parameters
     * @return \StructType\EditaParceiroResponse|bool
     */
    public function EditaParceiro(\StructType\EditaParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoContacto $parameters
     * @return \StructType\EditaTipoContactoResponse|bool
     */
    public function EditaTipoContacto(\StructType\EditaTipoContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoParceiro
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoParceiro $parameters
     * @return \StructType\EditaTipoParceiroResponse|bool
     */
    public function EditaTipoParceiro(\StructType\EditaTipoParceiro $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoParceiro($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstabelecimento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstabelecimento $parameters
     * @return \StructType\EditaEstabelecimentoResponse|bool
     */
    public function EditaEstabelecimento(\StructType\EditaEstabelecimento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstabelecimento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaContacto
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaContacto $parameters
     * @return \StructType\EditaContactoResponse|bool
     */
    public function EditaContacto(\StructType\EditaContacto $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaContacto($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArmazem
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArmazem $parameters
     * @return \StructType\EditaArmazemResponse|bool
     */
    public function EditaArmazem(\StructType\EditaArmazem $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArmazem($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocIdentificacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocIdentificacao $parameters
     * @return \StructType\EditaTipoDocIdentificacaoResponse|bool
     */
    public function EditaTipoDocIdentificacao(\StructType\EditaTipoDocIdentificacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocIdentificacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArmazemLocalizacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArmazemLocalizacao $parameters
     * @return \StructType\EditaArmazemLocalizacaoResponse|bool
     */
    public function EditaArmazemLocalizacao(\StructType\EditaArmazemLocalizacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArmazemLocalizacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaMetodoPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaMetodoPagamento $parameters
     * @return \StructType\EditaMetodoPagamentoResponse|bool
     */
    public function EditaMetodoPagamento(\StructType\EditaMetodoPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaMetodoPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaCondicaoPagamento
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaCondicaoPagamento $parameters
     * @return \StructType\EditaCondicaoPagamentoResponse|bool
     */
    public function EditaCondicaoPagamento(\StructType\EditaCondicaoPagamento $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaCondicaoPagamento($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigo
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigo $parameters
     * @return \StructType\EditaArtigoResponse|bool
     */
    public function EditaArtigo(\StructType\EditaArtigo $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigo($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoFornecedor
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoFornecedor $parameters
     * @return \StructType\EditaArtigoFornecedorResponse|bool
     */
    public function EditaArtigoFornecedor(\StructType\EditaArtigoFornecedor $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoFornecedor($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoIdioma
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoIdioma $parameters
     * @return \StructType\EditaArtigoIdiomaResponse|bool
     */
    public function EditaArtigoIdioma(\StructType\EditaArtigoIdioma $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoIdioma($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoLote
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoLote $parameters
     * @return \StructType\EditaArtigoLoteResponse|bool
     */
    public function EditaArtigoLote(\StructType\EditaArtigoLote $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoLote($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoMoeda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoMoeda $parameters
     * @return \StructType\EditaArtigoMoedaResponse|bool
     */
    public function EditaArtigoMoeda(\StructType\EditaArtigoMoeda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoMoeda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaArtigoUnidade
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaArtigoUnidade $parameters
     * @return \StructType\EditaArtigoUnidadeResponse|bool
     */
    public function EditaArtigoUnidade(\StructType\EditaArtigoUnidade $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaArtigoUnidade($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoCompraId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoCompraId $parameters
     * @return \StructType\EditaDocumentoCompraIdResponse|bool
     */
    public function EditaDocumentoCompraId(\StructType\EditaDocumentoCompraId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoCompraId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoCompra $parameters
     * @return \StructType\EditaDocumentoCompraResponse|bool
     */
    public function EditaDocumentoCompra(\StructType\EditaDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstadoDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstadoDocumentoCompra $parameters
     * @return \StructType\EditaEstadoDocumentoCompraResponse|bool
     */
    public function EditaEstadoDocumentoCompra(\StructType\EditaEstadoDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstadoDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoVendaId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoVendaId $parameters
     * @return \StructType\EditaDocumentoVendaIdResponse|bool
     */
    public function EditaDocumentoVendaId(\StructType\EditaDocumentoVendaId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoVendaId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoVenda $parameters
     * @return \StructType\EditaDocumentoVendaResponse|bool
     */
    public function EditaDocumentoVenda(\StructType\EditaDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaReferenciaMBDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaReferenciaMBDocumentoVenda $parameters
     * @return \StructType\EditaReferenciaMBDocumentoVendaResponse|bool
     */
    public function EditaReferenciaMBDocumentoVenda(\StructType\EditaReferenciaMBDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaReferenciaMBDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaEstadoDocumentoVenda
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaEstadoDocumentoVenda $parameters
     * @return \StructType\EditaEstadoDocumentoVendaResponse|bool
     */
    public function EditaEstadoDocumentoVenda(\StructType\EditaEstadoDocumentoVenda $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaEstadoDocumentoVenda($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoInternoId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoInternoId $parameters
     * @return \StructType\EditaDocumentoInternoIdResponse|bool
     */
    public function EditaDocumentoInternoId(\StructType\EditaDocumentoInternoId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoInternoId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoInterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoInterno $parameters
     * @return \StructType\EditaDocumentoInternoResponse|bool
     */
    public function EditaDocumentoInterno(\StructType\EditaDocumentoInterno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoInterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoLiquidacaoId
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoLiquidacaoId $parameters
     * @return \StructType\EditaDocumentoLiquidacaoIdResponse|bool
     */
    public function EditaDocumentoLiquidacaoId(\StructType\EditaDocumentoLiquidacaoId $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoLiquidacaoId($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDocumentoLiquidacao
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDocumentoLiquidacao $parameters
     * @return \StructType\EditaDocumentoLiquidacaoResponse|bool
     */
    public function EditaDocumentoLiquidacao(\StructType\EditaDocumentoLiquidacao $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDocumentoLiquidacao($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaCliente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaCliente $parameters
     * @return \StructType\EditaClienteResponse|bool
     */
    public function EditaCliente(\StructType\EditaCliente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaCliente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaConcelho
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaConcelho $parameters
     * @return \StructType\EditaConcelhoResponse|bool
     */
    public function EditaConcelho(\StructType\EditaConcelho $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaConcelho($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaContaBancaria
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaContaBancaria $parameters
     * @return \StructType\EditaContaBancariaResponse|bool
     */
    public function EditaContaBancaria(\StructType\EditaContaBancaria $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaContaBancaria($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaDistrito
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaDistrito $parameters
     * @return \StructType\EditaDistritoResponse|bool
     */
    public function EditaDistrito(\StructType\EditaDistrito $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaDistrito($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoContaCorrente
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoContaCorrente $parameters
     * @return \StructType\EditaTipoDocumentoContaCorrenteResponse|bool
     */
    public function EditaTipoDocumentoContaCorrente(\StructType\EditaTipoDocumentoContaCorrente $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoContaCorrente($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoCompra
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoCompra $parameters
     * @return \StructType\EditaTipoDocumentoCompraResponse|bool
     */
    public function EditaTipoDocumentoCompra(\StructType\EditaTipoDocumentoCompra $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoCompra($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentoInterno
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentoInterno $parameters
     * @return \StructType\EditaTipoDocumentoInternoResponse|bool
     */
    public function EditaTipoDocumentoInterno(\StructType\EditaTipoDocumentoInterno $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentoInterno($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named EditaTipoDocumentStock
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\EditaTipoDocumentStock $parameters
     * @return \StructType\EditaTipoDocumentStockResponse|bool
     */
    public function EditaTipoDocumentStock(\StructType\EditaTipoDocumentStock $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->EditaTipoDocumentStock($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\EditaArmazemJSONResponse|\StructType\EditaArmazemLocalizacaoJSONResponse|\StructType\EditaArmazemLocalizacaoResponse|\StructType\EditaArmazemLocalizacaoXMLResponse|\StructType\EditaArmazemResponse|\StructType\EditaArmazemXMLResponse|\StructType\EditaArtigoArmazemJSONResponse|\StructType\EditaArtigoArmazemResponse|\StructType\EditaArtigoArmazemXMLResponse|\StructType\EditaArtigoFornecedorJSONResponse|\StructType\EditaArtigoFornecedorResponse|\StructType\EditaArtigoFornecedorXMLResponse|\StructType\EditaArtigoIdiomaJSONResponse|\StructType\EditaArtigoIdiomaResponse|\StructType\EditaArtigoIdiomaXMLResponse|\StructType\EditaArtigoJSONResponse|\StructType\EditaArtigoLoteJSONResponse|\StructType\EditaArtigoLoteResponse|\StructType\EditaArtigoLoteXMLResponse|\StructType\EditaArtigoMoedaJSONResponse|\StructType\EditaArtigoMoedaResponse|\StructType\EditaArtigoMoedaXMLResponse|\StructType\EditaArtigoResponse|\StructType\EditaArtigoUnidadeJSONResponse|\StructType\EditaArtigoUnidadeResponse|\StructType\EditaArtigoUnidadeXMLResponse|\StructType\EditaArtigoXMLResponse|\StructType\EditaClienteJSONResponse|\StructType\EditaClienteResponse|\StructType\EditaClienteXMLResponse|\StructType\EditaConcelhoJSONResponse|\StructType\EditaConcelhoResponse|\StructType\EditaConcelhoXMLResponse|\StructType\EditaCondicaoPagamentoJSONResponse|\StructType\EditaCondicaoPagamentoResponse|\StructType\EditaCondicaoPagamentoXMLResponse|\StructType\EditaConfiguracaoEasyPayJSONResponse|\StructType\EditaConfiguracaoEasyPayResponse|\StructType\EditaConfiguracaoEasyPayXMLResponse|\StructType\EditaContaBancariaJSONResponse|\StructType\EditaContaBancariaResponse|\StructType\EditaContaBancariaXMLResponse|\StructType\EditaContactoJSONResponse|\StructType\EditaContactoResponse|\StructType\EditaContactoXMLResponse|\StructType\EditaDistritoJSONResponse|\StructType\EditaDistritoResponse|\StructType\EditaDistritoXMLResponse|\StructType\EditaDocumentoCompraIdJSONResponse|\StructType\EditaDocumentoCompraIdResponse|\StructType\EditaDocumentoCompraIdXMLResponse|\StructType\EditaDocumentoCompraJSONResponse|\StructType\EditaDocumentoCompraResponse|\StructType\EditaDocumentoCompraXMLResponse|\StructType\EditaDocumentoInternoIdJSONResponse|\StructType\EditaDocumentoInternoIdResponse|\StructType\EditaDocumentoInternoIdXMLResponse|\StructType\EditaDocumentoInternoJSONResponse|\StructType\EditaDocumentoInternoResponse|\StructType\EditaDocumentoInternoXMLResponse|\StructType\EditaDocumentoLiquidacaoIdJSONResponse|\StructType\EditaDocumentoLiquidacaoIdResponse|\StructType\EditaDocumentoLiquidacaoIdXMLResponse|\StructType\EditaDocumentoLiquidacaoJSONResponse|\StructType\EditaDocumentoLiquidacaoResponse|\StructType\EditaDocumentoLiquidacaoXMLResponse|\StructType\EditaDocumentoVendaIdJSONResponse|\StructType\EditaDocumentoVendaIdResponse|\StructType\EditaDocumentoVendaIdXMLResponse|\StructType\EditaDocumentoVendaJSONResponse|\StructType\EditaDocumentoVendaResponse|\StructType\EditaDocumentoVendaXMLResponse|\StructType\EditaEditaTipoParceiroXMLResponse|\StructType\EditaEmpresaJSONResponse|\StructType\EditaEmpresaResponse|\StructType\EditaEmpresaXMLResponse|\StructType\EditaEstabelecimentoJSONResponse|\StructType\EditaEstabelecimentoResponse|\StructType\EditaEstabelecimentoXMLResponse|\StructType\EditaEstadoDocumentoCompraJSONResponse|\StructType\EditaEstadoDocumentoCompraResponse|\StructType\EditaEstadoDocumentoCompraXMLResponse|\StructType\EditaEstadoDocumentoVendaJSONResponse|\StructType\EditaEstadoDocumentoVendaResponse|\StructType\EditaEstadoDocumentoVendaXMLResponse|\StructType\EditaFamiliaJSONResponse|\StructType\EditaFamiliaResponse|\StructType\EditaFamiliaXMLResponse|\StructType\EditaFornecedorJSONResponse|\StructType\EditaFornecedorResponse|\StructType\EditaFornecedorXMLResponse|\StructType\EditaFreguesiaJSONResponse|\StructType\EditaFreguesiaResponse|\StructType\EditaFreguesiaXMLResponse|\StructType\EditaFuncionarioJSONResponse|\StructType\EditaFuncionarioResponse|\StructType\EditaFuncionarioXMLResponse|\StructType\EditaIvaJSONResponse|\StructType\EditaIvaResponse|\StructType\EditaIvaXMLResponse|\StructType\EditaLinhaDocJSONResponse|\StructType\EditaLinhaDocResponse|\StructType\EditaLinhaDocStatusJSONResponse|\StructType\EditaLinhaDocStatusResponse|\StructType\EditaLinhaDocStatusXMLResponse|\StructType\EditaLinhaDocTransJSONResponse|\StructType\EditaLinhaDocTransResponse|\StructType\EditaLinhaDocTransXMLResponse|\StructType\EditaLinhaDocXMLResponse|\StructType\EditaLinhaInternosJSONResponse|\StructType\EditaLinhaInternosResponse|\StructType\EditaLinhaInternosStatusJSONResponse|\StructType\EditaLinhaInternosStatusResponse|\StructType\EditaLinhaInternosStatusXMLResponse|\StructType\EditaLinhaInternosXMLResponse|\StructType\EditaLinhaLiqJSONResponse|\StructType\EditaLinhaLiqResponse|\StructType\EditaLinhaLiqXMLResponse|\StructType\EditaMarcaJSONResponse|\StructType\EditaMarcaResponse|\StructType\EditaMarcaXMLResponse|\StructType\EditaMetodoPagamentoJSONResponse|\StructType\EditaMetodoPagamentoResponse|\StructType\EditaMetodoPagamentoXMLResponse|\StructType\EditaModeloJSONResponse|\StructType\EditaModeloResponse|\StructType\EditaModeloXMLResponse|\StructType\EditaModoExpedicaoJSONResponse|\StructType\EditaModoExpedicaoResponse|\StructType\EditaModoExpedicaoXMLResponse|\StructType\EditaMoedaJSONResponse|\StructType\EditaMoedaResponse|\StructType\EditaMoedaXMLResponse|\StructType\EditaMoradaAlternativaClienteJSONResponse|\StructType\EditaMoradaAlternativaClienteResponse|\StructType\EditaMoradaAlternativaClienteXMLResponse|\StructType\EditaMoradaAlternativaFornecedorJSONResponse|\StructType\EditaMoradaAlternativaFornecedorResponse|\StructType\EditaMoradaAlternativaFornecedorXMLResponse|\StructType\EditaMotivoEstornoJSONResponse|\StructType\EditaMotivoEstornoResponse|\StructType\EditaMotivoEstornoXMLResponse|\StructType\EditaMotivoIsencaoIVAJSONResponse|\StructType\EditaMotivoIsencaoIVAResponse|\StructType\EditaMotivoIsencaoIVAXMLResponse|\StructType\EditaOrigemContactoJSONResponse|\StructType\EditaOrigemContactoResponse|\StructType\EditaOrigemContactoXMLResponse|\StructType\EditaOutroTerceiroJSONResponse|\StructType\EditaOutroTerceiroResponse|\StructType\EditaOutroTerceiroXMLResponse|\StructType\EditaPaisJSONResponse|\StructType\EditaPaisResponse|\StructType\EditaPaisXMLResponse|\StructType\EditaParceiroJSONResponse|\StructType\EditaParceiroResponse|\StructType\EditaParceiroXMLResponse|\StructType\EditaPendenteIdJSONResponse|\StructType\EditaPendenteIdResponse|\StructType\EditaPendenteIdXMLResponse|\StructType\EditaPendenteJSONResponse|\StructType\EditaPendenteResponse|\StructType\EditaPendenteXMLResponse|\StructType\EditaReferenciaMBDocumentoVendaResponse|\StructType\EditaResumoIvaJSONResponse|\StructType\EditaResumoIvaResponse|\StructType\EditaResumoIvaXMLResponse|\StructType\EditaResumoRetencaoJSONResponse|\StructType\EditaResumoRetencaoLiqJSONResponse|\StructType\EditaResumoRetencaoLiqResponse|\StructType\EditaResumoRetencaoLiqXMLResponse|\StructType\EditaResumoRetencaoResponse|\StructType\EditaResumoRetencaoXMLResponse|\StructType\EditaSerieCCTJSONResponse|\StructType\EditaSerieCCTResponse|\StructType\EditaSerieCCTXMLResponse|\StructType\EditaSerieComprasJSONResponse|\StructType\EditaSerieComprasResponse|\StructType\EditaSerieComprasXMLResponse|\StructType\EditaSerieContratoJSONResponse|\StructType\EditaSerieContratoResponse|\StructType\EditaSerieContratoXMLResponse|\StructType\EditaSerieStockJSONResponse|\StructType\EditaSerieStockResponse|\StructType\EditaSerieStockXMLResponse|\StructType\EditaSerieVendasJSONResponse|\StructType\EditaSerieVendasResponse|\StructType\EditaSerieVendasXMLResponse|\StructType\EditaTipoContactoJSONResponse|\StructType\EditaTipoContactoResponse|\StructType\EditaTipoContactoXMLResponse|\StructType\EditaTipoDocIdentificacaoJSONResponse|\StructType\EditaTipoDocIdentificacaoResponse|\StructType\EditaTipoDocIdentificacaoXMLResponse|\StructType\EditaTipoDocumentoCompraJSONResponse|\StructType\EditaTipoDocumentoCompraResponse|\StructType\EditaTipoDocumentoCompraXMLResponse|\StructType\EditaTipoDocumentoContaCorrenteJSONResponse|\StructType\EditaTipoDocumentoContaCorrenteResponse|\StructType\EditaTipoDocumentoContaCorrenteXMLResponse|\StructType\EditaTipoDocumentoInternoJSONResponse|\StructType\EditaTipoDocumentoInternoResponse|\StructType\EditaTipoDocumentoInternoXMLResponse|\StructType\EditaTipoDocumentoVendaJSONResponse|\StructType\EditaTipoDocumentoVendaResponse|\StructType\EditaTipoDocumentoVendaXMLResponse|\StructType\EditaTipoDocumentStockJSONResponse|\StructType\EditaTipoDocumentStockResponse|\StructType\EditaTipoDocumentStockXMLResponse|\StructType\EditaTipoParceiroJSONResponse|\StructType\EditaTipoParceiroResponse|\StructType\EditaTipoTerceiroJSONResponse|\StructType\EditaTipoTerceiroResponse|\StructType\EditaTipoTerceiroXMLResponse|\StructType\EditaUnidadeJSONResponse|\StructType\EditaUnidadeResponse|\StructType\EditaUnidadeXMLResponse|\StructType\EditaVendedorJSONResponse|\StructType\EditaVendedorResponse|\StructType\EditaVendedorXMLResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
