<?php

namespace ServiceType;

use \WsdlToPhp\PackageBase\AbstractSoapClientBase;

/**
 * This class stands for Devolve ServiceType
 * @subpackage Services
 */
class Devolve extends AbstractSoapClientBase
{
    /**
     * Method to call the operation originally named DevolveDocumentosPagosMB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolveDocumentosPagosMB $parameters
     * @return \StructType\DevolveDocumentosPagosMBResponse|bool
     */
    public function DevolveDocumentosPagosMB(\StructType\DevolveDocumentosPagosMB $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DevolveDocumentosPagosMB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Method to call the operation originally named DevolvePagamentosMB
     * @uses AbstractSoapClientBase::getSoapClient()
     * @uses AbstractSoapClientBase::setResult()
     * @uses AbstractSoapClientBase::getResult()
     * @uses AbstractSoapClientBase::saveLastError()
     * @param \StructType\DevolvePagamentosMB $parameters
     * @return \StructType\DevolvePagamentosMBResponse|bool
     */
    public function DevolvePagamentosMB(\StructType\DevolvePagamentosMB $parameters)
    {
        try {
            $this->setResult(self::getSoapClient()->DevolvePagamentosMB($parameters));
            return $this->getResult();
        } catch (\SoapFault $soapFault) {
            $this->saveLastError(__METHOD__, $soapFault);
            return false;
        }
    }
    /**
     * Returns the result
     * @see AbstractSoapClientBase::getResult()
     * @return \StructType\DevolveDocumentosPagosMBResponse|\StructType\DevolvePagamentosMBResponse
     */
    public function getResult()
    {
        return parent::getResult();
    }
    /**
     * Method returning the class name
     * @return string __CLASS__
     */
    public function __toString()
    {
        return __CLASS__;
    }
}
